
import puppeteer from 'puppeteer';

import fs from 'fs';
import path from 'path';

(async () => {
  const browser = await puppeteer.launch();
  const page = await browser.newPage();

  try {
    // URL de la página que deseas guardar
    const url = 'https://consultaprocesos.ramajudicial.gov.co/Procesos/NombreRazonSocial'; // Cambia esto por la URL de tu página

    // Navegar a la página
    console.log(`Navegando a ${url}...`);
    await page.goto(url, { waitUntil: 'networkidle2' }); // Esperar hasta que la página esté completamente cargada

    // Crear una carpeta para guardar los recursos
    const outputDir = './pagina_guardada';
    if (!fs.existsSync(outputDir)) {
      fs.mkdirSync(outputDir);
    }

    // Obtener el contenido HTML de la página
    console.log('Obteniendo el contenido HTML...');
    let htmlContent = await page.content();

    // Descargar y reemplazar recursos externos (CSS, JS, imágenes)
    const resourceTypes = ['stylesheet', 'script', 'image'];
    const resources = await page.evaluate((resourceTypes) => {
      const resourcesToDownload = [];
      resourceTypes.forEach(type => {
        document.querySelectorAll(`link[rel="stylesheet"], script[src], img[src]`).forEach(element => {
          if (type === 'stylesheet' && element.tagName === 'LINK') {
            resourcesToDownload.push({ type, url: element.href });
          } else if (type === 'script' && element.tagName === 'SCRIPT' && element.src) {
            resourcesToDownload.push({ type, url: element.src });
          } else if (type === 'image' && element.tagName === 'IMG' && element.src) {
            resourcesToDownload.push({ type, url: element.src });
          }
        });
      });
      return resourcesToDownload;
    }, resourceTypes);

    console.log(`Descargando ${resources.length} recursos...`);

    for (const resource of resources) {
      try {
        const response = await page.goto(resource.url);
        if (response) {
          const buffer = await response.buffer();
          const extension = path.extname(new URL(resource.url).pathname) || `.${resource.type}`;
          const fileName = `${resource.type}-${Math.random().toString(36).substring(7)}${extension}`;
          const filePath = path.join(outputDir, fileName);

          // Guardar el recurso en la carpeta
          fs.writeFileSync(filePath, buffer);

          // Reemplazar la URL original en el HTML con la ruta local
          htmlContent = htmlContent.replace(resource.url, fileName);
        }
      } catch (error) {
        console.error(`Error al descargar el recurso ${resource.url}:`, error.message);
      }
    }

    // Guardar el HTML modificado en un archivo
    const htmlFilePath = path.join(outputDir, 'pagina_guardada.html');
    fs.writeFileSync(htmlFilePath, htmlContent);

    console.log(`La página ha sido guardada en "${htmlFilePath}" junto con sus recursos.`);
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    await browser.close();
  }
})();