'use strict'

var express = require('express');
var bodyParser = require('body-parser');

const cors = require ('cors');

var app = express();
var path = require('path');

/*
const angularDistFolder = path.join(__dirname, 'client');
app.use(express.static(angularDistFolder));

console.log('el dir name',angularDistFolder);
app.get('*', (req, res) => {
	res.sendFile(path.join(__dirname, 'index.html'));
});
*/
//configura cabeceras http
// app.use((req, res, next) =>{
// 	res.header('Acces-Control-Allow-Origin', '*');
// 	res.header('Acces-Control-Allow-Headers', 'Authorization, X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Allow-Request-Method');
// 	res.header('Acces-Control-Allow-Mehods', 'GET, POST, OPTIONS, PUT, DELETE');
// 	res.header('Allow', 'GET, POST, OPTIONS, PUT, DELETE');
// 	next();
// });

app.use(cors());
//app.options('*', cors());

// app.use(cors({
// 	allowedHeaders: 'Authorization',
// 	//origin: ['http://localhost:4200'],
// 	maxAge: 3600,
// 	allowedHeaders: ['Content-Type', 'Acces-Control-Allow-Origin', '*'],
// 	allowedOrigins: ['*'],
// 	allowedMethods: ['GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'OPTIONS'], 
// 	maxContentLength: 100 * 1024 * 1024,
// 	credentials: true,
// 	optionsSuccessStatus: 204,
	
//   }));


// app.use((req, res, next) => {
// 	res.header('Access-Control-Allow-Origin', 'http://localhost:4200');
// 	res.header('Access-Control-Allow-Headers', 'Origin, X-Requested-With, Content-Type, Accept, Authorization');
// 	res.header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
// 	res.header('Access-Control-Allow-Credentials', true);
// 	next();
//   });

//para produccion


app.use(express.static(path.join(__dirname, 'client')));
app.use('/', express.static('client', {redirect:false}));


app.use(bodyParser.json({ limit: '700mb' }));
app.use(bodyParser.urlencoded({ limit: '700mb', extended: true }));

//carga rutas
var user_routes = require('./routes/user');
var transaction_routes = require('./routes/transaction');
var company_routes = require('./routes/company');
var canal_routes = require('./routes/channel');
var plan_routes = require('./routes/plan');
var activity_routes = require('./routes/activity');//para actividades económicas
var country_routes = require('./routes/country');//para el listado de paises
var city_routes = require('./routes/city');//para el listado de ciudades
var restriction_routes = require('./routes/restriction');//para el listado de ciudades
var resource_routes = require('./routes/resource');//para el origen recursos
var relation_routes = require('./routes/relation');//para los tipos de relaciones
var list_routes = require('./routes/list');//para las listas
var search_routes = require('./routes/search');//para salvar los archivos de la busqueda masiva sencilla proveniented e un excel
var juris_routes = require('./routes/jurisdiction');
var riskprofile_routes = require('./routes/riskProfile');
var profiledSearch_routes = require('./routes/profiledSearch');
var product_routes = require('./routes/product');
var percent_routes = require('./routes/percent');
var report_routes = require('./routes/report');
var general_routes = require('./routes/general');
var listName_routes = require('./routes/listName');
var customlistName_routes = require('./routes/customlistname');
var ranges_routes = require('./routes/range');
var usuario_routes = require('./routes/usuario');
var alerts_routes = require('./routes/alert');
var email_routes = require('./routes/email');
var rama_routes = require('./routes/ramajudicial');
var searchapi_routes = require('./routes/searchapi');//para salvar los archivos de la busqueda masiva sencilla proveniented e un excel

app.use(bodyParser.urlencoded({extended:false}));
app.use(bodyParser.json());




//carga de rutas base
//app.use('/', express.static('client', {redirect: false}));
app.use('/app', user_routes);
app.use('/app', transaction_routes);
app.use('/app', company_routes);
app.use('/app', canal_routes);
app.use('/app', plan_routes);
app.use('/app', activity_routes); //actividdes económicas
app.use('/app', country_routes); //listado de paises
app.use('/app', city_routes); //listado de ciudades
app.use('/app', restriction_routes); //para las listas restrictivas ofac
app.use('/app', resource_routes); //para las listas restrictivas ofac
app.use('/app', relation_routes); //para los tipos de relaciones
app.use('/app', list_routes); //para las listas
app.use('/app', search_routes); //para la ruta que salva los registros de las busquedas masivas sencillas provenientes de un excel
app.use('/app', juris_routes);
app.use('/app', riskprofile_routes);
app.use('/app', profiledSearch_routes); //para activar las busqeudas masivas perfiladas
app.use('/app', product_routes);
app.use('/app', percent_routes); //para los porcentajes
app.use('/app', report_routes); //Para las busquedas que se convierten en reportes
app.use('/app', general_routes); //para para activar todas las rutas que son como generales
app.use('/app', listName_routes); //para para activar todas las rutas que de listar nombre de listas
app.use('/app', customlistName_routes); //para para activar todas las rutas que de listar nombre de listas
app.use('/app', ranges_routes); //para para activar todas las rutas que de listar nombre de listas
app.use('/app', usuario_routes);
app.use('/app', alerts_routes);
app.use('/app', email_routes);
app.use('/app', rama_routes);
app.use('/app', searchapi_routes); //para salvar los archivos de la busqueda masiva sencilla proveniented e un excel


//para produccion
 app.get('*', function(req, res, next){
 	return res.sendFile(path.resolve('client/index.html'));
});


module.exports = app;