'use strict'

/***CONPONENTES DE ACTIVIDADES ECONÓMICAS */

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Plan = require('../models/activity');
var jwt = require('../services/jwt');
const activity = require('../models/activity');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.codigo = params.codigo;
	plan.actividad_economica = params.actividad_economica;
    plan.nivel_riesgo = params.nivel_riesgo;
    plan.estado = params.estado;
    plan.creado = new Date();
	plan.codigoPais = params.codigoPais;
	
				if(plan.codigo != null && plan.actividad_economica != null && plan.nivel_riesgo != null ){
					//guarda el usuario
                    
   
					plan.save((err, planStored) => {
                      
						if(err){
							res.status(500).send({message: 'Error al guardar la actividad económica'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'No se ha guardado la actividad económica'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar la actividad económica'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha logrado actualizar la actividad económica'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos las actividades economicas*/
/******************************************/
function getPlans(req, res){

	try {
		const planes = Plan.find( function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}

//*****************************************/
/*función para devolver todos las actividades economicas*/
/******************************************/
function getActivitiesByCountry(req, res){

	var countryId = req.params.idPais;

	try {
		const planes = Plan.find({codigoPais: countryId}, function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


 /*******************************************************************************************************/
 // Funcion para devolver una actividad y 
 // permitir su edición. Verificada
 /*******************************************************************************************************/
function getPlan(req, res){
	var planId = req.params.id;
	try {
		const plan = Plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); //encuentra una actividad económica y la devuelve para editarlo
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de actividades económicas'});
	}

}



function getActivity(req, res){
	//console.log('llego aqui by code');
	
	var planId = req.params.id;
	//console.log(planId);
		
		try {
			
			const activity = Plan.find({'codigo': planId}, function(err, plan) { 
				if (err){
					res.send(err)
				}else{
					res.json(plan);
				}
			}); 
			//console.log("Los ciudades "+activity);
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
		}
	
	}

  //para eliminar la actividad económica. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la actividad económica'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan,
	getActivity,
	getActivitiesByCountry
}