'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Channel = require('../models/channel');
var jwt = require('../services/jwt');



function savePlan(req, res){
	
	var canal = new Channel();

	var params = req.body;
	
    canal.nombre = params.nombre;
	canal.calificacion = params.calificacion;
    canal.tipo_relacion = params.tipo_relacion;
    canal.estado = params.estado;
    canal.creado = new Date();
	
				if(canal.nombre != null && canal.calificacion != null && canal.tipo_relacion != null ){
					//guarda el usuario
                    
   
					canal.save((err, canalStored) => {
                        //console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar el canal'});
						}else{
							if(!canalStored){
								res.status(404).send({message: 'NO se ha guardado el canal'});
							}else{
								res.status(200).send({canal: canalStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Channel.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el canal'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el canal'});
			}else{
				res.status(200).send({canal: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos los canales*/
/******************************************/
function getPlans(req, res){

	try {
		const planes = Channel.find( function(err, elcanal) {
			if (err){
				res.send(err)
			}else{
				res.json(elcanal);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de los canales *************/
/*Esta función es usada para actualizar un canal dado */
/*que lo recupera y lo lleva al form de crear canal   */
/********************************************************/
function getPlan(req, res){

	var planId = req.params.id;
	try {
		const canal = Channel.findById(planId, function(err, canal) { 
			if (err){
				res.send(err)
			}else{
				res.json(canal);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal'});
	}

}

function getPlanReporte(req, res){
	//console.log('llego aqui by code');
	
	var planId = req.params.id;
	//console.log(planId);
		
		try {
			
			const canal = Channel.findOne({'codigo': planId}, function(err, canal) { 
				if (err){
					res.send(err)
				}else{
					res.json(canal);
				}
			}); 
			//console.log("Los ciudades "+canal);
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
		}
	
	}

  //para eliminar el canal. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Channel.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el canal'});
	}
}


/****************************************************** */
/* Funcion para devolver los canbales filtrados por     */
/*****************************************************  */
function getChannels(req, res){
	var id = req.params.id;

	console.log(id);
	try {
		const canales = Channel.find({"tipo_relacion": id}, function(err, canalFiltrado) {
			if (err){
				res.send(err)
			}else{
				res.json(canalFiltrado);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de filtro de canales'});
	}
}


module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan,
	getChannels,
	getPlanReporte
}