'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
//var Plan = require('../models/city');
var Plan = require('../models/jurisdiction');
var jwt = require('../services/jwt');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.codigo = params.codigo;
	plan.nombre_municipio = params.nombre_municipio;
	plan.calificacion = params.calificacion;
    plan.estado = params.estado;
    plan.creado = new Date();
	

				if(plan.codigo != null && plan.nombre_municipio != null && plan.calificacion != null ){
					//guarda la ciudad
					plan.save((err, planStored) => {
                        //console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar la ciudad'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'NO se ha guardado la ciudad'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar la ciudad'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la ciudad'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos las ciudades*/
/******************************************/
function getPlans(req, res){

	try {
		const planes = Plan.find( function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de las ciudades *************/
/*Esta función es usada para actualizar una ciudad dado */
/*que lo recupera y lo lleva al form de crear pais   */
/********************************************************/
function getPlan(req, res){

	var planId = req.params.id;
	try {
		const plan = Plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal'});
	}

}

  //para eliminar la ciudad. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al eliminar la ciudad'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan
}