'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');

var bcrypt = require('bcrypt-nodejs');
var Company = require('../models/company');
var jwt = require('../services/jwt');

const multer = require('multer');
//const upload = multer();




function grabaCompania(req, res){
	var company = new Company();

	var params = req.body;
	
	// const moment = require('moment');

	// // Obtener la fecha y hora actual en la zona horaria local
	// const fechaActual = moment();
	// // Convertir el objeto Moment a un objeto Date de JavaScript
	// const fechaParaMongoDB = fechaActual.toDate();
	
	// console.log(fechaParaMongoDB);
	// // Formatear la fecha en español
	// const fechaFormateada = fechaActual.locale('es').format('L'); // Formato corto: 25/10/2023

	// console.log(fechaFormateada);



	let fechaActual = new Date();
	
	let fechaFormateada = fechaActual.toLocaleDateString();

    company.nombre = params.nombre;
	company.nit = params.nit;
    company.direccion = params.direccion;
	company.telefono = params.telefono;
	company.email = params.email;
    company.pagina_web = params.pagina_web;
    company.user_id = params.user_id;
    company.plan_id = params.plan_id;
    company.estado = params.estado;
	company.pais = params.pais;
    company.creado = new Date();
	company.nombreLogo = params.nombreLogo;
	company.fecha_inicio_plan = fechaFormateada;
	

				if(company.nombre != null && company.nit != null && company.direccion != null ){
					//guarda el usuario
                    
   
					company.save((err, companyStored) => {
                        //console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar la compañia'});
						}else{
							if(!companyStored){
								res.status(404).send({message: 'NO se ha guardado la compañia'});
							}else{
								res.status(200).send({company: companyStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Rellena todos los campos'});
				}

} 



//actualiza la compañia
function updateCompany(req, res){
	var companyId = req.params.id;
	var update = req.body;

	

	Company.findByIdAndUpdate(companyId, update, (err, companyUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar el usuario'});
		}else{
			if(!companyUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el usuario'});
			}else{
				res.status(200).send({user: companyUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todas las empresas*/
/******************************************/
async function getCompanies(req, res){

	// Company.aggregate([
	// 	{
	// 		$lookup: {
	// 			from: "users",
	// 			localField: "user_id",
	// 			foreignField: "_id",
	// 			as: "user"
	// 		}
	// 	},
	// 	{
	// 		$project: {
	// 			_id: 1,
	// 			nombre: 1,
	// 			nit: 1,
	// 			direccion: 1,
	// 			telefono: 1,
	// 			email: 1,
	// 			pagina_web: 1,
	// 			user: 1
	// 		}
	// 	}
	// ]).exec((err, companies) => {
	// 	if(err){
	// 		res.status(500).send({message: 'Error al devolver las empresas'});
	// 	}else{
	// 		if(!companies){
	// 			res.status(404).send({message: 'No hay empresas'});
	// 		}else{
	// 			res.status(200).send({companies});
	// 		}
	// 	}
	// })




	// try {
	// 	const usuarios = Company.find( function(err, empresa) {
	// 		if (err){
	// 			res.send(err)
	// 		}else{
	// 			res.json(empresa);
	// 		}
	// 	}); //encuentra todos las empresas
		

	// } catch (error) {
	// 	res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	// }



	// try {
	// 	const result = await Company.aggregate([
	// 	  {
	// 		$lookup: {
	// 		  from: "plans",  // Nombre de la colección de planes
	// 		  localField: "plan_id",
	// 		  foreignField: "plan_id",
	// 		  as: "plan_info"
	// 		}
	// 	  },
	// 	  {
	// 		$unwind: {
	// 		  path: "$plan_info",
	// 		  preserveNullAndEmptyArrays: true  // Mantiene las compañías sin plan
	// 		}
	// 	  },
	// 	  {
	// 		$project: {
	// 		  // Incluye todos los campos originales de Company
	// 		  _id: 1,
	// 		  nombre: 1,
	// 		  nit: 1,
	// 		  direccion: 1,
	// 		  telefono: 1,
	// 		  email: 1,
	// 		  pagina_web: 1,
	// 		  pais: 1,
	// 		  estado: 1,
	// 		  creado: 1,
	// 		  nombreLogo: 1,
	// 		  // ... otros campos de Company que quieras incluir ...
	// 		  plan_id: 1,
	// 		  // Añade el nombre del plan
	// 		  plan_name: "$plan_info.nombre"
	// 		  // Note que ya no intentamos excluir plan_info aquí
	// 		}
	// 	  }
	// 	]);
	
	// 	console.log(result);
	// 	return result;
	//   } catch (error) {
	// 	console.error("Error al listar compañías con planes:", error);
	// 	throw error;
	//   }

	// try {
	// 	const result = await Company.aggregate([
	// 	  {
	// 		$lookup: {
	// 		  from: "plans",
	// 		  localField: "plan_id",
	// 		  foreignField: "plan_id",
	// 		  as: "plan_info"
	// 		}
	// 	  },
	// 	  {
	// 		$addFields: {
	// 		  plan_name: {
	// 			$cond: {
	// 			  if: { $gt: [{ $size: "$plan_info" }, 0] },
	// 			  then: { $arrayElemAt: ["$plan_info.nombre", 0] },
	// 			  else: null
	// 			}
	// 		  }
	// 		}
	// 	  },
	// 	  {
	// 		$project: {
	// 			id: 1,
	// 			nombre: 1,
	// 			nit: 1,
	// 			direccion: 1,
	// 			telefono: 1,
	// 			email: 1,
	// 			pagina_web: 1,
	// 			pais: 1,
	// 			estado: 1,
	// 			creado: 1,
	// 			nombreLogo: 1,
	// 			// ... otros campos de Company que quieras incluir ...
	// 			plan_id: 1,
	// 			// Añade el nombre del plan
	// 			plan_name: 1,

	// 			// Note que ya no intentamos excluir plan_info aquí
	// 			// Excluimos plan_info ya que no lo necesitamos más
	// 			//plan_info: 0
	// 		}
	// 	  }
	// 	]);
	
	// 	console.log(result);
	// 	return result;
	//   } catch (error) {
	// 	console.error("Error al listar compañías con planes:", error);
	// 	throw error;
	//   }







	
		// try {
		//   const result = await Company.aggregate([
		// 	{
		// 	  $lookup: {
		// 		from: "plans",
		// 		localField: "plan_id",
		// 		foreignField: "_id", // Assuming plan_id in Company references _id in Plans
		// 		as: "plan_info"
		// 	  }
		// 	},
		// 	{
		// 	  $addFields: {
		// 		plan_name: {
		// 		  $cond: {
		// 			if: { $gt: [{ $size: "$plan_info" }, 0] },
		// 			then: { $arrayElemAt: ["$plan_info.nombre", 0] },
		// 			else: null
		// 		  }
		// 		}
		// 	  }
		// 	},
		// 	{
		// 	  $project: {
		// 		_id: 1,
		// 		nombre: 1,
		// 		direccion: 1,
		// 		// ... other Company fields you want to include ...
		// 		plan_id: 1,
		// 		plan_name: 1,
		// 		plan_info: 1
		// 	  }
		// 	}
		//   ]);
		//   console.log(result);
		//   return result;
		// } catch (error) {
		//   console.error("Error al listar compañías con planes:", error);
		//   throw error;
		// }
	  

		const pipeline = [
			{
			  $lookup: {
				from: "plans",
				let: { codigo: "$plan_id" },
				pipeline: [
				  {
					$match: {
					  $expr: { $eq: ["$_id", { $toObjectId: "$$codigo" }] }
					}
				  }
				],
				as: "planInfo"
			  }
			},
			{
			  $unwind: {
				path: "$planInfo",
				preserveNullAndEmptyArrays: true
			  }
			},
			{
			  $addFields: {
				nombrePlan: {
				  $ifNull: ["$planInfo.nombre", "Plan no encontrado"]
				}
			  }
			},
			{
			  $project: {
				countryInfo: 0
			  }
			}
		  ];
				try {
					const resultados =  await Company.aggregate(pipeline);
					  res.json(resultados);
				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador de companias'});
				}
			
			}


		



/********************************************************/
/*función para devolver UNO de las empresas *************/
/*Esta función es usada para actualizar una empresa dado */
/*que lo recupera y lo lleva al form de crear empresa   */
/********************************************************/
function getCompany(req, res){

	var companyId = req.params.id;
	try {
		const usuario = Company.findById(companyId, function(err, compan) { 
			if (err){
				res.send(err)
			}else{
				res.json(compan);
			}
		}); //encuentra un compañia por id y lo devuelve para editarlo
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de empresas'});
	}

}

async function getCompanyBy(req, res){

	var companyId = req.params.id;
	//console.log(companyId);
	
	try {
		const usuario = Company.findById(companyId, function(err, compan) { 
			if (err){
				res.send(err)
			}else{
				res.json(compan);
			}
		}); //encuentra un compañia por id y lo devuelve para editarlo
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de empresas'});
	}

}


  //para eliminar la empresa. recibe un id
function delCompany(req, res){
	var companyId = req.params.id;
	
	try {
		
		Company.findByIdAndDelete(companyId, function (err, companyRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(companyRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la empresa'});
	}
}



	//funcion para subir el logo del cliente
	function uploadImage(req, res){

		const imageName = req;

//		console.log(imageName);

//console.log('llego al controller');


// 		console.log('llego al uploadimage del controll3r');
// 		//const image = req.files.image;

// 		// Configuración de multer para procesar la carga de archivos
// const storage = multer.diskStorage({
// 	destination: (req, file, cb) => {
// 	  // Define la carpeta donde se guardarán los archivos cargados
// 	  cb(null, 'uploads/');
// 	},
// 	filename: (req, file, cb) => {
	  
// 	  cb(null, Date.now() + '-' + file.originalname);
// 	}
//   });
  
//   const upload = multer({ storage });

  
		// Obtener extensión del archivo
		//const ext = path.extname(image.originalname);

		//const buffer = Buffer.from(image, 'base64');

		// Nombre de archivo único 
		// const fileName = `img-${Date.now()}.jpg`;
		
	  
		// const path = `./uploads/${fileName}`;
		
		// if (!fs.existsSync('../uploads/')) {
		// 	fs.mkdirSync('../uploads/');
		//   }


		// try {
		// 	fs.writeFileSync(path, buffer);
		// 	res.send(`Imagen ${fileName} subida exitosamente!`);
		//   } catch(error) {
		// 	console.log(error);
		// 	res.status(500).send('Error subiendo la imagen'); 
		//   }
	}




	function getCompanyByName(req, res){

		let name = req.params.name;
			try {
				const companias = Company.find({ nombre: { $regex: new RegExp(name, 'i') }}, function(err, compania) { 
					if (compania.length > 0){
						res.json(compania);
					} 
				}); 

			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador'});
			}
	}
	


module.exports = {
	grabaCompania,
	updateCompany,
	getCompanies,
	getCompany,
	delCompany,
	getCompanyBy,
	uploadImage,
	getCompanyByName
}