'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Plan = require('../models/country');
var jwt = require('../services/jwt');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.nombre = params.nombre;
	plan.nivel_riesgo = params.nivel_riesgo;
	plan.calificacion = params.calificacion;
	plan.ranking = params.ranking;
	plan.codigo = params.codigo;
    plan.estado = params.estado;
    plan.creado = new Date();
	

				if(plan.nombre != null && plan.nivel_riesgo != null && plan.calificacion != null ){
					//guarda el pais
					plan.save((err, planStored) => {
                        //console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar el pais'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'NO se ha guardado el pais'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el pais'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el pais'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos los paises*/
/******************************************/
function getPlans(req, res){
	try {
		const planes = Plan.find( function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de los paises *************/
/*Esta función es usada para actualizar un pais dado */
/*que lo recupera y lo lleva al form de crear pais   */
/********************************************************/
function getPlan(req, res){
//console.log('llego aqui');
// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
	var planId = req.params.id;
	try {
		//Se realiza el cambio de findById a findOne para hacer uso de un campo diferente al id
		const plan = Plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal'});
	}

}

  function getCountryByCode(req, res){
	// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
		var planId = req.params.id;
		//console.log(req);
		var planIdNumber = parseInt(planId);
		console.log(planIdNumber);
		try {
			
			const planes = Plan.find({'codigo': planIdNumber}, function(err, planes) { 
				if (err){
					res.send(err)
				}else{
					res.json(planes);
				}
			}); 
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
		}
	
	}
	

	function getCountryById(req, res){
		// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
			var planId = req.params.id;
			//console.log(req);
			//var planIdNumber = parseInt(planId);
			
			try {
				
				const planes = Plan.find({'_id': planId}, function(err, pais) { 
					if (err){
						res.send(err)
					}else{
						res.json(pais);
					}
				}); 
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de pais' + req + planId});
			}
		
		}

		

  //para eliminar el plan. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el pais'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan,
	getCountryByCode,
	getCountryById,
}