'use strict'
const nodemailer = require('nodemailer');
const fs = require('fs');
const path = require('path');
//*****************************************/
/*función para ENVIAR MENSAJES POR EMAIL todos los porcentajes*/
/******************************************/
async function sendEmail(req, res){
	
  let recibido = req.body;

  let to = recibido.email_to;
  let subject = recibido.email_subject;
  let html = JSON.stringify(recibido.email_body)
  let text = 'PLD Internacional';
  


    //Configura el transporter
		const transporter = nodemailer.createTransport({
			host: 'mx0.pldinternacional.com',  // Usa el servidor SMTP apropiado
			port: 587,
			secure: false, // true para 465, false para otros puertos
			auth: {
				user: 'sistemas@pldinternacional.com', // Tu dirección de correo
				pass: 'qwertasd'  // Tu contraseña
			}
		});

  try {

    const imagePath = path.join(__dirname, 'logoEmail', 'pld_trans_80.png');
    const imageData = fs.readFileSync(imagePath, { encoding: 'base64' });

    let info = await transporter.sendMail({
      from: '"PLD Internacional" <sistemas@pldinternacional.com>',
      to: to,
      subject: subject,
      text: text,
      html:  formatearHtml(html) + `
      <p>Atentamente, </p>
      <p>PLD Internacional<br>
        <img src="data:image/png;base64,${imageData}" alt="Prevención de lavado de dinero">
      </p>
    `
      
    });
    //console.log('Mensaje enviado: %s', info.messageId);
    return info;
  } catch (error) {
   // console.error('Error al enviar el correo:', error);
    throw error;
  }
}



function formatearHtml(json) {
  // Convertir el JSON a un objeto JavaScript
  const objeto = JSON.parse(json);

  // Función recursiva para crear elementos HTML
  function crearElemento(elemento) {
    let html = '';

   
    if (typeof elemento === 'object') {
      html += '<ul>';
      for (const key in elemento) {
        html += `<li>${key}: ${crearElemento(elemento[key])}</li>`;
      }
      html += '</ul>';
    } else {
      html += elemento;
    }
  
    return html;
  }
 
  // Crear el elemento raíz <pre> para el formato de código
  return `<pre><code>${crearElemento(objeto)}</code></pre>`;
}






module.exports = {
	sendEmail,
  formatearHtml
}