'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Percent = require('../models/percent');
var Transaction = require('../models/transaction');
var jwt = require('../services/jwt');
//const { head } = require('../routes/general');
var Search = require('../models/search');

var User = require('../models/user');

//*****************************************/
/*función para devolver todos los porcentajes*/
/******************************************/
function getPorcentajes(req, res){

	try {
		const porcentajes = Percent.find( function(err, porcentajes) {
			if (err){
				res.send(err)
			}else{
				res.json(porcentajes);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


//*****************************************************************/
/*FUNCIÓN PARA DEVOLVER TODOS LOS ID DE GRABACIÓN POR CADA EMPRESA*/
/******************************************************************/
function getDataList(req, res){

	var params = req.params;
	var idEmpresa = params.idEmpresa;

	let consulta2 = "[{ $match: { empresa_id: " + "'" + idEmpresa +"'" + " }}" + "," + " { $group: {_id: '$idGrabacion' }}]";

	let consulta = [
		{ $match: { empresa_id: idEmpresa }}, 
		{ $group: { _id: "$idGrabacion", creado: {$first: '$creado' }, usuarioCrea:{$first: '$usuarioCrea'}, empresa_id:{$first: '$empresa_id'}, nombre_datos:{$first: '$nombre_datos'} } }
	  ];
		try {
			const trasnsac = Transaction.aggregate(consulta, function(err, trasnsac) {
				if (err){
					res.send(err)
				}else{
					res.json(trasnsac);
				}
			}); 
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	
	}
	

	
//*****************************************************************/
/*FUNCIÓN PARA ELIMINAR UN CONJUNTOD E DATOS                      */
/******************************************************************/
function delDataList(req, res){

	var params = req.params;
	var idEmpresa = params.idEmpresa;
	var idGrabacion = params.idGrabacion;

	//console.log(idEmpresa);
	//console.log(idGrabacion);

		try {
			const trasnsac = Transaction.deleteMany({empresa_id: idEmpresa, idGrabacion: idGrabacion}, function(err, trasnsac) {
				if (err){
					res.send(err)
				}else{
					res.json(trasnsac);
				}
			}); 
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	
	}

	 /*******************************************************************************************************/
	 // Funcion para devolver los registros de la coleccion searches
	 // correspondientes a las busquedas realizadas por las personas de cada empresa
	 /*******************************************************************************************************/
	function getHistoricoBusquedas(req, res){

		let idBusqueda = req.params.idEmpresa;

			try {
				const resbusqueda = Search.find({conmpany_id: idBusqueda}, function(err, resbusqueda) {

					if (err){
						res.send(err)
					}else{
						res.json(resbusqueda);
					}
				}); 
				

			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador'});
			}

	}

 /*******************************************************************************************************/
 // Actualiza un usuario a traves del ID
 // Actualiza el password
 /*******************************************************************************************************/
 function updateUserPorId(req, res){
	var userId = req.query.userId;
	var password = req.query.password;

	//calcula el hash del nuevo password
	bcrypt.hash(password, null, null, function(err, hash){

		User.findByIdAndUpdate(userId, {$set: {password: hash}}, (err, userUpdated) => {
			if(err){
				res.send({message: 'Error al actualizar el usuario'});
			}else{
				if(!userUpdated){
					res.send({message: 'No se ha podido actualizar el usuario'});
				}else{
					res.send({rpta: 'Actualizado'});
				}
			}
		})
	});
}



module.exports = {
	getPorcentajes,
	getDataList,
	delDataList,
	getHistoricoBusquedas,
	updateUserPorId
}