'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var Jurisdiction = require('../models/jurisdiction');
var jwt = require('../services/jwt');
const { db } = require('../models/jurisdiction');
//const { head } = require('../routes/usuario');
const jurisdiction = require('../models/jurisdiction');

var countryModel = require('../models/country');


//VERIFICADA
/********************************************************/
/*función para devolver las jurisdicciones *************/
/*de acuerdo con el código  del pais seleccionadoen el select*/
/********************************************************/
function getJurisdicciones(req, res){

	//console.log('llego al controlador');
	var codigoPais = req.params.idPais;
		
		try {
			const jurisdiccion = Jurisdiction.find({'codigoPais': codigoPais}, function(err, jurisdicciones) { 
				if (err){
					res.send(err)
				}else{
					res.json(jurisdicciones);
				}
			}); 
			
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de jurisdicciones'});
		}
	
	}


	 /*******************************************************************************************************/
	 // Devuelve todas las jurisdicciones
	 // sin distingo de pais
	 /*******************************************************************************************************/
	//   async function getAllJurisdicciones(req, res){
	
	// 	var codigoPais = req.params.idPais;
			
	// 		try {
	// 			const jurisdiccion =  Jurisdiction.find({}, async function(err, jurisdicciones) { 
	// 				if (err){
	// 					res.send(err)
	// 				}else{
	// 			//	console.log('Las jurisdiciones con pas', jurisdicciones);
	// 					res.json(jurisdicciones);
	// 				}
	// 			}); 
				
		
	// 		} catch (error) {
	// 			res.status(400).send({message: 'ha ocurrido un error en el controlador de jurisdicciones'});
	// 		}
		
	// 	}
	
	async function getAllJurisdicciones(req, res){
	
		const pipeline = [
			{
			  $lookup: {
				from: "countries",
				let: { codigo: "$codigoPais" },
				pipeline: [
				  {
					$match: {
					  $expr: { $eq: ["$_id", { $toObjectId: "$$codigo" }] }
					}
				  }
				],
				as: "countryInfo"
			  }
			},
			{
			  $unwind: {
				path: "$countryInfo",
				preserveNullAndEmptyArrays: true
			  }
			},
			{
			  $addFields: {
				nombrePais: {
				  $ifNull: ["$countryInfo.nombre", "País no encontrado"]
				}
			  }
			},
			{
			  $project: {
				countryInfo: 0
			  }
			}
		  ];
				try {
					const jurisdiccion =  await Jurisdiction.aggregate(pipeline);
					  res.json(jurisdiccion);
				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador de jurisdicciones'});
				}
			
			}


		// //funcion para devolver el nombre del pais dado un id. este id es enviado desde el controlador jurisdiction
		// async function getCountryByIdJuris(idPais){
			
		// 	try {
		// 		const planes = await countryModel.find({'_id': idPais});
		// 		return planes;
		// 	} catch (error) {
				
		// 	}
		
		// }



		function getJurisdiccionesReporte(req, res){
			//console.log('llego aqui by code');
			// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
			var codigoMun = req.params.idCiudad;
				
				try {
					
					const jurisdiccion = Jurisdiction.find({'codigoMunicipio': codigoMun}, function(err, jurisdicciones) { 
						if (err){
							res.send(err)
						}else{
							res.json(jurisdicciones);
						}
					}); 
					//console.log("Los ciudades "+jurisdiccion);
			
				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
				}
			
			}


			
/************************************************************************************* */
/*******función para devolver el nombre de una jurisdiccion  *************/
/********************************************************/
function getJurisdiccion(req, res){
	var id = req.params.idJurisdiccion;
	//console.log('el valro recibo de la juariaduciosdhwaidg', id);
		try {
			const jurisdiccion = Jurisdiction.findById(id, function(err, jurisdiccion) { 
				if (err){
					res.send(err)
				}else{
					res.json(jurisdiccion);
				}
			}); 
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de jurisdicciones'});
		}
	}



	 /*******************************************************************************************************/
	 // Graba en la base de datos una jurisdiccion
	 // Additional notes
	 /*******************************************************************************************************/
	 function saveJuris(req, res){
		
		let jur = new Jurisdiction();

		var params = req.body;
		//console.log('llego a save juros', params);
		jur.codigoPais = params.codigoPais;
		jur.codigoMunicipio = params.codigoMunicipio;
		jur.nombreMunicipio = params.nombreMunicipio;
		jur.calificacion = params.calificacion;
		jur.estado = params.estado;
		jur.creado = new Date();
		jur.usuarioCrea = params.usuarioCrea;
		
	
				//guarda la ciudad
		jur.save((err, planStored) => {
				//console.log(err);
				if(err){
					res.status(500).send({message: 'Error al guardar la jurisdiccion'});
				}else{
					if(!planStored){
						res.status(404).send({message: 'NO se ha guardado la jurisdiccion'});
					}else{
						res.status(200).send({plan: planStored});
					}
				}
			});

	} 


	 /*******************************************************************************************************/
	 // Funcion para eliminar una jurisdiccion
	 // Additional notes
	 /*******************************************************************************************************/

	 function delJurisdiccion(req, res){
		var planId = req.params.id;
		try {
			Jurisdiction.findByIdAndDelete(Object(planId), function (err, planRemoved){
				if (err){
					res.send(err)
				}else{
					res.json(planRemoved);
				}
	
			});
	
		} catch (error) {
			res.status(500).send({message: 'Sucedió un error al eliminar la jurisdiccion'});
		}
	}
	

//actualiza una jurisdiccion
	function updateJurisdiccion(req, res){
		var planId = req.params.id;
		var update = req.body;
		try {
			Jurisdiction.findByIdAndUpdate(Object(planId), update, {new:true}, function (err, planUpdated){
				if (err){
					res.send(err)
				}else{
					res.json(planUpdated);
				}
	
			});
	
		} catch (error) {
			res.status(500).send({message: 'Sucedió un error al actualizar la jurisdiccion'});
		}
	}






//BORRAR DE AUI PARA ABAJO sin borrar la exportacion def funciones





















			

//Graba en la base de datos muchos registros provenientes un archivo de excel
//Graba las busquedas que hace una empresa.

function saveJurisdiccion(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;
	/*
	console.log('respuesta de a uno');
	params.forEach(element => {
		db.collection("transactions").bsonOptions(element);
		console.log(element);
	});
*/

	if (empresa_id != ''){
		//if(db.collection(empresa_id).insertMany (params)){
			
		if(db.collection("searches").insertMany(params)){
			//console.log("Archivo de Busqueda Masiva IMportado");
			res.status(200).send({message: 'Grabado correctamente'});
		}else{
			//console.log("File imported error.");
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	}

}



/********************************************************************/
/*  funcion para devolver todos los registros de la base de datos que aparecen reportados en ls listas****/
/* ******************************************************************/

async function getReportados(req, res){
	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;


	//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
	//db.users.find({'name': {'$regex': 'sometext', '$options': 'i'}})
	//ACTUALMENTE LO TENEMOS ASI
	//const resultado = await db.collection("list").find({firstNamelastName: new RegExp('.*' + nombreAlias + '.*')}).toArray();

				let nombreAliasParts = nombreAlias.split(' ');
				let queryString = '';
				nombreAliasParts.forEach(element => {
					queryString = queryString + "{" + "'firstNamelastName': {'$regex': new RegExp('.*" + element + ".*'" +"),"+ "'$options': 'i'}},";
				});

				let inicio = "'$and'" + ": [ ";
				let final = "]";
				queryString = inicio + queryString;

				queryString = queryString.slice(0,-1)+ final;

				//console.log('el resultado modificado');
			//console.log(queryString);


			/*
db.getCollection("list").find({
  '$and': [
    { 'firstNamelastName': {'$regex': new RegExp('.*juan.*'),'$options': 'i'} },
    { 'firstNamelastName': {'$regex': new RegExp('.*mopro.*'),'$options': 'i'} }
  ]
}).toArray();


			*/

	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias != '0' && nit != '0'){
		try {
			//consulta por nit
			//const resultadoNit = await db.collection("list").find({'idNumber': {'$regex': new RegExp('.*' + nit + '.*')}}).toArray();
			const resultadoNit = await db.collection("lists").find({'idNumber':  nit }).toArray();
			if(resultadoNit.length === 0){
				//const resultadoNombre = await db.collection("list").find({'firstNamelastName': {'$regex': new RegExp('.*' + nombreAlias + '.*'), '$options': 'i'}}).toArray();
				const resultadoNombre = await db.collection("lists").find(queryString).toArray();
				res.json(resultadoNombre);
			}else{
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(err);
		}
	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias
			//console.log('consulto por nombre cuando nit es 0:', nombreAlias);
			try {
				const resultadoNombre = await db.collection("lists").find({'firstNamelastName': {'$regex': new RegExp('.*' + nombreAlias + '.*'), '$options': 'i'}}).toArray();
				res.json(resultadoNombre);
			} catch (error) {
				res.send(err);
			}
		}else
		//console.log('consulto por nit cuando nombre es 0:', nit);
			if(nit != '0' && nombreAlias === '0'){
				try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('.*' + nit + '.*')}}).toArray();
					//console.log('consulto por nit');
					res.json(resultadoNit);
				} catch (error) {
					res.send(err);
				}
			}
	}
}




/*
function getReportados(req, res){
	try {
		const entities = Entity.find( function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		});
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}
*/





















/***************************************************************/
/*  funcion para salvar cualquier registro en la base de datos****/
/*  Para adaptar:  (*), (*) ************************************/
/* *************************************************************/
function saveOneSearch(req, res){
	var entity = new Entity();
	var params = req.body;
	
	//(*)
	entity.nombre = params.nombre;
    entity.creado = new Date();
	entity.usuarioCrea = params.usuarioCrea;
		
		//graba la entidad en la base de datos
		//if(entity.nombre != null && user.apellido != null && user.username != null ){
		if(entity.nombre != null ){ //(*)
			//guarda la entidad
			entity.save((err, entityStored) => {
				if(err){
					res.status(500).send({message: 'Error al grabar en la base de datos'});
				}else{
					if(!entityStored){
						res.status(404).send({message: 'No se ha guardado la entidad en la base de datos'});
					}else{
						res.status(200).send({user: entityStored});
					}
				}
			});
		}else{
			res.status(200).send({message: 'Todos los campos son obligatorios'});
		}
} 



/********************************************************/
/*función para devolver UN registro de la base de datos**/
/*Esta función es usada para recueprar un registro dado */
/*que lo recupera y lo lleva al form de crear entity    */
/********************************************************/
function getEntity(req, res){
	var entityId = req.params.id;

	try {
		const entity = Entity.findById(entityId, function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}


/*********************************************************/
/*función para ACTUALIZAR UNO de los registros ***********/
/*Esta función es usada para actualizar un registro dado */
/*********************************************************/
function updateEntity(req, res){
	var entityId = req.params.id;
	var update = req.body;

	Entity.findByIdAndUpdate(entityId, update, (err, entityUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar'});
		}else{
			if(!entityUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la base de datos'});
			}else{
				res.status(200).send({user: entityUpdated});
			}
		}
	})
}

/*********************************************************/
/** Función para ELIMINAR UNO de los registros ***********/
/** Esta función es usada para eliminar un registro dado */
/*********************************************************/
function deleteEntity(req, res){
	var entityId = req.params.id;
	
	try {
		Entity.findByIdAndDelete(entityId, function (err, entityRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(entityRemoved);
			}
		});
	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el registro'});
	}
}


//funcion para obtener el nombre de un pais dandole un id


module.exports = {
	getJurisdicciones,
	getJurisdiccion,
	//saveSearch,
	updateEntity,
	getReportados,
	getEntity,
	deleteEntity,
	saveOneSearch,
	getJurisdiccionesReporte,
	getAllJurisdicciones,
	saveJuris,
	delJurisdiccion,
	updateJurisdiccion
};