'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');
 
const distance = require('jaro-winkler');


//para poder importar archivos de excel de +-50000 registros
//var express = require('express');
//var app = express();
//var bodyParser = require('body-parser');
//app.use(bodyParser.json({limit: "100mb", extended: true}));


//app.use(express.json({limit: '100mb'}));
//app.use(express.urlencoded({limit: '100mb'}));

//app.use(bodyParser.urlencoded({limit: "100mb", extended: true, parameterLimit:100000}));

//app.use(bodyParser.json({limit: '10mb', extended: true}))
//app.use(bodyParser.urlencoded({limit: '10mb', extended: true}))



var bcrypt = require('bcrypt-nodejs');
var Transaction = require('../models/transaction');
var jwt = require('../services/jwt');
const { Console } = require('console');
//const { db } = require('../models/transaction');
const api = require('../routes/transaction');
//const transaction = require('../models/transaction');

var List = require('../models/list');
const { db } = require('../models/list');
//const { query } = require('express');

var Customlistname = require('../models/customlistname');

var ListNameOficial = require('../models/listName');
//const { param } = require('../app');
//para acceder el data services y poner el valor de la variable por donde lo encontró




/********************************************************************************** */
//esta funcion sirve para grbar en la base de datos el nombre de una lista
//luego debe devolver el id de la lista creada para se salve como un campo adicional 
//cuando se graba una nueva lista
/********************************************************************************** */

//ya no se usa ??. revisar creo que si
async function saveListname(req, res){

	var titulo_lista = req.body;

	if (titulo_lista != ''){
		const resultado = await db.collection("listnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}

//graba en la base de datos el nombre de la lista indice y devuelve el id para identificar 
//en la collection customlists que lista pertenece a que empresa

async function saveMyListName(req, res){

	var titulo_lista = req.body;

	

	if (titulo_lista != ''){
		const resultado = await db.collection("customlistnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}


function saveListaXML(req, res){

	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	//var primerRegistro = params[0];
	//var empresa_id = primerRegistro.empresa_id;

	
	var nombre_coleccion = "lists"
	//if (empresa_id != ''){
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	//}
}


function saveLista(req, res){
	//	var transaction = new Transaction();
	var params = req.body;

	List.firstNamelastName = params.firstNamelastName;

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;

	//var nombre_coleccion = "lists"
	
	if (empresa_id != ''){
		if(List.insertMany(params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}

	// List.save((err, planStored) => {
	// 	console.log(err);
	// 	if(err){
	// 		res.status(500).send({message: 'Error al guardar el pais'});
	// 	}else{
	// 		if(!planStored){
	// 			res.status(404).send({message: 'NO se ha guardado el pais'});
	// 		}else{
	// 			res.status(200).send({plan: planStored});
	// 		}
	// 	}
	// });


	// if (empresa_id != ''){
	// 	if(db.collection(nombre_coleccion).insertMany (params)){
	// 		res.status(200).send(true);
	// 	}else{
	// 		console.log("File imported error.");
	// 	}
	// }

	
}

function saveListaPersonalizada(req, res){
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;

	var nombre_coleccion = "customlists"
	
	if (empresa_id != ''){
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}
}

/******************************************************* */
//El borrado de una lista implica varias validaciones
//tener en cuenta 
/****************************************************** */

async function deleteLista(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}


async function deleteListaPersonalizada(req, res){
	var orden = req.params;
	var id = orden.id;
	try {
		 const resultado = await db.collection("customlists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}
			

function saveTransaction(req, res){

				var transaction = new Transaction();
			
				var params = req.body;
				
				transaction.empresa_id = params.empresa_id;
				transaction.nit = params.nit;
				transaction.nombreTransaccion = params.nombreTransaccion;
				transaction.montoTransaccion = params.montoTransaccion;
				transaction.fechaTransaccion = params.fechaTransaccion;
				//completar
				//transaction.idUsario = 'traerlo de la session'
				//transaction.idEmpresa = params.idEmpresa;
				//completar
				transaction.creado = new Date();
			
			
							if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
								//guarda el usuario
								transaction.save((err, transactionStored) => {
									if(err){
										res.status(500).send({message: 'Error al guardar la transacción'});
									}else{
										if(!transactionStored){
											res.status(404).send({message: 'NO se ha guardado la transacción'});
										}else{
											res.status(200).send({transaction: transactionStored});
										}
									}
								});
							}else{
								res.status(200).send({message: 'Rellena todos los campos por favor'});
							}
			
						}



function updateTransaction(req, res){
	var transactionId = req.params.id;
	var update = req.body;

	transaction.findByIdAndUpdate(transactionId, update, (err, transactionUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar la transaccion'});
		}else{
			if(!transactionUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la transaccion'});
			}else{
				res.status(200).send({user: transactionUpdated});
			}
		}


	})

}


function saveExcelTransaction(req, res){
	var transaction = new Transaction();
	var params = req.body;

	
}

/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada
/********************************************************/
function getTransactions(req, res){

	var params = req.body;
	
	var fechaIni = req.params.fIni;
	var fechaFin = req.params.fFin;
	const agg = [
		{
		  '$match': {
			'$and': [
			  {
				'fechaTransaccion': {
				  '$gte': new Date(fechaIni)
				}
			  }, {
				'fechaTransaccion': {
				  '$lte': new Date(fechaFin)
				}
			  }
			]
		  }
		}, {
		  '$group': {
			'_id': {}, 
			'Promedio': {
			  '$avg': '$montoTransaccion'
			},
			devstd:{
				$stdDevSamp: '$montoTransaccion'
			}
		  }
		}
	  ];
	  
	
Transaction.aggregate(agg).exec((err, transaccion) => {
	if(err){
		message: 'error en el servidor';
	}else{
		if(transaccion){
			res.status(200).send({transaccion});
		}
	}
} );
	



}


function normalizeText(text) {
    // Validación de entrada mejorada
    if (!text || typeof text !== 'string') {
        return '';
    }
    return text
        .normalize("NFD")
        .replace(/[\u0300-\u036f]/g, "") // Elimina acentos
        .replace(/ñ/g, 'n')              // Manejo explícito de ñ
        .replace(/Ñ/g, 'n')              // Manejo explícito de Ñ
        // CAMBIO IMPORTANTE: Preservar guiones, apostrofes y puntos en nombres
        .replace(/[^a-zA-Z0-9\s\-'\.]/g, "")  // Preserva guiones (-), apostrofes (') y puntos (.)
        .toLowerCase()                    // Convierte todo a minúsculas
        .replace(/\s+/g, ' ')            // Normaliza espacios múltiples a uno solo
        .trim();                         // Elimina espacios al inicio y final
}


const mongoose = require('mongoose');
// async function crearIndices() {
//     try {
//         const List = mongoose.model('List');
//         const collection = List.collection;

//         // Obtener índices existentes una sola vez
//         const indicesExistentes = await collection.indexes();
        
//         // Crear un Set con los campos que ya tienen índices (más rápido)
//         const camposConIndice = new Set();
//         indicesExistentes.forEach(idx => {
//             Object.keys(idx.key).forEach(campo => camposConIndice.add(campo));
//         });

//         // Definir índices a crear
//         const indicesACrear = [
//             { campo: 'idNumber', nombre: 'idNumber_1' },
//             { campo: 'firstNamelastName', nombre: 'firstNamelastName_1' },
//             { campo: 'miAlias', nombre: 'miAlias_1' }
//         ];

//         // Crear índices en paralelo
//         const promesas = indicesACrear.map(async (indice) => {
//             if (camposConIndice.has(indice.campo)) {
//                 console.log(`✓ Índice en ${indice.campo} ya existe`);
//                 return { campo: indice.campo, status: 'exists' };
//             }

//             try {
//                 await collection.createIndex(
//                     { [indice.campo]: 1 }, 
//                     { name: indice.nombre, background: true }
//                 );
//                 console.log(`✓ Índice creado: ${indice.nombre}`);
//                 return { campo: indice.campo, status: 'created' };
//             } catch (err) {
//                 if (err.code === 85 || err.code === 86) {
//                     console.log(`⚠ Índice en ${indice.campo} ya existe con otro nombre`);
//                     return { campo: indice.campo, status: 'exists_different_name' };
//                 } else {
//                     console.error(`✗ Error creando índice ${indice.nombre}:`, err.message);
//                     return { campo: indice.campo, status: 'error', error: err.message };
//                 }
//             }
//         });

//         // Esperar todas las promesas
//         await Promise.all(promesas);

//         console.log('✓ Verificación de índices completada');
//         return true;
//     } catch (error) {
//         console.error('Error al crear índices:', error.message);
//         console.warn('⚠ Continuando con índices existentes');
//         return false;
//     }
// }





/* *******************************
	FUNCIONES UTILES UTILIZADAS A LO LARGO DEL CODIGO
******************************** */

	async function searchByName(searchTerm, PersonModel) {
  try {
    // Normalizar el término de búsqueda
    //const normalizedSearch = normalizeSearchTerm(searchTerm);
	const normalizedSearch = searchTerm;
    
    // Realizar búsqueda con text search
    const results = await PersonModel.aggregate([
      {
        // Búsqueda de texto
        $match: {
          $text: { 
            $search: normalizedSearch,
            $caseSensitive: false,
            $diacriticSensitive: false
          }
        }
      },
      {
        // Agregar el score de relevancia
        $addFields: {
          score: { $meta: "textScore" }
        }
      },
      {
        // Ordenar por score descendente (mejor coincidencia primero)
        $sort: { score: -1 }
      },
      {
        // Limitar a 10 resultados
        $limit: 3
      },
      {
        // Proyectar campos necesarios (ajusta según tus necesidades)
        $project: {
          firstNamelastName: 1,
          miAlias: 1,
		  estado: 1,
		  idNumber: 1,
		  otraInformacion: 1,
		  nombreLista: 1,
		  tipoLista: 1,
          score: 1,
          // Agrega otros campos que necesites
          _id: 1
        }
      }
    ]);

    return results;

  } catch (error) {
    console.error('Error en búsqueda de texto:', error);
    throw error;
  }
}


/**
 * Normaliza el término de búsqueda para mejorar coincidencias
 * @param {string} term - Término a normalizar
 * @returns {string} - Término normalizado
 */
function normalizeSearchTerm(term) {
  if (!term) return '';
  
  let normalized = term.trim();
  
  // Remover puntos comunes en siglas (s.a.s -> sas, s.a -> sa, etc.)
  normalized = normalized.replace(/\b([a-zA-Z])\.(?=[a-zA-Z])/g, '$1');
  normalized = normalized.replace(/\b([a-zA-Z])\.\s*/g, '$1 ');
  
  // Remover caracteres especiales comunes pero mantener espacios
  normalized = normalized.replace(/[.,\/#!$%\^&\*;:{}=\-_`~()]/g, ' ');
  
  // Eliminar múltiples espacios
  normalized = normalized.replace(/\s+/g, ' ').trim();
  
  // Agregar operador OR implícito para búsqueda más flexible
  // Esto ayuda a encontrar coincidencias parciales
  const words = normalized.split(' ');
  
  // Si hay múltiples palabras, crear búsqueda que requiera algunas palabras
  if (words.length > 2) {
    // Para frases largas, buscar coincidencia exacta de frase Y palabras individuales
    normalized = `"${normalized}" ${words.join(' ')}`;
  }
  
  return normalized;
}


//Crea indices compuestos
async function crearIndices() {
    try {
        const List = mongoose.model('List');
        const collection = List.collection;

        // Obtener índices existentes una sola vez
        const indicesExistentes = await collection.indexes();
        
        // Verificar si existe el índice de texto compuesto
        const tieneIndiceTexto = indicesExistentes.some(idx => 
            idx.key && (idx.key._fts === 'text' || idx.textIndexVersion)
        );

        if (tieneIndiceTexto) {
            console.log('✓ Índice de texto compuesto ya existe');
        } else {
            try {
                // Crear índice de texto compuesto con pesos
                await collection.createIndex(
                    { 
                        //idNumber: "text", 
                        firstNamelastName: "text",
                        miAlias: "text"
                    },
                    {
                        name: "search_text_index",
                        weights: {
                            //idNumber: 10,
                            firstNamelastName: 10,
                            miAlias: 8
                        },
                        default_language: "none", //fuinciona para ingles y español
                        background: true
                    }
                );
                console.log('✓ Índice de texto compuesto creado: search_text_index');
                console.log('  - idNumber (peso: 10)');
                console.log('  - firstNamelastName (peso: 5)');
                console.log('  - miAlias (peso: 3)');
            } catch (err) {
                if (err.code === 85 || err.code === 86) {
                    console.log('⚠ Índice de texto ya existe con otro nombre');
                } else {
                    console.error('✗ Error creando índice de texto:', err.message);
                    throw err;
                }
            }
        }

        console.log('✓ Verificación de índices completada');
        return true;
    } catch (error) {
        console.error('Error al crear índices:', error.message);
        console.warn('⚠ Continuando con índices existentes');
        return false;
    }
}



/***************************************
FIN DE FUNCIONES UTILES UTILIZADAS A LO LARGO DEL CODIGO
****************************************/



//PARA DEVOLVER LOS USUARIOS REPORTADOS
/******************************** */
//SE USA PARA LA CONSULTA SENCILLA
/******************************** */

async function getReportados(req, res){

	await crearIndices();

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;

	var nombreAlias_nit = nombreAlias + ' / ' + nit;

	// BÚSQUEDA SIN DISTINGUIR MAYÚSCULAS, MINÚSCULAS Y ACENTOS
	let nombreAliasParts = normalizeText(nombreAlias).split(' ');
	var i = 0;
	let queryString = [];

	nombreAliasParts.forEach(element => {
		// Creamos un patrón que matchee la palabra con o sin acentos
		const normalizedElement = element
			.replace(/a/g, '[aáàâãä]')
			.replace(/e/g, '[eéèêë]')
			.replace(/i/g, '[iíìîï]')
			.replace(/o/g, '[oóòôõö]')
			.replace(/u/g, '[uúùûü]')
			.replace(/n/g, '[nñ]');

		queryString[i] = {
				"$or": [
					{
						"firstNamelastName": {
							"$regex": new RegExp("\\b" + normalizedElement + "\\b", "i")
						}
					},
					{
						"miAlias": {
							"$regex": new RegExp("\\b" + normalizedElement + "\\b", "i")
						}
					}
				]
			};


		i++;
	});

	
	const consulta ={
		"$and": queryString
	};


	



	//busca si los dos datos tienen valores : nit y nombre alias
	//Si los dos datos tiene valores y en la busqueda encuentra por nit. Para y no busca mas
	if(nombreAlias != '0' && nit != '0'){

			const terminos = nombreAlias.split(' ').filter(t => t.trim() !== '');
			// Escapar los términos
			let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));

			// Crear array de expresiones regulares individuales para cada término
			// Cada término debe existir en cualquier parte del string
			let regexConditions = escapedTerms.map(term => ({
				firstNamelastName: { $regex: new RegExp(`\\b${term}\\b`, "i") }
			}));

			
			let miAlias = nombreAlias;

				const pipeline = [
					{
						$match: {
							$or: [
								{ idNumber: { $regex: new RegExp(`\\b${nit}\\b`, "i") } },
								// Usar $and para asegurar que TODAS las palabras estén presentes
								{$and: regexConditions }
							]
						}
					},
					{
						$addFields: {
							matchedBy: {
								$switch: {
									branches: [
										{
											case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
											then: "idNumber"
										},
										{
											case: {
												$allElementsTrue: [
													escapedTerms.map(term => ({
														$regexMatch: { 
															input: "$firstNamelastName", 
															regex: new RegExp(`\\b${term}\\b`, "i")
														}
													}))
												]
											},
											then: "firstNamelastName"
										}
									],
									default: "No match"
								}
							}
						}
					},
					{
						$match: {
							matchedBy: { $ne: "No match" }
						}
					}
				];

				const res_ambos = await List.aggregate(pipeline).exec();

				if (res_ambos.length === 0) {
					//consulta posibles coincidencias solo por el nombre o el alias dado que no encontró ninguno en las busquedas anteriores
				  let resultados =	await searchByName(nombreAlias, List);
					if(resultados.length === 0){
						const sinResultados =  {
							firstNamelastName: nombreAlias,
							idNumber: nit,
							estado: 'No Reportado',
							encontrado_por: '',
							coincidencia: 0,
							terminosBuscados: nombreAlias_nit, 
						}
						const arraySinResultados = [sinResultados];
						res.json(arraySinResultados);
					}else{
						//agregar a resultados los campos faltantes
						resultados.forEach(element => {
							element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
							//element.terminosBuscados = nit + ' / ' + nombreAlias;
							element.terminosBuscados =  nombreAlias;
							element.coincidencia = 0;
						})
						res.json(resultados);
					}
					// const sinResultados =  {
					// 	firstNamelastName: nombreAlias,
					// 	idNumber: nit,
					// 	estado: 'No Reportado',
					// 	encontrado_por: '',
					// 	coincidencia: 0,
					// 	terminosBuscados: nombreAlias_nit, 
					// }
					// const arraySinResultados = [sinResultados];
					// res.json(arraySinResultados);
					
						//let nit_alias = nit + ' ' + nombreAlias;
						//	sin_resultados(nit, nombreAlias, nit_alias, element );
						//xml = '';
				} else {
						res_ambos[0].coincidencia = 1;
						res_ambos[0].el_primero = '1';

						let encontro_idNumber = false;
						res_ambos.forEach(element => {
							if (element.matchedBy === 'firstNamelastName' ) {
								element.encontrado_por = '(Nombre_Alias): ' + ' ' + nombreAlias;
							} else if (element.matchedBy === 'idNumber' ) {
								encontro_idNumber = true;
								element.encontrado_por = '(NIT_Alias): ' + nit;
							} else {
								element.encontrado_por = '( Nombre / Alias): ' + nombreAlias;
							}
							 element.terminosBuscados = nombreAlias + ' / ' + nit;
						});

						console.log('el valor de encontro_idNumber es: ', encontro_idNumber);
						if (encontro_idNumber) {
							//filtre solamente los elementos que tengan el campo matchedBy = idNumber
							res_ambos = res_ambos.filter(element => element.matchedBy === 'idNumber');
							//devuelva los resultados
							res.json(res_ambos);
						}

						// let resultadosAproximados = await searchByName(nombreAlias, List);
						// resultadosAproximados.forEach(element => {
						// 	element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
						// 	element.terminosBuscados = nit + ' / ' + nombreAlias;
						// 	element.coincidencia = 0;
						// })
						// const res_ambos_final = res_ambos.concat(resultadosAproximados);
		
						// //elimina los registros cuyo campo firstNamelastName se repite
						// const arrayUnico = Array.from(
						// new Map(res_ambos_final.map(item => [item._id.toString(), item])).values()
						// );

						 res.json(res_ambos);
				}

	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias
			
			try {
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				
				//no encontró el nombre
				if(resultadoNombre.length === 0) { 
					//consulta por alias
					const resultadoAlias = await db.collection("lists").find({
						'miAlias': { $regex: new RegExp(nombreAlias, 'i') }
					  }).toArray();

					  // Llamamos a la función que consulta la rama judicial  y el resultado lo agregamos al json
		
					 if (resultadoAlias.length === 0) {

						//consulta posibles coincidencias solo por el nombre o el alias dado que no encontró ninguno en las busquedas anteriores
						let resultados =	await searchByName(nombreAlias, List);
							if(resultados.length === 0){
								const sinResultados =  {
									firstNamelastName: nombreAlias,
									idNumber: nit,
									estado: 'No Reportado',
									encontrado_por: '',
									coincidencia: 0,
									terminosBuscados: nombreAlias_nit, 
								}
								const arraySinResultados = [sinResultados];
								res.json(arraySinResultados);
							}else{
								//agregar a resultados los campos faltantes
								resultados.forEach(element => {
									element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
									//element.terminosBuscados = nit + ' / ' + nombreAlias;
									element.terminosBuscados =  nombreAlias;
									element.coincidencia = 0;
								})
								res.json(resultados);
							}

						// //no encontró el alias
						// const sinResultados =  {
						// 	firstNamelastName: nombreAlias,
						// 	idNumber: nit,
						// 	estado: 'No Reportado',
						// 	encontrado_por: '',
						// 	coincidencia:0,
						// 	terminosBuscados: nombreAlias,
						// }
						// const arraySinResultados = [sinResultados];
						// res.json(arraySinResultados);
					} else {
							resultadoAlias[0].coincidencia = 100;
							resultadoAlias[0].encontrado_por = '(Alias) '+ nombreAlias; //almacena en el objeto por donde fue encontrado
							resultadoAlias[0].terminosBuscados = nombreAlias;
							res.json(resultadoAlias);
					}
				} else {
					let j=0;
					resultadoNombre.forEach((element) =>{
						let coincidencia =  jaroWinklerf(nombreAlias.toUpperCase(), element.firstNamelastName.toUpperCase());
						resultadoNombre[j].coincidencia = coincidencia * 100;
						resultadoNombre[j].encontrado_por = '(Nombre) '+ nombreAlias;
						resultadoNombre[j].terminosBuscados = nombreAlias;
						j++;
					});
					
					//Agrega a lo que haya encontrado por nombre lo que encuentre por busqueda de tipo text
					let resultadosAproximados = await searchByName(nombreAlias, List);
						resultadosAproximados.forEach(element => {
							element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
							element.terminosBuscados = nombreAlias;
							element.coincidencia = 0;
						})
						const res_por_nombre = resultadoNombre.concat(resultadosAproximados);
		
						//elimina los registros cuyo campo firstNamelastName se repite
						let arrayUnico = [];
						arrayUnico = Array.from(
						new Map(res_por_nombre.map(item => [item._id.toString(), item])).values()
						);

					res.json(arrayUnico);
				}
				
			} catch (error) {
				console.log(error.message);
				res.send(error);
			}
		}else{
			if(nit != '0' && nombreAlias === '0'){
				try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					//no encontró el nombre
						if(resultadoNit.length === 0) { 
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								idNumber: nit,
								estado: 'No Reportado',
								encontrado_por: '',
								terminosBuscados: nit,
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						}else{
							resultadoNit[0].encontrado_por = nit;
							resultadoNit[0].terminosBuscados = nit;
							res.json(resultadoNit);
						}
				} catch (error) {
					res.send(err);
				}
			}
	}
	
		//consulta por nit
		
	}
	

}

/********************************************** */
/* Tra resultados dela lista personalizada teniendo en cuenta el 
/* id de la empresa (filtrando */

async function getReportadosPersonalizado(req, res){

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;
	var idEmpresa = params.idEmpresa;
	//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
	// let nombreAliasParts = nombreAlias.split(' ');
	var i = 0;
	let queryString = [];
	// nombreAliasParts.forEach(element => {
	// 	var exp = "\\b" + element + "\\b";
	// 	var expReg = new RegExp(exp, 'i');
	// 	queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
	// 	i++;
	// });
	
	//queryString = queryString +','+ {empresa_id:idEmpresa};



	/************************************************************************************************** */
	/* Conforma la consulta para buscar las pabras digitalas en alias y le agrega que sea de su empresa */
	/************************************************************************************************** */
	queryString.push({
		empresa_id:  idEmpresa   
	  });
	  let nombreAliasParts = nombreAlias.split(' ');

	  nombreAliasParts.forEach(element => {
		var exp = "\\b" + element + "\\b";
		var expReg = new RegExp(exp, 'i');
		queryString.push({
		  "firstNamelastName": {
			"$regex": expReg  
		  }
		})
	  });
	const consulta ={
		"$and": queryString
	};

	/************************************************************************************************** */
	/* Conforma la consulta para buscar los numeros digitados en NIT y le agrega que sea de su empresa */
	/************************************************************************************************** */
	let queryStringNit = [];
	queryStringNit.push({
		empresa_id:  idEmpresa   
	  });
	var exp = "\\b" + nit + "\\b";
	var expReg = new RegExp(exp, 'i');
	queryStringNit.push({
		"idNumber": {
		"$regex": expReg  
		}
	})
	const consultaNit ={
		"$and": queryStringNit
	};

	
	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias !== '0' && nit !=='0'){
		
		try {
			//consulta por nit
			//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
			const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
			if(resultadoNit.length === 0){
				//consulta por nombre
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				
				//es porque no lo encontró por nombre. Entonces devuelve lo que buscó para que se pueda calcular el perfil del riesgo
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre[0].terminosBuscados = nit + ' / ' + nombreAlias;
					resultadoNombre[0].encontrado_por = nombre;
					res.json(resultadoNombre);
				}
			}else{
				resultadoNit.forEach(element => {
					element.terminosBuscados =  nit + ' / ' + nombreAlias;
					element.encontrado_por = '(NIT) ' + nit;
				})
				
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(error);
		}
	}else{
		if(nombreAlias !== '0' && nit ==='0'){ //solo llega nombreAlias
			//consulta por nombre alias
			try {
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				//no encontró el nombre
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre.forEach(element => {
						element.terminosBuscados =  nombreAlias;
						element.encontrado_por = '(Nombre) ' + nombreAlias;
					})
					// resultadoNombre[0].terminosBuscados = nombreAlias;
					// resultadoNombre[0].encontrado_por = nombreAlias;
					res.json(resultadoNombre);
				}
			} catch (error) {
				console.log(error.message);
				res.send(error);
			}
		}else{
			if(nit !== '0' && nombreAlias === '0'){
				
				try {
					//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
					//no encontró el nombre
						if(resultadoNit.length === 0) { 
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								idNumber: nit,
								terminosBuscados: nit,
								encontrado_por: '',
								estado: 'No Reportado'
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						}else{
							resultadoNit[0].terminosBuscados = nit;
							resultadoNit[0].encontrado_por = '(NIT) ' + nit;
							res.json(resultadoNit);
						}
				} catch (error) {
					res.send(err);
				}
			}
	}
	
		//consulta por nit
		
	}
	

}



//funcion para mover una lista entre colecciones
async function moveList(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").find({idLista: id});

		 const resultadoDocs = await resultado.toArray();
		 const resultado2 = await db.collection("backuplists").insertMany(resultadoDocs);

		 //const borra = await db.collection("lists").deleteMany({id: {$in: resultadoDocs}});

		 if(resultado) {
			//insertelo en una nueva colección para guardar el historicos de listas

			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}

async function delListPersonal(req, res){
	var listId = req.params.id;

	try {
		const resulta = Customlistname.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}



//********************************************* */
/* BORRA EL INDICE DE LA LISTA OFICIAL         */
/********************************************* */
async function delListOficial(req, res){
	var listId = req.params.id;

	try {
		const resulta = ListNameOficial.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}

 /*******************************************************************************************************/
 // funcion dejaro winkler
 // Additional notes
 /*******************************************************************************************************/
function jaroWinklerf(s1, s2){
	//return new Promise((resolve, reject) => {
		let dist = distance(s1,s2);
	//	resolve(dist);
	return dist;
	//});
  }



  function calcularScoreRelevancia(nombre, terminoBusqueda) {
  const nombreLower = nombre.toLowerCase().trim();
  const busquedaLower = terminoBusqueda.toLowerCase().trim();
  const terminosBusqueda = busquedaLower.split(/\s+/); // ["juan", "carlos", "rodriguez"]
  const terminosNombre = nombreLower.split(/\s+/);
  
  let score = 0;
  
  // ===== 1. COINCIDENCIA EXACTA (máxima prioridad) =====
  if (nombreLower === busquedaLower) {
    return 10000; // Score altísimo para coincidencia perfecta
  }
  
  // ===== 2. COINCIDENCIA EXACTA AL INICIO (+1000) =====
  if (nombreLower.startsWith(busquedaLower + ' ') || nombreLower.startsWith(busquedaLower)) {
    score += 1000;
  }
  
  // ===== 3. CONTIENE LA BÚSQUEDA EXACTA (+500) =====
  else if (nombreLower.includes(busquedaLower)) {
    score += 500;
  }
  
  // ===== 4. TODOS LOS TÉRMINOS PRESENTES (independiente del orden) =====
  const terminosEncontrados = terminosBusqueda.filter(termino => 
    nombreLower.includes(termino)
  );
  
  const porcentajeCoincidencia = terminosEncontrados.length / terminosBusqueda.length;
  
  if (porcentajeCoincidencia === 1) {
    // TODOS los términos están presentes
    score += 800;
    
    // ===== 5. BONUS: Términos en el mismo orden relativo (+200) =====
    let enOrden = true;
    let ultimaPosicion = -1;
    
    for (let termino of terminosBusqueda) {
      const pos = nombreLower.indexOf(termino);
      if (pos <= ultimaPosicion) {
        enOrden = false;
        break;
      }
      ultimaPosicion = pos;
    }
    
    if (enOrden) {
      score += 200;
    }
    
    // ===== 6. BONUS: Términos contiguos o casi contiguos (+150) =====
    let terminosContiguos = 0;
    for (let i = 0; i < terminosBusqueda.length - 1; i++) {
      const pos1 = nombreLower.indexOf(terminosBusqueda[i]);
      const pos2 = nombreLower.indexOf(terminosBusqueda[i + 1], pos1);
      
      // Si están separados por menos de 20 caracteres, son "casi contiguos"
      if (pos2 > pos1 && (pos2 - pos1) < 20) {
        terminosContiguos++;
      }
    }
    score += terminosContiguos * 50;
    
  } else if (porcentajeCoincidencia >= 0.5) {
    // Al menos 50% de los términos presentes
    score += 400 * porcentajeCoincidencia;
  }
  
  // ===== 7. BONUS: Coincidencia de términos individuales (+30 cada uno) =====
  score += terminosEncontrados.length * 30;
  
  // ===== 8. BONUS: El nombre completo coincide con los términos (sin extras) =====
  const terminosExtra = terminosNombre.filter(termino => 
    !terminosBusqueda.some(t => termino.includes(t) || t.includes(termino))
  );
  
  if (terminosExtra.length === 0 && terminosEncontrados.length === terminosBusqueda.length) {
    // No hay términos extras, solo los buscados
    score += 300;
  }
  
  // ===== 9. PENALIZACIÓN: Por longitud extra =====
  const longitudDiferencia = Math.abs(nombre.length - terminoBusqueda.length);
  score -= longitudDiferencia * 1;
  
  // ===== 10. PENALIZACIÓN: Por palabras extra =====
  const palabrasExtra = Math.max(0, terminosNombre.length - terminosBusqueda.length);
  score -= palabrasExtra * 50;
  
  return Math.max(0, score); // No permitir scores negativos
}


module.exports = {
	saveTransaction,
	updateTransaction,
	saveExcelTransaction,
	saveLista,
	saveListaXML,
	deleteLista,
	getTransactions,
	saveListname,
	getReportados,
	moveList,
	saveListaPersonalizada,
	getReportadosPersonalizado,
	saveMyListName,
	deleteListaPersonalizada,
	delListPersonal,
	delListOficial,
};


