'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');
 
//const distance = require('jaro-winkler');


var bcrypt = require('bcrypt-nodejs');
var Transaction = require('../models/transaction');
var jwt = require('../services/jwt');
const { Console } = require('console');
const api = require('../routes/transaction');

var List = require('../models/list');
const { db } = require('../models/list');

var Customlistname = require('../models/customlistname');

var ListNameOficial = require('../models/listName');


/********************************************************************************** */
//esta funcion sirve para grbar en la base de datos el nombre de una lista
//luego debe devolver el id de la lista creada para se salve como un campo adicional 
//cuando se graba una nueva lista
/********************************************************************************** */

//ya no se usa ??. revisar creo que si
async function saveListname(req, res){

	var titulo_lista = req.body;

	if (titulo_lista != ''){
		const resultado = await db.collection("listnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}

//graba en la base de datos el nombre de la lista indice y devuelve el id para identificar 
//en la collection customlists que lista pertenece a que empresa

async function saveMyListName(req, res){
	var titulo_lista = req.body;

	if (titulo_lista != ''){
		const resultado = await db.collection("customlistnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}


function saveListaXML(req, res){

	var params = req.body;
	var nombre_coleccion = "lists"
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
}


function saveLista(req, res){
	//	var transaction = new Transaction();
	var params = req.body;
	List.firstNamelastName = params.firstNamelastName;
	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;
	
	if (empresa_id != ''){
		if(List.insertMany(params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}
}

function saveListaPersonalizada(req, res){
	var params = req.body;
	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;

	var nombre_coleccion = "customlists"
	if (empresa_id != ''){
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}
}

/******************************************************* */
//El borrado de una lista implica varias validaciones
//tener en cuenta 
/****************************************************** */

async function deleteLista(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}


async function deleteListaPersonalizada(req, res){
	var orden = req.params;
	var id = orden.id;
	try {
		 const resultado = await db.collection("customlists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}
			

function saveTransaction(req, res){

				var transaction = new Transaction();
			
				var params = req.body;
				
				transaction.empresa_id = params.empresa_id;
				transaction.nit = params.nit;
				transaction.nombreTransaccion = params.nombreTransaccion;
				transaction.montoTransaccion = params.montoTransaccion;
				transaction.fechaTransaccion = params.fechaTransaccion;
				transaction.creado = new Date();
							if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
								//guarda el usuario
								transaction.save((err, transactionStored) => {
									if(err){
										res.status(500).send({message: 'Error al guardar la transacción'});
									}else{
										if(!transactionStored){
											res.status(404).send({message: 'NO se ha guardado la transacción'});
										}else{
											res.status(200).send({transaction: transactionStored});
										}
									}
								});
							}else{
								res.status(200).send({message: 'Rellena todos los campos por favor'});
							}
			
						}



function updateTransaction(req, res){
	var transactionId = req.params.id;
	var update = req.body;

	transaction.findByIdAndUpdate(transactionId, update, (err, transactionUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar la transaccion'});
		}else{
			if(!transactionUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la transaccion'});
			}else{
				res.status(200).send({user: transactionUpdated});
			}
		}


	})

}


function saveExcelTransaction(req, res){
	var transaction = new Transaction();
	var params = req.body;

	
}

/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada
/********************************************************/
function getTransactions(req, res){

	var params = req.body;
	
	var fechaIni = req.params.fIni;
	var fechaFin = req.params.fFin;
	const agg = [
		{
		  '$match': {
			'$and': [
			  {
				'fechaTransaccion': {
				  '$gte': new Date(fechaIni)
				}
			  }, {
				'fechaTransaccion': {
				  '$lte': new Date(fechaFin)
				}
			  }
			]
		  }
		}, {
		  '$group': {
			'_id': {}, 
			'Promedio': {
			  '$avg': '$montoTransaccion'
			},
			devstd:{
				$stdDevSamp: '$montoTransaccion'
			}
		  }
		}
	  ];
	  
	
Transaction.aggregate(agg).exec((err, transaccion) => {
	if(err){
		message: 'error en el servidor';
	}else{
		if(transaccion){
			res.status(200).send({transaccion});
		}
	}
} );
	



}


// function normalizeText(text) {
//     // Validación de entrada mejorada
//     if (!text || typeof text !== 'string') {
//         return '';
//     }
//     return text
//         .normalize("NFD")
//         .replace(/[\u0300-\u036f]/g, "") // Elimina acentos
//         .replace(/ñ/g, 'n')              // Manejo explícito de ñ
//         .replace(/Ñ/g, 'n')              // Manejo explícito de Ñ
//         // CAMBIO IMPORTANTE: Preservar guiones, apostrofes y puntos en nombres
//         .replace(/[^a-zA-Z0-9\s\-'\.]/g, "")  // Preserva guiones (-), apostrofes (') y puntos (.)
//         .toLowerCase()                    // Convierte todo a minúsculas
//         .replace(/\s+/g, ' ')            // Normaliza espacios múltiples a uno solo
//         .trim();                         // Elimina espacios al inicio y final
// }


const mongoose = require('mongoose');


// Función específica para normalizar abreviaturas
// function normalizeAbbreviations(text) {
//   if (!text) return '';
  
//   return text
//     .replace(/\bs\.?\s*a\.?\s*s\.?\s*\b/gi, 'sas ') // S.A.S debe ir ANTES de S.A
//     .replace(/\bs\.?\s*a\.?\s*\b/gi, 'sa ')
//     .replace(/\bs\.?\s*r\.?\s*l\.?\s*\b/gi, 'srl ')
//     .replace(/\bltda\.?\s*\b/gi, 'ltda ')
//     .replace(/\bc\.?\s*i\.?\s*a\.?\s*\b/gi, 'cia ')
//     .replace(/\binc\.?\s*\b/gi, 'inc ')
//     .replace(/\bcorp\.?\s*\b/gi, 'corp ')
//     .replace(/\be\.?\s*u\.?\s*\b/gi, 'eu ')
//     .replace(/\bc\.?\s*v\.?\s*\b/gi, 'cv ')
//     .replace(/\s+/g, ' ')
//     .trim();
// }


function normalizeAbbreviations(text) {
  if (!text) return '';
  
  return text
    // América Latina (orden específico importante)
    .replace(/\bs\.?\s*a\.?\s*p\.?\s*i\.?\s*\b/gi, 'sapi ') // S.A.P.I. (México)
    .replace(/\bs\.?\s*a\.?\s*s\.?\s*\b/gi, 'sas ') // S.A.S (debe ir ANTES de S.A.)
    .replace(/\bs\.?\s*a\.?\s*c\.?\s*\b/gi, 'sac ') // S.A.C (Perú)
    .replace(/\bs\.?\s*a\.?\s*a\.?\s*\b/gi, 'saa ') // S.A.A (Perú)
    .replace(/\bs\.?\s*a\.?\s*\b/gi, 'sa ') // S.A.
    .replace(/\bs\.?\s*r\.?\s*l\.?\s*\b/gi, 'srl ') // S.R.L. / S. de R.L.
    .replace(/\bltda\.?\s*\b/gi, 'ltda ') // Ltda.
    .replace(/\bc\.?\s*v\.?\s*\b/gi, 'cv ') // C.V. (Capital Variable - México)
    .replace(/\bs\.?\s*c\.?\s*\b/gi, 'sc ') // S.C. (Sociedad Civil)
    .replace(/\beireli\.?\s*\b/gi, 'eireli ') // EIRELI (Brasil)
    .replace(/\beirl\.?\s*\b/gi, 'eirl ') // EIRL (Perú)
    .replace(/\be\.?\s*u\.?\s*\b/gi, 'eu ') // E.U. (Empresa Unipersonal)
    
    // Estados Unidos
    .replace(/\bllc\.?\s*\b/gi, 'llc ') // LLC
    .replace(/\bpllc\.?\s*\b/gi, 'pllc ') // PLLC
    .replace(/\bllp\.?\s*\b/gi, 'llp ') // LLP
    .replace(/\binc\.?\s*\b/gi, 'inc ') // Inc.
    .replace(/\bcorp\.?\s*\b/gi, 'corp ') // Corp.
    
    // Europa - Alemania/Austria/Suiza
    .replace(/\bgmbh\.?\s*\b/gi, 'gmbh ') // GmbH
    .replace(/\ba\.?\s*g\.?\s*\b/gi, 'ag ') // AG
    
    // Europa - Reino Unido
    .replace(/\bplc\.?\s*\b/gi, 'plc ') // PLC
    .replace(/\bltd\.?\s*\b/gi, 'ltd ') // Ltd.
    
    // Europa - Francia
    .replace(/\bs\.?\s*a\.?\s*r\.?\s*l\.?\s*\b/gi, 'sarl ') // SARL
    
    // Europa - Italia
    .replace(/\bs\.?\s*p\.?\s*a\.?\s*\b/gi, 'spa ') // SpA
    
    // Europa - Países Bajos
    .replace(/\bb\.?\s*v\.?\s*\b/gi, 'bv ') // B.V.
    .replace(/\bn\.?\s*v\.?\s*\b/gi, 'nv ') // N.V.
    
    // Europa - Escandinavia
    .replace(/\ba\.?\s*b\.?\s*\b/gi, 'ab ') // AB (Suecia)
    .replace(/\ba\.?\s*s\.?\s*a\.?\s*\b/gi, 'asa ') // ASA (Noruega)
    .replace(/\ba\.?\s*s\.?\s*\b/gi, 'as ') // AS (Noruega)
    
    // Asia - Singapur/Malasia
    .replace(/\bpte\.?\s*ltd\.?\s*\b/gi, 'pte ltd ') // Pte. Ltd.
    .replace(/\bsdn\.?\s*bhd\.?\s*\b/gi, 'sdn bhd ') // Sdn. Bhd.
    
    // Asia - Australia/India
    .replace(/\bpty\.?\s*ltd\.?\s*\b/gi, 'pty ltd ') // Pty. Ltd.
    .replace(/\bpvt\.?\s*ltd\.?\s*\b/gi, 'pvt ltd ') // Pvt. Ltd.
    
    // Asia - China/Japón/Hong Kong
    .replace(/\bco\.?\s*ltd\.?\s*\b/gi, 'co ltd ') // Co. Ltd.
    
    // Otros términos comunes
    .replace(/\bc\.?\s*i\.?\s*a\.?\s*\b/gi, 'cia ') // Cía. (Compañía)
    
    // Normalizar espacios múltiples
    .replace(/\s+/g, ' ')
    .trim();
}


// Normalización completa para comparación
function normalizeText(text) {
  if (!text) return '';
  
  let normalized = text
    .toLowerCase()
    .normalize('NFD')
    .replace(/[\u0300-\u036f]/g, '');
  
  normalized = normalizeAbbreviations(normalized);
  
  normalized = normalized
    .replace(/[.,;:\-_()[\]{}'"!?¿¡]/g, ' ')
    .replace(/\s+/g, ' ')
    .trim();
 
  return normalized;
}

function calculateTokenSimilarity(searchTerm, targetText) {
  const search = normalizeText(searchTerm);
  const target = normalizeText(targetText);
  
  if (!search || !target) return 0;
  
  const searchTokens = search.split(' ').filter(t => t.length > 1);
  const targetTokens = target.split(' ').filter(t => t.length > 1);
  
  if (searchTokens.length === 0) return 0;
  
  let matchedTokens = 0;
  
  searchTokens.forEach(searchToken => {
    const exactMatch = targetTokens.some(targetToken => targetToken === searchToken);
    
    if (exactMatch) {
      matchedTokens++;
    } else {
      const partialMatch = targetTokens.some(targetToken => {
        const similarity = calculateLevenshteinSimilarity(searchToken, targetToken);
        return similarity >= 85;
      });
      
      if (partialMatch) {
        matchedTokens += 0.8;
      }
    }
  });
  
  return (matchedTokens / searchTokens.length) * 100;
}

function calculateLevenshteinSimilarity(str1, str2) {
  const s1 = str1.toLowerCase();
  const s2 = str2.toLowerCase();
  
  if (s1 === s2) return 100;
  
  const matrix = [];
  
  for (let i = 0; i <= s2.length; i++) {
    matrix[i] = [i];
  }
  for (let j = 0; j <= s1.length; j++) {
    matrix[0][j] = j;
  }
  
  for (let i = 1; i <= s2.length; i++) {
    for (let j = 1; j <= s1.length; j++) {
      if (s2.charAt(i - 1) === s1.charAt(j - 1)) {
        matrix[i][j] = matrix[i - 1][j - 1];
      } else {
        matrix[i][j] = Math.min(
          matrix[i - 1][j - 1] + 1,
          matrix[i][j - 1] + 1,
          matrix[i - 1][j] + 1
        );
      }
    }
  }
  
  const distance = matrix[s2.length][s1.length];
  const maxLength = Math.max(s1.length, s2.length);
  return ((maxLength - distance) / maxLength) * 100;
}

async function searchByName_VERSION01(searchTerm, PersonModel) {
  try {
    
    
    const normalizedForSearch = normalizeAbbreviations(searchTerm.trim());

    let allResults = [];
    
    // ESTRATEGIA 1: Text Search con filtro de idNumber vacío
    try {
      const textResults = await PersonModel.aggregate([
        {
          $match: {
                $text: { 
                  $search: normalizedForSearch,
                  $caseSensitive: false,
                  $diacriticSensitive: false
                }
          }
        },
        {
          $addFields: {
            score: { $meta: "textScore" },
            searchMethod: { $literal: "text_search" }
          }
        },
        {
          $project: {
            firstNamelastName: 1,
            miAlias: 1,
            estado: 1,
            idNumber: 1,
            otraInformacion: 1,
            nombreLista: 1,
            tipoLista: 1,
            score: 1,
            searchMethod: 1,
            _id: 1
          }
        }
      ]);
      
    
      allResults = [...textResults];
    } catch (err) {
      console.log('✗ Text search error:', err.message);
    }
    
    // ESTRATEGIA 2: Regex 
    if (allResults.length === 0) {
      const tokens = normalizeText(searchTerm).split(' ').filter(t => t.length > 1);
      
      if (tokens.length > 0) {
        const regexConditions = tokens.map(token => ({
          $or: [
            { firstNamelastName: { $regex: token, $options: 'i' } },
            { miAlias: { $regex: token, $options: 'i' } }
          ]
        }));
        
        // Agregar condición de idNumber vacío
        const regexResults = await PersonModel.find({
            ...regexConditions,
        }).limit(100).lean();
        
        
        //revisar si esta ok incluir los campos aqui
        const scoredResults = regexResults.map(doc => ({
          ...doc,
          score: 1,
          searchMethod: 'regex',
		  terminosBuscados: nit + ' / ' + nombreAlias,
		  encontrado_por: '(Nombre_Alias): ' + ' ' + nombreAlias
        }));
        
        allResults = [...allResults, ...scoredResults];
      }
    }
    
    if (allResults.length === 0) {
      
      return [];
    }
    
    
    const maxScore = Math.max(...allResults.map(r => r.score));
    
    const resultsWithScores = allResults.map(doc => {
      const namesSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.firstNamelastName || ''
      );
      
      const aliasSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.miAlias || ''
      );
      
      const maxStringSimilarity = Math.max(namesSimilarity, aliasSimilarity);
      
      let combinedScore;
      if (doc.searchMethod === 'text_search') {
        const normalizedMongoScore = (doc.score / maxScore) * 100;
        combinedScore = (normalizedMongoScore * 0.6) + (maxStringSimilarity * 0.4);
      } else {
        combinedScore = maxStringSimilarity;
      }
      
      
      
      return {
        ...doc,
        stringSimilarity: parseFloat(maxStringSimilarity.toFixed(2)),
        combinedScore: parseFloat(combinedScore.toFixed(2))
      };
    });
    
    const filteredResults = resultsWithScores
      .filter(result => result.combinedScore >= 75)
      .sort((a, b) => b.combinedScore - a.combinedScore)
      .slice(0, 5)
      .map(r => ({
        _id: r._id,
        firstNamelastName: r.firstNamelastName,
        miAlias: r.miAlias,
        estado: r.estado,
        idNumber: r.idNumber,
        otraInformacion: r.otraInformacion,
        nombreLista: r.nombreLista,
        tipoLista: r.tipoLista,
        stringSimilarity: r.stringSimilarity,
        combinedScore: r.combinedScore
		
      }));
    
   
    
    return filteredResults;

  } catch (error) {
    console.error('❌ Error:', error);
    throw error;
  }
}

async function searchByName(searchTerm, PersonModel) {
  try {
    
    const normalizedForSearch = normalizeAbbreviations(searchTerm.trim());
    
    // NUEVO: Extraer tokens para garantizar que TODOS estén presentes
    const searchTokens = normalizeText(searchTerm).split(' ').filter(t => t.length > 1);

    let allResults = [];
    
    // ESTRATEGIA 1: Text Search
    try {
      const textResults = await PersonModel.aggregate([
        {
          $match: {
                $text: { 
                  $search: normalizedForSearch,
                  $caseSensitive: false,
                  $diacriticSensitive: false
                }
          }
        },
        {
          $addFields: {
            score: { $meta: "textScore" },
            searchMethod: { $literal: "text_search" }
          }
        },
        {
          $project: {
            firstNamelastName: 1,
            miAlias: 1,
            estado: 1,
            idNumber: 1,
            otraInformacion: 1,
            nombreLista: 1,
            tipoLista: 1,
            score: 1,
            searchMethod: 1,
            _id: 1
          }
        }
      ]);
      
      // NUEVO: Filtrar para garantizar que TODOS los tokens estén presentes
      const textResultsFiltered = textResults.filter(doc => {
        const docText = normalizeText(
          `${doc.firstNamelastName || ''} ${doc.miAlias || ''}`
        );
        
        // Verificar que TODOS los tokens de búsqueda estén en el documento
        const hasAllTokens = searchTokens.every(searchToken => {
          return docText.includes(searchToken);
        });
        
        return hasAllTokens;
      });
      
      // NUEVO: Usar resultados filtrados
      allResults = [...textResultsFiltered];
      
    } catch (err) {
      console.log('✗ Text search error:', err.message);
    }
    
    // ESTRATEGIA 2: Regex 
    if (allResults.length === 0) {
      const tokens = normalizeText(searchTerm).split(' ').filter(t => t.length > 1);
      
      if (tokens.length > 0) {
        const regexConditions = tokens.map(token => ({
          $or: [
            { firstNamelastName: { $regex: token, $options: 'i' } },
            { miAlias: { $regex: token, $options: 'i' } }
          ]
        }));
        
        // NUEVO: Usar $and para garantizar que TODOS los tokens estén presentes
        const regexResults = await PersonModel.find({
          $and: regexConditions
        }).limit(100).lean();
        
        
        //revisar si esta ok incluir los campos aqui
        const scoredResults = regexResults.map(doc => ({
          ...doc,
          score: 1,
          searchMethod: 'regex',
		  terminosBuscados: 'nit ' + ' / ' + searchTerm,
		  encontrado_por: '(Nombre_Alias): ' + ' ' + searchTerm
        }));
        
        allResults = [...allResults, ...scoredResults];
      }
    }
    
    if (allResults.length === 0) {
      
      return [];
    }
    
    
    const maxScore = Math.max(...allResults.map(r => r.score));
    
    const resultsWithScores = allResults.map(doc => {
      const namesSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.firstNamelastName || ''
      );
      
      const aliasSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.miAlias || ''
      );
      
      const maxStringSimilarity = Math.max(namesSimilarity, aliasSimilarity);
      
      let combinedScore;
      if (doc.searchMethod === 'text_search') {
        const normalizedMongoScore = (doc.score / maxScore) * 100;
        combinedScore = (normalizedMongoScore * 0.6) + (maxStringSimilarity * 0.4);
      } else {
        combinedScore = maxStringSimilarity;
      }
      
      
      
      return {
        ...doc,
        stringSimilarity: parseFloat(maxStringSimilarity.toFixed(2)),
        combinedScore: parseFloat(combinedScore.toFixed(2))
      };
    });
    
    const filteredResults = resultsWithScores
      .filter(result => result.combinedScore >= 75)
      .sort((a, b) => b.combinedScore - a.combinedScore)
      .slice(0, 50)
      .map(r => ({
        _id: r._id,
        firstNamelastName: r.firstNamelastName,
        miAlias: r.miAlias,
        estado: r.estado,
        idNumber: r.idNumber,
        otraInformacion: r.otraInformacion,
        nombreLista: r.nombreLista,
        tipoLista: r.tipoLista,
        stringSimilarity: r.stringSimilarity,
        combinedScore: r.combinedScore
		
      }));
    
   
    
    return filteredResults;

  } catch (error) {
    console.error('❌ Error:', error);
    throw error;
  }
}







//Crea indices compuestos
async function crearIndices() {
    try {
        const List = mongoose.model('List');
        const collection = List.collection;

        // Obtener índices existentes
        const indicesExistentes = await collection.indexes();
        
        // Buscar cualquier índice de texto existente
        const indiceTextoExistente = indicesExistentes.find(idx => 
            idx.key && (idx.key._fts === 'text' || idx.textIndexVersion)
        );

        if (indiceTextoExistente) {
            console.log('⚠ Se encontró índice de texto existente:', indiceTextoExistente.name);
            
            // Verificar si tiene los campos correctos
            const tieneAliasIndexado = indiceTextoExistente.weights?.miAlias !== undefined;
            
            if (!tieneAliasIndexado) {
                console.log('⚠ El índice NO incluye "miAlias". Eliminando índice anterior...');
                try {
                    await collection.dropIndex(indiceTextoExistente.name);
                    console.log('✓ Índice anterior eliminado');
                } catch (dropErr) {
                    console.error('✗ Error eliminando índice:', dropErr.message);
                    throw dropErr;
                }
            } else {
                console.log('✓ Índice ya incluye "miAlias" correctamente');
                return true;
            }
        }

        // Crear el índice de texto compuesto con los campos correctos
        try {
            await collection.createIndex(
                { 
                    firstNamelastName: "text",
                    miAlias: "text"
                },
                {
                    name: "search_text_index",
                    weights: {
                        firstNamelastName: 10,
                        miAlias: 8
                    },
                    default_language: "none",
                    background: true
                }
            );
            console.log('✓ Índice de texto compuesto creado: search_text_index');
            console.log('  - firstNamelastName (peso: 10)');
            console.log('  - miAlias (peso: 8)');
        } catch (err) {
            if (err.code === 85 || err.code === 86) {
                console.log('⚠ Conflicto con índice existente. Intenta eliminar manualmente el índice de texto anterior.');
            } else {
                console.error('✗ Error creando índice de texto:', err.message);
                throw err;
            }
        }

        console.log('✓ Verificación de índices completada');
        return true;
    } catch (error) {
        console.error('Error al crear índices:', error.message);
        console.warn('⚠ Continuando con índices existentes');
        return false;
    }
}



/***************************************
FIN DE FUNCIONES UTILES UTILIZADAS A LO LARGO DEL CODIGO
****************************************/



//PARA DEVOLVER LOS USUARIOS REPORTADOS
/******************************** */
//SE USA PARA LA CONSULTA SENCILLA
/******************************** */

async function getReportados(req, res){

	await crearIndices();

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;

	var nombreAlias_nit = nombreAlias + ' / ' + nit;

	// BÚSQUEDA SIN DISTINGUIR MAYÚSCULAS, MINÚSCULAS Y ACENTOS
	let nombreAliasParts = normalizeText(nombreAlias).split(' ');
	var i = 0;
	let queryString = [];

	nombreAliasParts.forEach(element => {
		// Creamos un patrón que matchee la palabra con o sin acentos
		const normalizedElement = element
			.replace(/a/g, '[aáàâãä]')
			.replace(/e/g, '[eéèêë]')
			.replace(/i/g, '[iíìîï]')
			.replace(/o/g, '[oóòôõö]')
			.replace(/u/g, '[uúùûü]')
			.replace(/n/g, '[nñ]');

		queryString[i] = {
				"$or": [
					{
						"firstNamelastName": {
							"$regex": new RegExp("\\b" + normalizedElement + "\\b", "i")
						}
					},
					{
						"miAlias": {
							"$regex": new RegExp("\\b" + normalizedElement + "\\b", "i")
						}
					}
				]
			};


		i++;
	});

	
	const consulta ={
		"$and": queryString
	};


	//busca si los dos datos tienen valores : nit y nombre alias
	//Si los dos datos tiene valores y en la busqueda encuentra por nit. Para y no busca mas
	if(nombreAlias != '0' && nit != '0'){

			const terminos = nombreAlias.split(' ').filter(t => t.trim() !== '');
			// Escapar los términos
			let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));

			// Crear array de expresiones regulares individuales para cada término
			// Cada término debe existir en cualquier parte del string
			let regexConditions = escapedTerms.map(term => ({
				firstNamelastName: { $regex: new RegExp(`\\b${term}\\b`, "i") }
			}));

			// Busca primero por nit usando la expresion regular
			try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
						
						if(resultadoNit.length === 0) { //Entonces busca por nombre usando la busqueda tipo text
							let resultadosAproximados = await searchByName(nombreAlias, List);
							//console.log('resultadosAproximados', resultadosAproximados);
							//console.log('Los resultados aproximados son: ', resultadosAproximados);
								if(resultadosAproximados.length > 0) { //Si encontro algo por nombre, pues pone los campos adicionales
									resultadosAproximados.forEach(element => {
										element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
										element.terminosBuscados =  nombreAlias + ' / ' + nit;
										element.coincidencia = 0;
									})
								}
								
							if(resultadosAproximados.length === 0){ //busca por nombre o alias
								const sinResultados =  {
									firstNamelastName: nombreAlias,
									idNumber: nit,
									estado: 'No Reportado',
									encontrado_por: '',
									terminosBuscados: nit + ' / ' + nombreAlias
								}
								const arraySinResultados = [sinResultados];
								res.json(arraySinResultados);
							} else { // No encontró nada por nit ni por nombre 
								
								//ordenar el arreglo por tipo de lista. Primero las restrictivas, luego vinculantes y por ultimjo informativa
								const listTypeOrder = ['Restrictiva', 'Vinculante', 'Informativa'];
								resultadosAproximados.sort((a, b) => {
									const indexA = listTypeOrder.indexOf(a.tipoLista);
									const indexB = listTypeOrder.indexOf(b.tipoLista);
									return indexA - indexB;
								})
								
								res.json(resultadosAproximados);
							}



						} else{

							const resul_nit_enviar = resultadoNit.map(doc => ({
								...doc,
								score: 1,
								searchMethod: 'regex',
								terminosBuscados: nit + ' / ' + nombreAlias,
								encontrado_por: '(Nit): ' + ' ' + nit
							}));



							// resultadoNit[0].encontrado_por = '(Nit)' + ' / ' + nit;
							// resultadoNit[0].terminosBuscados = nit + ' / ' + nombreAlias;
							//ordenar el arreglo por tipo de lista. Primero las restrictivas, luego vinculantes y por ultimjo informativa
								// const listTypeOrder = ['Restrictiva', 'Vinculante', 'Informativa'];
								// resul_nit_enviar.sort((a, b) => {
								// 	const indexA = listTypeOrder.indexOf(a.tipoLista);
								// 	const indexB = listTypeOrder.indexOf(b.tipoLista);
								// 	return indexA - indexB;
								// })
							res.json(resul_nit_enviar);
						}
				} catch (error) {
					res.send(err);
				}
	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias
			
			
						
						
							let resultadosAproximados = await searchByName(nombreAlias, List);
							//console.log('resultadosAproximados', resultadosAproximados);
							//console.log('Los resultados aproximados son: ', resultadosAproximados);
								if(resultadosAproximados.length > 0) { //Si encontro algo por nombre, pues pone los campos adicionales
									resultadosAproximados.forEach(element => {
										element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
										element.terminosBuscados =  nombreAlias;
										element.coincidencia = 0;
									})
								}
								
							if(resultadosAproximados.length === 0){ 
								const sinResultados =  {
									firstNamelastName: nombreAlias,
									idNumber: nit,
									estado: 'No Reportado',
									encontrado_por: '',
									terminosBuscados: nit + ' / ' + nombreAlias
								}
								const arraySinResultados = [sinResultados];
								res.json(arraySinResultados);
							} else { // No encontró nada por nit ni por nombre 
								//ordenar el arreglo por tipo de lista. Primero las restrictivas, luego vinculantes y por ultimjo informativa
								const listTypeOrder = ['Restrictiva', 'Vinculante', 'Informativa'];
								resultadosAproximados.sort((a, b) => {
									const indexA = listTypeOrder.indexOf(a.tipoLista);
									const indexB = listTypeOrder.indexOf(b.tipoLista);
									return indexA - indexB;
								})
								res.json(resultadosAproximados);
							}













			// try {
			// 	const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				
			// 	//no encontró el nombre
			// 	if(resultadoNombre.length === 0) { 
			// 		//consulta por alias
			// 		const resultadoAlias = await db.collection("lists").find({
			// 			'miAlias': { $regex: new RegExp(nombreAlias, 'i') }
			// 		  }).toArray();

			// 		  // Llamamos a la función que consulta la rama judicial  y el resultado lo agregamos al json
		
			// 		 if (resultadoAlias.length === 0) {

			// 			//consulta posibles coincidencias solo por el nombre o el alias dado que no encontró ninguno en las busquedas anteriores
			// 			let resultados =	await searchByName(nombreAlias, List);
			// 				if(resultados.length === 0){
			// 					const sinResultados =  {
			// 						firstNamelastName: nombreAlias,
			// 						idNumber: nit,
			// 						estado: 'No Reportado',
			// 						encontrado_por: '',
			// 						coincidencia: 0,
			// 						terminosBuscados: nombreAlias_nit, 
			// 					}
			// 					const arraySinResultados = [sinResultados];
			// 					res.json(arraySinResultados);
			// 				}else{
			// 					//agregar a resultados los campos faltantes
			// 					resultados.forEach(element => {
			// 						element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
			// 						//element.terminosBuscados = nit + ' / ' + nombreAlias;
			// 						element.terminosBuscados =  nombreAlias;
			// 						element.coincidencia = 0;
			// 					})
			// 					res.json(resultados);
			// 				}
			// 		} else {
			// 				resultadoAlias[0].coincidencia = 100;
			// 				resultadoAlias[0].encontrado_por = '(Alias) '+ nombreAlias; //almacena en el objeto por donde fue encontrado
			// 				resultadoAlias[0].terminosBuscados = nombreAlias;
			// 				res.json(resultadoAlias);
			// 		}
			// 	} else {
			// 		let j=0;
			// 		resultadoNombre.forEach((element) =>{
			// 			let coincidencia =  jaroWinklerf(nombreAlias.toUpperCase(), element.firstNamelastName.toUpperCase());
			// 			resultadoNombre[j].coincidencia = coincidencia * 100;
			// 			resultadoNombre[j].encontrado_por = '(Nombre) '+ nombreAlias;
			// 			resultadoNombre[j].terminosBuscados = nombreAlias;
			// 			j++;
			// 		});
					
			// 		//Agrega a lo que haya encontrado por nombre lo que encuentre por busqueda de tipo text
			// 		let resultadosAproximados = await searchByName(nombreAlias, List);
			// 			resultadosAproximados.forEach(element => {
			// 				element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
			// 				element.terminosBuscados = nombreAlias;
			// 				element.coincidencia = 0;
			// 			})
			// 			const res_por_nombre = resultadoNombre.concat(resultadosAproximados);
		
			// 			//elimina los registros cuyo campo firstNamelastName se repite
			// 			let arrayUnico = [];
			// 			arrayUnico = Array.from(
			// 			new Map(res_por_nombre.map(item => [item._id.toString(), item])).values()
			// 			);

			// 		res.json(arrayUnico);
			// 	}
				
			// } catch (error) {
			// 	console.log(error.message);
			// 	res.send(error);
			// }
		}else{
			if(nit != '0' && nombreAlias === '0'){
				try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					//no encontró el nombre
						if(resultadoNit.length === 0) { 
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								idNumber: nit,
								estado: 'No Reportado',
								encontrado_por: '',
								terminosBuscados: nit,
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						}else{
							resultadoNit[0].encontrado_por = nit;
							resultadoNit[0].terminosBuscados = nit;
							// //ordenar el arreglo por tipo de lista. Primero las restrictivas, luego vinculantes y por ultimjo informativa
							// 	const listTypeOrder = ['Restrictiva', 'Vinculante', 'Informativa'];
							// 	resultadoNit.sort((a, b) => {
							// 		const indexA = listTypeOrder.indexOf(a.tipoLista);
							// 		const indexB = listTypeOrder.indexOf(b.tipoLista);
							// 		return indexA - indexB;
							// 	})
							res.json(resultadoNit);
						}
				} catch (error) {
					res.send(err);
				}
			}
	}
	
		//consulta por nit
		
	}
	

}

/********************************************** */
/* Tra resultados dela lista personalizada teniendo en cuenta el 
/* id de la empresa (filtrando */

async function getReportadosPersonalizado(req, res){

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;
	var idEmpresa = params.idEmpresa;
	//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
	// let nombreAliasParts = nombreAlias.split(' ');
	var i = 0;
	let queryString = [];
	// nombreAliasParts.forEach(element => {
	// 	var exp = "\\b" + element + "\\b";
	// 	var expReg = new RegExp(exp, 'i');
	// 	queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
	// 	i++;
	// });
	
	//queryString = queryString +','+ {empresa_id:idEmpresa};



	/************************************************************************************************** */
	/* Conforma la consulta para buscar las pabras digitalas en alias y le agrega que sea de su empresa */
	/************************************************************************************************** */
	queryString.push({
		empresa_id:  idEmpresa   
	  });
	  let nombreAliasParts = nombreAlias.split(' ');

	  nombreAliasParts.forEach(element => {
		var exp = "\\b" + element + "\\b";
		var expReg = new RegExp(exp, 'i');
		queryString.push({
		  "firstNamelastName": {
			"$regex": expReg  
		  }
		})
	  });
	const consulta ={
		"$and": queryString
	};

	/************************************************************************************************** */
	/* Conforma la consulta para buscar los numeros digitados en NIT y le agrega que sea de su empresa */
	/************************************************************************************************** */
	let queryStringNit = [];
	queryStringNit.push({
		empresa_id:  idEmpresa   
	  });
	var exp = "\\b" + nit + "\\b";
	var expReg = new RegExp(exp, 'i');
	queryStringNit.push({
		"idNumber": {
		"$regex": expReg  
		}
	})
	const consultaNit ={
		"$and": queryStringNit
	};

	
	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias !== '0' && nit !=='0'){
		
		try {
			//consulta por nit
			//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
			const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
			if(resultadoNit.length === 0){
				//consulta por nombre
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				
				//es porque no lo encontró por nombre. Entonces devuelve lo que buscó para que se pueda calcular el perfil del riesgo
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre[0].terminosBuscados = nit + ' / ' + nombreAlias;
					resultadoNombre[0].encontrado_por = nombre;
					res.json(resultadoNombre);
				}
			}else{
				resultadoNit.forEach(element => {
					element.terminosBuscados =  nit + ' / ' + nombreAlias;
					element.encontrado_por = '(NIT) ' + nit;
				})
				
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(error);
		}
	}else{
		if(nombreAlias !== '0' && nit ==='0'){ //solo llega nombreAlias
			//consulta por nombre alias
			try {
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				//no encontró el nombre
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre.forEach(element => {
						element.terminosBuscados =  nombreAlias;
						element.encontrado_por = '(Nombre) ' + nombreAlias;
					})
					// resultadoNombre[0].terminosBuscados = nombreAlias;
					// resultadoNombre[0].encontrado_por = nombreAlias;
					res.json(resultadoNombre);
				}
			} catch (error) {
				console.log(error.message);
				res.send(error);
			}
		}else{
			if(nit !== '0' && nombreAlias === '0'){
				
				try {
					//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
					//no encontró el nombre
						if(resultadoNit.length === 0) { 
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								idNumber: nit,
								terminosBuscados: nit,
								encontrado_por: '',
								estado: 'No Reportado'
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						}else{
							resultadoNit[0].terminosBuscados = nit;
							resultadoNit[0].encontrado_por = '(NIT) ' + nit;
							res.json(resultadoNit);
						}
				} catch (error) {
					res.send(err);
				}
			}
	}
	
		//consulta por nit
		
	}
	

}



//funcion para mover una lista entre colecciones
async function moveList(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").find({idLista: id});

		 const resultadoDocs = await resultado.toArray();
		 const resultado2 = await db.collection("backuplists").insertMany(resultadoDocs);

		 //const borra = await db.collection("lists").deleteMany({id: {$in: resultadoDocs}});

		 if(resultado) {
			//insertelo en una nueva colección para guardar el historicos de listas

			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}

async function delListPersonal(req, res){
	var listId = req.params.id;

	try {
		const resulta = Customlistname.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}



//********************************************* */
/* BORRA EL INDICE DE LA LISTA OFICIAL         */
/********************************************* */
async function delListOficial(req, res){
	var listId = req.params.id;

	try {
		const resulta = ListNameOficial.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}

 /*******************************************************************************************************/
 // funcion dejaro winkler
 // Additional notes
 /*******************************************************************************************************/
function jaroWinklerf(s1, s2){
	//return new Promise((resolve, reject) => {
		let dist = distance(s1,s2);
	//	resolve(dist);
	return dist;
	//});
  }



  


module.exports = {
	saveTransaction,
	updateTransaction,
	saveExcelTransaction,
	saveLista,
	saveListaXML,
	deleteLista,
	getTransactions,
	saveListname,
	getReportados,
	moveList,
	saveListaPersonalizada,
	getReportadosPersonalizado,
	saveMyListName,
	deleteListaPersonalizada,
	delListPersonal,
	delListOficial,
};


