'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');
 
const distance = require('jaro-winkler');


//para poder importar archivos de excel de +-50000 registros
//var express = require('express');
//var app = express();
//var bodyParser = require('body-parser');
//app.use(bodyParser.json({limit: "100mb", extended: true}));


//app.use(express.json({limit: '100mb'}));
//app.use(express.urlencoded({limit: '100mb'}));

//app.use(bodyParser.urlencoded({limit: "100mb", extended: true, parameterLimit:100000}));

//app.use(bodyParser.json({limit: '10mb', extended: true}))
//app.use(bodyParser.urlencoded({limit: '10mb', extended: true}))



var bcrypt = require('bcrypt-nodejs');
var Transaction = require('../models/transaction');
var jwt = require('../services/jwt');
const { Console } = require('console');
//const { db } = require('../models/transaction');
const api = require('../routes/transaction');
//const transaction = require('../models/transaction');

var List = require('../models/list');
const { db } = require('../models/list');
//const { query } = require('express');

var Customlistname = require('../models/customlistname');

var ListNameOficial = require('../models/listName');
//const { param } = require('../app');
//para acceder el data services y poner el valor de la variable por donde lo encontró




/********************************************************************************** */
//esta funcion sirve para grbar en la base de datos el nombre de una lista
//luego debe devolver el id de la lista creada para se salve como un campo adicional 
//cuando se graba una nueva lista
/********************************************************************************** */

//ya no se usa ??. revisar creo que si
async function saveListname(req, res){

	var titulo_lista = req.body;

	if (titulo_lista != ''){
		const resultado = await db.collection("listnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}

//graba en la base de datos el nombre de la lista indice y devuelve el id para identificar 
//en la collection customlists que lista pertenece a que empresa

async function saveMyListName(req, res){

	var titulo_lista = req.body;

	

	if (titulo_lista != ''){
		const resultado = await db.collection("customlistnames").insertOne(titulo_lista);
		if(resultado){
			res.send(resultado.insertedId);
		}else{
			//console.log("Error en el grabado de nombre de lista.");
		}
	}


}


function saveListaXML(req, res){

	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	//var primerRegistro = params[0];
	//var empresa_id = primerRegistro.empresa_id;

	
	var nombre_coleccion = "lists"
	//if (empresa_id != ''){
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	//}
}


function saveLista(req, res){
	//	var transaction = new Transaction();
	var params = req.body;

	List.firstNamelastName = params.firstNamelastName;

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;

	//var nombre_coleccion = "lists"
	
	if (empresa_id != ''){
		if(List.insertMany(params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}

	// List.save((err, planStored) => {
	// 	console.log(err);
	// 	if(err){
	// 		res.status(500).send({message: 'Error al guardar el pais'});
	// 	}else{
	// 		if(!planStored){
	// 			res.status(404).send({message: 'NO se ha guardado el pais'});
	// 		}else{
	// 			res.status(200).send({plan: planStored});
	// 		}
	// 	}
	// });


	// if (empresa_id != ''){
	// 	if(db.collection(nombre_coleccion).insertMany (params)){
	// 		res.status(200).send(true);
	// 	}else{
	// 		console.log("File imported error.");
	// 	}
	// }

	
}

function saveListaPersonalizada(req, res){
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;

	var nombre_coleccion = "customlists"
	
	if (empresa_id != ''){
		if(db.collection(nombre_coleccion).insertMany (params)){
			res.status(200).send(true);
		}else{
			console.log("File imported error.");
		}
	}
}

/******************************************************* */
//El borrado de una lista implica varias validaciones
//tener en cuenta 
/****************************************************** */

async function deleteLista(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}


async function deleteListaPersonalizada(req, res){
	var orden = req.params;
	var id = orden.id;
	try {
		 const resultado = await db.collection("customlists").deleteMany({idLista: id});

		 if(resultado.deletedCount > 0) {
			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}
			

function saveTransaction(req, res){

				var transaction = new Transaction();
			
				var params = req.body;
				
				transaction.empresa_id = params.empresa_id;
				transaction.nit = params.nit;
				transaction.nombreTransaccion = params.nombreTransaccion;
				transaction.montoTransaccion = params.montoTransaccion;
				transaction.fechaTransaccion = params.fechaTransaccion;
				//completar
				//transaction.idUsario = 'traerlo de la session'
				//transaction.idEmpresa = params.idEmpresa;
				//completar
				transaction.creado = new Date();
			
			
							if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
								//guarda el usuario
								transaction.save((err, transactionStored) => {
									if(err){
										res.status(500).send({message: 'Error al guardar la transacción'});
									}else{
										if(!transactionStored){
											res.status(404).send({message: 'NO se ha guardado la transacción'});
										}else{
											res.status(200).send({transaction: transactionStored});
										}
									}
								});
							}else{
								res.status(200).send({message: 'Rellena todos los campos por favor'});
							}
			
						}



function updateTransaction(req, res){
	var transactionId = req.params.id;
	var update = req.body;

	transaction.findByIdAndUpdate(transactionId, update, (err, transactionUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar la transaccion'});
		}else{
			if(!transactionUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la transaccion'});
			}else{
				res.status(200).send({user: transactionUpdated});
			}
		}


	})

}


function saveExcelTransaction(req, res){
	var transaction = new Transaction();
	var params = req.body;

	
}

/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada
/********************************************************/
function getTransactions(req, res){

	var params = req.body;
	
	var fechaIni = req.params.fIni;
	var fechaFin = req.params.fFin;
	const agg = [
		{
		  '$match': {
			'$and': [
			  {
				'fechaTransaccion': {
				  '$gte': new Date(fechaIni)
				}
			  }, {
				'fechaTransaccion': {
				  '$lte': new Date(fechaFin)
				}
			  }
			]
		  }
		}, {
		  '$group': {
			'_id': {}, 
			'Promedio': {
			  '$avg': '$montoTransaccion'
			},
			devstd:{
				$stdDevSamp: '$montoTransaccion'
			}
		  }
		}
	  ];
	  
	
Transaction.aggregate(agg).exec((err, transaccion) => {
	if(err){
		message: 'error en el servidor';
	}else{
		if(transaccion){
			res.status(200).send({transaccion});
		}
	}
} );
	



}


function normalizeText(text) {
    // Validación de entrada mejorada
    if (!text || typeof text !== 'string') {
        return '';
    }
    return text
        .normalize("NFD")
        .replace(/[\u0300-\u036f]/g, "") // Elimina acentos
        .replace(/ñ/g, 'n')              // Manejo explícito de ñ
        .replace(/Ñ/g, 'n')              // Manejo explícito de Ñ
        // CAMBIO IMPORTANTE: Preservar guiones, apostrofes y puntos en nombres
        .replace(/[^a-zA-Z0-9\s\-'\.]/g, "")  // Preserva guiones (-), apostrofes (') y puntos (.)
        .toLowerCase()                    // Convierte todo a minúsculas
        .replace(/\s+/g, ' ')            // Normaliza espacios múltiples a uno solo
        .trim();                         // Elimina espacios al inicio y final
}


const mongoose = require('mongoose');
// async function crearIndices() {
//     try {
//         const List = mongoose.model('List');
//         const collection = List.collection;

//         // Obtener índices existentes una sola vez
//         const indicesExistentes = await collection.indexes();
        
//         // Crear un Set con los campos que ya tienen índices (más rápido)
//         const camposConIndice = new Set();
//         indicesExistentes.forEach(idx => {
//             Object.keys(idx.key).forEach(campo => camposConIndice.add(campo));
//         });

//         // Definir índices a crear
//         const indicesACrear = [
//             { campo: 'idNumber', nombre: 'idNumber_1' },
//             { campo: 'firstNamelastName', nombre: 'firstNamelastName_1' },
//             { campo: 'miAlias', nombre: 'miAlias_1' }
//         ];

//         // Crear índices en paralelo
//         const promesas = indicesACrear.map(async (indice) => {
//             if (camposConIndice.has(indice.campo)) {
//                 console.log(`✓ Índice en ${indice.campo} ya existe`);
//                 return { campo: indice.campo, status: 'exists' };
//             }

//             try {
//                 await collection.createIndex(
//                     { [indice.campo]: 1 }, 
//                     { name: indice.nombre, background: true }
//                 );
//                 console.log(`✓ Índice creado: ${indice.nombre}`);
//                 return { campo: indice.campo, status: 'created' };
//             } catch (err) {
//                 if (err.code === 85 || err.code === 86) {
//                     console.log(`⚠ Índice en ${indice.campo} ya existe con otro nombre`);
//                     return { campo: indice.campo, status: 'exists_different_name' };
//                 } else {
//                     console.error(`✗ Error creando índice ${indice.nombre}:`, err.message);
//                     return { campo: indice.campo, status: 'error', error: err.message };
//                 }
//             }
//         });

//         // Esperar todas las promesas
//         await Promise.all(promesas);

//         console.log('✓ Verificación de índices completada');
//         return true;
//     } catch (error) {
//         console.error('Error al crear índices:', error.message);
//         console.warn('⚠ Continuando con índices existentes');
//         return false;
//     }
// }





/* *******************************
	FUNCIONES UTILES UTILIZADAS A LO LARGO DEL CODIGO
******************************** */

	async function searchByName(searchTerm, PersonModel) {
  try {
    // Normalizar el término de búsqueda
    //const normalizedSearch = normalizeSearchTerm(searchTerm);
	const normalizedSearch = searchTerm;
    
    // Realizar búsqueda con text search
    const results = await PersonModel.aggregate([
      {
        // Búsqueda de texto
        $match: {
          $text: { 
            $search: normalizedSearch,
            $caseSensitive: false,
            $diacriticSensitive: false
          }
        }
      },
      {
        // Agregar el score de relevancia
        $addFields: {
          score: { $meta: "textScore" }
        }
      },
      {
        // Ordenar por score descendente (mejor coincidencia primero)
        $sort: { score: -1 }
      },
      {
        // Limitar a 10 resultados
        $limit: 5
      },
      {
        // Proyectar campos necesarios (ajusta según tus necesidades)
        $project: {
          firstNamelastName: 1,
          miAlias: 1,
		  estado: 1,
		  idNumber: 1,
		  otraInformacion: 1,
		  nombreLista: 1,
		  tipoLista: 1,
          score: 1,
          // Agrega otros campos que necesites
          _id: 1
        }
      }
    ]);

    return results;

  } catch (error) {
    console.error('Error en búsqueda de texto:', error);
    throw error;
  }
}


/**
 * Normaliza el término de búsqueda para mejorar coincidencias
 * @param {string} term - Término a normalizar
 * @returns {string} - Término normalizado
 */
function normalizeSearchTerm(term) {
  if (!term) return '';
  
  let normalized = term.trim();
  
  // Remover puntos comunes en siglas (s.a.s -> sas, s.a -> sa, etc.)
  normalized = normalized.replace(/\b([a-zA-Z])\.(?=[a-zA-Z])/g, '$1');
  normalized = normalized.replace(/\b([a-zA-Z])\.\s*/g, '$1 ');
  
  // Remover caracteres especiales comunes pero mantener espacios
  normalized = normalized.replace(/[.,\/#!$%\^&\*;:{}=\-_`~()]/g, ' ');
  
  // Eliminar múltiples espacios
  normalized = normalized.replace(/\s+/g, ' ').trim();
  
  // Agregar operador OR implícito para búsqueda más flexible
  // Esto ayuda a encontrar coincidencias parciales
  const words = normalized.split(' ');
  
  // Si hay múltiples palabras, crear búsqueda que requiera algunas palabras
  if (words.length > 2) {
    // Para frases largas, buscar coincidencia exacta de frase Y palabras individuales
    normalized = `"${normalized}" ${words.join(' ')}`;
  }
  console.log('el resultadod e la normalizacion....', normalized);
  return normalized;
}


//Crea indices compuestos
async function crearIndices() {
    try {
        const List = mongoose.model('List');
        const collection = List.collection;

        // Obtener índices existentes una sola vez
        const indicesExistentes = await collection.indexes();
        
        // Verificar si existe el índice de texto compuesto
        const tieneIndiceTexto = indicesExistentes.some(idx => 
            idx.key && (idx.key._fts === 'text' || idx.textIndexVersion)
        );

        if (tieneIndiceTexto) {
            console.log('✓ Índice de texto compuesto ya existe');
        } else {
            try {
                // Crear índice de texto compuesto con pesos
                await collection.createIndex(
                    { 
                        //idNumber: "text", 
                        firstNamelastName: "text",
                        miAlias: "text"
                    },
                    {
                        name: "search_text_index",
                        weights: {
                            //idNumber: 10,
                            firstNamelastName: 10,
                            miAlias: 8
                        },
                        default_language: "none", //fuinciona para ingles y español
                        background: true
                    }
                );
                console.log('✓ Índice de texto compuesto creado: search_text_index');
                console.log('  - idNumber (peso: 10)');
                console.log('  - firstNamelastName (peso: 5)');
                console.log('  - miAlias (peso: 3)');
            } catch (err) {
                if (err.code === 85 || err.code === 86) {
                    console.log('⚠ Índice de texto ya existe con otro nombre');
                } else {
                    console.error('✗ Error creando índice de texto:', err.message);
                    throw err;
                }
            }
        }

        console.log('✓ Verificación de índices completada');
        return true;
    } catch (error) {
        console.error('Error al crear índices:', error.message);
        console.warn('⚠ Continuando con índices existentes');
        return false;
    }
}



/***************************************
FIN DE FUNCIONES UTILES UTILIZADAS A LO LARGO DEL CODIGO
****************************************/



//PARA DEVOLVER LOS USUARIOS REPORTADOS
/******************************** */
//SE USA PARA LA CONSULTA SENCILLA
/******************************** */

async function getReportados(req, res){

	await crearIndices();

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;

	const resultado = await advancedSearch(List, {
		idNumber: nit,
		firstNamelastName: nombreAlias
	});

	console.log(resultado.results);

}


/* codigo para getResultados */

// ============================================
// CONFIGURACIÓN
// ============================================

// Umbral de similitud mínimo (0-100)
const SIMILARITY_THRESHOLD = 75; // Aumentado de 70 a 75
const MIN_WORD_MATCHES = 2; // Mínimo de palabras que deben coincidir

/*
ESTRUCTURA DE DOCUMENTOS EN MONGODB:
{
  _id: ObjectId,
  firstNamelastName: String,  // Ej: "José García Pérez" o "Anibal Enterprise S.A."
  miAlias: String,            // Ej: "Pepe" o "Anibal Corp"
  idNumber: String            // Ej: "1234567890"
}

ÍNDICES RECOMENDADOS:
db.collection.createIndex({
  firstNamelastName: "text",
  miAlias: "text",
  idNumber: "text"
}, {
  weights: {
    idNumber: 10,
    firstNamelastName: 5,
    miAlias: 3
  },
  name: "search_index"
});

db.collection.createIndex({ idNumber: 1 });
db.collection.createIndex({ firstNamelastName: 1 });
db.collection.createIndex({ miAlias: 1 });
*/

// ============================================
// FUNCIONES AUXILIARES
// ============================================

/**
 * Ejecuta un pipeline de agregación compatible con MongoDB nativo y Mongoose
 */
async function executeAggregate(collection, pipeline) {
  try {
    const cursor = collection.aggregate(pipeline);
    
    if (typeof cursor.toArray === 'function') {
      return await cursor.toArray();
    } else if (cursor.then) {
      return await cursor;
    } else {
      return await cursor;
    }
  } catch (error) {
    console.error('Error ejecutando aggregate:', error);
    throw error;
  }
}

/**
 * Normaliza texto de forma SUAVE (solo tildes y mayúsculas)
 */
function normalizeTextLight(text) {
  if (!text) return '';
  return text
    .toString()
    .normalize('NFD')
    .replace(/[\u0300-\u036f]/g, '')
    .toLowerCase()
    .trim();
}

/**
 * Genera variaciones de búsqueda para aumentar las coincidencias
 */
function generateSearchVariations(text) {
  if (!text) return [];
  
  const normalized = normalizeTextLight(text);
  const variations = [normalized];
  
  const withoutDots = normalized.replace(/\./g, '');
  if (withoutDots !== normalized) {
    variations.push(withoutDots);
  }
  
  const withoutDotsCompact = normalized.replace(/\.\s*/g, '');
  if (withoutDotsCompact !== normalized && withoutDotsCompact !== withoutDots) {
    variations.push(withoutDotsCompact);
  }
  
  const withSpaces = normalized.replace(/-/g, ' ');
  if (withSpaces !== normalized) {
    variations.push(withSpaces);
  }
  
  const compact = normalized.replace(/\s+/g, ' ');
  if (compact !== normalized) {
    variations.push(compact);
  }
  
  return [...new Set(variations)];
}

/**
 * Escapa caracteres especiales para regex
 */
function escapeRegex(text) {
  return text.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}

/**
 * Calcula similitud entre dos strings (0-100)
 * Usa algoritmo mejorado de Jaro-Winkler simplificado
 */
function calculateSimilarity(str1, str2) {
  if (!str1 || !str2) return 0;
  if (str1 === str2) return 100;
  
  const s1 = normalizeTextLight(str1);
  const s2 = normalizeTextLight(str2);
  
  if (s1 === s2) return 100;
  
  // Similitud por palabras coincidentes (más estricta)
  const words1 = s1.split(/\s+/).filter(w => w.length > 0);
  const words2 = s2.split(/\s+/).filter(w => w.length > 0);
  
  if (words1.length === 0 || words2.length === 0) return 0;
  
  let exactMatches = 0;
  let partialMatches = 0;
  
  words1.forEach(w1 => {
    words2.forEach(w2 => {
      if (w1 === w2) {
        exactMatches++;
      } else if (w1.length > 3 && w2.length > 3) {
        if (w1.includes(w2) || w2.includes(w1)) {
          partialMatches += 0.5;
        }
      }
    });
  });
  
  const totalMatches = exactMatches + partialMatches;
  const maxWords = Math.max(words1.length, words2.length);
  const wordSimilarity = (totalMatches / maxWords) * 100;
  
  // Similitud por caracteres
  const maxLen = Math.max(s1.length, s2.length);
  const minLen = Math.min(s1.length, s2.length);
  
  let matches = 0;
  for (let i = 0; i < minLen; i++) {
    if (s1[i] === s2[i]) matches++;
  }
  
  const charSimilarity = (matches / maxLen) * 100;
  
  // Penalización por diferencia de longitud
  const lengthDiff = Math.abs(s1.length - s2.length) / maxLen;
  const lengthPenalty = lengthDiff * 20;
  
  // Promedio ponderado con penalización
  const similarity = (wordSimilarity * 0.75) + (charSimilarity * 0.25) - lengthPenalty;
  
  return Math.max(0, Math.round(similarity));
}

/**
 * Cuenta cuántas palabras del búsqueda coinciden en el texto
 */
function countWordMatches(searchWords, targetText) {
  const targetNormalized = normalizeTextLight(targetText);
  const targetWords = targetNormalized.split(/\s+/).filter(w => w.length > 0);
  
  let matches = 0;
  searchWords.forEach(searchWord => {
    if (targetWords.some(targetWord => 
      targetWord === searchWord || 
      (searchWord.length > 3 && targetWord.includes(searchWord)) ||
      (targetWord.length > 3 && searchWord.includes(targetWord))
    )) {
      matches++;
    }
  });
  
  return matches;
}

/**
 * Genera variaciones de un nombre para búsqueda flexible
 */
function generateNameVariations(fullName) {
  const normalized = normalizeTextLight(fullName);
  const words = normalized.split(/\s+/).filter(w => w.length > 0);
  
  return {
    original: fullName,
    normalized: normalized,
    words: words,
    variations: generateSearchVariations(fullName),
    firstWord: words[0] || '',
    lastWord: words[words.length - 1] || '',
    wordCount: words.length
  };
}

// ============================================
// PIPELINE PRINCIPAL DE BÚSQUEDA
// ============================================

async function advancedSearch(collection, { idNumber, firstNamelastName }, options = {}) {
  const threshold = options.similarityThreshold || SIMILARITY_THRESHOLD;
  
  // CASO 1: Solo idNumber
  if (idNumber && !firstNamelastName) {
    return await searchByIdNumber(collection, idNumber);
  }
  
  // CASO 2: Solo nombre
  if (!idNumber && firstNamelastName) {
    return await searchByName(collection, firstNamelastName, threshold);
  }
  
  // CASO 3: Ambos parámetros
  if (idNumber && firstNamelastName) {
    return await searchByBoth(collection, idNumber, firstNamelastName, threshold);
  }
  
  // CASO 4: Sin parámetros
  return {
    success: false,
    message: 'Debe proporcionar al menos un parámetro de búsqueda',
    results: []
  };
}

// ============================================
// BÚSQUEDA POR ID NUMBER
// ============================================

async function searchByIdNumber(collection, idNumber) {
  const normalizedId = normalizeTextLight(idNumber);
  const escapedId = escapeRegex(normalizedId);
  
  // Word boundary para búsqueda más precisa
  const wordBoundaryRegex = `\\b${escapedId}\\b`;
  
  const pipeline = [
    {
      $addFields: {
        idNumber_normalized: {
          $toLower: { $trim: { input: { $ifNull: ["$idNumber", ""] } } }
        }
      }
    },
    {
      $match: {
        idNumber_normalized: {
          $regex: wordBoundaryRegex,
          $options: 'i'
        }
      }
    },
    {
      $addFields: {
        relevanceScore: {
          $add: [
            { $cond: [{ $eq: ["$idNumber_normalized", normalizedId] }, 100, 0] },
            { $cond: [
              { $regexMatch: { input: "$idNumber_normalized", regex: `^${escapedId}\\b` } },
              80,
              0
            ]},
            { $cond: [
              { $regexMatch: { input: "$idNumber_normalized", regex: `\\b${escapedId}$` } },
              60,
              0
            ]},
            { $cond: [
              { $regexMatch: { input: "$idNumber_normalized", regex: `\\b${escapedId}\\b` } },
              40,
              0
            ]}
          ]
        }
      }
    },
    {
      $sort: { relevanceScore: -1, idNumber: 1 }
    },
    {
      $project: {
        idNumber_normalized: 0
      }
    }
  ];
  
  try {
    const results = await executeAggregate(collection, pipeline);
    
    return {
      success: results.length > 0,
      searchType: 'idNumber',
      matchCount: results.length,
      results: results
    };
  } catch (error) {
    console.error('Error en searchByIdNumber:', error);
    throw error;
  }
}

// ============================================
// BÚSQUEDA POR NOMBRE CON SIMILITUD (CORREGIDA)
// ============================================

async function searchByName(collection, nameParam, threshold) {
  const variations = generateNameVariations(nameParam);
  
  // ✅ CORRECCIÓN: Búsqueda más estricta
  const orConditions = [];
  
  // 1. Búsqueda por coincidencia completa o casi completa
  variations.variations.forEach(variant => {
    const escaped = escapeRegex(variant);
    orConditions.push(
      { firstNamelastName: { $regex: `^${escaped}`, $options: 'i' } }, // Empieza con
      { firstNamelastName: { $regex: `${escaped}$`, $options: 'i' } }, // Termina con
      { firstNamelastName: { $regex: `^${escaped}$`, $options: 'i' } }, // Coincidencia exacta
      { miAlias: { $regex: escaped, $options: 'i' } } // Alias puede ser más flexible
    );
  });
  
  // 2. ✅ CORRECCIÓN: Solo buscar por palabras individuales si hay pocas palabras
  //    Y solo si la palabra es significativa (4+ caracteres)
  if (variations.wordCount <= 2) {
    variations.words.forEach(word => {
      if (word.length >= 4) { // Aumentado de 3 a 4
        const escaped = escapeRegex(word);
        orConditions.push(
          { firstNamelastName: { $regex: `\\b${escaped}\\b`, $options: 'i' } }
        );
      }
    });
  }
  
  const pipeline = [
    {
      $match: {
        $or: orConditions
      }
    },
    {
      $limit: 100
    }
  ];
  
  try {
    let results = await executeAggregate(collection, pipeline);
    
    // Post-procesamiento: calcular similitud y filtrar
    results = results.map(doc => {
      const nameSimilarity = calculateSimilarity(nameParam, doc.firstNamelastName);
      const aliasSimilarity = doc.miAlias ? calculateSimilarity(nameParam, doc.miAlias) : 0;
      const maxSimilarity = Math.max(nameSimilarity, aliasSimilarity);
      
      // ✅ CORRECCIÓN: Contar palabras coincidentes
      const nameWordMatches = countWordMatches(variations.words, doc.firstNamelastName);
      const aliasWordMatches = doc.miAlias ? countWordMatches(variations.words, doc.miAlias) : 0;
      const maxWordMatches = Math.max(nameWordMatches, aliasWordMatches);
      
      return {
        ...doc,
        similarityScore: maxSimilarity,
        nameSimilarity: nameSimilarity,
        aliasSimilarity: aliasSimilarity,
        wordMatches: maxWordMatches,
        searchWordCount: variations.wordCount
      };
    });
    
    // ✅ CORRECCIÓN: Filtrar por umbral Y por número mínimo de palabras coincidentes
    results = results.filter(doc => {
      // Si la búsqueda tiene múltiples palabras, requerir mínimo de coincidencias
      if (variations.wordCount >= 2) {
        const minRequired = Math.min(MIN_WORD_MATCHES, variations.wordCount);
        return doc.similarityScore >= threshold && doc.wordMatches >= minRequired;
      }
      // Si es una sola palabra, solo aplicar threshold
      return doc.similarityScore >= threshold;
    });
    
    // Ordenar por similitud y luego por palabras coincidentes
    results.sort((a, b) => {
      if (b.similarityScore !== a.similarityScore) {
        return b.similarityScore - a.similarityScore;
      }
      return b.wordMatches - a.wordMatches;
    });
    
    return {
      success: results.length > 0,
      searchType: 'name_similarity',
      matchCount: results.length,
      threshold: threshold,
      minWordMatches: variations.wordCount >= 2 ? MIN_WORD_MATCHES : 1,
      results: results.slice(0, 50)
    };
  } catch (error) {
    console.error('Error en searchByName:', error);
    return {
      success: false,
      searchType: 'name_similarity',
      matchCount: 0,
      threshold: threshold,
      results: [],
      error: error.message
    };
  }
}

// ============================================
// BÚSQUEDA CON AMBOS PARÁMETROS (CORREGIDA)
// ============================================

async function searchByBoth(collection, idNumber, nameParam, threshold) {
  const variations = generateNameVariations(nameParam);
  const normalizedId = normalizeTextLight(idNumber);
  const escapedId = escapeRegex(normalizedId);
  const wordBoundaryRegex = `\\b${escapedId}\\b`;
  
  // ✅ CORRECCIÓN: Condiciones de nombre más estrictas
  const nameOrConditions = [];
  
  variations.variations.forEach(variant => {
    const escaped = escapeRegex(variant);
    nameOrConditions.push(
      { firstNamelastName: { $regex: `^${escaped}`, $options: 'i' } },
      { firstNamelastName: { $regex: `${escaped}$`, $options: 'i' } },
      { miAlias: { $regex: escaped, $options: 'i' } }
    );
  });
  
  // Solo palabras significativas
  if (variations.wordCount <= 2) {
    variations.words.forEach(word => {
      if (word.length >= 4) {
        const escaped = escapeRegex(word);
        nameOrConditions.push(
          { firstNamelastName: { $regex: `\\b${escaped}\\b`, $options: 'i' } }
        );
      }
    });
  }
  
  const pipeline = [
    {
      $addFields: {
        idNumber_normalized: {
          $toLower: { $trim: { input: { $ifNull: ["$idNumber", ""] } } }
        }
      }
    },
    {
      $match: {
        $and: [
          { idNumber_normalized: { $regex: wordBoundaryRegex, $options: 'i' } },
          { $or: nameOrConditions }
        ]
      }
    },
    {
      $limit: 100
    }
  ];
  
  try {
    let results = await executeAggregate(collection, pipeline);
    
    if (results.length > 0) {
      results = results.map(doc => {
        const nameSimilarity = calculateSimilarity(nameParam, doc.firstNamelastName);
        const aliasSimilarity = doc.miAlias ? calculateSimilarity(nameParam, doc.miAlias) : 0;
        const maxSimilarity = Math.max(nameSimilarity, aliasSimilarity);
        
        const nameWordMatches = countWordMatches(variations.words, doc.firstNamelastName);
        const aliasWordMatches = doc.miAlias ? countWordMatches(variations.words, doc.miAlias) : 0;
        const maxWordMatches = Math.max(nameWordMatches, aliasWordMatches);
        
        return {
          ...doc,
          similarityScore: maxSimilarity,
          wordMatches: maxWordMatches,
          relevanceScore: 100
        };
      });
      
      // ✅ CORRECCIÓN: Aplicar mismo filtro que en searchByName
      results = results.filter(doc => {
        if (variations.wordCount >= 2) {
          const minRequired = Math.min(MIN_WORD_MATCHES, variations.wordCount);
          return doc.similarityScore >= threshold && doc.wordMatches >= minRequired;
        }
        return doc.similarityScore >= threshold;
      });
      
      results.sort((a, b) => {
        if (b.similarityScore !== a.similarityScore) {
          return b.similarityScore - a.similarityScore;
        }
        return b.wordMatches - a.wordMatches;
      });
      
      if (results.length > 0) {
        return {
          success: true,
          searchType: 'both_parameters',
          matchCount: results.length,
          threshold: threshold,
          results: results.slice(0, 50)
        };
      }
    }
    
    // Estrategia 2: Fallback - buscar por separado
    const idResults = await searchByIdNumber(collection, idNumber);
    const nameResults = await searchByName(collection, nameParam, threshold);
    
    // ✅ CORRECCIÓN: Priorizar resultados que aparecen en ambas búsquedas
    const idMap = new Map(idResults.results.map(r => [r._id.toString(), r]));
    const nameMap = new Map(nameResults.results.map(r => [r._id.toString(), r]));
    
    const bothMatches = [];
    const onlyIdMatches = [];
    const onlyNameMatches = [];
    
    idResults.results.forEach(doc => {
      const id = doc._id.toString();
      if (nameMap.has(id)) {
        bothMatches.push({ ...doc, matchType: 'both' });
      } else {
        onlyIdMatches.push({ ...doc, matchType: 'id_only' });
      }
    });
    
    nameResults.results.forEach(doc => {
      const id = doc._id.toString();
      if (!idMap.has(id)) {
        onlyNameMatches.push({ ...doc, matchType: 'name_only' });
      }
    });
    
    const combinedResults = [...bothMatches, ...onlyIdMatches, ...onlyNameMatches];
    
    return {
      success: combinedResults.length > 0,
      searchType: 'fallback_separate',
      matchCount: combinedResults.length,
      threshold: threshold,
      bothMatches: bothMatches.length,
      idOnlyMatches: onlyIdMatches.length,
      nameOnlyMatches: onlyNameMatches.length,
      results: combinedResults.slice(0, 50)
    };
  } catch (error) {
    console.error('Error en searchByBoth:', error);
    return {
      success: false,
      searchType: 'both_parameters',
      matchCount: 0,
      threshold: threshold,
      results: [],
      error: error.message
    };
  }
}

// ============================================
// EXPORTACIÓN
// ============================================

module.exports = {
  advancedSearch,
  calculateSimilarity,
  normalizeTextLight,
  generateSearchVariations,
  executeAggregate,
  countWordMatches,
  SIMILARITY_THRESHOLD,
  MIN_WORD_MATCHES
};

/*
EJEMPLO DE USO:

const { MongoClient } = require('mongodb');
const { advancedSearch } = require('./searchPipeline');

async function main() {
  const client = await MongoClient.connect('mongodb://localhost:27017');
  const db = client.db('myDatabase');
  const collection = db.collection('persons');
  
  // Búsqueda por nombre - ahora más precisa
  const result1 = await advancedSearch(collection, {
    firstNamelastName: 'José García'
  });
  console.log('Resultados:', result1);
  
  // Búsqueda con umbral personalizado
  const result2 = await advancedSearch(
    collection,
    { firstNamelastName: 'Jose Maria' },
    { similarityThreshold: 80 }
  );
  
  // Ver detalles de coincidencias
  result2.results.forEach(r => {
    console.log(`Nombre: ${r.firstNamelastName}`);
    console.log(`Similitud: ${r.similarityScore}%`);
    console.log(`Palabras coincidentes: ${r.wordMatches}/${r.searchWordCount}`);
  });
  
  await client.close();
}

main().catch(console.error);
*/

/* fin de codigo para getResultados */















/********************************************** */
/* Tra resultados dela lista personalizada teniendo en cuenta el 
/* id de la empresa (filtrando */

async function getReportadosPersonalizado(req, res){

	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;
	var idEmpresa = params.idEmpresa;
	//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
	// let nombreAliasParts = nombreAlias.split(' ');
	var i = 0;
	let queryString = [];
	// nombreAliasParts.forEach(element => {
	// 	var exp = "\\b" + element + "\\b";
	// 	var expReg = new RegExp(exp, 'i');
	// 	queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
	// 	i++;
	// });
	
	//queryString = queryString +','+ {empresa_id:idEmpresa};



	/************************************************************************************************** */
	/* Conforma la consulta para buscar las pabras digitalas en alias y le agrega que sea de su empresa */
	/************************************************************************************************** */
	queryString.push({
		empresa_id:  idEmpresa   
	  });
	  let nombreAliasParts = nombreAlias.split(' ');

	  nombreAliasParts.forEach(element => {
		var exp = "\\b" + element + "\\b";
		var expReg = new RegExp(exp, 'i');
		queryString.push({
		  "firstNamelastName": {
			"$regex": expReg  
		  }
		})
	  });
	const consulta ={
		"$and": queryString
	};

	/************************************************************************************************** */
	/* Conforma la consulta para buscar los numeros digitados en NIT y le agrega que sea de su empresa */
	/************************************************************************************************** */
	let queryStringNit = [];
	queryStringNit.push({
		empresa_id:  idEmpresa   
	  });
	var exp = "\\b" + nit + "\\b";
	var expReg = new RegExp(exp, 'i');
	queryStringNit.push({
		"idNumber": {
		"$regex": expReg  
		}
	})
	const consultaNit ={
		"$and": queryStringNit
	};

	
	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias !== '0' && nit !=='0'){
		
		try {
			//consulta por nit
			//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
			const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
			if(resultadoNit.length === 0){
				//consulta por nombre
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				
				//es porque no lo encontró por nombre. Entonces devuelve lo que buscó para que se pueda calcular el perfil del riesgo
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre[0].terminosBuscados = nit + ' / ' + nombreAlias;
					resultadoNombre[0].encontrado_por = nombre;
					res.json(resultadoNombre);
				}
			}else{
				resultadoNit.forEach(element => {
					element.terminosBuscados =  nit + ' / ' + nombreAlias;
					element.encontrado_por = '(NIT) ' + nit;
				})
				
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(error);
		}
	}else{
		if(nombreAlias !== '0' && nit ==='0'){ //solo llega nombreAlias
			//consulta por nombre alias
			try {
				const resultadoNombre = await db.collection("customlists").find(consulta).toArray();
				//no encontró el nombre
				if(resultadoNombre.length === 0) { 
					const sinResultados =  {
						firstNamelastName: nombreAlias,
						idNumber: nit,
						terminosBuscados: nit + ' / ' + nombreAlias,
						encontrado_por: '',
						estado: 'No Reportado'
					}
					const arraySinResultados = [sinResultados];
					res.json(arraySinResultados);
				}else{
					resultadoNombre.forEach(element => {
						element.terminosBuscados =  nombreAlias;
						element.encontrado_por = '(Nombre) ' + nombreAlias;
					})
					// resultadoNombre[0].terminosBuscados = nombreAlias;
					// resultadoNombre[0].encontrado_por = nombreAlias;
					res.json(resultadoNombre);
				}
			} catch (error) {
				console.log(error.message);
				res.send(error);
			}
		}else{
			if(nit !== '0' && nombreAlias === '0'){
				
				try {
					//const resultadoNit = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					const resultadoNit = await db.collection("customlists").find(consultaNit).toArray();
					//no encontró el nombre
						if(resultadoNit.length === 0) { 
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								idNumber: nit,
								terminosBuscados: nit,
								encontrado_por: '',
								estado: 'No Reportado'
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						}else{
							resultadoNit[0].terminosBuscados = nit;
							resultadoNit[0].encontrado_por = '(NIT) ' + nit;
							res.json(resultadoNit);
						}
				} catch (error) {
					res.send(err);
				}
			}
	}
	
		//consulta por nit
		
	}
	

}



//funcion para mover una lista entre colecciones
async function moveList(req, res){
	var orden = req.params;
	var id = orden.id;
	
	try {
		 const resultado = await db.collection("lists").find({idLista: id});

		 const resultadoDocs = await resultado.toArray();
		 const resultado2 = await db.collection("backuplists").insertMany(resultadoDocs);

		 //const borra = await db.collection("lists").deleteMany({id: {$in: resultadoDocs}});

		 if(resultado) {
			//insertelo en una nueva colección para guardar el historicos de listas

			res.send({eliminados: resultado.deletedCount});
		  } else {
			res.send({reselim: 'Sin documentos para eliminar'});
		  }
	} catch (error) {
		res.send().error;
	}

}

async function delListPersonal(req, res){
	var listId = req.params.id;

	try {
		const resulta = Customlistname.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}



//********************************************* */
/* BORRA EL INDICE DE LA LISTA OFICIAL         */
/********************************************* */
async function delListOficial(req, res){
	var listId = req.params.id;

	try {
		const resulta = ListNameOficial.findByIdAndDelete({'_id': listId}, function (err, listIdRemoved){
			if (err){
				res.send(err)
			}else{
				res.send({elimnados: resulta.deletedCount});
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover la lista'});
	}
}

 /*******************************************************************************************************/
 // funcion dejaro winkler
 // Additional notes
 /*******************************************************************************************************/
function jaroWinklerf(s1, s2){
	//return new Promise((resolve, reject) => {
		let dist = distance(s1,s2);
	//	resolve(dist);
	return dist;
	//});
  }


module.exports = {
	saveTransaction,
	updateTransaction,
	saveExcelTransaction,
	saveLista,
	saveListaXML,
	deleteLista,
	getTransactions,
	saveListname,
	getReportados,
	moveList,
	saveListaPersonalizada,
	getReportadosPersonalizado,
	saveMyListName,
	deleteListaPersonalizada,
	delListPersonal,
	delListOficial,
};


