'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Percent = require('../models/percent');
var jwt = require('../services/jwt');
//onst { json } = require('body-parser');



function getPercent(req, res){
	var id_empresa = req.params.id;
		try {
			
			const percent = Percent.find({'idEmpresa': id_empresa}, function(err, percent) { 
				if (err){
					res.send(err)
				}else{
					res.json(percent);
				}
			}); 
			//console.log("Los porcentajes "+percent);
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
		}
	
	}


	 /*******************************************************************************************************/
	 // Devuelve todos los porcentajes para que se puedan crear los porcentajes de cada empres
	 // Los personalizados
	 /*******************************************************************************************************/

	 function getAllPercent(req, res){
		//var id_empresa = req.params.id;
		let datos = JSON.parse(req.query['DATOS']);
		let tipo_porcentaje = datos.tipo_porcentaje;
		let id_empresa = datos.idEmpresa;
		let clase_porcentaje = datos.clase_porcentaje;
		
		const consulta = { $and : [{tipo_porcentaje: tipo_porcentaje}, {idEmpresa: id_empresa}, {clase_porcentaje: clase_porcentaje}]};
			try {
				
				//const porcentajes = Percent.find({'idEmpresa': id_empresa}, function(err, porcentajes) { 
				const porcentajes = Percent.find(consulta, function(err, porcentajes) { 
					if (err){
						res.send(err)
					}else{
						//console.log('xxxx', porcentajes);
						res.json(porcentajes);
					}
				}); 
				
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
			}
		
		}

	 /*******************************************************************************************************/
	 // Devuelve todos los porcentajes y los trae por idEmpresa
	 // Los personalizados
	 /*******************************************************************************************************/

	 function getAllPercentByIdEmpresa(req, res){
		var id_empresa = req.params.idEmpresa;

			try {
				
				const porcentajes = Percent.find({'idEmpresa': id_empresa}, function(err, porcentajes) { 
				
					if (err){
						res.send(err)
					}else{
						res.json(porcentajes);
					}
				}); 
				
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
			}
		
		}

	/*******************************************************************************************************/
	// Graba los procentajes oficiales en la base de datos
	// Additional notes
	/*******************************************************************************************************/
	async function savePercent(req, res){
		var id_empresa = req.params.idEmpresa;
		var PORCENTAJES = 	req.body;

		let consulta = { $and : [{tipo_porcentaje: PORCENTAJES.tipo_porcentaje}, {idEmpresa: id_empresa}, {clase_porcentaje: PORCENTAJES.clase_porcentaje}]};

		//consulte si existe el documento
		try {
			const existe = await Percent.findOne(consulta);
			
			if (existe) {
				// Si existe, actualice el documento
				const graba_porcentaje = Percent.findOneAndUpdate(consulta, PORCENTAJES)
				.then(updatedPercent => {
					if (!updatedPercent) {
						// Si updatedPercent es null, significa que no se encontró un documento para actualizar
						console.error('No se encontró un documento para actualizar.');

					  } else {
						// La actualización fue exitosa, y updatedPercent contiene el documento actualizado
						var rpta = 'porcentajes_actualizados';
						res.status(200).json( rpta );
					  }

				});
			} else {

		//Graba el registro en la 	base de datos
				const graba_porcentaje = await Percent.create(PORCENTAJES)
					.then(result => {
						//if (result.insertedCount === 1) {
							var rpta = 'porcentajes_actualizados';
							res.status(200).json( rpta );
						//  } else {
							console.error('Error al inertar el documento.');
					  //	}
				});
			}
		} catch (error) {
			
		}

		

	}

	/*******************************************************************************************************/
	// Graba los procentajes oficiales en la base de datos
	// Additional notes
	/*******************************************************************************************************/
	function savePercentByCompany(req, res){
		//var id_empresa = req.params.idEmpresa;
		var PORCENTAJES = 	req.body;

		const nuevoPorcentaje = new Percent(PORCENTAJES);
		try {
			const graba_porcentaje = nuevoPorcentaje.save()
				.then(updatedPercent => {
					if (!updatedPercent) {
						// Si updatedPercent es null, significa que no se encontró un documento para actualizar
						console.error('No se encontró un documento para actualizar.');
					  } else {
						// La actualización fue exitosa, y updatedPercent contiene el documento actualizado
						var rpta = 'porcentajes_actualizados';
						res.status(200).json( rpta );
					  }

				});
			
			
		} catch (error) {
			throw new Error(`Error al actualizar el porcentaje: ${error.message}`);
		}

	}


	 /*******************************************************************************************************/
	 // Elimina un registro de los porcentajes oficiales
	 // Additional notes
	 /*******************************************************************************************************/
	 
		function delPercent(req, res){
			var id_empresa = req.params.id;
				try {
					
					const percent = Percent.findOneAndDelete({'idEmpresa': id_empresa}, function(err, percent) { 
						if (err){
							res.send({eliminado: 0})
						}else{
							res.json({eliminado: 1});
						}
					}); 
			
				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
				}
			
			}


module.exports = {
	savePercentByCompany,
	getAllPercentByIdEmpresa,
	savePercent,
	getPercent,
	getAllPercent,
	delPercent
}