'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Plan = require('../models/plan');
var jwt = require('../services/jwt');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.nombre = params.nombre;
	plan.cantidad_consultas = params.cantidad_consultas;
    plan.descripcion = params.descripcion;
    plan.estado = params.estado;
    plan.creado = new Date();
	

				if(plan.nombre != null && plan.cantidad_consultas != null && plan.descripcion != null ){
					//guarda el usuario
                    
   
					plan.save((err, planStored) => {
                        console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar el plan'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'NO se ha guardado el plan'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el plan'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el plan'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos los planes*/
/******************************************/
function getPlans(req, res){
//console.log("llegue aqui")
	try {
		const planes = Plan.find( function(err, planes) {
			if (err){
				res.send(err)
			}else{
				res.json(planes);
			}
		}); 
		//console.log(planes)

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de las planes *************/
/*Esta función es usada para actualizar un plan dado */
/*que lo recupera y lo lleva al form de crear plan   */
/********************************************************/
function getPlan(req, res){
//console.log('lleo hast este lugar');
	var planId = req.params.id;
	
	try {
		const plan = Plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); //encuentra un compañia por id y lo devuelve para editarlo
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de planes'});
	}

}

async function getPlanByName(req, res){
	//console.log('lleo hast este lugar');
		var planId = req.params.id;
		
		try {
			const plan = Plan.findById(planId, function(err, plan) { 
				if (err){
					res.send(err)
				}else{
					res.json(plan);
				}
			}); //encuentra un plan por id y lo devuelve para editarlo
			
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de planes'});
		}
	
	}

  //para eliminar el plan. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el plan'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan,
	getPlanByName
}