'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var User = require('../models/user');
var jwt = require('../services/jwt');


function saveProfile(req, res){
	var user = new User();

	var params = req.body;
		
	user.nombre = params.nombre;
	user.apellido = params.apellido;
    user.username = params.username;
	user.tipo_documento = params.tipo_documento;
    user.documento = params.documento;
    user.estado = params.estado;
	user.company_id = params.company_id;
    user.creado = new Date();
	user.usuarioCrea = params.usuarioCrea;
	user.role = params.role;
	
	
	if(params.password){
			//encriptar contraseña y guardar datos
			bcrypt.hash(params.password, null, null, function(err, hash){
				user.password = hash;

				if(user.nombre != null && user.apellido != null && user.username != null ){
					//guarda el usuario
					user.save((err, userStored) => {
						if(err){
							console.log(err);
							res.status(500).send({message: 'Error al guardar el usuario final'});
						}else{
							if(!userStored){
								res.status(404).send({message: 'NO se ha guardado el usuario'});
							}else{
								res.status(200).send({user: userStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Rellena todos los campos'});
				}
			});
	}else{
		res.status(200).send({message: 'Introduce la contraseña'});
	}

} 




/********************************************************/
/*función para devolver UNO de los usuarios *************/
/*Esta función es usada para actualizar un usuario dado */
/*que lo recupera y lo lleva al form de crear usuario   */
/********************************************************/
function getProfile(req, res){

	var userId = req.params.id;
	try {
		const usuario = User.findById(userId, function(err, persona) { 
			if (err){
				res.send(err)
			}else{
				res.json(persona);
			}
		}); //encuentra un usuario por id y lo devuelve para editarlo
		//res.json(usuarios); //devuelve los usuarios

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}


}


//para actualizar el usuario. Recibe un ID
function deleteProfile(req, res){
	var userId = req.params.id;
	
//console.log('llego hasta aqui');
	try {
		
		User.findByIdAndDelete(userId, function (err, userRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(userRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el usuario'});
	}
	


}


module.exports = {
	saveProfile,
	getProfile,
	deleteProfile
};