'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var ProfiledSearch = require('../models/profiledSearch');
var jwt = require('../services/jwt');
const { db } = require('../models/search');

const distance = require('jaro-winkler');

			

//Graba en la base de datos muchos registros provenientes un archivo de excel
//Graba las busquedas que hace una empresa.

//al parecer no se usa. esta grabacion no vale la pena hacerla . se deshabilita
function saveExcelFile(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;
	/*
	console.log('respuesta de a uno');
	params.forEach(element => {
		db.collection("transactions").bsonOptions(element);
		console.log(element);
	});
*/

	if (empresa_id != ''){
		//if(db.collection(empresa_id).insertMany (params)){
			
		if(db.collection("profiledSearches").insertMany(params)){
			//console.log("Archivo de Busqueda Masiva Perfilada IMportado");
			res.status(200).send({message: 'Grabado correctamente'});
		}else{
			//console.log("File imported error.");
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	}

}

//esta funcion es la version actual y que esta funcionando
async function getReportadosPerfilada(req, res){
	let resultados = [];

	let datos = req.body['registros'];
	let id_empresa = req.body['id_empresa'];

	for (const [index, element ] of datos.entries()) {

			let nit = element.identificacion;
			let nombreAlias = element.nombreAlias;
			let pep = element.PEP;

	
			/**********este es el codigo nuevo */
			// Función para normalizar texto (eliminar acentos)
			function normalizeText(text) {
				return text.normalize("NFD")
					.replace(/[\u0300-\u036f]/g, "")
					.trim();
			}

			// Divido la cadena de búsqueda y normalizo cada término
			const terminos = nombreAlias
			.split(' ')
			.map(term => normalizeText(term));

			// Escapar los términos
			let escapedTerms = terminos.map(t => {
			// Primero escapamos caracteres especiales
			const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');

			// Luego agregamos soporte para acentos en cada vocal
			return escaped
				.replace(/a/g, '[aáàâãä]')
				.replace(/e/g, '[eéèêë]')
				.replace(/i/g, '[iíìîï]')
				.replace(/o/g, '[oóòôõö]')
				.replace(/u/g, '[uúùûü]')
				.replace(/n/g, '[nñ]');
			});

			// Construir la expresión regular con límites de palabra
			let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");


			/*********este es el codigo anterior */
			//divido la cadena de busqueda
			//const terminos = nombreAlias.split(' ');
			//escapar los terminos
			//let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
			//let consulta_regexp = new RegExp(".*" + escapedTerms.join(".*") + ".*");
			//let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");

			
			if (nombreAlias !== '0' && nit === '0') { //Solo el nombreAlias tiene datos
				let filtro = {
					firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				};
				const res_nombreAlias = await db.collection("lists").find(filtro).toArray();

				if (res_nombreAlias.length === 0) { //consulte por alias
					const consultaAlias = { aka: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }
					const res_Alias = await db.collection("lists").find(consultaAlias).toArray();

						if( res_Alias.length === 0) {
							sin_resultados(nit, nombreAlias, nombreAlias, element, pep );
						} else {
							//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_Alias[0].firstNamelastName.toUpperCase());
							//res_Alias[0].coincidencia = coincidencia;
							res_Alias[0].el_primero = '1';

							res_Alias.forEach(element => {
								element.encontrado_por = '(Alias): ' + nombreAlias;
								let nombre = element.firstNamelastName;
								let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), nombre.toUpperCase());
								element.coincidencia = coincidencia;
								element.terminosBusqueda = nombreAlias;
								element.PEP = pep;
							});
							//res_Alias[0].encontrado_por = '(Alias): ' + nombreAlias;
							acumula_resultados(res_Alias, element);
						}
				} else {
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias[0].firstNamelastName.toUpperCase());
					res_nombreAlias[0].coincidencia = coincidencia;

					//res_nombreAlias[0].encontrado_por = '(Nombre): ' + nombreAlias;	
					res_nombreAlias[0].el_primero = '1';

					res_nombreAlias.forEach(element => {
						element.encontrado_por = '(Nombre): ' + nombreAlias;
						let nombre = element.firstNamelastName;
						let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), nombre.toUpperCase());
						element.coincidencia = coincidencia;
						element.terminosBusqueda = nombreAlias;
						element.PEP = pep;
					});

					acumula_resultados(res_nombreAlias, element);
				}
			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit tiene datos

				const res_nit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp(`\\b${nit}\\b`, "i")}}).toArray();

				if (res_nit.length === 0) {
					sin_resultados(nit, nombreAlias, nit, element, pep );
				} else {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit[0].firstNamelastName.toUpperCase());
				res_nit[0].coincidencia = 1;
				//res_nit[0].encontrado_por = '(NIT): ' + nit;
				res_nit.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //dado que el nit se busca completo dentro del campo
					element.terminosBusqueda = nit;
					element.PEP = pep;
				});
				acumula_resultados(res_nit, element);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos

				const pipeline = [
					{
						$match: {
						$or: [
							{ idNumber: { $regex: new RegExp(`\\b${nit}\\b`, "i"),} },
							{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} }
							//{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
						]
						}
					},
					{
						$addFields: {
						  matchedBy: {
							$switch: {
								branches: [
									{
									  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
									  then: "idNumber"
									},
									{
									  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
									  then: "firstNamelastName"
									}
								  ],
							  default: "No match"  
							}
						  }
						} 
					  },
					  {
						$match: {
						  matchedBy: { $ne: "No match" }
						}
					  }
				];
				const res_ambos = await db.collection("lists").aggregate(pipeline).toArray();

				if (res_ambos.length === 0) {
				let nit_alias = nit + ' / ' + nombreAlias;
				sin_resultados(nit, nombreAlias, nit_alias, element, pep );
				} else {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_ambos[0].firstNamelastName.toUpperCase());
				res_ambos[0].coincidencia = 1;
				res_ambos[0].el_primero = '1';

				res_ambos.forEach(element => {
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						element.encontrado_por = '(NIT): ' + nit;
					} else {
						element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					}
					//element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.coincidencia = 0.85;
					element.terminosBusqueda = nit + ' / ' + nombreAlias;
					element.PEP = pep;
				});

				//res_ambos[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
				acumula_resultados(res_ambos, element);
				}
			}


			//lo busca en las listas personalizadas
			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				
				// let filtro_personalizada = {
				// 	firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				// };

				let filtro_personalizada = {
					$and: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i' } },
						{ empresa_id: id_empresa }
					]
				};


				const res_nombreAlias_personalizada = await db.collection("customlists").find(filtro_personalizada).toArray();

				if (res_nombreAlias_personalizada.length > 0) {
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias_personalizada[0].firstNamelastName.toUpperCase());
					res_nombreAlias_personalizada[0].coincidencia = coincidencia;
					//res_nombreAlias_personalizada[0].encontrado_por = '(Alias): ' + nombreAlias;

					res_nombreAlias_personalizada[0].el_primero = '1';

					res_nombreAlias_personalizada.forEach(element => {
						element.encontrado_por = '(Alias): ' + nombreAlias;
						element.terminosBusqueda = nombreAlias;
						element.PEP = pep;
					});

					acumula_resultados(res_nombreAlias_personalizada, element);
				}

			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos
				//const res_nit_personalizada = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();

				const res_nit_personalizada = await db.collection("customlists").find({
					$and: [
						{ 'idNumber': { '$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i' } },
						{ 'empresa_id': id_empresa }
					]
				}).toArray();

				if (res_nit_personalizada.length > 0) {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit_personalizada[0].firstNamelastName.toUpperCase());
				res_nit_personalizada[0].coincidencia = 1;
				//res_nit_personalizada[0].encontrado_por = '(NIT): ' + nit;

				res_nit_personalizada[0].el_primero = '1';

				res_nit_personalizada.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //pues lo encontró por nit y se presupone que la busqueda solo lo devuelve cuando lo encuentra
					element.terminosBusqueda = nit;
					element.PEP = pep;
				});

				acumula_resultados(res_nit_personalizada, element);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos
				const pipeline = [
				{
					$match: {
						$or: [
							{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
							{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
						],
						$and: [
							{ empresa_id: id_empresa }
						]
					}
				}
				];
				const res_ambos_personalizada = await db.collection("customlists").aggregate(pipeline).toArray();
				
				if (res_ambos_personalizada.length > 0) {
				let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_ambos_personalizada[0].firstNamelastName.toUpperCase());
				res_ambos_personalizada[0].coincidencia = coincidencia;

				//res_ambos_personalizada[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;

				res_ambos_personalizada[0].el_primero = '1';

				res_ambos_personalizada.forEach(element => {
					element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.PEP = pep;
					element.terminosBusqueda = nit + ' / ' + nombreAlias;
				});

				acumula_resultados(res_ambos_personalizada, element);
				}
			}
			
			if (index === datos.length - 1) {	
				res.json(resultados);
			}
		}
			
		
function sin_resultados(nit, nombreAlias, encontrado_por, elemento, pep) {
	const sinResultados = [{
	  firstNamelastName: nombreAlias,
	  idNumber: nit,
	  estado: 'No Reportado',
	  coincidencia: 0,
	  //encontrado_por: encontrado_por
	  terminosBusqueda: encontrado_por,
	  PEP: pep
	}];
	acumula_resultados(sinResultados, elemento);
  }


function acumula_resultados(respuesta, elemento) {
	let divididos = [];
	let divididos2 = [];

	
	
	if (respuesta[0].estado === 'Reportado') {
		respuesta.forEach(objeto => {
			objeto.nombreAlias = elemento.nombreAlias;
			objeto.tipo_relacion = elemento.tipo_relacion;
			objeto.pais = elemento.pais;
			objeto.dateOfBirth = elemento.dateOfBirth;
			objeto.title = elemento.title;
			objeto.aka = elemento.aka;
			objeto.programList = elemento.programList;
			objeto.address = elemento.address;
			objeto.ciudad = elemento.ciudad;
			objeto.actividad = elemento.actividad;
			objeto.canal = elemento.canal;
			objeto.producto = elemento.producto;
			objeto.origen_recursos = elemento.origen_recursos;
			objeto.estado = 'Reportado';
		 });
		
		resultados.splice(0,0,...respuesta);
	  } else {
		respuesta.forEach(objeto => {
			objeto.nombreAlias = elemento.nombreAlias;
			objeto.tipo_relacion = elemento.tipo_relacion;
			objeto.pais = elemento.pais;
			objeto.dateOfBirth = elemento.dateOfBirth;
			objeto.title = elemento.title;
			objeto.aka = elemento.aka;
			objeto.programList = elemento.programList;
			objeto.address = elemento.address;
			objeto.ciudad = elemento.ciudad;
			objeto.actividad = elemento.actividad;
			objeto.canal = elemento.canal;
			objeto.producto = elemento.producto;
			objeto.origen_recursos = elemento.origen_recursos;
			objeto.estado = 'No Reportado';
		 });
		resultados.push(...respuesta);
	  }

	//console.log(' los xxxxxxXXXXXX ',respuesta);

	

	
  //resultados.push(...respuesta);
}
	
  

	

}

//Verificada
/*************************************************************************************************** */
/* Función que permite consultar las personas que se cargan en el excel de busqueda masiva perfilada */
/*************************************************************************************************** */
async function getReportadosPerfilada_ver0(req, res){
	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;

	let nombreAliasParts = nombreAlias.split(' ');

	var i = 0;
	let queryString = [];
	nombreAliasParts.forEach(element => {
		queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
		i++;
	});
	

	const consulta ={
		"$and": queryString
	};
	//busca si los dos datos tienen valores : nit y nombre alias

	if(nombreAlias != '0' && nit != '0'){
		try {
			//consulta por nit
			const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
			if(resultadoNit.length === 0){
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				if(resultadoNombre.length === 0){ //lo busca entonces por el alias
					
					const resultadoAlias = await db.collection("lists").find({
						'aka': { $regex: new RegExp(nombreAlias, 'i') }
					  }).toArray();

					 if (resultadoAlias.length === 0) {
							res.json('No Reportado');
					 } else {
						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
						res.json(resultadoAlias);
					 }
				} else {
					resultadoNombre[0].encontrado_por = '(Nombre): '+nombreAlias;
					res.json(resultadoNombre);
				}
			}else{
				
				resultadoNit[0].encontrado_por = '(Nit): '+ nit;
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(err);
		}
	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias
			try {
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				
				if(resultadoNombre.length === 0){ //lo busca por el alias
					
					const resultadoAlias = await db.collection("lists").find({
						'aka': { $regex: new RegExp(nombreAlias, 'i') }
					  }).toArray();

					if (resultadoAlias.length === 0) {
						res.json('No Reportado');
					} else{
						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
						res.json(resultadoAlias);
					}
					
				} else {
					resultadoNombre[0].encontrado_por = '(Nombre): '+ nombreAlias;
					res.json(resultadoNombre);
				}
				
			} catch (error) {
				res.send(error);
			}
		}else
			if(nit != '0' && nombreAlias === '0'){
				try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					if(resultadoNit.length > 0){
						resultadoNit[0].encontrado_por = '(NIT): '+nit;
						res.json(resultadoNit);
					}
					
				} catch (error) {
					res.send(err);
				}
			}
	}
}



//Revisar si es util o no en este controlador. por ahora no es util
/********************************************************************/
/*  funcion para devolver todos los registros de la base de datos ****/
/* ******************************************************************/

async function getReportados(req, res){
	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;


	let nombreAliasParts = nombreAlias.split(' ');

	var i = 0;
	let queryString = [];
	nombreAliasParts.forEach(element => {
		queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
		i++;
	});
	

	const consulta ={
		"$and": queryString
	};


	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias != '0' && nit != '0'){
		try {
			//consulta por nit
			const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
			if(resultadoNit.length === 0){
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				res.json(resultadoNombre);
			}else{
				res.json(resultadoNit);
			}	
		} catch (error) {
			res.send(err);
		}
	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias
			try {
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				res.json(resultadoNombre);
			} catch (error) {
				res.send(error);
			}
		}else
			if(nit != '0' && nombreAlias === '0'){
				try {
					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					res.json(resultadoNit);
				} catch (error) {
					res.send(err);
				}
			}
	}
}

function jaroWinklerf(s1, s2){
	let dist = distance(s1,s2);

	return dist;
	
  }
  



module.exports = {
	saveExcelFile,
	getReportados,
	getReportadosPerfilada
};