'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var Entity = require('../models/relation');
var jwt = require('../services/jwt');


/***************************************************************/
/*  funcion para salvar cualquier registro en la base de datos****/
/*  Para adaptar:  (*), (*) ************************************/
/* *************************************************************/
function saveEntity(req, res){
	var entity = new Entity();
	var params = req.body;
	
	//(*)
	entity.nombre = params.nombre;
    entity.creado = new Date();
	entity.usuarioCrea = params.usuarioCrea;
		
		//graba la entidad en la base de datos
		//if(entity.nombre != null && user.apellido != null && user.username != null ){
		if(entity.nombre != null ){ //(*)
			//guarda la entidad
			entity.save((err, entityStored) => {
				if(err){
					res.status(500).send({message: 'Error al grabar en la base de datos'});
				}else{
					if(!entityStored){
						res.status(404).send({message: 'No se ha guardado la entidad en la base de datos'});
					}else{
						res.status(200).send({user: entityStored});
					}
				}
			});
		}else{
			res.status(200).send({message: 'Todos los campos son obligatorios'});
		}
} 


/********************************************************************/
/*  funcion para devolver todos los registros de la base de datos****/
/* ******************************************************************/
function getEntities(req, res){
	try {
		const entities = Entity.find( function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		});
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}

/********************************************************/
/*función para devolver UN registro de la base de datos**/
/*Esta función es usada para recueprar un registro dado */
/*que lo recupera y lo lleva al form de crear entity    */
/********************************************************/
function getEntity(req, res){
	var entityId = req.params.id;

	try {
		const entity = Entity.findById(entityId, function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}


/*********************************************************/
/*función para ACTUALIZAR UNO de los registros ***********/
/*Esta función es usada para actualizar un registro dado */
/*********************************************************/
function updateEntity(req, res){
	var entityId = req.params.id;
	var update = req.body;

	Entity.findByIdAndUpdate(entityId, update, (err, entityUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar'});
		}else{
			if(!entityUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la base de datos'});
			}else{
				res.status(200).send({user: entityUpdated});
			}
		}
	})
}

/*********************************************************/
/** Función para ELIMINAR UNO de los registros ***********/
/** Esta función es usada para eliminar un registro dado */
/*********************************************************/
function deleteEntity(req, res){
	var entityId = req.params.id;
	
	try {
		Entity.findByIdAndDelete(entityId, function (err, entityRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(entityRemoved);
			}
		});
	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el registro'});
	}
}


module.exports = {
	saveEntity,
	updateEntity,
	getEntities,
	getEntity,
	deleteEntity
};