'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Report = require('../models/report');
var jwt = require('../services/jwt');


function saveReport(req, res){
	var report = new Report();
	//console.log(req.body);
	var params = req.body;
	//console.log("este es el params "+params.nombreAlias);
	
    report.idEmpresa = params.idEmpresa;
	report.firstNamelastName = params.firstNamelastName;
	report.idNumber = params.idNumber;
	report.nombreAlias = params.nombreAlias;
	report.estado = params.estado;
    report.paisN = params.paisN;
	report.ciudadN = params.ciudadN;
	report.canalN = params.canalN;
	report.actividadN = params.actividadN;
	report.productoN = params.productoN;
	report.origenN = params.origenN;
    report.perfilRiesgo = params.perfilRiesgo;
	report.perfilRiesgoRestante = params.perfilRiesgoRestante;
	report.observacionesObj = params.observacionesObj;
	report.porcentajePaisObj = params.porcentajePaisObj;
	report.porcentajeCiudad = params.porcentajeCiudad;
	report.porcentajeActividad = params.porcentajeActividad;
    report.porcentajeCanal = params.porcentajeCanal;
	report.porcentajeOrigen = params.porcentajeOrigen;
    report.porcentajeProducto = params.porcentajeProducto;
	report.idBusqueda = params.idBusqueda;
	report.fechaCreacion = params.fechaCreacion;
	report.usuarioCrea = params.usuarioCrea;

	//console.log("el rerport"+report);
    //report.creado = new Date();
	
					//guarda el pais
					report.save((err, reportStored) => {
                        console.log(err);
						//console.log(reportStored);
						if(err){
							res.status(500).send({message: 'Error al guardar el pais'});
						}
					});
				

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el pais'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el pais'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

function getIdBusqueda(req, res){
	var planId = req.params.id;

	try {
		const report = Report.find({'idBusqueda': planId}, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
		//console.log("Los reportes de busqueda ID"+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
	}

}

async function getReportByAny(req, res){

	var id = req.query.id;
	var nombre = req.query.name;
	var estado = req.query.estado;
	var pais = req.query.pais;
	var fechaInicio = req.query.startDate;
	var fechaFin = req.query.endDate;
	var tipoOperacion = req.query.tipoOperacion;
	//fechaFin = '2023-06-13T00:00:00.000Z'
	//fechaInicio = '2023-06-01T00:00:00.000Z'
	// console.log(id);
	// console.log(fechaInicio);
	// console.log(fechaFin);

	const query = {};

  // Agregar campos a la consulta solo si tienen valores proporcionados
  if (id != '') {
    query.idNumber = id;
  }
  if (nombre != '') {
    query.name = nombre;
  }
  if (estado) {
    query.estado = estado;
  }
  if (pais) {
    query.paisN = pais;
  }
  if (fechaInicio != '' && fechaFin != '') {
    query.fechaCreacion = {
      $gte: new Date(fechaInicio),
      $lte: new Date(fechaFin)
    };
  }
  if (tipoOperacion != '') {
    query.tipoOperacion = tipoOperacion;
  }



	try {
			
		const report = Report.find(query, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
		console.log("Los planes by Any"+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
	}
}

  async function getReportBy(req, res){
	//console.log('llego aqui by code');
	// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
		var id = req.query.id;
		var nombre = req.query.name;
		var estado = req.query.estado;
		var date = req.query.date;

		//console.log(req);
		//var idNumber = parseInt(id);
		//console.log(req);
	
		
		//if (id.lenght() > 0) {
			try {
				const report = await Report.find({
				  $or: [
					{ "firstNamelastName": nombre },
					{ "estado": estado },
					{ "idNumber": id },
					{ "fechaCreacion": date }
				  ]
				}).exec();
			  
				//console.log("Los reportes:", report);
				res.json(report);
			  } catch (error) {
				res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal' + req + planId });
			  }
		//} 
		/*
		else if (nombre.lenght() > 0) {
			try {
			
				const report = Report.find({'firstNameLastName': nombre}, function(err, report) { 
					if (err){
						res.send(err)
					}else{
						res.json(report);
					}
				}); 
				console.log("Los planes"+report);
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
			}
		} else if (alias.lenght() > 0) {
			try {
			
				const report = Report.find({'nombreAlias': alias}, function(err, report) { 
					if (err){
						res.send(err)
					}else{
						res.json(report);
					}
				}); 
				console.log("Los planes"+report);
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
			}
		} else {
			
		}{
			
		}{
			
		}*/
	
	}
	



module.exports = {
	saveReport,
	updatePlan,
	getReportBy,
	getIdBusqueda,
	getReportByAny
}