'use strict'


/* ORIGEN RECURSOS */


//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Plan = require('../models/resource');
var jwt = require('../services/jwt');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.procedencia = params.procedencia;
	plan.calificacion = params.calificacion;
    plan.estado = params.estado;
    plan.creado = new Date();
	

				if(plan.procedencia != null && plan.calificacion != null && plan.estado != null ){
					plan.save((err, planStored) => {
                        console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar origen recursos'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'NO se ha guardado origen recursos'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	Plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar origen recursos'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar origen recursos'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos klos origenes de recursos*/
/******************************************/
function getPlans(req, res){

	try {
		const planes = Plan.find( function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de los origenes de recursos *************/
/*Esta función es usada para actualizar un pais dado */
/*que lo recupera y lo lleva al form de crear pais   */
/********************************************************/
function getPlan(req, res){

	var planId = req.params.id;
	try {
		const plan = Plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de origen recursos'});
	}

}


function getResource(req, res){
	//console.log('llego aqui by code');
	
	var planId = req.params.id;
	//console.log(planId);
		
		try {
			
			const plan = Plan.findOne({'codigo': planId}, function(err, plan) { 
				if (err){
					res.send(err)
				}else{
					res.json(plan);
				}
			}); 
			//console.log("Los ciudades "+plan);
	
		} catch (error) {
			res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req });
		}
	
	}

  //para eliminar el plan. recibe un id
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		Plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover origen recursos'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan,
	getResource
}