'use strict'

/* LISTAS RESTRICTIVAS OFAC */


//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



var bcrypt = require('bcrypt-nodejs');
var Plan = require('../models/restriction');
var jwt = require('../services/jwt');


function savePlan(req, res){
	var plan = new Plan();

	var params = req.body;
	
    plan.tipo_consulta = params.tipo_consulta; //positivo / negativo
	plan.consulta = params.consulta;
	plan.jurisdiccion_pais = params.jurisdiccion_pais;
	plan.canal = params.canal;
	plan.actividad = params.actividad;
	plan.producto = params.producto;
	plan.origen_recurso = params.origen_recurso;
    plan.estado = params.estado;
    plan.creado = new Date();
	

				if(plan.tipo_consulta != null && plan.consulta != null && plan.jurisdiccion_pais != null ){
					//guarda lista restrictiva
					plan.save((err, planStored) => {
                        console.log(err);
						if(err){
							res.status(500).send({message: 'Error al guardar lista restrictiva'});
						}else{
							if(!planStored){
								res.status(404).send({message: 'NO se ha guardado lista restrictiva'});
							}else{
								res.status(200).send({plan: planStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Diligencia todos los campos'});
				}

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	plan.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar lista restrictiva'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar lista restrictiva'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

//*****************************************/
/*función para devolver todos la lista restrictiva*/
/******************************************/
function getPlans(req, res){

	try {
		const planes = plan.find( function(err, plan) {
			if (err){
				res.send(err)
			}else{
				res.json(plan);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}

}


/********************************************************/
/*función para devolver UNO de la lista restrictiva*******/
/*Esta función es usada para actualizar un pais dado */
/*que lo recupera y lo lleva al form de crear pais   */
/********************************************************/
function getPlan(req, res){

	var planId = req.params.id;
	try {
		const plan = plan.findById(planId, function(err, plan) { 
			if (err){
				res.send(err)
			}else{
				res.json(plann);
			}
		}); 
		

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador la lista restrictiva'});
	}

}

  //para eliminar la lista resctrictiva
function delPlan(req, res){
	var planId = req.params.id;
	
	try {
		
		plan.findByIdAndDelete(planId, function (err, planRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(planRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover lista restrictiva'});
	}
}



module.exports = {
	savePlan,
	updatePlan,
	getPlans,
	getPlan,
    delPlan
}