'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var RiskProfile = require('../models/riskProfile');
var jwt = require('../services/jwt');
const { Console } = require('console');


//esta funcion graba los datos en riskprofiles que viene de la busqueda sencilla cuando el usuario selecciona un registro del resultado de la busqueda
//para hacer un perfil. Si no hace el perfil este registro se mantiene, si lo hace este registro se elimina y se reemplaza por el perfil completo

function saveRiskProfile(req, res){
	var riskProfile = new RiskProfile();

	var params = req.body;
	
	riskProfile.idEmpresa = params.idEmpresa;
	riskProfile.tipo_relacion = params.tipo_relacion;
	riskProfile.estadoConsulta = params.estadoConsulta
	riskProfile.pais = params.pais;
	riskProfile.jurisdiccion = params.jurisdiccion;
	riskProfile.tipo_usuario = params.tipo_usuario;
	riskProfile.canal = params.canal;
	riskProfile.actividad = params.actividad;
	riskProfile.producto = params.producto;
	riskProfile.origen_recursos = params.origen_recursos;
	riskProfile.perfilRiesgo = params.perfilRiesgo;
	riskProfile.rango_salarial = params.rango_salarial;
	riskProfile.patrimonio_liquido = params.patrimonio_liquido;
	riskProfile.fechaCreado = params.fechaCreado;
	riskProfile.usuarioCrea = params.usuarioCrea;
	riskProfile.es_pep = params.es_pep;
	riskProfile.idNumber = params.idNumber;
	riskProfile.nombreAlias = params.nombreAlias;
	riskProfile.tipo_persona = params.tipo_persona;
	riskProfile.nombre_lista = params.nombre_lista;
	riskProfile.encontrado_por = params.encontrado_por;
	riskProfile.otra_informacion = params.otra_informacion;
	riskProfile.tipo_lista = params.tipo_lista;
	riskProfile.id_usuario = params.id_usuario;
	riskProfile.tipo_operacion = params.tipo_operacion;

	


		//guarda el usuario
		riskProfile.save((err, riskProfileStored) => {
			if(err){
				//console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!riskProfileStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: riskProfileStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 

//graba en la base de datos los registros de busqueda y resultados de la busqueda masiva perfilada
//Aqui se graba cuando se le da clic al boton 'finalice el proceso'
//en la busqueda masiva perfilada
async function saveReport(req, res){
	var report = new RiskProfile();
	

	var params = req.body;
	


    report.idEmpresa = params.idEmpresa;
	report.firstNamelastName = params.firstNamelastName;
	report.idNumber = params.idNumber;
	report.nombreAlias = params.nombreAlias;
	report.estadoConsulta = params.estadoConsulta;
    report.pais = params.pais;
	report.jurisdiccion = params.jurisdiccion;
	report.canal = params.canal;
	report.actividad = params.actividad;
	report.producto = params.producto;
	report.origen_recursos = params.origen_recursos;
    report.perfilRiesgo = params.perfilRiesgo;
	report.perfilRiesgoRestante = params.perfilRiesgoRestante;
	report.observacionesObj = params.observacionesObj;
	report.porcentajePaisObj = params.porcentajePaisObj;
	report.porcentajeCiudad = params.porcentajeCiudad;
	report.porcentajeActividad = params.porcentajeActividad;
    report.porcentajeCanal = params.porcentajeCanal;
	report.porcentajeOrigen = params.porcentajeOrigen;
    report.porcentajeProducto = params.porcentajeProducto;
	report.idBusqueda = params.idBusqueda;
	report.fechaCreado = params.fechaCreado;
	report.usuarioCrea = params.usuarioCrea;
	report.encontrado_por = params.encontrado_por;
	report.tipo_lista = params.tipo_lista;
	report.id_usuario = params.id_usuario;
	report.tipo_operacion = params.tipo_operacion;
	report.nombreLista = params.nombreLista;
	

	
    //report.creado = new Date();
	
					//guarda el pais
					await report.save((err, reportStored) => {
						res.send({ id: reportStored._id });
                        //console.log(err);
						//console.log(reportStored);
						if(err){
							//console.log('el error ',err)
							res.status(500).send({message: 'Error al guardar el pais'});
						}
					});
				

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	RiskProfile.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el pais'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el pais'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

function getIdBusqueda(req, res){
	var planId = req.params.id;

	try {
		const report = RiskProfile.find({'idBusqueda': planId}, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
		//console.log("Los reportes de busqueda ID"+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
	}

}


//ejecuta la consulta llamada desde busqueda-sencilla-reporte o sea busqueda historicos
async function getReportByAny(req, res){

	var id = req.query.id; //correspomnde al contenido del idNumber del template
	var empresaId = req.query.idEmpresa; 
	
	var nombre = req.query.name; //correspomnde al contenido del nombreAlias del template
	var estado = req.query.estado;
	var pais = req.query.pais;
	var fechaInicio = req.query.startDate;
	var fechaFin = req.query.endDate;
	var tipoOperacion = req.query.tipoOperacion;
	var usuarioCrea = req.query.usuarioCrea;
	var juris = req.query.juris;
	var activ = req.query.nombreActividad;
	var nombreProducto = req.query.nombreProducto;
	var nombreORecurso = req.query.nombreORecursos;
	var tipoUsuario = req.query.tipoUsuario;
	var tipo_perfil = req.query.tipo_perfil;

	

	//fechaFin = '2023-06-13T00:00:00.000Z'
	//fechaInicio = '2023-06-01T00:00:00.000Z'
	let queryString = [];
	const query = { empresaId }; // Inicializar con empresaId si está disponible
	//queryString.push({empresaId: empresaId})
	
	
	// Agregar campos a la consulta solo si tienen valores proporcionados
	if (id !== undefined && id !== null && id !== '') { //si proporciona el idNumber en el template
		queryString.push({"idNumber": {
			"$regex": new RegExp("\\b" + req.query.id + "\\b", 'i')
		  }})
	  }

	if (nombre !== undefined && nombre !== null && nombre !== '' )  {
		let nombreAliasParts = nombre.split(' ');
		var i = 0;
		nombreAliasParts.forEach(element => {
			queryString[i] =  {"nombreAlias" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
			i++;
		});
		
	  //const nombreAliasParts = req.query.name.split(' ');
	  //const nombreAliasQueries = nombreAliasParts.map(element => ({
		//nombreAlias: { $regex: new RegExp("\\b" + element + "\\b", 'i') }
	  //}));
	  //query.nombreAlias = nombreAliasQueries[0].nombreAlias;
	}

	//incluye el uso del tipo_perfil

	//if ( tipo_perfil !== undefined && tipo_perfil !== null && tipo_perfil !== '' && tipo_perfil !== 'undefined') {

	if ( tipo_perfil === 'PERFIL DE RIESGO MEDIO' || tipo_perfil === 'PERFIL DE RIESGO MEDIO BAJO' || tipo_perfil === 'PERFIL DE RIESGO MEDIO ALTO' ||
		 tipo_perfil === 'PERFIL DE RIESGO BAJO' || tipo_perfil === 'PERFIL DE RIESGO ALTO' || tipo_perfil === 'PERFIL DE RIESGO INMINENTE') {
			
		if (tipo_perfil === 'PERFIL DE RIESGO MEDIO') {
			queryString.push({perfilRiesgo: {$regex: new RegExp("\\b" +tipo_perfil + "\\b" + "(?!\\s+(?:BAJO|ALTO)\\b)", 'i')}});
		}else if (tipo_perfil === 'PERFIL DE RIESGO MEDIO BAJO' || tipo_perfil === 'PERFIL DE RIESGO MEDIO ALTO') {
			queryString.push({perfilRiesgo: {$regex: new RegExp("\\b" +tipo_perfil + "\\b", 'i')}});
		} else if (tipo_perfil === 'PERFIL DE RIESGO BAJO') {
			queryString.push({perfilRiesgo: {$regex: new RegExp("\\b" +tipo_perfil + "\\b", 'i')}});
		} else if (tipo_perfil === 'PERFIL DE RIESGO ALTO') {
			queryString.push({perfilRiesgo: {$regex: new RegExp("\\b" + tipo_perfil + "\\b", 'i')}});
		} else if (tipo_perfil === 'PERFIL DE RIESGO INMINENTE') {
			queryString.push({perfilRiesgo: {$regex: new RegExp("\\b" + tipo_perfil + "\\b", 'i')}});
		}
		
	}

	if (estado !== undefined && estado !== null && estado !== '') queryString.push({estadoConsulta: estado})

	//if (pais !== undefined && pais !== null && pais !== '') queryString.push({paisN: pais})

	if (pais !== undefined && pais !== null && pais !== '') queryString.push({pais: pais});

	if (juris !== undefined && juris !== null && juris !== '') queryString.push({jurisdiccion: juris});

	if (activ !== 'undefined' && activ !== undefined && activ !== null && activ !== '') queryString.push({actividad: activ});

	if (nombreProducto !== 'undefined' && nombreProducto !== undefined && nombreProducto !== null && nombreProducto !== '') queryString.push({producto: nombreProducto});

	if (nombreORecurso !== 'undefined' && nombreORecurso !== undefined && nombreORecurso !== null && nombreORecurso !== '') queryString.push({origen_recursos: nombreORecurso});

	if (tipoUsuario !== 'undefined' && tipoUsuario !== undefined && tipoUsuario !== null && tipoUsuario !== '') queryString.push({tipo_usuario: tipoUsuario});

	//if (tipo_perfil !== 'undefined' && tipo_perfil !== undefined && tipo_perfil !== null && tipo_perfil !== '') queryString.push({perfilRiesgo: tipo_perfil});

	if (req.query.startDate && req.query.endDate) {
		// if (req.query.startDate === req.query.endDate){
		// 	console.log('ento');
		// 	queryString.push({"fechaCreado" : { "$eq" : new Date(req.query.startDate) }})//solo compara por igualdad sin rango
		// } else {
			queryString.push({"fechaCreado" : {
			  "$gte" : new Date(req.query.startDate),
			  "$lte" : new Date(req.query.endDate)
			}})
		//}
		}

	if (tipoOperacion !== undefined && tipoOperacion !== null && tipoOperacion !== '') queryString.push({tipo_operacion: tipoOperacion})

	//if (estado) queryString.estadoConsulta = estado;
	if (req.query.pais !== undefined && req.query.pais !== null && req.query.pais !== '') query.pais = req.query.pais;
	
	if (req.query.startDate && req.query.endDate) {
		// if (req.query.startDate === req.query.endDate){
		// 	query.fechaCreado = new Date(req.query.startDate); //solo compara por igualdad sin rango
		// } else {
		query.fechaCreado = {
			$gte: new Date(req.query.startDate),
			$lte: new Date(req.query.endDate)
		};
		//}
	}
	if (tipoOperacion !== undefined && tipoOperacion !== null && tipoOperacion !== '') query.tipo_operacion = req.query.tipoOperacion;
	
	//en proceso
	//queryString.push({"idEmpresa" : { "$eq" : empresaId }})
	
	
	
	//ahora le sumo una consulta adicional relacionada con el usuario activo

	//queryString.push({"usuarioCrea" : { "$eq" : usuarioCrea }})



	
	if (queryString.length > 0) {
		queryString.push({"idEmpresa":  empresaId });
			//queryString.push({"idEmpresa" : { "$eq" : empresaId }});
			//queryString.push({"usuarioCrea" : { "$eq" : usuarioCrea }});
			let consulta ={
				"$and": queryString
			};
			//console.log('el contenido de consulta es', consulta);
		try {
		const report = await RiskProfile.find(consulta);
		
		req.query.id = null;
	
			req.query.name = null;
			req.query.estado = null;
			req.query.pais = null;
			req.query.startDate = null;
			req.query.endDate = null;
			req.query.tipoOperacion = null;
			req.query.tipo_perfil = null;
			
			res.json(report);
		} catch (error) {
		res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal' });
		}

	}
}




  async function getReportBy(req, res){
	//console.log('llego aqui by code');
	// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
		var id = req.query.id;
		var nombre = req.query.name;
		var estado = req.query.estadoConsulta;
		var date = req.query.date;


		


			try {
				const report = await RiskProfile.find({
				  $or: [
					{ "firstNamelastName": nombre },
					{ "estado": estado },
					{ "idNumber": id },
					{ "fechaCreacion": date }
				  ]
				}).exec();
			  
				//console.log("Los reportes:", report);
				res.json(report);
			  } catch (error) {
				res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal' + req + planId });
			  }

		
	
	}

	
	/*****************************************************************************************************************************/
/* Función para obtener el perfil de riesgo de la persona que se caba de carlarle el perfil de riesgo en busqueda sencilla  */
/*****************************************************************************************************************************/
function getRiskProfile(req, res){
	//var params = req.body;
	var idProfile = req.params.idProfile;

	//console.log('el valor de profuile xxx', idProfile);
	try {
		const profile = RiskProfile.findById(idProfile, function(err, profile) { 
			if (err){
				res.send(err)
			}else{
				//console.log('la salida',profile);
				res.json(profile);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador del perfil de riesgos'});
	}
}


	/*****************************************************************************************************************************/
/* Función para ELIMINAR el perfil de riesgo de la persona que se caba de cargarle el perfil de riesgo en busqueda sencilla  */
/*****************************************************************************************************************************/
function del_RiskProfile(req, res){
	//var params = req.body;
	var idProfile = req.params.idProfile;

	//console.log('Aqui debio borrar el registro', idProfile);
	try {
		const profile = RiskProfile.deleteOne({_id: idProfile}, function(err, profile) { 
			if (err){
				res.send(err)
			}else{
				res.json(profile);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador del perfil de riesgos'});
	}
}

/*****************************************************************************************************************************/
/* Función para actualizar el perfil de riesgo de la persona que se caba de calcularle el perfil de riesgo en busqueda sencilla  */
/*****************************************************************************************************************************/
function updateRiskProfile(req, res){
	var params = req.body;
	var idProfile = req.params.idProfile;
	var info_actualizar = req.body;
	try {
		
		const updateProfile = RiskProfile.findOneAndUpdate({_id: Object(idProfile)}, {$set: info_actualizar}, function(err, updateProfile) { 
			//console.log(updateProfile);
			if (err){
				res.send(err)
			}else{
				res.json(updateProfile);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de la actualización del registro de busqueda sencilla'});
	}
}

module.exports = {
	saveRiskProfile,
	getReportBy,
	getReportByAny,
	getIdBusqueda,
	saveReport,
	getRiskProfile,
	updateRiskProfile,
	del_RiskProfile

};