'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var RiskProfile = require('../models/riskProfile');
var jwt = require('../services/jwt');



function saveRiskProfile(req, res){
	var riskProfile = new RiskProfile();

	var params = req.body;

	riskProfile.idEmpresa = params.idEmpresa;
	riskProfile.tipo_relacion = params.tipo_relacion;
	riskProfile.estadoConsulta = params.estadoConsulta
	riskProfile.pais = params.pais;
	riskProfile.jurisdiccion = params.jurisdiccion;
	riskProfile.tipo_usuario = params.tipo_usuario;
	riskProfile.canal = params.canal;
	riskProfile.actividad = params.actividad;
	riskProfile.producto = params.producto;
	riskProfile.origen_recursos = params.origen_recursos;
	riskProfile.perfil_riesgo = params.perfil_riesgo;
	riskProfile.rango_salarial = params.rango_salarial;
	riskProfile.patrimonio_liquido = params.patrimonio_liquido;
	riskProfile.fechaCreado = params.fechaCreado;
	riskProfile.usuarioCrea = params.usuarioCrea;
	riskProfile.es_pep = params.es_pep;
	riskProfile.idNumber = params.idNumber;
	riskProfile.nombreAlias = params.nombreAlias;
	riskProfile.tipo_persona = params.tipo_persona;

		//guarda el usuario
		riskProfile.save((err, riskProfileStored) => {
			if(err){
				console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!riskProfileStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: riskProfileStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 

function saveReport(req, res){
	var report = new RiskProfile();
	console.log(req.body);
	var params = req.body;
	console.log("este es el params "+params.nombreAlias);
	
    report.idEmpresa = params.idEmpresa;
	report.firstNamelastName = params.firstNamelastName;
	report.idNumber = params.idNumber;
	report.nombreAlias = params.nombreAlias;
	report.estadoConsulta = params.estadoConsulta;
    report.paisN = params.paisN;
	report.ciudadN = params.ciudadN;
	report.canalN = params.canalN;
	report.actividadN = params.actividadN;
	report.productoN = params.productoN;
	report.origenN = params.origenN;
    report.perfilRiesgo = params.perfilRiesgo;
	report.perfilRiesgoRestante = params.perfilRiesgoRestante;
	report.observacionesObj = params.observacionesObj;
	report.porcentajePaisObj = params.porcentajePaisObj;
	report.porcentajeCiudad = params.porcentajeCiudad;
	report.porcentajeActividad = params.porcentajeActividad;
    report.porcentajeCanal = params.porcentajeCanal;
	report.porcentajeOrigen = params.porcentajeOrigen;
    report.porcentajeProducto = params.porcentajeProducto;
	report.idBusqueda = params.idBusqueda;
	report.fechaCreacion = params.fechaCreacion;
	report.usuarioCrea = params.usuarioCrea;

	console.log("el rerport"+report);
    //report.creado = new Date();
	
					//guarda el pais
					report.save((err, reportStored) => {
                        console.log(err);
						console.log(reportStored);
						if(err){
							res.status(500).send({message: 'Error al guardar el pais'});
						}
					});
				

} 




function updatePlan(req, res){
	var planId = req.params.id;
	var update = req.body;

	RiskProfile.findByIdAndUpdate(planId, update, (err, planUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el pais'});
		}else{
			if(!planUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el pais'});
			}else{
				res.status(200).send({plan: planUpdated});
			}
		}


	})

}

function getIdBusqueda(req, res){
	var planId = req.params.id;

	try {
		const report = RiskProfile.find({'idBusqueda': planId}, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
		console.log("Los reportes de busqueda ID"+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
	}

}



async function getReportByAny(req, res){

	var id = req.query.id;
	var empresaId = req.query.idEmpresa;
	var nombre = req.query.name;
	var estado = req.query.estado;
	var pais = req.query.pais;
	var fechaInicio = req.query.startDate;
	var fechaFin = req.query.endDate;
	var tipoOperacion = req.query.tipoOperacion;
	//fechaFin = '2023-06-13T00:00:00.000Z'
	//fechaInicio = '2023-06-01T00:00:00.000Z'
	console.log("Soy el ID",id);
	console.log(fechaInicio);
	console.log(fechaFin);
	const query = { empresaId }; // Inicializar con empresaId si está disponible
	
	// Agregar campos a la consulta solo si tienen valores proporcionados
	if (req.query.id) {
		query.idNumber = {
		  $regex: new RegExp("\\b" + req.query.id + "\\b", 'i')
		};
	  }
	if (req.query.name) {
	  const nombreAliasParts = req.query.name.split(' ');
	  const nombreAliasQueries = nombreAliasParts.map(element => ({
		nombreAlias: { $regex: new RegExp("\\b" + element + "\\b", 'i') }
	  }));
	  query.$and = nombreAliasQueries;
	}
	if (req.query.estadoConsulta) query.estadoConsulta = req.query.estadoConsulta;
	if (req.query.pais) query.pais = req.query.pais;
	if (req.query.startDate && req.query.endDate) {
	  query.fechaCreado = {
		$gte: new Date(req.query.startDate),
		$lte: new Date(req.query.endDate)
	  };
	}
	if (req.query.tipoOperacion) query.tipo_operacion = req.query.tipoOperacion;
	
	console.log(query);
	console.log("nombre" + query.$and);
	
	try {
	  const report = await RiskProfile.find(query);
	  console.log("lo que responde Risk profiles", report);
	  res.json(report);
	} catch (error) {
	  res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal' });
	}
}




  async function getReportBy(req, res){
	console.log('llego aqui by code');
	// Se realiza el cambio de ID a Codigo ya que la variable a buscar es el codigo
		var id = req.query.id;
		var nombre = req.query.name;
		var estado = req.query.estadoConsulta;
		var date = req.query.date;

		//console.log(req);
		//var idNumber = parseInt(id);
		//console.log(req);
		console.log(id);
		console.log(nombre);
		console.log(estado);
		console.log(date);

		
		//if (id.lenght() > 0) {
			try {
				const report = await RiskProfile.find({
				  $or: [
					{ "firstNamelastName": nombre },
					{ "estado": estado },
					{ "idNumber": id },
					{ "fechaCreacion": date }
				  ]
				}).exec();
			  
				console.log("Los reportes:", report);
				res.json(report);
			  } catch (error) {
				res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal' + req + planId });
			  }
		//} 
		/*
		else if (nombre.lenght() > 0) {
			try {
			
				const report = Report.find({'firstNameLastName': nombre}, function(err, report) { 
					if (err){
						res.send(err)
					}else{
						res.json(report);
					}
				}); 
				console.log("Los planes"+report);
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
			}
		} else if (alias.lenght() > 0) {
			try {
			
				const report = Report.find({'nombreAlias': alias}, function(err, report) { 
					if (err){
						res.send(err)
					}else{
						res.json(report);
					}
				}); 
				console.log("Los planes"+report);
		
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
			}
		} else {
			
		}{
			
		}{
			
		}*/
	
	}

	
	/*****************************************************************************************************************************/
/* Función para obtener el perfil de riesgo de la persona que se caba de carlarle el perfil de riesgo en busqueda sencilla  */
/*****************************************************************************************************************************/
function getRiskProfile(req, res){
	//var params = req.body;
	var idProfile = req.params.idProfile;

	console.log('el valor de profuile xxx', idProfile);
	try {
		const profile = RiskProfile.findById(idProfile, function(err, profile) { 
			if (err){
				res.send(err)
			}else{
				console.log('la salida',profile);
				res.json(profile);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador del perfil de riesgos'});
	}
}



/*****************************************************************************************************************************/
/* Función para actualizar el perfil de riesgo de la persona que se caba de calcularle el perfil de riesgo en busqueda sencilla  */
/*****************************************************************************************************************************/
function updateRiskProfile(req, res){
	var params = req.body;
	var idProfile = req.params.idProfile;
	var info_actualizar = req.body;
	try {
		
		const updateProfile = RiskProfile.findOneAndUpdate({_id: Object(idProfile)}, {$set: info_actualizar}, function(err, updateProfile) { 
			console.log(updateProfile);
			if (err){
				res.send(err)
			}else{
				res.json(updateProfile);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de la actualización del registro de busqueda sencilla'});
	}
}

module.exports = {
	saveRiskProfile,
	getReportBy,
	getReportByAny,
	getIdBusqueda,
	saveReport,
	getRiskProfile,
	updateRiskProfile

};