'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var Entity = require('../models/search');
var jwt = require('../services/jwt');
const { db } = require('../models/search');

const distance = require('jaro-winkler');

const c = console.log;

//Graba en la base de datos muchos registros provenientes un archivo de excel
//Graba las busquedas que hace una empresa.

function saveSearch(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;
	/*
	console.log('respuesta de a uno');
	params.forEach(element => {
		db.collection("transactions").bsonOptions(element);
		console.log(element);
	});
*/

	if (empresa_id != ''){
		//if(db.collection(empresa_id).insertMany (params)){
			
		if(db.collection("searches").insertMany(params)){
			//console.log("Archivo de Busqueda Masiva IMportado");
			res.status(200).send({message: 'Grabado correctamente'});
		}else{
			//console.log("File imported error.");
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	}

}


/*
/* optimziado 04*/
/**/ 

// Función para crear índices si no existen
async function ensureIndexes() {
	try {
		const listsCollection = db.collection("lists");
		const customListsCollection = db.collection("customlists");
		
		// Función auxiliar para verificar si un índice existe por nombre
		async function indexExists(collection, indexName) {
			try {
				const indexes = await collection.indexes();
				return indexes.some(index => index.name === indexName);
			} catch (error) {
				console.error(`Error verificando índices en ${collection.collectionName}:`, error);
				return false;
			}
		}
		
		// Función para crear índice de forma segura
		async function createIndexSafe(collection, indexSpec, options) {
			try {
				const exists = await indexExists(collection, options.name);
				if (!exists) {
					await collection.createIndex(indexSpec, options);
					console.log(`Índice ${options.name} creado exitosamente en ${collection.collectionName}`);
				} else {
					console.log(`Índice ${options.name} ya existe en ${collection.collectionName}`);
				}
			} catch (error) {
				// Capturar errores específicos de MongoDB
				if (error.code === 85) { // IndexOptionsConflict
					console.log(`Conflicto de opciones de índice para ${options.name}, pero el índice existe`);
				} else if (error.code === 86) { // IndexKeySpecsConflict  
					console.log(`Conflicto de especificación de índice para ${options.name}, pero el índice existe`);
				} else if (error.message && error.message.includes('already exists')) {
					console.log(`Índice ${options.name} ya existe con diferentes opciones`);
				} else {
					console.error(`Error creando índice ${options.name} en ${collection.collectionName}:`, error.message);
				}
			}
		}
		
		// Crear índices para lists
		await createIndexSafe(
			listsCollection,
			{ "firstNamelastName": 1 },
			{ name: "firstNamelastName_1", background: true }
		);
		
		await createIndexSafe(
			listsCollection,
			{ "miAlias": 1 },
			{ name: "miAlias_1", background: true }
		);
		
		await createIndexSafe(
			listsCollection,
			{ "idNumber": 1 },
			{ name: "idNumber_1", background: true }
		);
		
		// Crear índices para customlists
		await createIndexSafe(
			customListsCollection,
			{ "firstNamelastName": 1, "empresa_id": 1 },
			{ name: "custom_firstNamelastName_empresa", background: true }
		);
		
		await createIndexSafe(
			customListsCollection,
			{ "idNumber": 1, "empresa_id": 1 },
			{ name: "custom_idNumber_empresa", background: true }
		);
		
	} catch (error) {
		console.error('Error general en ensureIndexes:', error);
		// No interrumpir la ejecución si falla la creación de índices
	}
}

/*
OPTIMZIADO 06
*/
async function getReportados(req, res) {
    const BATCH_SIZE = 100; // Procesar en lotes de 100 registros
    const MAX_CONCURRENT = 10; // Máximo de operaciones concurrentes
    
    let resultados = [];
    let datos = req.body['registros'];
    let id_empresa = req.body['id_empresa'];
    
    // Función auxiliar para normalizar texto (sacada del loop para reutilización)
    const normalizeText = (text) => {
        return text.normalize("NFD")
            .replace(/[\u0300-\u036f]/g, "")
            .trim();
    };
    
    // Función para construir regex con soporte de acentos
    const buildAccentRegex = (nombreAlias) => {
        const terminos = nombreAlias
            .split(' ')
            .map(term => normalizeText(term));
        
        const escapedTerms = terminos.map(t => {
            const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            return escaped
                .replace(/a/g, '[aáàâãä]')
                .replace(/e/g, '[eéèêë]')
                .replace(/i/g, '[iíìîï]')
                .replace(/o/g, '[oóòôõö]')
                .replace(/u/g, '[uúùûü]')
                .replace(/n/g, '[nñ]');
        });
        
        return new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b", 'i');
    };
    
    // Función para calcular coincidencia (optimizada con memoización)
    const coincidenciaCache = new Map();
    const getCoincidencia = (str1, str2) => {
        const key = `${str1}|${str2}`;
        if (coincidenciaCache.has(key)) {
            return coincidenciaCache.get(key);
        }
        const result = jaroWinklerf(str1.toUpperCase(), str2.toUpperCase());
        coincidenciaCache.set(key, result);
        return result;
    };
    
    // Función para procesar un registro individual
    const procesarRegistro = async (element, index) => {
        const nit = element.idNumber;
        const nombreAlias = element.nombreAlias;
        const resultadosRegistro = [];
        
        try {
            // Preparar las consultas de forma paralela
            const promises = [];
            
            if (nombreAlias !== '0' && nit === '0') {
                // Solo nombre/alias - consultas paralelas con múltiples variaciones
                const searchVariations = buildSearchVariations(nombreAlias);
                
                // Construir consulta OR con todas las variaciones
                const orConditions = searchVariations.map(regex => ({
                    firstNamelastName: { $regex: regex }
                }));
                
                // Si hay variaciones, usar OR, si no, usar búsqueda simple
                const filtro = orConditions.length > 0 ? 
                    { $or: orConditions } : 
                    { firstNamelastName: { $regex: new RegExp(nombreAlias, 'i') } };
                
                promises.push(
                    // Búsqueda en listas principales con todas las variaciones
                    db.collection("lists")
                        .find(filtro)
                        .limit(100)
                        .toArray()
                        .then(res_nombreAlias => {
                            if (res_nombreAlias.length > 0) {
                                return res_nombreAlias.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(Nombre): ' + nombreAlias,
                                    coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                    terminosBuscados: nombreAlias,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            // Si no encuentra por nombre, buscar por alias con variaciones más flexibles
                            const aliasVariations = [
                                new RegExp('.*' + nombreAlias + '.*', 'i'),
                                new RegExp('.*' + normalizeText(nombreAlias) + '.*', 'i'),
                                // Buscar cada palabra del nombre por separado en el alias
                                ...nombreAlias.split(' ').filter(t => t.length > 2).map(term => 
                                    new RegExp('.*' + term + '.*', 'i')
                                )
                            ];
                            
                            return db.collection("lists")
                                .find({ $or: aliasVariations.map(r => ({ miAlias: { $regex: r } })) })
                                .limit(100)
                                .toArray()
                                .then(res_Alias => {
                                    if (res_Alias.length > 0) {
                                        return res_Alias.map((elem, idx) => ({
                                            ...elem,
                                            encontrado_por: '(Alias): ' + nombreAlias,
                                            coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                            terminosBuscados: nombreAlias,
                                            el_primero: idx === 0 ? '1' : undefined
                                        }));
                                    }
                                    return [];
                                });
                        }),
                    
                    // Búsqueda en listas personalizadas con variaciones
                    db.collection("customlists")
                        .find({
                            $and: [
                                { empresa_id: id_empresa },
                                orConditions.length > 0 ? 
                                    { $or: orConditions } : 
                                    { firstNamelastName: { $regex: new RegExp(nombreAlias, 'i') } }
                            ]
                        })
                        .limit(100)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(Alias): ' + nombreAlias,
                                    coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                    terminosBuscados: nombreAlias,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return [];
                        })
                );
                
            } else if (nombreAlias === '0' && nit !== '0') {
                // Solo NIT - mejorar búsqueda para manejar variaciones en formato
                const nitVariations = [];
                
                // Limpiar el NIT de caracteres especiales
                const cleanNit = nit.replace(/[-.\s]/g, '');
                
                // Variación 1: NIT exacto
                nitVariations.push(new RegExp(`\\b${nit}\\b`, 'i'));
                
                // Variación 2: NIT sin caracteres especiales
                if (cleanNit !== nit) {
                    nitVariations.push(new RegExp(`\\b${cleanNit}\\b`, 'i'));
                }
                
                // Variación 3: NIT con diferentes formatos (XX-XXXXXXX-X, XX.XXXXXXX.X)
                if (cleanNit.length >= 9) {
                    // Formato con guiones: XX-XXXXXXX-X
                    const withDashes = `${cleanNit.slice(0,2)}-${cleanNit.slice(2,9)}-${cleanNit.slice(9)}`;
                    nitVariations.push(new RegExp(`\\b${withDashes}\\b`, 'i'));
                    
                    // Formato con puntos: XX.XXXXXXX.X
                    const withDots = `${cleanNit.slice(0,2)}.${cleanNit.slice(2,9)}.${cleanNit.slice(9)}`;
                    nitVariations.push(new RegExp(`\\b${withDots}\\b`, 'i'));
                }
                
                // Construir consulta OR con todas las variaciones
                const nitOrConditions = nitVariations.map(regex => ({
                    idNumber: { $regex: regex }
                }));
                
                promises.push(
                    // Búsqueda en listas principales
                    db.collection("lists")
                        .find({ $or: nitOrConditions })
                        .limit(100)
                        .toArray()
                        .then(res_nit => {
                            if (res_nit.length > 0) {
                                return res_nit.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(NIT): ' + nit,
                                    coincidencia: 1,
                                    terminosBuscados: nit,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return []; // Retornar array vacío si no encuentra
                        }),
                    
                    // Búsqueda en listas personalizadas
                    db.collection("customlists")
                        .find({
                            $and: [
                                { empresa_id: id_empresa },
                                { $or: nitOrConditions }
                            ]
                        })
                        .limit(100)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(NIT): ' + nit,
                                    coincidencia: 1,
                                    terminosBuscados: nit,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return []; // Retornar array vacío si no encuentra
                        })
                );
                
            } else if (nombreAlias !== '0' && nit !== '0') {
                // Ambos tienen datos - usar aggregation pipeline optimizado
                const searchVariations = buildSearchVariations(nombreAlias);
                 nitRegex = new RegExp(`\\b${nit}\\b`, 'i');
                
                // Usar la primera variación como principal (más específica)
                const mainNameRegex = searchVariations.length > 0 ? searchVariations[0] : new RegExp(nombreAlias, 'i');
                
                // Construir condiciones OR para todas las variaciones
                 nameOrConditions = searchVariations.length > 0 ?
                    searchVariations.map(regex => ({ firstNamelastName: { $regex: regex } })) :
                    [{ firstNamelastName: { $regex: new RegExp(nombreAlias, 'i') } }];
                
                 pipeline = [
                    {
                        $match: {
                            $or: [
                                ...nameOrConditions,
                                { idNumber: { $regex: nitRegex } }
                            ]
                        }
                    },
                    { $limit: 100 },
                    {
                        $addFields: {
                            matchedBy: {
                                $switch: {
                                    branches: [
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$idNumber", 
                                                    regex: `\\b${nit}\\b`,
                                                    options: "i"
                                                } 
                                            },
                                            then: "idNumber"
                                        },
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$firstNamelastName", 
                                                    regex: mainNameRegex.source,
                                                    options: "i" 
                                                } 
                                            },
                                            then: "firstNamelastName"
                                        }
                                    ],
                                    default: "firstNamelastName"  // Si llegó aquí, coincidió con alguna variación del nombre
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];
                
                 pipelinePersonalizada = [
                    {
                        $match: {
                            $and: [
                                { empresa_id: id_empresa },
                                {
                                    $or: [
                                        ...nameOrConditions,
                                        { idNumber: { $regex: nitRegex } }
                                    ]
                                }
                            ]
                        }
                    },
                    { $limit: 100 },
                    {
                        $addFields: {
                            matchedBy: {
                                $switch: {
                                    branches: [
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$idNumber", 
                                                    regex: `\\b${nit}\\b`,
                                                    options: "i"
                                                } 
                                            },
                                            then: "idNumber"
                                        },
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$firstNamelastName", 
                                                    regex: mainNameRegex.source,
                                                    options: "i" 
                                                } 
                                            },
                                            then: "firstNamelastName"
                                        }
                                    ],
                                    default: "firstNamelastName"  // Si llegó aquí, coincidió con alguna variación del nombre
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];ations(nombreAlias);
                const nitRegex = new RegExp(`\\b${nit}\\b`, 'i');
                
                // Construir condiciones OR para las variaciones del nombre
                const nameOrConditions = searchVariations.length > 0 ?
                    searchVariations.map(regex => ({ firstNamelastName: { $regex: regex } })) :
                    [{ firstNamelastName: { $regex: new RegExp(nombreAlias, 'i') } }];
                
                const pipeline = [
                    {
                        $match: {
                            $or: [
                                ...nameOrConditions,
                                { idNumber: { $regex: nitRegex } }
                            ]
                        }
                    },
                    { $limit: 100 },
                    {
                        $addFields: {
                            matchedBy: {
                                $cond: {
                                    if: { 
                                        $regexMatch: { 
                                            input: "$idNumber", 
                                            regex: `\\b${nit}\\b`,
                                            options: "i"
                                        } 
                                    },
                                    then: "idNumber",
                                    else: {
                                        $cond: {
                                            if: {
                                                $or: searchVariations.map(v => ({
                                                    $regexMatch: {
                                                        input: "$firstNamelastName",
                                                        regex: v.source,
                                                        options: "i"
                                                    }
                                                }))
                                            },
                                            then: "firstNamelastName",
                                            else: "No match"
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];
                
                const pipelinePersonalizada = [
                    {
                        $match: {
                            $and: [
                                { empresa_id: id_empresa },
                                {
                                    $or: [
                                        ...nameOrConditions,
                                        { idNumber: { $regex: nitRegex } }
                                    ]
                                }
                            ]
                        }
                    },
                    { $limit: 100 },
                    {
                        $addFields: {
                            matchedBy: {
                                $cond: {
                                    if: { 
                                        $regexMatch: { 
                                            input: "$idNumber", 
                                            regex: `\\b${nit}\\b`,
                                            options: "i"
                                        } 
                                    },
                                    then: "idNumber",
                                    else: {
                                        $cond: {
                                            if: {
                                                $or: searchVariations.map(v => ({
                                                    $regexMatch: {
                                                        input: "$firstNamelastName",
                                                        regex: v.source,
                                                        options: "i"
                                                    }
                                                }))
                                            },
                                            then: "firstNamelastName",
                                            else: "No match"
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];
                
                promises.push(
                    // Búsqueda en listas principales
                    db.collection("lists")
                        .aggregate(pipeline)
                        .toArray()
                        .then(res_ambos => {
                            if (res_ambos.length > 0) {
                                return res_ambos.map((elem, idx) => {
                                    let encontrado_por;
                                    if (elem.matchedBy === 'firstNamelastName') {
                                        encontrado_por = '(Nombre): ' + nombreAlias;
                                    } else if (elem.matchedBy === 'idNumber') {
                                        encontrado_por = '(NIT): ' + nit;
                                    } else {
                                        encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                                    }
                                    
                                    return {
                                        ...elem,
                                        encontrado_por,
                                        coincidencia: 0.85,
                                        terminosBuscados: nit + ' / ' + nombreAlias,
                                        el_primero: idx === 0 ? '1' : undefined
                                    };
                                });
                            }
                            return []; // Retornar array vacío si no encuentra
                        }),
                    
                    // Búsqueda en listas personalizadas
                    db.collection("customlists")
                        .aggregate(pipelinePersonalizada)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => {
                                    let encontrado_por;
                                    if (elem.matchedBy === 'firstNamelastName') {
                                        encontrado_por = '(Nombre): ' + nombreAlias;
                                    } else if (elem.matchedBy === 'idNumber') {
                                        encontrado_por = '(NIT): ' + nit;
                                    } else {
                                        encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                                    }
                                    
                                    return {
                                        ...elem,
                                        encontrado_por,
                                        coincidencia: 0.85,
                                        terminosBuscados: nit + ' / ' + nombreAlias,
                                        el_primero: idx === 0 ? '1' : undefined
                                    };
                                });
                            }
                            return []; // Retornar array vacío si no encuentra
                        })
                );
            }
            
            // Esperar todas las promesas y combinar resultados
            const allResults = await Promise.all(promises);
            
            // Verificar si hay resultados reales (no arrays vacíos)
            let hayResultadosReales = false;
            
            allResults.forEach(results => {
                if (results && results.length > 0) {
                    hayResultadosReales = true;
                    resultadosRegistro.push(...results);
                }
            });
            
            // Si NO hay resultados en ninguna búsqueda, agregar "No Reportado"
            if (!hayResultadosReales) {
                const terminosBuscados = nombreAlias !== '0' && nit !== '0' ? 
                    nit + ' / ' + nombreAlias : 
                    (nombreAlias !== '0' ? nombreAlias : nit);
                    
                resultadosRegistro.push({
                    firstNamelastName: nombreAlias !== '0' ? nombreAlias : '0',
                    idNumber: nit !== '0' ? nit : '0',
                    estado: 'No Reportado',
                    coincidencia: 0,
                    terminosBuscados: terminosBuscados
                });
            }
            
        } catch (error) {
            console.error(`Error procesando registro ${index}:`, error);
            // En caso de error real de conexión o sistema, mantener el registro como no reportado
            resultadosRegistro.push({
                firstNamelastName: nombreAlias !== '0' ? nombreAlias : '0',
                idNumber: nit !== '0' ? nit : '0',
                estado: 'No Reportado',
                coincidencia: 0,
                terminosBuscados: nombreAlias !== '0' && nit !== '0' ? 
                    nit + ' / ' + nombreAlias : 
                    (nombreAlias !== '0' ? nombreAlias : nit)
            });
        }
        
        return resultadosRegistro;
    };
    
    // Función para procesar lotes con control de concurrencia
    const procesarLote = async (lote, startIndex) => {
        const resultadosLote = [];
        
        // Procesar cada elemento del lote en paralelo
        const promesasLote = lote.map((element, idx) => 
            procesarRegistro(element, startIndex + idx)
        );
        
        const resultadosElementos = await Promise.all(promesasLote);
        
        // Combinar y ordenar resultados del lote
        resultadosElementos.forEach(elementResults => {
            const reportados = elementResults.filter(r => r.estado === 'Reportado');
            const noReportados = elementResults.filter(r => r.estado !== 'Reportado');
            
            // Mantener el orden: reportados primero
            resultadosLote.push(...reportados, ...noReportados);
        });
        
        return resultadosLote;
    };
    
    // Dividir datos en lotes y procesar con control de concurrencia
    try {
        const lotes = [];
        for (let i = 0; i < datos.length; i += BATCH_SIZE) {
            lotes.push(datos.slice(i, Math.min(i + BATCH_SIZE, datos.length)));
        }
        
        // Procesar lotes con control de concurrencia
        const resultadosTotales = [];
        for (let i = 0; i < lotes.length; i += MAX_CONCURRENT) {
            const lotesActuales = lotes.slice(i, Math.min(i + MAX_CONCURRENT, lotes.length));
            
            const promesasLotes = lotesActuales.map((lote, idx) => 
                procesarLote(lote, (i + idx) * BATCH_SIZE)
            );
            
            const resultadosLotes = await Promise.all(promesasLotes);
            resultadosLotes.forEach(loteResultados => {
                resultadosTotales.push(...loteResultados);
            });
            
            // Log de progreso cada cierto número de registros
            const procesados = Math.min((i + MAX_CONCURRENT) * BATCH_SIZE, datos.length);
            if (procesados % 1000 === 0 || procesados === datos.length) {
                console.log(`Procesados ${procesados}/${datos.length} registros`);
            }
        }
        
        // Ordenar resultados finales: Reportados primero
        const reportadosFinales = resultadosTotales.filter(r => r.estado === 'Reportado');
        const noReportadosFinales = resultadosTotales.filter(r => r.estado !== 'Reportado');
        
        resultados = [...reportadosFinales, ...noReportadosFinales];
        
        res.json(resultados);
        
    } catch (error) {
        console.error('Error general en procesamiento:', error);
        res.status(500).json({ 
            error: 'Error procesando registros', 
            detalle: error.message 
        });
    }
}

// IMPORTANTE: Crear estos índices en MongoDB para máximo rendimiento
/*
// Índices para la colección "lists"
db.lists.createIndex({ "firstNamelastName": "text" })
db.lists.createIndex({ "idNumber": 1 })
db.lists.createIndex({ "aka": 1 })
db.lists.createIndex({ "estado": 1 })

// Índices compuestos para búsquedas combinadas
db.lists.createIndex({ "firstNamelastName": 1, "idNumber": 1 })

// Índice para búsquedas case-insensitive y con acentos
db.lists.createIndex(
    { "firstNamelastName": 1 },
    { 
        collation: { 
            locale: "es", 
            strength: 1,  // Ignora case y diacríticos
            numericOrdering: true 
        } 
    }
)

// Índices para la colección "customlists"
db.customlists.createIndex({ "firstNamelastName": "text" })
db.customlists.createIndex({ "idNumber": 1 })
db.customlists.createIndex({ "empresa_id": 1 })
db.customlists.createIndex({ "estado": 1 })

// Índices compuestos para customlists
db.customlists.createIndex({ "empresa_id": 1, "firstNamelastName": 1 })
db.customlists.createIndex({ "empresa_id": 1, "idNumber": 1 })
db.customlists.createIndex({ "empresa_id": 1, "firstNamelastName": 1, "idNumber": 1 })

// Índice con collation para búsquedas insensibles
db.customlists.createIndex(
    { "empresa_id": 1, "firstNamelastName": 1 },
    { 
        collation: { 
            locale: "es", 
            strength: 1,
            numericOrdering: true 
        } 
    }
)

// Para optimizar aún más, considera crear un campo normalizado:
// 1. Agregar campo normalizado al insertar/actualizar documentos:
//    doc.firstNamelastNameNormalized = doc.firstNamelastName
//        .normalize("NFD")
//        .replace(/[\u0300-\u036f]/g, "")
//        .toLowerCase();
// 
// 2. Crear índice en el campo normalizado:
//    db.lists.createIndex({ "firstNamelastNameNormalized": 1 })
//    db.customlists.createIndex({ "empresa_id": 1, "firstNamelastNameNormalized": 1 })
*/





























/*
OPTIMIZADO 05
*/
async function getReportados(req, res) {
    const BATCH_SIZE = 100; // Procesar en lotes de 100 registros
    const MAX_CONCURRENT = 10; // Máximo de operaciones concurrentes
    
    let resultados = [];
    let datos = req.body['registros'];
    let id_empresa = req.body['id_empresa'];
    
    // Función auxiliar para normalizar texto (sacada del loop para reutilización)
    const normalizeText = (text) => {
        return text.normalize("NFD")
            .replace(/[\u0300-\u036f]/g, "")
            .trim();
    };
    
    // Función para construir regex con soporte de acentos
    const buildAccentRegex = (nombreAlias) => {
        const terminos = nombreAlias
            .split(' ')
            .map(term => normalizeText(term));
        
        const escapedTerms = terminos.map(t => {
            const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            return escaped
                .replace(/a/g, '[aáàâãä]')
                .replace(/e/g, '[eéèêë]')
                .replace(/i/g, '[iíìîï]')
                .replace(/o/g, '[oóòôõö]')
                .replace(/u/g, '[uúùûü]')
                .replace(/n/g, '[nñ]');
        });
        
        return new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b", 'i');
    };
    
    // Función para calcular coincidencia (optimizada con memoización)
    const coincidenciaCache = new Map();
    const getCoincidencia = (str1, str2) => {
        const key = `${str1}|${str2}`;
        if (coincidenciaCache.has(key)) {
            return coincidenciaCache.get(key);
        }
        const result = jaroWinklerf(str1.toUpperCase(), str2.toUpperCase());
        coincidenciaCache.set(key, result);
        return result;
    };
    
    // Función para procesar un registro individual
    const procesarRegistro = async (element, index) => {
        const nit = element.idNumber;
		//const nit = element.identificacion;
        const nombreAlias = element.nombreAlias;
        const resultadosRegistro = [];
        
        try {
            // Preparar las consultas de forma paralela
            const promises = [];
            
            if (nombreAlias !== '0' && nit === '0') {
                // Solo nombre/alias - consultas paralelas
                const consulta_regexp = buildAccentRegex(nombreAlias);
                
                promises.push(
                    // Búsqueda en listas principales
                    db.collection("lists")
                        .find({ firstNamelastName: { $regex: consulta_regexp } })
                        .limit(100) // Limitar resultados para evitar sobrecarga
                        .toArray()
                        .then(res_nombreAlias => {
                            if (res_nombreAlias.length > 0) {
                                return res_nombreAlias.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(Nombre): ' + nombreAlias,
                                    coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                    terminosBuscados: nombreAlias,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            // Si no encuentra por nombre, buscar por alias
                            return db.collection("lists")
                                .find({ miAlias: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } })
                                .limit(100)
                                .toArray()
                                .then(res_Alias => {
                                    if (res_Alias.length > 0) {
                                        return res_Alias.map((elem, idx) => ({
                                            ...elem,
                                            encontrado_por: '(Alias): ' + nombreAlias,
                                            coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                            terminosBuscados: nombreAlias,
                                            el_primero: idx === 0 ? '1' : undefined
                                        }));
                                    }
                                    return []; // Retornar array vacío si no encuentra
                                });
                        }),
                    
                    // Búsqueda en listas personalizadas
                    db.collection("customlists")
                        .find({
                            firstNamelastName: { $regex: buildAccentRegex(nombreAlias) },
                            empresa_id: id_empresa
                        })
                        .limit(100)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(Alias): ' + nombreAlias,
                                    coincidencia: getCoincidencia(nombreAlias, elem.firstNamelastName),
                                    terminosBuscados: nombreAlias,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return []; // Retornar array vacío si no encuentra
                        })
                );
                
            } else if (nombreAlias === '0' && nit !== '0') {
                // Solo NIT - consultas paralelas
                const nitRegex = new RegExp("\\b" + nit + "\\b", 'i');
                
                promises.push(
                    // Búsqueda en listas principales
                    db.collection("lists")
                        .find({ idNumber: { $regex: nitRegex } })
                        .limit(100)
                        .toArray()
                        .then(res_nit => {
                            if (res_nit.length > 0) {
                                return res_nit.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(NIT): ' + nit,
                                    coincidencia: 1,
                                    terminosBuscados: nit,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return []; // Retornar array vacío si no encuentra
                        }),
                    
                    // Búsqueda en listas personalizadas
                    db.collection("customlists")
                        .find({
                            idNumber: { $regex: nitRegex },
                            empresa_id: id_empresa
                        })
                        .limit(100)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => ({
                                    ...elem,
                                    encontrado_por: '(NIT): ' + nit,
                                    coincidencia: 1,
                                    terminosBuscados: nit,
                                    el_primero: idx === 0 ? '1' : undefined
                                }));
                            }
                            return []; // Retornar array vacío si no encuentra
                        })
                );
                
            } else if (nombreAlias !== '0' && nit !== '0') {
                // Ambos tienen datos - usar aggregation pipeline optimizado
                const consulta_regexp = buildAccentRegex(nombreAlias);
                const nitRegex = new RegExp(`\\b${nit}\\b`, 'i');
                
                const pipeline = [
                    {
                        $match: {
                            $or: [
                                { firstNamelastName: { $regex: consulta_regexp } },
                                { idNumber: { $regex: nitRegex } }
                            ]
                        }
                    },
                    { $limit: 100 }, // Limitar resultados
                    {
                        $addFields: {
                            matchedBy: {
                                $switch: {
                                    branches: [
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$idNumber", 
                                                    regex: `\\b${nit}\\b`,
                                                    options: "i"
                                                } 
                                            },
                                            then: "idNumber"
                                        },
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$firstNamelastName", 
                                                    regex: consulta_regexp.source,  // Extraer el patrón sin flags
                                                    options: "i" 
                                                } 
                                            },
                                            then: "firstNamelastName"
                                        }
                                    ],
                                    default: "No match"
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];
                
                const pipelinePersonalizada = [
                    {
                        $match: {
                            $and: [
                                { empresa_id: id_empresa },
                                {
                                    $or: [
                                        { firstNamelastName: { $regex: consulta_regexp } },
                                        { idNumber: { $regex: nitRegex } }
                                    ]
                                }
                            ]
                        }
                    },
                    { $limit: 100 },
                    {
                        $addFields: {
                            matchedBy: {
                                $switch: {
                                    branches: [
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$idNumber", 
                                                    regex: `\\b${nit}\\b`,
                                                    options: "i"
                                                } 
                                            },
                                            then: "idNumber"
                                        },
                                        {
                                            case: { 
                                                $regexMatch: { 
                                                    input: "$firstNamelastName", 
                                                    regex: consulta_regexp.source,  // Extraer el patrón sin flags
                                                    options: "i" 
                                                } 
                                            },
                                            then: "firstNamelastName"
                                        }
                                    ],
                                    default: "No match"
                                }
                            }
                        }
                    },
                    {
                        $match: {
                            matchedBy: { $ne: "No match" }
                        }
                    }
                ];
                
                promises.push(
                    // Búsqueda en listas principales
                    db.collection("lists")
                        .aggregate(pipeline)
                        .toArray()
                        .then(res_ambos => {
                            if (res_ambos.length > 0) {
                                return res_ambos.map((elem, idx) => {
                                    let encontrado_por;
                                    if (elem.matchedBy === 'firstNamelastName') {
                                        encontrado_por = '(Nombre): ' + nombreAlias;
                                    } else if (elem.matchedBy === 'idNumber') {
                                        encontrado_por = '(NIT): ' + nit;
                                    } else {
                                        encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                                    }
                                    
                                    return {
                                        ...elem,
                                        encontrado_por,
                                        coincidencia: 0.85,
                                        terminosBuscados: nit + ' / ' + nombreAlias,
                                        el_primero: idx === 0 ? '1' : undefined
                                    };
                                });
                            }
                            return []; // Retornar array vacío si no encuentra
                        }),
                    
                    // Búsqueda en listas personalizadas
                    db.collection("customlists")
                        .aggregate(pipelinePersonalizada)
                        .toArray()
                        .then(res_personalizada => {
                            if (res_personalizada.length > 0) {
                                return res_personalizada.map((elem, idx) => {
                                    let encontrado_por;
                                    if (elem.matchedBy === 'firstNamelastName') {
                                        encontrado_por = '(Nombre): ' + nombreAlias;
                                    } else if (elem.matchedBy === 'idNumber') {
                                        encontrado_por = '(NIT): ' + nit;
                                    } else {
                                        encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                                    }
                                    
                                    return {
                                        ...elem,
                                        encontrado_por,
                                        coincidencia: 0.85,
                                        terminosBuscados: nit + ' / ' + nombreAlias,
                                        el_primero: idx === 0 ? '1' : undefined
                                    };
                                });
                            }
                            return []; // Retornar array vacío si no encuentra
                        })
                );
            }
            
            // Esperar todas las promesas y combinar resultados
            const allResults = await Promise.all(promises);
            
            // Verificar si hay resultados reales (no arrays vacíos)
            let hayResultadosReales = false;
            
            allResults.forEach(results => {
                if (results && results.length > 0) {
                    hayResultadosReales = true;
                    resultadosRegistro.push(...results);
                }
            });
            
            // Si NO hay resultados en ninguna búsqueda, agregar "No Reportado"
            if (!hayResultadosReales) {
                const terminosBuscados = nombreAlias !== '0' && nit !== '0' ? 
                    nit + ' / ' + nombreAlias : 
                    (nombreAlias !== '0' ? nombreAlias : nit);
                    
                resultadosRegistro.push({
                    firstNamelastName: nombreAlias !== '0' ? nombreAlias : '0',
                    idNumber: nit !== '0' ? nit : '0',
                    estado: 'No Reportado',
                    coincidencia: 0,
                    terminosBuscados: terminosBuscados
                });
            }
            
        } catch (error) {
            console.error(`Error procesando registro ${index}:`, error);
            // En caso de error real de conexión o sistema, mantener el registro como no reportado
            resultadosRegistro.push({
                firstNamelastName: nombreAlias !== '0' ? nombreAlias : '0',
                idNumber: nit !== '0' ? nit : '0',
                estado: 'No Reportado',
                coincidencia: 0,
                terminosBuscados: nombreAlias !== '0' && nit !== '0' ? 
                    nit + ' / ' + nombreAlias : 
                    (nombreAlias !== '0' ? nombreAlias : nit)
            });
        }
        
        return resultadosRegistro;
    };
    
    // Función para procesar lotes con control de concurrencia
    const procesarLote = async (lote, startIndex) => {
        const resultadosLote = [];
        
        // Procesar cada elemento del lote en paralelo
        const promesasLote = lote.map((element, idx) => 
            procesarRegistro(element, startIndex + idx)
        );
        
        const resultadosElementos = await Promise.all(promesasLote);
        
        // Combinar y ordenar resultados del lote
        resultadosElementos.forEach(elementResults => {
            const reportados = elementResults.filter(r => r.estado === 'Reportado');
            const noReportados = elementResults.filter(r => r.estado !== 'Reportado');
            
            // Mantener el orden: reportados primero
            resultadosLote.push(...reportados, ...noReportados);
        });
        
        return resultadosLote;
    };
    
    // Dividir datos en lotes y procesar con control de concurrencia
    try {
        const lotes = [];
        for (let i = 0; i < datos.length; i += BATCH_SIZE) {
            lotes.push(datos.slice(i, Math.min(i + BATCH_SIZE, datos.length)));
        }
        
        // Procesar lotes con control de concurrencia
        const resultadosTotales = [];
        for (let i = 0; i < lotes.length; i += MAX_CONCURRENT) {
            const lotesActuales = lotes.slice(i, Math.min(i + MAX_CONCURRENT, lotes.length));
            
            const promesasLotes = lotesActuales.map((lote, idx) => 
                procesarLote(lote, (i + idx) * BATCH_SIZE)
            );
            
            const resultadosLotes = await Promise.all(promesasLotes);
            resultadosLotes.forEach(loteResultados => {
                resultadosTotales.push(...loteResultados);
            });
            
            // Log de progreso cada cierto número de registros
            const procesados = Math.min((i + MAX_CONCURRENT) * BATCH_SIZE, datos.length);
            if (procesados % 1000 === 0 || procesados === datos.length) {
                console.log(`Procesados ${procesados}/${datos.length} registros`);
            }
        }
        
        // Ordenar resultados finales: Reportados primero
        const reportadosFinales = resultadosTotales.filter(r => r.estado === 'Reportado');
        const noReportadosFinales = resultadosTotales.filter(r => r.estado !== 'Reportado');
        
        resultados = [...reportadosFinales, ...noReportadosFinales];
        
        res.json(resultados);
        
    } catch (error) {
        console.error('Error general en procesamiento:', error);
        res.status(500).json({ 
            error: 'Error procesando registros', 
            detalle: error.message 
        });
    }
}

// IMPORTANTE: Crear estos índices en MongoDB para máximo rendimiento
/*
// Índices para la colección "lists"
db.lists.createIndex({ "firstNamelastName": "text" })
db.lists.createIndex({ "idNumber": 1 })
db.lists.createIndex({ "aka": 1 })
db.lists.createIndex({ "estado": 1 })

// Índices compuestos para búsquedas combinadas
db.lists.createIndex({ "firstNamelastName": 1, "idNumber": 1 })

// Índices para la colección "customlists"
db.customlists.createIndex({ "firstNamelastName": "text" })
db.customlists.createIndex({ "idNumber": 1 })
db.customlists.createIndex({ "empresa_id": 1 })
db.customlists.createIndex({ "estado": 1 })

// Índices compuestos para customlists
db.customlists.createIndex({ "empresa_id": 1, "firstNamelastName": 1 })
db.customlists.createIndex({ "empresa_id": 1, "idNumber": 1 })
db.customlists.createIndex({ "empresa_id": 1, "firstNamelastName": 1, "idNumber": 1 })
*/
  















































async function getReportados_optimizado_04(req, res) {
	
	// Asegurar índices
	await ensureIndexes();
	
	let resultados = [];
	let datos = req.body['registros'];
	let id_empresa = req.body['id_empresa'];
  
	// Procesar todos los registros en paralelo
	const promesasRegistros = datos.map(async (element, index) => {

		let nit = element.identificacion;
		let nombreAlias = element.nombreAlias;

		// Función para normalizar texto (eliminar acentos) - EXACTAMENTE IGUAL
		function normalizeText(text) {
			return text.normalize("NFD")
				.replace(/[\u0300-\u036f]/g, "")
				.trim();
		}

		// Divido la cadena de búsqueda y normalizo cada término - EXACTAMENTE IGUAL
		const terminos = nombreAlias
		.split(' ')
		.map(term => normalizeText(term));

		// Escapar los términos - EXACTAMENTE IGUAL
		let escapedTerms = terminos.map(t => {
		// Primero escapamos caracteres especiales
		const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');

		// Luego agregamos soporte para acentos en cada vocal
		return escaped
			.replace(/a/g, '[aáàâãä]')
			.replace(/e/g, '[eéèêë]')
			.replace(/i/g, '[iíìîï]')
			.replace(/o/g, '[oóòôõö]')
			.replace(/u/g, '[uúùûü]')
			.replace(/n/g, '[nñ]');
		});

		// Construir la expresión regular con límites de palabra - EXACTAMENTE IGUAL
		let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");

		let resultadosElemento = [];
		
		// Función para procesar resultados - CONSERVA LA LÓGICA ORIGINAL
		function procesarResultados(resultados, tipoEncontrado, termino) {
			if (resultados.length > 0) {
				resultados[0].el_primero = '1';
				resultados.forEach(element => {
					element.encontrado_por = tipoEncontrado + termino;
					// Eliminé jaroWinkler como pediste, usando valores fijos según el tipo
					if (tipoEncontrado.includes('NIT')) {
						element.coincidencia = 1;
						element.terminosBuscados = nit;
					} else if (tipoEncontrado.includes('Alias')) {
						element.coincidencia = 0.8;
						element.terminosBuscados = nombreAlias;
					} else {
						element.coincidencia = 0.9;
						element.terminosBuscados = nombreAlias;
					}
				});
				return resultados;
			}
			return [];
		}

		// Función para procesar resultados ambos - CONSERVA LA LÓGICA ORIGINAL
		function procesarResultadosAmbos(resultados) {
			if (resultados.length > 0) {
				resultados[0].el_primero = '1';
				resultados.forEach(element => {
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
						element.terminosBuscados = nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						element.encontrado_por = '(NIT): ' + nit;
						element.terminosBuscados = nit;
					} else {
						element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
						element.terminosBuscados = nit + ' / ' + nombreAlias;
					}
					element.coincidencia = 0.85;
				});
				return resultados;
			}
			return [];
		}
		
		if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos - LÓGICA ORIGINAL
			
			// Búsqueda en lists - PARALELA
			const promesaLists = (async () => {
				let filtro = {
					firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				};
				const res_nombreAlias = await db.collection("lists").find(filtro).toArray();

				if (res_nombreAlias.length === 0) { //consulte por alias - LÓGICA ORIGINAL
					const consultaAlias = { aka: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }
					const res_Alias = await db.collection("lists").find(consultaAlias).toArray();
					return procesarResultados(res_Alias, '(Alias): ', nombreAlias);
				} else {
					return procesarResultados(res_nombreAlias, '(Nombre): ', nombreAlias);
				}
			})();

			// Búsqueda en customlists - PARALELA
			const promesaCustom = (async () => {
				let filtro_personalizada = {
					$and: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i' } },
						{ empresa_id: id_empresa }
					]
				};
				const res_nombreAlias_personalizada = await db.collection("customlists").find(filtro_personalizada).toArray();
				if (res_nombreAlias_personalizada.length > 0) {
					res_nombreAlias_personalizada[0].el_primero = '1';
					res_nombreAlias_personalizada.forEach(element => {
						element.encontrado_por = '(Alias): ' + nombreAlias;
						element.terminosBuscados = nombreAlias;
						element.coincidencia = 0.8;
					});
				}
				return res_nombreAlias_personalizada;
			})();

			// Ejecutar ambas búsquedas en paralelo
			const [resLists, resCustom] = await Promise.all([promesaLists, promesaCustom]);
			resultadosElemento.push(...resLists, ...resCustom);
		
		} else if (nombreAlias === '0' && nit !== '0') { //si solo nit tiene datos - LÓGICA ORIGINAL

			// Búsqueda en lists - PARALELA
			const promesaLists = (async () => {
				const res_nit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
				return procesarResultados(res_nit, '(NIT): ', nit);
			})();

			// Búsqueda en customlists - PARALELA
			const promesaCustom = (async () => {
				const res_nit_personalizada = await db.collection("customlists").find({
					$and: [
						{ 'idNumber': { '$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i' } },
						{ 'empresa_id': id_empresa }
					]
				}).toArray();

				if (res_nit_personalizada.length > 0) {
					res_nit_personalizada[0].el_primero = '1';
					res_nit_personalizada.forEach(element => {
						element.encontrado_por = '(NIT): ' + nit;
						element.coincidencia = 1;
						element.terminosBuscados = nit;
					});
				}
				return res_nit_personalizada;
			})();

			// Ejecutar ambas búsquedas en paralelo
			const [resLists, resCustom] = await Promise.all([promesaLists, promesaCustom]);
			resultadosElemento.push(...resLists, ...resCustom);
		
		} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos - LÓGICA ORIGINAL

			// Búsqueda en lists - PARALELA
			const promesaLists = (async () => {
				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
					]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos = await db.collection("lists").aggregate(pipeline).toArray();
				return procesarResultadosAmbos(res_ambos);
			})();

			// Búsqueda en customlists - PARALELA
			const promesaCustom = (async () => {
				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } },
					],
						$and: [
							{ empresa_id: id_empresa }
						]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos_personalizada = await db.collection("customlists").aggregate(pipeline).toArray();

				if (res_ambos_personalizada.length > 0) {
					res_ambos_personalizada[0].el_primero = '1';
					res_ambos_personalizada.forEach(element => {
						if (element.matchedBy === 'firstNamelastName' ) {
							element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
						} else if (element.matchedBy === 'idNumber' ) {
							element.encontrado_por = '(NIT): ' + nit;
						} else {
							element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
						}
						element.terminosBuscados = nit + ' / ' + nombreAlias;
						element.coincidencia = 0.85;
					});
				}
				return res_ambos_personalizada;
			})();

			// Ejecutar ambas búsquedas en paralelo
			const [resLists, resCustom] = await Promise.all([promesaLists, promesaCustom]);
			resultadosElemento.push(...resLists, ...resCustom);
		}

		// Si no hay resultados, aplicar la lógica original de sin_resultados
		if (resultadosElemento.length === 0) {
			let encontrado_por = (nombreAlias !== '0' && nit !== '0') ? nit + ' ' + nombreAlias : 
								 (nombreAlias !== '0' ? nombreAlias : nit);
			
			const sinResultados = [{
				firstNamelastName: nombreAlias,
				idNumber: nit,
				estado: 'No Reportado',
				coincidencia: 0,
				terminosBuscados: encontrado_por
			}];
			resultadosElemento.push(...sinResultados);
		}

		return { resultadosElemento, index };
	});

	// Esperar a que todos los registros terminen
	const todosLosResultados = await Promise.all(promesasRegistros);

	// Función acumula_resultados - LÓGICA ORIGINAL CONSERVADA
	function acumula_resultados(respuesta) {
		if (respuesta[0] && respuesta[0].estado === 'Reportado') {
		  resultados.splice(0,0,...respuesta);
		} else {
		  resultados.push(...respuesta);
		}
	}

	// Procesar resultados manteniendo el orden y la lógica original
	todosLosResultados
		.sort((a, b) => a.index - b.index) // Mantener orden original
		.forEach(({ resultadosElemento }) => {
			acumula_resultados(resultadosElemento);
		});

	res.json(resultados);
}





































/*********************************************** */
/****OPTIMZIADO 03 */
/*********************************************** */
async function getReportados_03(req, res) {
    try {
        let resultados = [];
        let datos = req.body['registros'];
        let id_empresa = req.body['id_empresa'];

        if (!datos || !Array.isArray(datos) || datos.length === 0) {
            return res.json([]);
        }

        console.log('los datos recibidos son:', datos);
        // CREAR ÍNDICES DE FORMA PROGRAMÁTICA AL INICIO
        const crearIndices = async () => {
            try {
                const indicesRequeridos = [
                    { collection: "lists", index: { "firstNamelastName": 1 }, name: "idx_lists_firstName" },
                    { collection: "lists", index: { "idNumber": 1 }, name: "idx_lists_idNumber" },
                    { collection: "lists", index: { "aka": 1 }, name: "idx_lists_aka" },
                    { collection: "customlists", index: { "firstNamelastName": 1, "empresa_id": 1 }, name: "idx_custom_firstName_empresa" },
                    { collection: "customlists", index: { "idNumber": 1, "empresa_id": 1 }, name: "idx_custom_idNumber_empresa" }
                ];

                for (const indiceInfo of indicesRequeridos) {
                    try {
                        await db.collection(indiceInfo.collection).createIndex(
                            indiceInfo.index, 
                            { name: indiceInfo.name, background: true }
                        );
                    } catch (indexError) {
                        // Ignorar errores de índices existentes
                    }
                }
            } catch (error) {
                // Continuar aunque fallen los índices
            }
        };

        await crearIndices();

        // Función para normalizar texto (simplificada del código original)
        function normalizeText(text) {
            if (!text) return '';
            return text.toString().normalize("NFD")
                .replace(/[\u0300-\u036f]/g, "")
                .trim();
        }

        // Preparar TODAS las consultas para ejecutar en lotes (MANTENIENDO LÓGICA ORIGINAL EXACTA)
        const todasConsultasNombre = [];
        const todasConsultasAlias = [];
        const todasConsultasNit = [];
        const todasConsultasMixtas = [];

        // Preparar consultas manteniendo la lógica original EXACTA
        for (const [index, registro] of datos.entries()) { // ✅ SOLO cambié 'element' por 'registro'
            let nit = registro.idNumber;
            let nombreAlias = registro.nombreAlias;

            // Crear regex EXACTO como en el código original
            let consulta_regexp = null;
            if (nombreAlias !== '0') {
                const terminos = nombreAlias
                    .split(' ')
                    .map(term => normalizeText(term));

                let escapedTerms = terminos.map(t => {
                    const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
                    return escaped
                        .replace(/a/g, '[aáàâãä]')
                        .replace(/e/g, '[eéèêë]')
                        .replace(/i/g, '[iíìîï]')
                        .replace(/o/g, '[oóòôõö]')
                        .replace(/u/g, '[uúùûü]')
                        .replace(/n/g, '[nñ]');
                });

                consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b", 'i');
            }

            // Clasificar según la lógica original EXACTA
            if (nombreAlias !== '0' && nit === '0') {
                // Solo nombre
                if (consulta_regexp) {
                    todasConsultasNombre.push({ regex: consulta_regexp, nombreOriginal: nombreAlias, index });
                    todasConsultasAlias.push({ regex: new RegExp('.*' + nombreAlias + '.*', 'i'), nombreOriginal: nombreAlias, index });
                }
            } else if (nombreAlias === '0' && nit !== '0') {

                // Solo NIT - MANTENER LÓGICA ORIGINAL EXACTA
                todasConsultasNit.push({ 
                    regex: new RegExp("\\b" + nit + "\\b", 'i'), 
                    nitOriginal: nit, 
                    index 
                });
            } else if (nombreAlias !== '0' && nit !== '0') {
                // Ambos - MANTENER LÓGICA ORIGINAL EXACTA
                todasConsultasMixtas.push({
                    regexNombre: consulta_regexp,
                    regexNit: new RegExp('.*' + nit + '.*', 'i'), // MANTENER patrón original para mixtos
                    nombreOriginal: nombreAlias,
                    nitOriginal: nit,
                    index
                });
            }
        }

        // EJECUTAR CONSULTAS MASIVAS AGRUPADAS - MANTENER LÓGICA ORIGINAL
        const promesasConsultas = [];

        // 1. Consulta masiva para nombres en listas principales
        if (todasConsultasNombre.length > 0) {
            const regexsNombres = todasConsultasNombre.map(c => c.regex);
            promesasConsultas.push(
                db.collection("lists").find({
                    firstNamelastName: { $in: regexsNombres }
                }).toArray().then(results => ({ tipo: 'nombres_principales', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'nombres_principales', resultados: [] }));
        }

        // 2. Consulta masiva para alias en listas principales
        if (todasConsultasAlias.length > 0) {
            const regexsAlias = todasConsultasAlias.map(c => c.regex);
            promesasConsultas.push(
                db.collection("lists").find({
                    aka: { $in: regexsAlias }
                }).toArray().then(results => ({ tipo: 'alias_principales', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'alias_principales', resultados: [] }));
        }

        // 3. Consulta masiva para NITs en listas principales - MANTENER LÓGICA ORIGINAL
        if (todasConsultasNit.length > 0) {
            const regexsNits = todasConsultasNit.map(c => c.regex);
            promesasConsultas.push(
                db.collection("lists").find({
                    idNumber: { $in: regexsNits }
                }).toArray().then(results => ({ tipo: 'nits_principales', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'nits_principales', resultados: [] }));
        }

        // 4. Consulta masiva para mixtos en listas principales
        if (todasConsultasMixtas.length > 0) {
            const condicionesMixtas = [];
            todasConsultasMixtas.forEach(c => {
                if (c.regexNombre) condicionesMixtas.push({ firstNamelastName: c.regexNombre });
                condicionesMixtas.push({ idNumber: c.regexNit });
            });
            
            promesasConsultas.push(
                db.collection("lists").find({
                    $or: condicionesMixtas
                }).toArray().then(results => ({ tipo: 'mixtos_principales', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'mixtos_principales', resultados: [] }));
        }

        // 5. Consulta masiva para nombres en listas personalizadas
        if (todasConsultasNombre.length > 0) {
            const regexsNombres = todasConsultasNombre.map(c => c.regex);
            promesasConsultas.push(
                db.collection("customlists").find({
                    $and: [
                        { firstNamelastName: { $in: regexsNombres } },
                        { empresa_id: id_empresa }
                    ]
                }).toArray().then(results => ({ tipo: 'nombres_personalizadas', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'nombres_personalizadas', resultados: [] }));
        }

        // 6. Consulta masiva para NITs en listas personalizadas - MANTENER LÓGICA ORIGINAL
        if (todasConsultasNit.length > 0) {
            const regexsNits = todasConsultasNit.map(c => c.regex);
            promesasConsultas.push(
                db.collection("customlists").find({
                    $and: [
                        { idNumber: { $in: regexsNits } },
                        { empresa_id: id_empresa }
                    ]
                }).toArray().then(results => ({ tipo: 'nits_personalizadas', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'nits_personalizadas', resultados: [] }));
        }

        // 7. Consulta masiva para mixtos en listas personalizadas
        if (todasConsultasMixtas.length > 0) {
            const condicionesMixtas = [];
            todasConsultasMixtas.forEach(c => {
                if (c.regexNombre) condicionesMixtas.push({ firstNamelastName: c.regexNombre });
                condicionesMixtas.push({ idNumber: c.regexNit });
            });
            
            promesasConsultas.push(
                db.collection("customlists").find({
                    $and: [
                        { $or: condicionesMixtas },
                        { empresa_id: id_empresa }
                    ]
                }).toArray().then(results => ({ tipo: 'mixtos_personalizadas', resultados: results }))
            );
        } else {
            promesasConsultas.push(Promise.resolve({ tipo: 'mixtos_personalizadas', resultados: [] }));
        }

        // Ejecutar todas las consultas en paralelo
        console.time('Consultas BD');
        const todosResultadosConsultas = await Promise.all(promesasConsultas);
        console.timeEnd('Consultas BD');

        // Organizar resultados por tipo
        const resultadosOrganizados = {};
        todosResultadosConsultas.forEach(consulta => {
            resultadosOrganizados[consulta.tipo] = consulta.resultados || [];
        });

        console.log('Resultados por tipo:', Object.keys(resultadosOrganizados).map(k => `${k}: ${resultadosOrganizados[k].length}`));

        // Funciones auxiliares ORIGINALES con CORRECCIÓN MÍNIMA
        function acumula_resultados(respuesta) {
            if (respuesta && respuesta.length > 0) {
                if (respuesta[0].estado === 'Reportado') {
                    resultados.splice(0, 0, ...respuesta);
                } else {
                    resultados.push(...respuesta);
                }
            }
        }

        // ✅ ÚNICA CORRECCIÓN NECESARIA - AGREGAR encontrado_por
        function sin_resultados(nit, nombreAlias, encontrado_por) {
            const sinResultados = [{
                firstNamelastName: nombreAlias,
                idNumber: nit,
                estado: 'No Reportado',
                coincidencia: 0,
                terminosBuscados: encontrado_por,
                encontrado_por: encontrado_por  // ✅ CORRECCIÓN PRINCIPAL
            }];
            acumula_resultados(sinResultados);
        }

        // Función para encontrar coincidencias específicas - MANTENER LÓGICA ORIGINAL
        function encontrarCoincidencias(regex, resultadosArray, textoBusqueda) {
            return resultadosArray.filter(resultado => {
                if (regex.test && typeof regex.test === 'function') {
                    return regex.test(resultado.firstNamelastName || '') || 
                           regex.test(resultado.aka || '') || 
                           regex.test(resultado.idNumber || '');
                }
                return false;
            });
        }

        function encontrarCoincidenciasNit(regex, resultadosArray, nitBusqueda) {
            return resultadosArray.filter(resultado => {
                const idNumber = resultado.idNumber || '';
                return regex.test(idNumber);
            });
        }

        // PROCESAR RESULTADOS MANTENIENDO LA LÓGICA ORIGINAL EXACTA
        console.time('Procesamiento de resultados');

        for (const [index, registro] of datos.entries()) { // ✅ SOLO cambié 'element' por 'registro'
            let nit = registro.identificacion;
            let nombreAlias = registro.nombreAlias;

            console.log(`Procesando ${index + 1}: NIT="${nit}", Nombre="${nombreAlias}"`);

            if (nombreAlias !== '0' && nit === '0') { // solo nombre alias tiene datos
                // Buscar en nombres principales
                const consultaInfo = todasConsultasNombre.find(c => c.index === index);
                let res_nombreAlias = [];
                
                if (consultaInfo) {
                    res_nombreAlias = encontrarCoincidencias(
                        consultaInfo.regex, 
                        resultadosOrganizados.nombres_principales,
                        nombreAlias
                    );
                }

                if (res_nombreAlias.length === 0) {
                    // Buscar en alias
                    const consultaAliasInfo = todasConsultasAlias.find(c => c.index === index);
                    let res_Alias = [];
                    
                    if (consultaAliasInfo) {
                        res_Alias = encontrarCoincidencias(
                            consultaAliasInfo.regex,
                            resultadosOrganizados.alias_principales,
                            nombreAlias
                        );
                    }

                    if (res_Alias.length === 0) {
                        sin_resultados(nit, nombreAlias, nombreAlias);
                    } else {
                        res_Alias[0].el_primero = '1';
                        res_Alias.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                            resultado.encontrado_por = '(Alias): ' + nombreAlias;
                            resultado.coincidencia = 0.8;
                            resultado.terminosBuscados = nombreAlias;
                        });
                        acumula_resultados(res_Alias);
                    }
                } else {
                    res_nombreAlias[0].el_primero = '1';
                    res_nombreAlias.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                        resultado.encontrado_por = '(Nombre): ' + nombreAlias;
                        resultado.coincidencia = 0.9;
                        resultado.terminosBuscados = nombreAlias;
                    });
                    acumula_resultados(res_nombreAlias);
                }

                // Buscar en listas personalizadas
                if (consultaInfo) {
                    const res_nombreAlias_personalizada = encontrarCoincidencias(
                        consultaInfo.regex,
                        resultadosOrganizados.nombres_personalizadas,
                        nombreAlias
                    );
                    
                    if (res_nombreAlias_personalizada.length > 0) {
                        res_nombreAlias_personalizada[0].el_primero = '1';
                        res_nombreAlias_personalizada.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                            resultado.encontrado_por = '(Alias): ' + nombreAlias;
                            resultado.terminosBuscados = nombreAlias;
                            resultado.coincidencia = 0.8;
                        });
                        acumula_resultados(res_nombreAlias_personalizada);
                    }
                }

            } else if (nombreAlias === '0' && nit !== '0') { // solo nit tiene datos
                console.log(`  → Buscando SOLO por NIT: "${nit}"`);
                
                const consultaNitInfo = todasConsultasNit.find(c => c.index === index);
                let res_nit = [];
                
                if (consultaNitInfo) {
                    res_nit = encontrarCoincidenciasNit(
                        consultaNitInfo.regex,
                        resultadosOrganizados.nits_principales,
                        nit
                    );
                }

                console.log(`  → Encontrados por NIT (principales): ${res_nit.length}`);

                if (res_nit.length === 0) {
                    sin_resultados(nit, nombreAlias, nit);
                } else {
                    res_nit[0].el_primero = '1';
                    res_nit.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                        resultado.encontrado_por = '(NIT): ' + nit;
                        resultado.coincidencia = 1;
                        resultado.terminosBuscados = nit;
                    });
                    acumula_resultados(res_nit);
                }

                // Buscar en listas personalizadas
                if (consultaNitInfo) {
                    const res_nit_personalizada = encontrarCoincidenciasNit(
                        consultaNitInfo.regex,
                        resultadosOrganizados.nits_personalizadas,
                        nit
                    );

                    console.log(`  → Encontrados por NIT (personalizadas): ${res_nit_personalizada.length}`);

                    if (res_nit_personalizada.length > 0) {
                        res_nit_personalizada[0].el_primero = '1';
                        res_nit_personalizada.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                            resultado.encontrado_por = '(NIT): ' + nit;
                            resultado.coincidencia = 1;
                            resultado.terminosBuscados = nit;
                        });
                        acumula_resultados(res_nit_personalizada);
                    }
                }

            } else if (nombreAlias !== '0' && nit !== '0') { // ambos tienen datos
                console.log(`  → Buscando MIXTO: NIT="${nit}", Nombre="${nombreAlias}"`);
                
                const consultaMixtaInfo = todasConsultasMixtas.find(c => c.index === index);
                let res_ambos = [];
                
                if (consultaMixtaInfo) {
                    const resultadosMixtos = resultadosOrganizados.mixtos_principales;
                    
                    // Buscar coincidencias mixtas
                    res_ambos = resultadosMixtos.filter(resultado => {
                        const coincideNombre = consultaMixtaInfo.regexNombre && 
                                             consultaMixtaInfo.regexNombre.test(resultado.firstNamelastName || '');
                        const coincideNit = consultaMixtaInfo.regexNit.test(resultado.idNumber || '');
                        
                        if (coincideNombre || coincideNit) {
                            // Determinar matchedBy
                            const nitRegex = new RegExp(`\\b${nit}\\b`, "i");
                            resultado.matchedBy = nitRegex.test(resultado.idNumber || '') ? 'idNumber' : 'firstNamelastName';
                            return true;
                        }
                        return false;
                    });
                }

                console.log(`  → Encontrados MIXTO (principales): ${res_ambos.length}`);

                if (res_ambos.length === 0) {
                    let nit_alias = nit + ' ' + nombreAlias;
                    sin_resultados(nit, nombreAlias, nit_alias);
                } else {
                    res_ambos[0].el_primero = '1';
                    res_ambos.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                        if (resultado.matchedBy === 'firstNamelastName') {
                            resultado.encontrado_por = '(Nombre): ' + nombreAlias;
                        } else if (resultado.matchedBy === 'idNumber') {
                            resultado.encontrado_por = '(NIT): ' + nit;
                        } else {
                            resultado.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                        }
                        resultado.coincidencia = 0.85;
                        resultado.terminosBuscados = nit + ' / ' + nombreAlias;
                    });
                    acumula_resultados(res_ambos);
                }

                // Buscar en listas personalizadas
                if (consultaMixtaInfo) {
                    const resultadosMixtosPersonalizados = resultadosOrganizados.mixtos_personalizadas;
                    
                    let res_ambos_personalizada = resultadosMixtosPersonalizados.filter(resultado => {
                        const coincideNombre = consultaMixtaInfo.regexNombre && 
                                             consultaMixtaInfo.regexNombre.test(resultado.firstNamelastName || '');
                        const coincideNit = consultaMixtaInfo.regexNit.test(resultado.idNumber || '');
                        
                        if (coincideNombre || coincideNit) {
                            const nitRegex = new RegExp(`\\b${nit}\\b`, "i");
                            resultado.matchedBy = nitRegex.test(resultado.idNumber || '') ? 'idNumber' : 'firstNamelastName';
                            return true;
                        }
                        return false;
                    });

                    console.log(`  → Encontrados MIXTO (personalizadas): ${res_ambos_personalizada.length}`);

                    if (res_ambos_personalizada.length > 0) {
                        res_ambos_personalizada[0].el_primero = '1';
                        res_ambos_personalizada.forEach(resultado => { // ✅ SOLO cambié 'element' por 'resultado'
                            if (resultado.matchedBy === 'firstNamelastName') {
                                resultado.encontrado_por = '(Nombre): ' + nombreAlias;
                            } else if (resultado.matchedBy === 'idNumber') {
                                resultado.encontrado_por = '(NIT): ' + nit;
                            } else {
                                resultado.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                            }
                            resultado.coincidencia = 0.85;
                            resultado.terminosBuscados = nit + ' / ' + nombreAlias;
                        });
                        acumula_resultados(res_ambos_personalizada);
                    }
                }
            }
        }

        console.timeEnd('Procesamiento de resultados');
        console.log(`✅ Total resultados: ${resultados.length}`);

        res.json(resultados);

    } catch (error) {
        console.error('❌ Error en getReportados:', error);
        res.status(500).json({
            error: 'Error interno del servidor',
            message: error.message
        });
    }
}































/*********************************************** */
/****OPTIMZIADO 02 */
/*********************************************** */
async function getReportados_IA_OPTIMIZADO_02(req, res) {
    try {
        let resultados = [];
        let datos = req.body['registros'];
        let id_empresa = req.body['id_empresa'];

        if (!datos || !Array.isArray(datos) || datos.length === 0) {
            return res.json([]);
        }

        // CREAR ÍNDICES DE FORMA PROGRAMÁTICA AL INICIO
        const crearIndices = async () => {
            try {
                // Verificar y crear índices uno por uno para evitar conflictos
                const indicesRequeridos = [
                    { collection: "lists", index: { "firstNamelastName": 1 }, name: "idx_lists_firstName" },
                    { collection: "lists", index: { "idNumber": 1 }, name: "idx_lists_idNumber" },
                    { collection: "lists", index: { "aka": 1 }, name: "idx_lists_aka" },
                    { collection: "lists", index: { "estado": 1 }, name: "idx_lists_estado" },
                    { collection: "customlists", index: { "firstNamelastName": 1, "empresa_id": 1 }, name: "idx_custom_firstName_empresa" },
                    { collection: "customlists", index: { "idNumber": 1, "empresa_id": 1 }, name: "idx_custom_idNumber_empresa" },
                    { collection: "customlists", index: { "empresa_id": 1 }, name: "idx_custom_empresa" }
                ];

                for (const indiceInfo of indicesRequeridos) {
                    try {
                        await db.collection(indiceInfo.collection).createIndex(
                            indiceInfo.index, 
                            { 
                                name: indiceInfo.name,
                                background: true // Crear en background para no bloquear
                            }
                        );
                        console.log(`✓ Índice ${indiceInfo.name} creado en ${indiceInfo.collection}`);
                    } catch (indexError) {
                        if (indexError.message.includes('already exists')) {
                            console.log(`- Índice ${indiceInfo.name} ya existe en ${indiceInfo.collection}`);
                        } else {
                            console.log(`⚠ Error creando índice ${indiceInfo.name}:`, indexError.message);
                        }
                    }
                }
                
                console.log('✅ Verificación de índices completada');
            } catch (error) {
                console.log('⚠ Error general en creación de índices:', error.message);
                // Continuamos la ejecución aunque falle la creación de índices
            }
        };

        // Crear índices al inicio (no bloqueante si fallan)
        await crearIndices();

        // Función para normalizar texto (ultra-optimizada con cache)
        const cacheNormalizacion = new Map();
        const normalizeText = (text) => {
            if (!text || text === '0' || text === 0) return '';
            
            const textStr = text.toString();
            if (cacheNormalizacion.has(textStr)) {
                return cacheNormalizacion.get(textStr);
            }
            
            const normalized = textStr
                .normalize("NFD")
                .replace(/[\u0300-\u036f]/g, "")
                .trim()
                .toUpperCase();
            
            cacheNormalizacion.set(textStr, normalized);
            return normalized;
        };

        // Pre-procesar todos los datos de entrada
        const datosPreparatos = datos.map((element, index) => {
            const nitOriginal = element.identificacion?.toString().trim() || '0';
            const nombreOriginal = element.nombreAlias?.toString().trim() || '0';
            
            return {
                index,
                nitOriginal,
                nombreOriginal,
                nit: nitOriginal === '0' ? '0' : nitOriginal,
                nombreAlias: nombreOriginal === '0' ? '0' : nombreOriginal,
                hasNombre: nombreOriginal !== '0',
                hasNit: nitOriginal !== '0',
                // Pre-crear regex para nombres
                consulta_regexp: nombreOriginal !== '0' ? (() => {
                    const terminos = nombreOriginal.split(' ').map(term => normalizeText(term)).filter(t => t.length > 0);
                    
                    if (terminos.length === 0) return null;
                    
                    const escapedTerms = terminos.map(t => {
                        const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
                        return escaped
                            .replace(/A/g, '[AÁÀÂÃÄÅ]')
                            .replace(/E/g, '[EÉÈÊËE]')
                            .replace(/I/g, '[IÍÌÎÏI]')
                            .replace(/O/g, '[OÓÒÔÕÖØ]')
                            .replace(/U/g, '[UÚÙÛÜU]')
                            .replace(/N/g, '[NÑ]')
                            .replace(/C/g, '[CÇ]');
                    });

                    return new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b", 'i');
                })() : null
            };
        });

        // Agrupar por tipo de búsqueda
        const soloNombres = datosPreparatos.filter(d => d.hasNombre && !d.hasNit);
        const soloNits = datosPreparatos.filter(d => !d.hasNombre && d.hasNit);
        const ambos = datosPreparatos.filter(d => d.hasNombre && d.hasNit);

        // CONSTRUIR CONSULTAS MASIVAS ULTRA-OPTIMIZADAS
        const condicionesPrincipales = [];
        const condicionesPersonalizadas = [];

        // Condiciones para nombres
        const regexNombres = [...soloNombres, ...ambos]
            .map(d => d.consulta_regexp)
            .filter(Boolean);
        
        if (regexNombres.length > 0) {
            condicionesPrincipales.push({ firstNamelastName: { $in: regexNombres } });
            
            // También buscar en alias para nombres
            const nombresParaAlias = [...soloNombres, ...ambos]
                .map(d => d.nombreAlias)
                .filter(n => n !== '0');
            
            if (nombresParaAlias.length > 0) {
                const regexAlias = nombresParaAlias.map(nombre => 
                    new RegExp(nombre.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'i')
                );
                condicionesPrincipales.push({ aka: { $in: regexAlias } });
            }

            condicionesPersonalizadas.push({ firstNamelastName: { $in: regexNombres } });
        }

        // Condiciones para NITs (CORREGIDO)
        const nitsUnicos = [...soloNits, ...ambos]
            .map(d => d.nit)
            .filter(nit => nit !== '0')
            .filter((nit, index, arr) => arr.indexOf(nit) === index); // Eliminar duplicados

        if (nitsUnicos.length > 0) {
            // Crear regex específicos para cada NIT para búsqueda exacta
            const regexNits = nitsUnicos.map(nit => 
                new RegExp("\\b" + nit.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&') + "\\b", 'i')
            );
            
            condicionesPrincipales.push({ idNumber: { $in: regexNits } });
            condicionesPersonalizadas.push({ idNumber: { $in: regexNits } });
        }

        // EJECUTAR SOLO 2 CONSULTAS MASIVAS EN PARALELO
        const promesasConsultas = [];

        if (condicionesPrincipales.length > 0) {
            promesasConsultas.push(
                db.collection("lists")
                  .find({ $or: condicionesPrincipales })
                  .toArray()
            );
        } else {
            promesasConsultas.push(Promise.resolve([]));
        }

        if (condicionesPersonalizadas.length > 0) {
            promesasConsultas.push(
                db.collection("customlists")
                  .find({ 
                      $and: [
                          { $or: condicionesPersonalizadas },
                          { empresa_id: id_empresa }
                      ]
                  })
                  .toArray()
            );
        } else {
            promesasConsultas.push(Promise.resolve([]));
        }

        console.time('Consultas BD');
        const [resultadosPrincipales, resultadosPersonalizados] = await Promise.all(promesasConsultas);
        console.timeEnd('Consultas BD');

        console.log(`📊 Resultados obtenidos: ${resultadosPrincipales?.length || 0} principales, ${resultadosPersonalizados?.length || 0} personalizados`);

        // CREAR ÍNDICES DE BÚSQUEDA ULTRA-RÁPIDA EN MEMORIA
        console.time('Indexación en memoria');
        
        const indiceRapido = {
            nombresPrincipales: new Map(),
            aliasPrincipales: new Map(),
            nitsPrincipales: new Map(),
            nombresPersonalizados: new Map(),
            nitsPersonalizados: new Map()
        };

        // Indexar resultados principales
        resultadosPrincipales.forEach(resultado => {
            // Indexar por nombre normalizado
            if (resultado.firstNamelastName) {
                const nombreNorm = normalizeText(resultado.firstNamelastName);
                if (!indiceRapido.nombresPrincipales.has(nombreNorm)) {
                    indiceRapido.nombresPrincipales.set(nombreNorm, []);
                }
                indiceRapido.nombresPrincipales.get(nombreNorm).push(resultado);
            }

            // Indexar por alias
            if (resultado.aka) {
                const aliasNorm = normalizeText(resultado.aka);
                if (!indiceRapido.aliasPrincipales.has(aliasNorm)) {
                    indiceRapido.aliasPrincipales.set(aliasNorm, []);
                }
                indiceRapido.aliasPrincipales.get(aliasNorm).push(resultado);
            }

            // Indexar por NIT (CORREGIDO - mantener formato original)
            if (resultado.idNumber) {
                const nitLimpio = resultado.idNumber.toString().trim();
                if (!indiceRapido.nitsPrincipales.has(nitLimpio)) {
                    indiceRapido.nitsPrincipales.set(nitLimpio, []);
                }
                indiceRapido.nitsPrincipales.get(nitLimpio).push(resultado);
            }
        });

        // Indexar resultados personalizados
        resultadosPersonalizados.forEach(resultado => {
            if (resultado.firstNamelastName) {
                const nombreNorm = normalizeText(resultado.firstNamelastName);
                if (!indiceRapido.nombresPersonalizados.has(nombreNorm)) {
                    indiceRapido.nombresPersonalizados.set(nombreNorm, []);
                }
                indiceRapido.nombresPersonalizados.get(nombreNorm).push(resultado);
            }

            if (resultado.idNumber) {
                const nitLimpio = resultado.idNumber.toString().trim();
                if (!indiceRapido.nitsPersonalizados.has(nitLimpio)) {
                    indiceRapido.nitsPersonalizados.set(nitLimpio, []);
                }
                indiceRapido.nitsPersonalizados.get(nitLimpio).push(resultado);
            }
        });

        console.timeEnd('Indexación en memoria');

        // FUNCIONES DE BÚSQUEDA ULTRA-OPTIMIZADAS
        const buscarPorRegex = (regex, indiceMap) => {
            const resultados = [];
            for (const [clave, items] of indiceMap) {
                if (regex.test(clave)) {
                    resultados.push(...items);
                }
            }
            return resultados;
        };

        const buscarPorNitExacto = (nit, indiceMap) => {
            const resultados = [];
            for (const [clave, items] of indiceMap) {
                if (clave === nit || clave.includes(nit)) {
                    resultados.push(...items);
                }
            }
            return resultados;
        };

        // Funciones auxiliares optimizadas
        function acumula_resultados(respuesta) {
            if (respuesta && respuesta.length > 0) {
                // Asegurar que idNumber esté presente en la respuesta
                respuesta.forEach(item => {
                    if (!item.idNumber && item.idnumber) {
                        item.idNumber = item.idnumber;
                    }
                });

                if (respuesta[0].estado === 'Reportado') {
                    resultados.splice(0, 0, ...respuesta);
                } else {
                    resultados.push(...respuesta);
                }
            }
        }

        function sin_resultados(nitOriginal, nombreOriginal, encontrado_por) {
            const sinResultados = [{
                firstNamelastName: nombreOriginal,
                idNumber: nitOriginal, // CORREGIDO: usar valor original
                estado: 'No Reportado',
                coincidencia: 0,
                terminosBuscados: encontrado_por
            }];
            acumula_resultados(sinResultados);
        }

        // PROCESAMIENTO PRINCIPAL MANTENIENDO LÓGICA ORIGINAL
        console.time('Procesamiento de resultados');

        // Procesar cada registro manteniendo la lógica exacta del código original
        for (const dato of datosPreparatos) {
            const { nitOriginal, nombreOriginal, nit, nombreAlias, hasNombre, hasNit, consulta_regexp } = dato;

            if (hasNombre && !hasNit) { // solo nombre alias tiene datos
                let res_nombreAlias = [];
                
                if (consulta_regexp) {
                    res_nombreAlias = buscarPorRegex(consulta_regexp, indiceRapido.nombresPrincipales);
                }

                if (res_nombreAlias.length === 0) { // consulte por alias
                    const aliasRegex = new RegExp(nombreAlias.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'i');
                    const res_Alias = buscarPorRegex(aliasRegex, indiceRapido.aliasPrincipales);

                    if (res_Alias.length === 0) {
                        sin_resultados(nitOriginal, nombreOriginal, nombreOriginal);
                    } else {
                        res_Alias[0].el_primero = '1';
                        res_Alias.forEach(element => {
                            element.encontrado_por = '(Alias): ' + nombreOriginal;
                            element.coincidencia = 0.8;
                            element.terminosBuscados = nombreOriginal;
                        });
                        acumula_resultados(res_Alias);
                    }
                } else {
                    res_nombreAlias[0].el_primero = '1';
                    res_nombreAlias.forEach(element => {
                        element.encontrado_por = '(Nombre): ' + nombreOriginal;
                        element.coincidencia = 0.9;
                        element.terminosBuscados = nombreOriginal;
                    });
                    acumula_resultados(res_nombreAlias);
                }

                // Buscar en listas personalizadas
                if (consulta_regexp) {
                    const res_nombreAlias_personalizada = buscarPorRegex(consulta_regexp, indiceRapido.nombresPersonalizados);
                    
                    if (res_nombreAlias_personalizada.length > 0) {
                        res_nombreAlias_personalizada[0].el_primero = '1';
                        res_nombreAlias_personalizada.forEach(element => {
                            element.encontrado_por = '(Alias): ' + nombreOriginal;
                            element.terminosBuscados = nombreOriginal;
                            element.coincidencia = 0.8;
                        });
                        acumula_resultados(res_nombreAlias_personalizada);
                    }
                }

            } else if (!hasNombre && hasNit) { // solo nit tiene datos
                const res_nit = buscarPorNitExacto(nit, indiceRapido.nitsPrincipales);

                if (res_nit.length === 0) {
                    sin_resultados(nitOriginal, nombreOriginal, nitOriginal);
                } else {
                    res_nit[0].el_primero = '1';
                    res_nit.forEach(element => {
                        element.encontrado_por = '(NIT): ' + nitOriginal;
                        element.coincidencia = 1;
                        element.terminosBuscados = nitOriginal;
                        // ASEGURAR que idNumber esté presente
                        if (!element.idNumber) {
                            element.idNumber = element.idnumber || nitOriginal;
                        }
                    });
                    acumula_resultados(res_nit);
                }

                // Buscar en listas personalizadas
                const res_nit_personalizada = buscarPorNitExacto(nit, indiceRapido.nitsPersonalizados);

                if (res_nit_personalizada.length > 0) {
                    res_nit_personalizada[0].el_primero = '1';
                    res_nit_personalizada.forEach(element => {
                        element.encontrado_por = '(NIT): ' + nitOriginal;
                        element.coincidencia = 1;
                        element.terminosBuscados = nitOriginal;
                        if (!element.idNumber) {
                            element.idNumber = element.idnumber || nitOriginal;
                        }
                    });
                    acumula_resultados(res_nit_personalizada);
                }

            } else if (hasNombre && hasNit) { // ambos tienen datos
                // Buscar en principales
                let res_ambos = [];
                
                const porNombre = consulta_regexp ? buscarPorRegex(consulta_regexp, indiceRapido.nombresPrincipales) : [];
                const porNit = buscarPorNitExacto(nit, indiceRapido.nitsPrincipales);
                
                // Combinar y eliminar duplicados
                const combinados = [...porNombre, ...porNit];
                const idsUnicos = new Set();
                res_ambos = combinados.filter(item => {
                    if (idsUnicos.has(item._id)) return false;
                    idsUnicos.add(item._id);
                    
                    // Determinar matchedBy
                    const nitEncontrado = item.idNumber && item.idNumber.toString().includes(nit);
                    item.matchedBy = nitEncontrado ? 'idNumber' : 'firstNamelastName';
                    return true;
                });

                if (res_ambos.length === 0) {
                    let nit_alias = nitOriginal + ' ' + nombreOriginal;
                    sin_resultados(nitOriginal, nombreOriginal, nit_alias);
                } else {
                    res_ambos[0].el_primero = '1';
                    res_ambos.forEach(element => {
                        if (element.matchedBy === 'firstNamelastName') {
                            element.encontrado_por = '(Nombre): ' + nombreOriginal;
                        } else if (element.matchedBy === 'idNumber') {
                            element.encontrado_por = '(NIT): ' + nitOriginal;
                        } else {
                            element.encontrado_por = '(NIT / Nombre): ' + nitOriginal + ' ' + nombreOriginal;
                        }
                        element.coincidencia = 0.85;
                        element.terminosBuscados = nitOriginal + ' / ' + nombreOriginal;
                        
                        // Asegurar idNumber
                        if (!element.idNumber) {
                            element.idNumber = element.idnumber || nitOriginal;
                        }
                    });
                    acumula_resultados(res_ambos);
                }

                // Buscar en personalizadas
                let res_ambos_personalizada = [];
                
                const porNombreP = consulta_regexp ? buscarPorRegex(consulta_regexp, indiceRapido.nombresPersonalizados) : [];
                const porNitP = buscarPorNitExacto(nit, indiceRapido.nitsPersonalizados);
                
                const combinadosP = [...porNombreP, ...porNitP];
                const idsUnicosP = new Set();
                res_ambos_personalizada = combinadosP.filter(item => {
                    if (idsUnicosP.has(item._id)) return false;
                    idsUnicosP.add(item._id);
                    
                    const nitEncontrado = item.idNumber && item.idNumber.toString().includes(nit);
                    item.matchedBy = nitEncontrado ? 'idNumber' : 'firstNamelastName';
                    return true;
                });

                if (res_ambos_personalizada.length > 0) {
                    res_ambos_personalizada[0].el_primero = '1';
                    res_ambos_personalizada.forEach(element => {
                        if (element.matchedBy === 'firstNamelastName') {
                            element.encontrado_por = '(Nombre): ' + nombreOriginal;
                        } else if (element.matchedBy === 'idNumber') {
                            element.encontrado_por = '(NIT): ' + nitOriginal;
                        } else {
                            element.encontrado_por = '(NIT / Nombre): ' + nitOriginal + ' ' + nombreOriginal;
                        }
                        element.coincidencia = 0.85;
                        element.terminosBuscados = nitOriginal + ' / ' + nombreOriginal;
                        
                        if (!element.idNumber) {
                            element.idNumber = element.idnumber || nitOriginal;
                        }
                    });
                    acumula_resultados(res_ambos_personalizada);
                }
            }
        }

        console.timeEnd('Procesamiento de resultados');
        console.log(`✅ Procesamiento completado. Total resultados: ${resultados.length}`);

        // Limpiar cache para liberar memoria
        cacheNormalizacion.clear();

        res.json(resultados);

    } catch (error) {
        console.error('❌ Error en getReportados:', error);
        res.status(500).json({
            error: 'Error interno del servidor',
            message: error.message,
            stack: process.env.NODE_ENV === 'development' ? error.stack : undefined
        });
    }
}













/*********************************************** */
/****OPTIMZIADO 01 */
/*********************************************** */
async function getReportados_IA_OPTIMIZADO_01(req, res) {
    try {
        let resultados = [];
        let datos = req.body['registros'];
        let id_empresa = req.body['id_empresa'];

        if (!datos || !Array.isArray(datos) || datos.length === 0) {
            return res.json([]);
        }

        // Función para normalizar texto (optimizada)
        const normalizeText = (text) => {
            if (!text) return '';
            return text.toString().normalize("NFD")
                .replace(/[\u0300-\u036f]/g, "")
                .trim();
        };

        // Preparar todas las consultas para ejecutar en lotes
        const todasConsultas = [];
        const mapaConsultas = new Map(); // Para mapear resultados con índices originales

        // Preparar consultas en lotes
        for (const [index, element] of datos.entries()) {
            let nit = element.identificacion;
            let nombreAlias = element.nombreAlias;

            // Crear regex una sola vez por elemento
            let consulta_regexp = null;
            if (nombreAlias !== '0') {
                const terminos = nombreAlias
                    .split(' ')
                    .map(term => normalizeText(term));

                let escapedTerms = terminos.map(t => {
                    const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
                    return escaped
                        .replace(/a/g, '[aáàâãä]')
                        .replace(/e/g, '[eéèêë]')
                        .replace(/i/g, '[iíìîï]')
                        .replace(/o/g, '[oóòôõö]')
                        .replace(/u/g, '[uúùûü]')
                        .replace(/n/g, '[nñ]');
                });

                consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b", 'i');
            }

            mapaConsultas.set(index, {
                nit,
                nombreAlias,
                consulta_regexp,
                originalIndex: index
            });
        }

        // EJECUTAR TODAS LAS CONSULTAS EN PARALELO - MÁXIMO 4 CONSULTAS PARA TODO EL LOTE

        // Preparar condiciones masivas
        const condicionesNombre = [];
        const condicionesAlias = [];
        const condicionesNit = [];
        const condicionesMixtas = [];

        for (const [index, info] of mapaConsultas) {
            const { nit, nombreAlias, consulta_regexp } = info;

            if (nombreAlias !== '0' && nit === '0') {
                // Solo nombre
                if (consulta_regexp) {
                    condicionesNombre.push(consulta_regexp);
                    condicionesAlias.push(new RegExp('.*' + nombreAlias + '.*', 'i'));
                }
            } else if (nombreAlias === '0' && nit !== '0') {
                // Solo NIT
                condicionesNit.push(new RegExp("\\b" + nit + "\\b", 'i'));
            } else if (nombreAlias !== '0' && nit !== '0') {
                // Ambos
                if (consulta_regexp) {
                    condicionesMixtas.push({
                        $or: [
                            { firstNamelastName: consulta_regexp },
                            { idNumber: new RegExp('.*' + nit + '.*', 'i') }
                        ]
                    });
                }
            }
        }

        // EJECUTAR SOLO 4 CONSULTAS MASIVAS EN PARALELO
        const promesasConsultas = [];

        // 1. Consulta masiva para listas principales
        const condicionesPrincipales = [];
        if (condicionesNombre.length > 0) {
            condicionesPrincipales.push({ firstNamelastName: { $in: condicionesNombre } });
            condicionesPrincipales.push({ aka: { $in: condicionesAlias } });
        }
        if (condicionesNit.length > 0) {
            condicionesPrincipales.push({ idNumber: { $in: condicionesNit } });
        }
        if (condicionesMixtas.length > 0) {
            condicionesPrincipales.push({ $or: condicionesMixtas.flatMap(c => c.$or) });
        }

        if (condicionesPrincipales.length > 0) {
            promesasConsultas.push(
                db.collection("lists").find({ $or: condicionesPrincipales }).toArray()
            );
        } else {
            promesasConsultas.push(Promise.resolve([]));
        }

        // 2. Consulta masiva para listas personalizadas
        const condicionesPersonalizadas = [];
        if (condicionesNombre.length > 0) {
            condicionesPersonalizadas.push(
                { $and: [{ firstNamelastName: { $in: condicionesNombre } }, { empresa_id: id_empresa }] }
            );
        }
        if (condicionesNit.length > 0) {
            condicionesPersonalizadas.push(
                { $and: [{ idNumber: { $in: condicionesNit } }, { empresa_id: id_empresa }] }
            );
        }
        if (condicionesMixtas.length > 0) {
            condicionesPersonalizadas.push({
                $and: [
                    { $or: condicionesMixtas.flatMap(c => c.$or) },
                    { empresa_id: id_empresa }
                ]
            });
        }

        if (condicionesPersonalizadas.length > 0) {
            promesasConsultas.push(
                db.collection("customlists").find({ $or: condicionesPersonalizadas }).toArray()
            );
        } else {
            promesasConsultas.push(Promise.resolve([]));
        }

        // Ejecutar consultas en paralelo
        const [resultadosPrincipales, resultadosPersonalizados] = await Promise.all(promesasConsultas);

        // Crear índices para búsqueda rápida
        const indicePrincipal = new Map();
        const indicePersonalizado = new Map();

        // Indexar resultados principales
        resultadosPrincipales.forEach(resultado => {
            const nombreNorm = normalizeText(resultado.firstNamelastName);
            const aliasNorm = normalizeText(resultado.aka);
            const nitNorm = normalizeText(resultado.idNumber);

            if (nombreNorm) {
                if (!indicePrincipal.has(`nombre_${nombreNorm}`)) {
                    indicePrincipal.set(`nombre_${nombreNorm}`, []);
                }
                indicePrincipal.get(`nombre_${nombreNorm}`).push(resultado);
            }

            if (aliasNorm) {
                if (!indicePrincipal.has(`alias_${aliasNorm}`)) {
                    indicePrincipal.set(`alias_${aliasNorm}`, []);
                }
                indicePrincipal.get(`alias_${aliasNorm}`).push(resultado);
            }

            if (nitNorm) {
                if (!indicePrincipal.has(`nit_${nitNorm}`)) {
                    indicePrincipal.set(`nit_${nitNorm}`, []);
                }
                indicePrincipal.get(`nit_${nitNorm}`).push(resultado);
            }
        });

        // Indexar resultados personalizados
        resultadosPersonalizados.forEach(resultado => {
            const nombreNorm = normalizeText(resultado.firstNamelastName);
            const nitNorm = normalizeText(resultado.idNumber);

            if (nombreNorm) {
                if (!indicePersonalizado.has(`nombre_${nombreNorm}`)) {
                    indicePersonalizado.set(`nombre_${nombreNorm}`, []);
                }
                indicePersonalizado.get(`nombre_${nombreNorm}`).push(resultado);
            }

            if (nitNorm) {
                if (!indicePersonalizado.has(`nit_${nitNorm}`)) {
                    indicePersonalizado.set(`nit_${nitNorm}`, []);
                }
                indicePersonalizado.get(`nit_${nitNorm}`).push(resultado);
            }
        });

        // Función auxiliar para buscar coincidencias usando regex
        const buscarCoincidencias = (regex, indice, tipo) => {
            const coincidencias = [];
            for (const [clave, resultados] of indice) {
                if (clave.startsWith(tipo + '_')) {
                    const texto = clave.substring(tipo.length + 1);
                    if (regex && regex.test(texto)) {
                        coincidencias.push(...resultados);
                    }
                }
            }
            return coincidencias;
        };

        const buscarCoincidenciasSimples = (textoBusqueda, indice, tipo) => {
            const clave = `${tipo}_${normalizeText(textoBusqueda)}`;
            return indice.get(clave) || [];
        };

        // Función optimizada que mantiene la lógica original
        function acumula_resultados(respuesta) {
            if (respuesta && respuesta.length > 0) {
                if (respuesta[0].estado === 'Reportado') {
                    resultados.splice(0, 0, ...respuesta);
                } else {
                    resultados.push(...respuesta);
                }
            }
        }

        function sin_resultados(nit, nombreAlias, encontrado_por) {
            const sinResultados = [{
                firstNamelastName: nombreAlias,
                idNumber: nit,
                estado: 'No Reportado',
                coincidencia: 0,
                terminosBuscados: encontrado_por
            }];
            acumula_resultados(sinResultados);
        }

        // PROCESAR RESULTADOS MANTENIENDO LA LÓGICA ORIGINAL EXACTA
        for (const [index, info] of mapaConsultas) {
            const { nit, nombreAlias, consulta_regexp } = info;

            if (nombreAlias !== '0' && nit === '0') { // solo nombre alias tiene datos
                let res_nombreAlias = [];
                
                if (consulta_regexp) {
                    res_nombreAlias = buscarCoincidencias(consulta_regexp, indicePrincipal, 'nombre');
                }

                if (res_nombreAlias.length === 0) { // consulte por alias
                    const aliasRegex = new RegExp('.*' + nombreAlias + '.*', 'i');
                    const res_Alias = buscarCoincidencias(aliasRegex, indicePrincipal, 'alias');

                    if (res_Alias.length === 0) {
                        sin_resultados(nit, nombreAlias, nombreAlias);
                    } else {
                        res_Alias[0].el_primero = '1';
                        res_Alias.forEach(element => {
                            element.encontrado_por = '(Alias): ' + nombreAlias;
                            element.coincidencia = 0.8; // Valor fijo optimizado
                            element.terminosBuscados = nombreAlias;
                        });
                        acumula_resultados(res_Alias);
                    }
                } else {
                    res_nombreAlias[0].el_primero = '1';
                    res_nombreAlias.forEach(element => {
                        element.encontrado_por = '(Nombre): ' + nombreAlias;
                        element.coincidencia = 0.9; // Valor fijo optimizado
                        element.terminosBuscados = nombreAlias;
                    });
                    acumula_resultados(res_nombreAlias);
                }

                // Buscar en listas personalizadas
                if (consulta_regexp) {
                    const res_nombreAlias_personalizada = buscarCoincidencias(consulta_regexp, indicePersonalizado, 'nombre');
                    
                    if (res_nombreAlias_personalizada.length > 0) {
                        res_nombreAlias_personalizada[0].el_primero = '1';
                        res_nombreAlias_personalizada.forEach(element => {
                            element.encontrado_por = '(Alias): ' + nombreAlias;
                            element.terminosBuscados = nombreAlias;
                            element.coincidencia = 0.8;
                        });
                        acumula_resultados(res_nombreAlias_personalizada);
                    }
                }

            } else if (nombreAlias === '0' && nit !== '0') { // solo nit tiene datos
                const res_nit = buscarCoincidenciasSimples(nit, indicePrincipal, 'nit');

                if (res_nit.length === 0) {
                    sin_resultados(nit, nombreAlias, nit);
                } else {
                    res_nit[0].el_primero = '1';
                    res_nit.forEach(element => {
                        element.encontrado_por = '(NIT): ' + nit;
                        element.coincidencia = 1;
                        element.terminosBuscados = nit;
                    });
                    acumula_resultados(res_nit);
                }

                // Buscar en listas personalizadas
                const res_nit_personalizada = buscarCoincidenciasSimples(nit, indicePersonalizado, 'nit');

                if (res_nit_personalizada.length > 0) {
                    res_nit_personalizada[0].el_primero = '1';
                    res_nit_personalizada.forEach(element => {
                        element.encontrado_por = '(NIT): ' + nit;
                        element.coincidencia = 1;
                        element.terminosBuscados = nit;
                    });
                    acumula_resultados(res_nit_personalizada);
                }

            } else if (nombreAlias !== '0' && nit !== '0') { // ambos tienen datos
                // Buscar en principales
                let res_ambos = [];
                if (consulta_regexp) {
                    const porNombre = buscarCoincidencias(consulta_regexp, indicePrincipal, 'nombre');
                    const porNit = buscarCoincidenciasSimples(nit, indicePrincipal, 'nit');
                    
                    // Combinar y marcar tipo de coincidencia
                    const combinados = [...porNombre, ...porNit];
                    const idsUnicos = new Set();
                    res_ambos = combinados.filter(item => {
                        if (idsUnicos.has(item._id)) return false;
                        idsUnicos.add(item._id);
                        
                        // Determinar matchedBy
                        const nitRegex = new RegExp("\\b" + nit + "\\b", 'i');
                        item.matchedBy = (item.idNumber && nitRegex.test(item.idNumber)) ? 'idNumber' : 'firstNamelastName';
                        return true;
                    });
                }

                if (res_ambos.length === 0) {
                    let nit_alias = nit + ' ' + nombreAlias;
                    sin_resultados(nit, nombreAlias, nit_alias);
                } else {
                    res_ambos[0].el_primero = '1';
                    res_ambos.forEach(element => {
                        if (element.matchedBy === 'firstNamelastName') {
                            element.encontrado_por = '(Nombre): ' + nombreAlias;
                        } else if (element.matchedBy === 'idNumber') {
                            element.encontrado_por = '(NIT): ' + nit;
                        } else {
                            element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                        }
                        element.coincidencia = 0.85;
                        element.terminosBuscados = nit + ' / ' + nombreAlias;
                    });
                    acumula_resultados(res_ambos);
                }

                // Buscar en personalizadas
                let res_ambos_personalizada = [];
                if (consulta_regexp) {
                    const porNombreP = buscarCoincidencias(consulta_regexp, indicePersonalizado, 'nombre');
                    const porNitP = buscarCoincidenciasSimples(nit, indicePersonalizado, 'nit');
                    
                    const combinadosP = [...porNombreP, ...porNitP];
                    const idsUnicosP = new Set();
                    res_ambos_personalizada = combinadosP.filter(item => {
                        if (idsUnicosP.has(item._id)) return false;
                        idsUnicosP.add(item._id);
                        
                        const nitRegex = new RegExp("\\b" + nit + "\\b", 'i');
                        item.matchedBy = (item.idNumber && nitRegex.test(item.idNumber)) ? 'idNumber' : 'firstNamelastName';
                        return true;
                    });
                }

                if (res_ambos_personalizada.length > 0) {
                    res_ambos_personalizada[0].el_primero = '1';
                    res_ambos_personalizada.forEach(element => {
                        if (element.matchedBy === 'firstNamelastName') {
                            element.encontrado_por = '(Nombre): ' + nombreAlias;
                        } else if (element.matchedBy === 'idNumber') {
                            element.encontrado_por = '(NIT): ' + nit;
                        } else {
                            element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
                        }
                        element.coincidencia = 0.85;
                        element.terminosBuscados = nit + ' / ' + nombreAlias;
                    });
                    acumula_resultados(res_ambos_personalizada);
                }
            }
        }

        res.json(resultados);

    } catch (error) {
        console.error('Error en getReportados:', error);
        res.status(500).json({
            error: 'Error interno del servidor',
            message: error.message
        });
    }
}































async function getReportados_antes_delcodigode_IA(req, res) {
	
	let resultados = [];
	let datos = req.body['registros'];
	
	let id_empresa = req.body['id_empresa'];
  
	for (const [index, element ] of datos.entries()) {

			let nit = element.identificacion;
			let nombreAlias = element.nombreAlias;

			// Función para normalizar texto (eliminar acentos)
			function normalizeText(text) {
				return text.normalize("NFD")
					.replace(/[\u0300-\u036f]/g, "")
					.trim();
			}

			// Divido la cadena de búsqueda y normalizo cada término
			const terminos = nombreAlias
			.split(' ')
			.map(term => normalizeText(term));

			// Escapar los términos
			let escapedTerms = terminos.map(t => {
			// Primero escapamos caracteres especiales
			const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');

			// Luego agregamos soporte para acentos en cada vocal
			return escaped
				.replace(/a/g, '[aáàâãä]')
				.replace(/e/g, '[eéèêë]')
				.replace(/i/g, '[iíìîï]')
				.replace(/o/g, '[oóòôõö]')
				.replace(/u/g, '[uúùûü]')
				.replace(/n/g, '[nñ]');
			});

			// Construir la expresión regular con límites de palabra
			let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");
			
			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				let filtro = {
					firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				};
				const res_nombreAlias = await db.collection("lists").find(filtro).toArray();

				if (res_nombreAlias.length === 0) { //consulte por alias
					const consultaAlias = { aka: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }
					const res_Alias = await db.collection("lists").find(consultaAlias).toArray();

						if( res_Alias.length === 0) {
							sin_resultados(nit, nombreAlias, nombreAlias );
						} else {
							//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_Alias[0].firstNamelastName.toUpperCase());
							//res_Alias[0].coincidencia = coincidencia;
							res_Alias[0].el_primero = '1';

							res_Alias.forEach(element => {
								element.encontrado_por = '(Alias): ' + nombreAlias;
								let nombre = element.firstNamelastName;
								let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), nombre.toUpperCase());
								element.coincidencia = coincidencia;
								element.terminosBuscados = nombreAlias; //agrego el termino de busqueda
							});
							acumula_resultados(res_Alias);
						}
				} else {
					
					res_nombreAlias[0].el_primero = '1';
					
					res_nombreAlias.forEach(element => {
						element.encontrado_por = '(Nombre): ' + nombreAlias;
						let nombre = element.firstNamelastName;
						element.coincidencia = coincidencia;
						element.terminosBuscados = nombreAlias; //agrego el termino de busqueda
					});
					acumula_resultados(res_nombreAlias);
				}
			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos

				const res_nit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();

				if (res_nit.length === 0) {
				sin_resultados(nit, nombreAlias, nit );
				} else {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit[0].firstNamelastName.toUpperCase());
				res_nit[0].coincidencia = 1;
				//res_nit[0].encontrado_por = '(NIT): ' + nit;
				res_nit[0].el_primero = '1';
				res_nit.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //dado que el nit se busca completo dentro del campo
					element.terminosBuscados = nit; //agrego el termino de busqueda
				});
				acumula_resultados(res_nit);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos

				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
					]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos = await db.collection("lists").aggregate(pipeline).toArray();

				if (res_ambos.length === 0) {
				let nit_alias = nit + ' ' + nombreAlias;
				sin_resultados(nit, nombreAlias, nit_alias );
				} else {
				res_ambos[0].coincidencia = 1;
				
				res_ambos[0].el_primero = '1';

				res_ambos.forEach(element => {
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						//element.encontrado_por = '(NIT_Alias): ' + nit;
						element.encontrado_por = '(NIT): ' + nit;
					} else {
						element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
					}
					//element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.coincidencia = 0.85;
					element.terminosBuscados = nit + ' / ' + nombreAlias; //pone los dos datos pues buesca por el uno o por el otro
				});
				//res_ambos[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
				acumula_resultados(res_ambos);
				}
			}


			/*
			//*********************lo busca en las listas personalizadas**********************
            */

			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				
				let filtro_personalizada = {
					$and: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i' } },
						{ empresa_id: id_empresa }
					]
				};
				
				const res_nombreAlias_personalizada = await db.collection("customlists").find(filtro_personalizada).toArray();
				
				if (res_nombreAlias_personalizada.length > 0) {
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias_personalizada[0].firstNamelastName.toUpperCase());
					res_nombreAlias_personalizada[0].coincidencia = coincidencia;
					//res_nombreAlias_personalizada[0].encontrado_por = '(Alias): ' + nombreAlias;

					res_nombreAlias_personalizada[0].el_primero = '1';

					res_nombreAlias_personalizada.forEach(element => {
						element.encontrado_por = '(Alias): ' + nombreAlias;
						element.terminosBuscados = nombreAlias;
					});

					acumula_resultados(res_nombreAlias_personalizada);
				}

			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos
				//const res_nit_personalizada = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
				const res_nit_personalizada = await db.collection("customlists").find({
					$and: [
						{ 'idNumber': { '$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i' } },
						{ 'empresa_id': id_empresa }
					]
				}).toArray();

				if (res_nit_personalizada.length > 0) {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit_personalizada[0].firstNamelastName.toUpperCase());
				res_nit_personalizada[0].coincidencia = 1;
				//res_nit_personalizada[0].encontrado_por = '(NIT): ' + nit;

				res_nit_personalizada[0].el_primero = '1';

				res_nit_personalizada.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //pues lo encontró por nit y se presupone que la busqueda solo lo devuelve cuando lo encuentra
					element.terminosBuscados = nit;
				});

				acumula_resultados(res_nit_personalizada);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos
				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } },
					],
						$and: [
							{ empresa_id: id_empresa }
						]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos_personalizada = await db.collection("customlists").aggregate(pipeline).toArray();
				
				if (res_ambos_personalizada.length > 0) {

				res_ambos_personalizada[0].el_primero = '1';

				res_ambos_personalizada.forEach(element => {

					//se agrega nuevo
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						element.encontrado_por = '(NIT): ' + nit;
					} else {
						element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
					}


					//fin se agreaga nuuevo
					//element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.terminosBuscados = nit + ' / ' + nombreAlias;
				});

				acumula_resultados(res_ambos_personalizada);
				}
			}
			if (index === datos.length - 1) {	
				res.json(resultados);
			}

			

	}
  
	function acumula_resultados(respuesta) {
		if (respuesta[0].estado === 'Reportado') {
		  resultados.splice(0,0,...respuesta);
		} else {
		  resultados.push(...respuesta);
		}
	  //resultados.push(...respuesta);
	}
  
	function sin_resultados(nit, nombreAlias, encontrado_por) {
	  const sinResultados = [{
		firstNamelastName: nombreAlias,
		idNumber: nit,
		estado: 'No Reportado',
		coincidencia: 0,
		//encontrado_por: encontrado_por
		terminosBuscados: encontrado_por
	  }];
	  acumula_resultados(sinResultados);
	}
  

  }
  



async function getReportados_ver_01(req, res){

	let resultados = [];
	//var params = req.params;
	//var nombreAlias = params.nombreAlias;
	//var nit = params.nit;

	//let datos = JSON.parse(req.query['registros']);
		// let tipo_porcentaje = datos.tipo_porcentaje;
		// let id_empresa = datos.idEmpresa;
		// let clase_porcentaje = datos.clase_porcentaje;
	
		//console.log('lo recibido: ',JSON.parse(req.query['DATOS']));

		//let procesar = JSON.parse(req.query['DATOS']);

		//let procesar = JSON.parse(req.query['registros']);
		let procesar = req.body;


		procesar.forEach(async (element, index) => {
				let nombreAlias = element.nombreAlias;
				let nombreAliasParts = nombreAlias.split(' ');
						var i = 0;
						let queryString = [];
						nombreAliasParts.forEach(element => {
							queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
							i++;
						});
						
						const consulta ={
							"$and": queryString
						};

						let nit = element.identificacion.toString();
				
				if(nombreAlias !== '0' && nit !== '0'){


					try {
							const resultadoNit = await new Promise((resolve, reject) => {
								db.collection("lists")
								  .find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}})
								  .toArray()
								  .then((result) => {
									resolve(result);
								  })
								  .catch((error) => {
									reject(error);
								  });
							  });
							
							  resultadoNit.then((result) => {
								
								if (result.length === 0) {
									
								}
								
							  });
							// const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray()

							if(resultadoNit.length === 0){
								const resultadoNombre = await new Promise ((resolve,reject) => {
									db.collection("lists")
									.find(consulta)
									.toArray()
									.then((result) => {
										resolve(result);  
									})
									.catch((error) => {
										 reject(error);
									 });
								});

								if (resultadoNombre.length === 0) {
									//consulta por alias
									
									const resultadoAlias =  await new Promise ((resolve,reject) => {
										 db.collection("lists")
										 .find({'aka': { $regex: new RegExp(nombreAlias, 'i') }})
										 .toArray()
										 .then((result) => {
											 resolve(result);
										 })
										 .catch((error) => {
											 reject(error);
										 });
										});	

									if (resultadoAlias.length === 0) {
										// const noreportado = [{
										// 	firstNamelastName: nombreAlias,
										// 	idNumber: nit,
										// 	estado: "No Reportado",
										// 	encontrado_por: nombreAlias+'-'+nit,
										// 	coincidencia: 0
										// 	//terminoBusqueda: nombreAlias
										// }];
										//resultados.push(noreportado);
										// resultadoAlias.coincidencia = 0;
										// resultadoAlias.firstNamelastName = nombreAlias;
										// resultadoAlias.encontrado_por = '(Alias): '+ nombreAlias + nit
										// resultadoAlias.estado = 'No Reportado';
										resultados = acumula_resultados(resultadoAlias);

									} else {
										resultadoAlias[0].coincidencia = 100;
										resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
										//resultados.push(resultadoAlias);
										resultados = acumula_resultados(resultadoAlias);
										//res.json(resultadoAlias);
									}
								} else {
									let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoAlias[0].firstNamelastName.toUpperCase());
									resultadoNombre[0].coincidencia = coincidencia;
									resultadoNombre[0].encontrado_por = nombreAlias;
									//resultados.push(resultadoNombre);
									resultados = acumula_resultados(resultadoNombre);
									//console.log('nombre: ', resultadoNombre);
									//res.json(resultadoNombre);
								}
							}else{ //devuelve el resultado por nit pues lo encontró
								resultadoNit[0].encontrado_por = nit; 
								resultados = acumula_resultados(resultadoNit);
							}
						
					} catch (error) {
						//res.send(error);
					}
				} else {
					
					if(nombreAlias !== '0' && nit === '0'){
						//consulta por nombre alias

						try {
							const resultadoNombre = await new Promise((resolve, reject) => {
								 db.collection("lists")
									.find(consulta).toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
							});

							if (resultadoNombre.length === 0) {
								//lo busca en el campo del alias
								const resultadoAlias = await new Promise((resolve, reject) => {
								db.collection("lists")
									.find({'aka': { $regex: new RegExp(nombreAlias, 'i') }})
									.toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
								});

								if (resultadoAlias.length === 0) {
										const sinResultados =  [{
											firstNamelastName: nombreAlias,
											//idNumber: nit,
											estado: 'No Reportado',
											encontrado_por: nombreAlias,
											coincidencia: 0
										}];
										//resultados.push(sinResultados);
										sinResultados.coincidencia = 0;
										resultados =acumula_resultados(sinResultados);
									} else {
										resultadoAlias[0].coincidencia = 100;
										resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
										//res.json(resultadoAlias);
										//resultados.push(resultadoAlias);
										resultados = acumula_resultados(resultadoAlias);
									}
							} else { //devuelve lo encontrado al buscar en el campo firstnamelastName
								resultadoNombre[0].encontrado_por = 'Encontrado por Nombre: '+ nombreAlias;
								let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
								resultadoNombre[0].coincidencia = coincidencia;
								//resultados.push(resultadoNombre);
								resultados = acumula_resultados(resultadoNombre);
							}

						} catch (error) {
							//res.send(error);
						}
					} else {
						if(nit !== '0' && nombreAlias === '0'){
							try {

								const resultadoNit = await new Promise((resolve, reject) => {
									db.collection("lists")
									.find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}})
									.toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
								});

								if(resultadoNit.length === 0){
									const sinResultados =  [{
										firstNamelastName: nombreAlias,
										idNumber: nit,
										estado: 'No Reportado',
										encontrado_por: nit,
										coincidencia: 0
									}];
									sinResultados.coincidencia = 0;
									//res.json(arraySinResultados);
									//resultados.push(sinResultados);
									resultados = acumula_resultados(sinResultados);
								} else {
									resultadoNit[0].encontrado_por = 'Encontrado por NIT: ' + nit; 
									//resultadoNit[0].coincidencia = 100; //se poden 100 DADO QUE EL SOFTWARE LO BUSCA COMO NUMERO SOLITO E INDEPENDIENTE
									//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
									//resultadoNombre[0].coincidencia = coincidencia;
									//res.json(resultadoNit);
									//resultados.push(resultadoNit);
									resultados = acumula_resultados(resultadoNit);
								}
								
							} catch (error) {
								res.send(err);
							}
						}
					}
				}
				
				
				

				if(index === procesar.length-1) {

					//console.log('el arreglo final xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',resultados, 'la longitud', resultados.length);
					res.json(resultados);
				  }

				
		});

		// function acumula_resultados(arreglo){
		// 	//console.log('el arreglo ha llegado a acumula ',arreglo, 'la longitud', arreglo.length);
			
		// 		resultados.push(arreglo);
			
			
		// 	return resultados;
		// }		
			
		

		//res.send(resultados);




	// let nombreAliasParts = nombreAlias.split(' ');
	// var i = 0;
	// let queryString = [];
	// nombreAliasParts.forEach(element => {
	// 	queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
	// 	i++;
	// });
	
	// const consulta ={
	// 	"$and": queryString
	// };

	// /*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
	// /******REVISAR los datos de una busqueda que no vienen con nit se estan yendo por aqui */

	// //busca si los dos datos tienen valores : nit y nombre alias
	// if(nombreAlias != '0' && nit != '0'){

	// 	try {
	// 		//consulta por nit
	// 		const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
	// 			if(resultadoNit.length === 0){
	// 				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
	// 				if (resultadoNombre.length === 0) {
	// 					//consulta por alias
	// 					const resultadoAlias = await db.collection("lists").find({
	// 						'aka': { $regex: new RegExp(nombreAlias, 'i') }
	// 					}).toArray();

	// 					if (resultadoAlias.length === 0) {
	// 						const noreportado = [{
	// 							firstNamelastName: nombreAlias,
	// 							idNumber: nit,
	// 							estado: "No Reportado",
	// 							encontrado_por: nombreAlias+'-'+nit,
	// 							coincidencia: 0
	// 							//terminoBusqueda: nombreAlias
	// 						}]
	// 						res.json(noreportado);

	// 					} else {
	// 						resultadoAlias[0].coincidencia = 100;
	// 						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
	// 						res.json(resultadoAlias);
	// 					}
	// 				} else {
	// 					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
	// 					resultadoNombre[0].coincidencia = coincidencia;
	// 					resultadoNombre[0].encontrado_por = nombreAlias;
	// 					res.json(resultadoNombre);
	// 				}
	// 			}else{
	// 				resultadoNit[0].encontrado_por = nit; 
	// 				res.json(resultadoNit);
	// 			}
			
	// 	} catch (error) {
	// 		res.send(error);
	// 	}
	// }else{
	// 	if(nombreAlias != '0' && nit === '0'){
	// 		//consulta por nombre alias

	// 		try {
	// 			const resultadoNombre = await db.collection("lists").find(consulta).toArray();
	// 			//console.log(resultadoNombre.length, resultadoNombre);

	// 			if (resultadoNombre.length === 0) {
	// 				//lo busca en el campo del alias
	// 				const resultadoAlias = await db.collection("lists").find({
	// 					'aka': { $regex: new RegExp(nombreAlias, 'i') }
	// 				  }).toArray();

	// 				 if (resultadoAlias.length === 0) {
	// 						const sinResultados =  {
	// 							firstNamelastName: nombreAlias,
	// 							//idNumber: nit,
	// 							estado: 'No Reportado',
	// 							encontrado_por: nombreAlias,
	// 							coincidencia: 0
	// 						}
	// 						const arraySinResultados = [sinResultados];
	// 						res.json(arraySinResultados);
	// 					} else {
	// 						resultadoAlias[0].coincidencia = 100;
	// 						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
	// 						res.json(resultadoAlias);
	// 					}
	// 			} else { //devuelve lo encontrado al buscar en el campo firstnamelastName
	// 				resultadoNombre[0].encontrado_por = 'Encontrado por Nombre: '+ nombreAlias;
	// 				let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
	// 				resultadoNombre[0].coincidencia = coincidencia;
	// 				//console.log('lo que envia al navegador: ', resultadoNombre);
	// 				res.json(resultadoNombre);
	// 			}

	// 		} catch (error) {
	// 			res.send(error);
	// 		}
	// 	}else
	// 		if(nit != '0' && nombreAlias === '0'){
	// 			try {

	// 				const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
	// 				if(resultadoNit.length === 0){
	// 					const sinResultados =  {
	// 						firstNamelastName: nombreAlias,
	// 						idNumber: nit,
	// 						estado: 'No Reportado',
	// 						encontrado_por: nit,
	// 						coincidencia: 0
	// 					}
	// 					const arraySinResultados = [sinResultados];
	// 					res.json(arraySinResultados);
	// 				}
	// 				resultadoNit[0].encontrado_por = 'Encontrado por NIT: ' + nit; 
	// 				res.json(resultadoNit);
					
	// 			} catch (error) {
	// 				res.send(err);
	// 			}
	// 		}
	// }
}

function saveSearchBMP(req, res){
	var entity = new Entity();

	var params = req.body;



	entity.empresa_id = params.empresa_id;
	entity.identificacion = params.identificacion;
	entity.nombreAlias = params.nombreAlias;
	entity.creado = params.fechaCreacion;
	entity.usuarioCrea = params.usuarioCrea;
	entity.tipoConsulta = params.tipoConsulta;

	//console.log(entity);
		//guarda el usuario
		entity.save((err, searchStored) => {
			if(err){
				//console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!searchStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: searchStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 


//de aqui para abajo tal vez no se usen estas funciones. Revisar

function saveSearchV2(req, res){
	var entity = new Entity();

	var params = req.body;

	//console.log(' estoy en save search V2');
	//console.log(params);

	entity.empresa_id = params.empresa_id;
	entity.identificacion = params.identificacion;
	entity.nombreAlias = params.nombreAlias;
	entity.creado = params.creado;
	entity.usuarioCrea = params.usuarioCrea;
	entity.tipoConsulta = params.tipoConsulta;

	//console.log(entity);
		//guarda el usuario
		entity.save((err, searchStored) => {
			if(err){
				//console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!searchStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: searchStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 

function saveSearchV3(req, res){
	var entity = new Entity();

	var params = req.body;

	
	//console.log(params);
	// entity.empresa_id = params.empresa_id;
	// entity.identificacion = params.identificacion;
	// entity.nombreAlias = params.nombreAlias
	// entity.creado = params.creado;
	// entity.usuarioCrea = params.usuarioCrea;
	// entity.tipoConsulta = params.tipoConsulta;

	// //console.log("Soy entity" + entity);
	// 	//guarda el usuario
		// entity.save((err, searchStored) => {
		// 	if(err){
		// 		//console.log(err);
		// 		res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
		// 	}else{
		// 		if(!searchStored){
		// 			res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
		// 		}else{
		// 			res.send({ id: searchStored._id });
		// 		//	res.status(200).send({riskProfile: riskProfileStored});
		// 		}
		// 	}
		// });
	
		//db.collection("searches").insertMany(params)
	if( params.length > 1 ){
		db.collection("searches").insertMany(params, function(err, result) {
			if (err) {
			  console.error('Error al insertar documentos', err);
			} else {
			  //console.log(`${result.insertedCount} documentos insertados correctamente`);
			  res.send({ estado: 'grabado' });
			}
		  });
		} else {
			db.collection("searches").insertOne(params, function(err, result) {
				if (err) {
				  console.error('Error al insertar documentos', err);
				} else {
				  //console.log(`${result.insertedCount} documentos insertados correctamente`);
				  res.send({ estado: 'grabado' });
				}
			  });
		}



} 


/***************************************************************/
/*  funcion para salvar cualquier registro en la base de datos****/
/*  Para adaptar:  (*), (*) ************************************/
/* *************************************************************/
function saveOneSearch(req, res){
	var entity = new Entity();
	var params = req.body;
	
	//(*)
	entity.nombre = params.nombre;
    entity.creado = new Date();
	entity.usuarioCrea = params.usuarioCrea;
		
		//graba la entidad en la base de datos
		//if(entity.nombre != null && user.apellido != null && user.username != null ){
		if(entity.nombre != null ){ //(*)
			//guarda la entidad
			entity.save((err, entityStored) => {
				if(err){
					res.status(500).send({message: 'Error al grabar en la base de datos'});
				}else{
					if(!entityStored){
						res.status(404).send({message: 'No se ha guardado la entidad en la base de datos'});
					}else{
						res.status(200).send({user: entityStored});
					}
				}
			});
		}else{
			res.status(200).send({message: 'Todos los campos son obligatorios'});
		}
} 



/********************************************************/
/*función para devolver UN registro de la base de datos**/
/*Esta función es usada para recueprar un registro dado */
/*que lo recupera y lo lleva al form de crear entity    */
/********************************************************/
function getEntity(req, res){
	var entityId = req.params.id;

	try {
		const entity = Entity.findById(entityId, function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}


/*********************************************************/
/*función para ACTUALIZAR UNO de los registros ***********/
/*Esta función es usada para actualizar un registro dado */
/*********************************************************/
function updateEntity(req, res){
	var entityId = req.params.id;
	var update = req.body;

	Entity.findByIdAndUpdate(entityId, update, (err, entityUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar'});
		}else{
			if(!entityUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la base de datos'});
			}else{
				res.status(200).send({user: entityUpdated});
			}
		}
	})
}

/*********************************************************/
/** Función para ELIMINAR UNO de los registros ***********/
/** Esta función es usada para eliminar un registro dado */
/*********************************************************/
function deleteEntity(req, res){
	var entityId = req.params.id;
	
	try {
		Entity.findByIdAndDelete(entityId, function (err, entityRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(entityRemoved);
			}
		});
	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el registro'});
	}
}

async function getSearch(req, res){

	var fechaInicio = req.query.startDate;
	var fechaFin = req.query.endDate;
	//fechaFin = '2023-06-13T00:00:00.000Z'
	//fechaInicio = '2023-06-01T00:00:00.000Z'
	//console.log(fechaInicio);
	//console.log(fechaFin);

	const query = {};

  // Agregar campos a la consulta solo si tienen valores proporcionados
    query.creado = {
      $gte: new Date(fechaInicio),
      $lte: new Date(fechaFin)
    };
 

	try {
			
		const report = Entity.find(query, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
	//	console.log("Las consultas encontradas "+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el servicio de consultas' + req + planId});
	}

}


async function getSearchCount(req, res) {
	
	let datos = JSON.parse(req.query['DATOS']);

	var fechaInicio = datos['startDate'];
	var fechaFin = datos['endDate'];
	var role =datos['elRole'];
	var idEmpresa = datos['idEmpresa'];
  
	var query = {};
	
  
	// devuelve todos los registros de una si  las dos fechas vienen con valor 0
	// if (fechaFin === 0 && fechaInicio === 0) {
	// 	console.log("entro cuando fechas valen 0");
	// 	query = { empresa_id: idEmpresa };
	// 	console.log('el valoir de query es ' + query);
	// }
	
//original

	if (role === "SuperAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
		 query = {
			creado: {
			  $gte: new Date(fechaInicio),
			  $lte: new Date(fechaFin),
			}
		  };
	} else if (role === "EmpresaAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
		 query = {
			$and: [
				{ creado: { $gte: new Date(fechaInicio), $lte: new Date(fechaFin) } },
				{ empresa_id: idEmpresa }
			]
		  };
	}

	try {
	  const report = await Entity.aggregate([
		{
			$match: query // Aplicar el filtro en la etapa de agregación usando 
		},
		{
		  $group: {
			_id: '$empresa_id',
			count: { $sum: 1 }
		  }
		}
	  ]).exec();
  
	//fin original

	// if (role === "SuperAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
	// 	query = {
	// 		creado: {
	// 			$gte: new Date(fechaInicio),
	// 			$lte: new Date(fechaFin),
	// 		},
	// 	};
	// } else if (role === "EmpresaAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
	// 	// Para Empresa, construye un pipeline que combine ambas colecciones
	// 	const entityQuery = {
	// 		creado: { $gte: new Date(fechaInicio), $lte: new Date(fechaFin) },
	// 		empresa_id: idEmpresa,
	// 	};
	
	// 	const restQuery = {
	// 		creado: { $gte: new Date(fecha_de_grabacion), $lte: new Date(fecha_de_grabacion) },
	// 		empresa_id: idEmpresa, // Suponemos que 'rest' tiene el mismo campo 'empresa_id'
	// 	};
	
	// 	// Pipeline personalizado para Empresa
	// 	const pipeline = [
	// 		// Primero filtra los registros de 'Entity'
	// 		{ $match: entityQuery },
	// 		// Combina con los registros de 'rest' que cumplan las mismas condiciones
	// 		{
	// 			$unionWith: {
	// 				coll: 'apirest',
	// 				pipeline: [{ $match: restQuery }], // Filtros para 'rest'
	// 			},
	// 		},
	// 		// Agrupa por 'empresa_id' y cuenta todos los registros (de ambas colecciones)
	// 		{
	// 			$group: {
	// 				_id: '$empresa_id',
	// 				count: { $sum: 1 },
	// 			},
	// 		},
	// 	];
	
	// 	try {
	// 		const report = await Entity.aggregate(pipeline).exec();
	// 		res.json(report);
	// 		// ...
	// 	} catch (err) {
	// 		// Manejo de errores
	// 	}
	// } else {
	// 	// Otros casos (sin fecha o rol no válido)
	// 	// ...
	// }
	  
	res.json(report);
	
	} catch (err) {
	 // console.error("Error al realizar la agregación:", err);
	  res.status(500).send({ message: "Error al realizar la agregación" });
	}

}	


   //*******************************************************************************************************/
   // Jaro Winkler para comparar dos cadenas
   // Additional notes
   /*******************************************************************************************************/




/* esta funciona ien*/

//   function jaroWinklerf(s1, s2) {
// 	const maxLength = Math.max(s1.length, s2.length);
//   if (maxLength === 0) {
//     return 1; // Si ambas cadenas están vacías, la distancia es 1.
//   }

//   // Calcula la distancia de Jaro
//   function jaroDistance(s1, s2) {
//     const m = s1.length;
//     const n = s2.length;

//     if (m === 0 || n === 0) return 0;

//     const maxDistance = Math.floor(Math.max(m, n) / 2) - 1;
//     const matches = Array(n).fill(false);

//     let matchingCount = 0;

//     for (let i = 0; i < m; i++) {
//       const start = Math.max(0, i - maxDistance);
//       const end = Math.min(i + maxDistance + 1, n);

//       for (let j = start; j < end; j++) {
//         if (!matches[j] && s1[i] === s2[j]) {
//           matches[j] = true;
//           matchingCount++;
//           break;
//         }
//       }
//     }

//     if (matchingCount === 0) return 0;

//     let transpositions = 0;
//     let j = 0;

//     for (let i = 0; i < m; i++) {
//       if (!matches[j]) {
//         j++;
//         continue;
//       }
//       if (s1[i] !== s2[j]) transpositions++;
//       j++;
//     }

//     const m1 = matchingCount;
//     const m2 = transpositions / 2;

//     return (m1 / m + m1 / n + (m1 - m2) / m1) / 3;
//   }

//   const jaroDist = jaroDistance(s1, s2);

//   // Calcula el factor de Winkler
//   const prefixLength = 4; // Longitud máxima para considerar como prefijo
//   let commonPrefix = 0;

//   for (let i = 0; i < prefixLength && i < Math.min(s1.length, s2.length); i++) {
//     if (s1[i] === s2[i]) commonPrefix++;
//     else break;
//   }

//   const winklerFactor = 0.1;
//   const jaroWinklerDist = jaroDist + commonPrefix * winklerFactor * (1 - jaroDist);

//   return Math.min(jaroWinklerDist, 1); // Asegura que la distancia no sea mayor que 1.
//   }


  function jaroWinklerf(s1, s2){
	let dist = distance(s1,s2);

	return dist;
	
  }

module.exports = {
	saveSearch,
	updateEntity,
	getReportados,
	//getReportadosPerfilada,
	getEntity,
	deleteEntity,
	saveOneSearch,
	saveSearchV2,
	saveSearchV3,
	getSearch,
	getSearchCount,
	saveSearchBMP
};