'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');


var bcrypt = require('bcrypt-nodejs');
var Entity = require('../models/search');
var jwt = require('../services/jwt');
const { db } = require('../models/search');

const distance = require('jaro-winkler');

const c = console.log;

//Graba en la base de datos muchos registros provenientes un archivo de excel
//Graba las busquedas que hace una empresa.

function saveSearch(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	var params = req.body;

	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	var primerRegistro = params[0];
	var empresa_id = primerRegistro.empresa_id;
	/*
	console.log('respuesta de a uno');
	params.forEach(element => {
		db.collection("transactions").bsonOptions(element);
		console.log(element);
	});
*/

	if (empresa_id != ''){
		//if(db.collection(empresa_id).insertMany (params)){
			
		if(db.collection("searches").insertMany(params)){
			//console.log("Archivo de Busqueda Masiva IMportado");
			res.status(200).send({message: 'Grabado correctamente'});
		}else{
			//console.log("File imported error.");
			res.status(400).send({message: 'ha ocurrido un error en el controlador'});
		}
	}

}



/********************************************************************/
/*  funcion para devolver todos los registros de la base de datos que aparecen reportados en ls listas****/
/* ******************************************************************/

async function BAK_getReportados(req, res){
	var params = req.params;
	var nombreAlias = params.nombreAlias;
	var nit = params.nit;

	let nombreAliasParts = nombreAlias.split(' ');
	var i = 0;
	let queryString = [];
	nombreAliasParts.forEach(element => {
		queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
		i++;
	});
	
	const consulta ={
		"$and": queryString
	};

	/*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
	/******REVISAR los datos de una busqueda que no vienen con nit se estan yendo por aqui */

	//busca si los dos datos tienen valores : nit y nombre alias
	if(nombreAlias != '0' && nit != '0'){

		try {
			//consulta por nit
			const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
				if(resultadoNit.length === 0){
					const resultadoNombre = await db.collection("lists").find(consulta).toArray();
					if (resultadoNombre.length === 0) {
						//consulta por alias
						const resultadoAlias = await db.collection("lists").find({
							'aka': { $regex: new RegExp(nombreAlias, 'i') }
						}).toArray();

						if (resultadoAlias.length === 0) {
							const noreportado = [{
								firstNamelastName: nombreAlias,
								idNumber: nit,
								estado: "No Reportado",
								encontrado_por: nombreAlias+'-'+nit,
								coincidencia: 0
								//terminoBusqueda: nombreAlias
							}]
							res.json(noreportado);

						} else {
							resultadoAlias[0].coincidencia = 100;
							resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
							res.json(resultadoAlias);
						}
					} else {
						let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
						resultadoNombre[0].coincidencia = coincidencia;
						resultadoNombre[0].encontrado_por = nombreAlias;
						res.json(resultadoNombre);
					}
				}else{
					resultadoNit[0].encontrado_por = nit; 
					res.json(resultadoNit);
				}
			
		} catch (error) {
			res.send(error);
		}
	}else{
		if(nombreAlias != '0' && nit === '0'){
			//consulta por nombre alias

			try {
				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
				//console.log(resultadoNombre.length, resultadoNombre);

				if (resultadoNombre.length === 0) {
					//lo busca en el campo del alias
					const resultadoAlias = await db.collection("lists").find({
						'aka': { $regex: new RegExp(nombreAlias, 'i') }
					  }).toArray();

					 if (resultadoAlias.length === 0) {
							const sinResultados =  {
								firstNamelastName: nombreAlias,
								//idNumber: nit,
								estado: 'No Reportado',
								encontrado_por: nombreAlias,
								coincidencia: 0
							}
							const arraySinResultados = [sinResultados];
							res.json(arraySinResultados);
						} else {
							resultadoAlias[0].coincidencia = 100;
							resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
							res.json(resultadoAlias);
						}
				} else { //devuelve lo encontrado al buscar en el campo firstnamelastName
					resultadoNombre[0].encontrado_por = 'Encontrado por Nombre: '+ nombreAlias;
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
					resultadoNombre[0].coincidencia = coincidencia;
					//console.log('lo que envia al navegador: ', resultadoNombre);
					res.json(resultadoNombre);
				}

			} catch (error) {
				res.send(error);
			}
		}else
			if(nit != '0' && nombreAlias === '0'){
				try {

					const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
					if(resultadoNit.length === 0){
						const sinResultados =  {
							firstNamelastName: nombreAlias,
							idNumber: nit,
							estado: 'No Reportado',
							encontrado_por: nit,
							coincidencia: 0
						}
						const arraySinResultados = [sinResultados];
						res.json(arraySinResultados);
					}
					resultadoNit[0].encontrado_por = 'Encontrado por NIT: ' + nit; 
					res.json(resultadoNit);
					
				} catch (error) {
					res.send(err);
				}
			}
	}
}


async function getReportados_nuevaver0(req, res){
	let resultados = [];
	let res_nit = [];
	let res_nombreAlias = [];
	let res_ambos = [];
	let datos = req.body;

	
	
	let i= 0;
	datos.forEach(async (element, index) => {
			let nit = element.identificacion;
			let nombreAlias = element.nombreAlias;

			if (nombreAlias !== 0 && nit === 0) {
				const consulta = { firstNamelastName: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }
				const res_nombreAlias = await db.collection("lists").find(consulta).toArray();
				if (res_nombreAlias.length === 0) { 
					sin_resultados(nit, nombreAlias);					
				} else {
					acumula_resultados(res_nombreAlias);
				}
			} else if (nombreAlias === 0 && nit !== 0 ) {
				const consulta = {
				 idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } 
				}
				const res_nit = await db.collection("lists").find(consulta).toArray();
				if (res_nit.length === 0) { 
					sin_resultados(nit, nombreAlias);					
				} else {
					acumula_resultados(res_nit);
				}
			} else if (nombreAlias !== 0 && nit !== 0) {
				const pipeline = [
					{
					$match: {
						$or: [
						{ firstNamelastName: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }, 
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i')} }
						]
					}
					}
				];
				const res_ambos = await db.collection("lists").aggregate(pipeline).toArray();
				if (res_ambos.length === 0) { 
					sin_resultados(nit, nombreAlias);					
				} else {
					acumula_resultados(res_nit);
				}
				
	}

	function acumula_resultados(respuesta) {
	  resultados.push(respuesta);
	}


	function sin_resultados(nit, nombreAlias) {
		const sinResultados =  {
			firstNamelastName: nombreAlias,
			idNumber: nit,
			estado: 'No Reportado',
			coincidencia: 0
		};
		acumula_resultados(sinResultados);
	}

	  if (index === datos.length - 1) {
	  	
	  }
	  

	});
	
	
}


async function getReportados_verOptimizada(req, res){
	let resultados = [];
	let datos = req.body;

	for (const [index, element ] of datos.entries()) {

		const pipeline = [
			{
			  $match: {
				$and: [
				  { firstNamelastName: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } },
				  { idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
				]
			  }
			}
		  ];


	}

}

		// res.write('[ '); // Inicio de la respuesta JSON
		// 		// Iterar sobre el cursor y enviar resultados parciales
		// 		while (await res_nombreAlias.hasNext()) {
		// 		const documento = await res_nombreAlias.next();
		// 		res.write(JSON.stringify(documento));
		// 		res.write(', ');
		// 		}
		// res.write(']'); // Fin de la respuesta JSON y res.end
		// res.end();

async function getReportados(req, res){

	let resultados = [];
	let datos = req.body['registros'];
	console.log('datos recibidos en el servidor: ', datos);
	let id_empresa = req.body['id_empresa'];
	
	await createOptimizedIndexes();
	
    const results = await processRecords(
            datos,
            50,  // Tamaño de lote (ajustar según tu hardware)
            8    // Concurrencia (ajustar según tu CPU)
    );
	

}



async function createOptimizedIndexes() {
        try {
            // Índices compuestos para búsquedas eficientes
            await this.collection.createIndex({ 
                "idNumber": 1 
            }, { 
                background: true,
                name: "idx_idNumber" 
            });
            
            await this.collection.createIndex({ 
                "nombreAlias": "text" 
            }, { 
                background: true,
                name: "idx_nombreAlias_text",
                default_language: 'spanish',
                language_override: 'language'
            });
            
            // Índice compuesto para búsquedas combinadas
            await this.collection.createIndex({ 
                "idNumber": 1, 
                "nombreAlias": "text" 
            }, { 
                background: true,
                name: "idx_combined"
            });
            
            console.log('Índices optimizados creados exitosamente');
        } catch (error) {
            console.error('Error creando índices:', error);
        }
    }

    // Función para normalizar texto (quitar tildes, mayúsculas, caracteres especiales)
    // function normalizeText(text) {
    //     if (!text) return '';
        
    //     return text
    //         .toLowerCase()
    //         .normalize('NFD')
    //         .replace(/[\u0300-\u036f]/g, '') // Quitar tildes
    //         .replace(/[^\w\s]/g, '') // Quitar caracteres especiales
    //         .replace(/\s+/g, ' ') // Normalizar espacios
    //         .trim();
    // }

	function normalizeText(text) {
    // Validación de entrada mejorada
    if (!text || typeof text !== 'string') {
        return '';
    }
    
    return text
        .normalize("NFD")
        .replace(/[\u0300-\u036f]/g, "") // Elimina acentos
        .replace(/ñ/g, 'n')              // Manejo explícito de ñ
        .replace(/Ñ/g, 'n')              // Manejo explícito de Ñ
        // CAMBIO IMPORTANTE: Preservar guiones, apostrofes y puntos en nombres
        .replace(/[^a-zA-Z0-9\s\-'\.]/g, "")  // Preserva guiones (-), apostrofes (') y puntos (.)
        .toLowerCase()                    // Convierte todo a minúsculas
        .replace(/\s+/g, ' ')            // Normaliza espacios múltiples a uno solo
        .trim();                         // Elimina espacios al inicio y final
}



// Función para crear variaciones de búsqueda fuzzy
    function createFuzzyVariations(sname) {
        const normalized = normalizeText(sname);
        const words = normalized.split(' ');
        
        const variations = [
            normalized,
            ...words, // Palabras individuales
            words.join('.*'), // Regex para orden no estricto
        ];
        
        // Agregar variaciones con caracteres opcionales para nombres comunes
        if (words.length > 1) {
            variations.push(words.map(w => `${w}.*`).join('|'));
        }
        
        return [...new Set(variations)].filter(v => v.length > 1);
    }

    // Crear consulta optimizada para búsqueda fuzzy
    function createFuzzyQuery(record) {
        const queries = [];
        
        // Búsqueda por idNumber exacto
        if (record.idNumber) {
            queries.push({
                idNumber: record.idNumber
            });
        }
        
        // Búsqueda fuzzy por nombreAlias
        if (record.nombreAlias) {
            const variations = this.createFuzzyVariations(record.nombreAlias);
            
            // Usar índice de texto para búsqueda inicial
            queries.push({
                $text: {
                    $search: variations.join(' '),
                    $caseSensitive: false,
                    $diacriticSensitive: false
                }
            });
            
            // Búsqueda con regex para mayor flexibilidad
            const regexPattern = variations
                .map(v => v.replace(/\s+/g, '.*'))
                .join('|');
                
            queries.push({
                nombreAlias: {
                    $regex: regexPattern,
                    $options: 'i'
                }
            });
        }
        
        // Búsqueda combinada cuando ambos campos existen
        if (record.idNumber && record.nombreAlias) {
            const nameVariations = this.createFuzzyVariations(record.nombreAlias);
            queries.push({
                $and: [
                    { idNumber: record.idNumber },
                    {
                        $or: nameVariations.map(variation => ({
                            nombreAlias: {
                                $regex: variation.replace(/\s+/g, '.*'),
                                $options: 'i'
                            }
                        }))
                    }
                ]
            });
        }
        
        return queries.length > 0 ? { $or: queries } : {};
    }

    // Procesar lote de registros
    async  function processBatch(batch, batchIndex) {
        const startTime = Date.now();
        const results = [];
        
        try {
            // Crear pipeline de agregación optimizado
            const pipeline = [
                {
                    $match: {
                        $or: batch.map(record => this.createFuzzyQuery(record))
                    }
                },
                {
                    $addFields: {
                        // Calcular score de similitud
                        similarityScore: {
                            $add: [
                                { $cond: [{ $ne: ["$idNumber", null] }, 2, 0] },
                                { $cond: [{ $ne: ["$nombreAlias", null] }, 1, 0] }
                            ]
                        }
                    }
                },
                {
                    $sort: {
                        similarityScore: -1,
                        _id: 1
                    }
                },
                {
                    $limit: batch.length * 5 // Limitar resultados por batch
                }
            ];

            const dbResults = await this.collection
                .aggregate(pipeline)
                .allowDiskUse(true)
                .toArray();

            // Asociar resultados con registros originales
            for (let i = 0; i < batch.length; i++) {
                const record = batch[i];
                const matches = this.findBestMatches(record, dbResults);
                
                results.push({
                    originalRecord: record,
                    matches: matches,
                    matchCount: matches.length,
                    batchIndex: batchIndex,
                    recordIndex: i
                });
            }

            const processingTime = Date.now() - startTime;
            console.log(`Lote ${batchIndex} procesado: ${batch.length} registros en ${processingTime}ms`);
            
            return results;
            
        } catch (error) {
            console.error(`Error procesando lote ${batchIndex}:`, error);
            return batch.map((record, index) => ({
                originalRecord: record,
                matches: [],
                matchCount: 0,
                error: error.message,
                batchIndex: batchIndex,
                recordIndex: index
            }));
        }
    }

    // Encontrar las mejores coincidencias para un registro
    function findBestMatches(record, dbResults) {
        const matches = [];
        const recordIdNorm = record.idNumber ? record.idNumber.toString() : '';
        const recordNameNorm = this.normalizeText(record.nombreAlias || '');
        
        for (const dbRecord of dbResults) {
            let score = 0;
            let reasons = [];
            
            // Puntuación por idNumber
            if (record.idNumber && dbRecord.idNumber) {
                if (recordIdNorm === dbRecord.idNumber.toString()) {
                    score += 10;
                    reasons.push('ID exacto');
                }
            }
            
            // Puntuación por similitud de nombre
            if (record.nombreAlias && dbRecord.nombreAlias) {
                const dbNameNorm = this.normalizeText(dbRecord.nombreAlias);
                const similarity = this.calculateStringSimilarity(recordNameNorm, dbNameNorm);
                
                if (similarity > 0.6) {
                    score += similarity * 5;
                    reasons.push(`Nombre similar (${(similarity * 100).toFixed(1)}%)`);
                }
            }
            
            // Solo incluir si hay una similitud mínima
            if (score > 2) {
                matches.push({
                    dbRecord: dbRecord,
                    score: score,
                    reasons: reasons
                });
            }
        }
        
        // Ordenar por score y retornar los mejores
        return matches
            .sort((a, b) => b.score - a.score)
            .slice(0, 5); // Top 5 matches
    }

    // Calcular similitud entre strings usando algoritmo de Levenshtein optimizado
    function calculateStringSimilarity(str1, str2) {
        if (str1 === str2) return 1.0;
        if (!str1 || !str2) return 0.0;
        
        const longer = str1.length > str2.length ? str1 : str2;
        const shorter = str1.length > str2.length ? str2 : str1;
        
        if (longer.length === 0) return 1.0;
        
        const distance = this.levenshteinDistance(longer, shorter);
        return (longer.length - distance) / longer.length;
    }

    function levenshteinDistance(str1, str2) {
        const matrix = Array(str2.length + 1).fill(null).map(() => 
            Array(str1.length + 1).fill(null)
        );
        
        for (let i = 0; i <= str1.length; i++) matrix[0][i] = i;
        for (let j = 0; j <= str2.length; j++) matrix[j][0] = j;
        
        for (let j = 1; j <= str2.length; j++) {
            for (let i = 1; i <= str1.length; i++) {
                const substitution = matrix[j - 1][i - 1] + 
                    (str1[i - 1] === str2[j - 1] ? 0 : 1);
                matrix[j][i] = Math.min(
                    matrix[j][i - 1] + 1,     // insertion
                    matrix[j - 1][i] + 1,     // deletion
                    substitution              // substitution
                );
            }
        }
        
        return matrix[str2.length][str1.length];
    }

    // Función principal para procesar todos los registros
    async function processRecords(records, batchSize = 100, concurrency = 4) {
        const startTime = Date.now();
        console.log(`Iniciando procesamiento de ${records.length} registros`);
        console.log(`Configuración: lotes de ${batchSize}, concurrencia ${concurrency}`);
        
        // Dividir en lotes
        const batches = [];
        for (let i = 0; i < records.length; i += batchSize) {
            batches.push(records.slice(i, i + batchSize));
        }
        
        console.log(`Creados ${batches.length} lotes para procesamiento`);
        
        // Procesar lotes con concurrencia controlada
        const results = [];
        
        for (let i = 0; i < batches.length; i += concurrency) {
            const concurrentBatches = batches.slice(i, i + concurrency);
            const promises = concurrentBatches.map((batch, index) => 
                this.processBatch(batch, i + index)
            );
            
            try {
                const batchResults = await Promise.all(promises);
                results.push(...batchResults.flat());
                
                const progress = Math.min(i + concurrency, batches.length);
                const percentage = ((progress / batches.length) * 100).toFixed(1);
                console.log(`Progreso: ${progress}/${batches.length} lotes (${percentage}%)`);
                
            } catch (error) {
                console.error(`Error procesando lotes ${i}-${i + concurrency}:`, error);
            }
        }
        
        const totalTime = Date.now() - startTime;
        console.log(`Procesamiento completado en ${totalTime}ms (${(totalTime/1000).toFixed(2)}s)`);
        console.log(`Promedio: ${(totalTime/records.length).toFixed(2)}ms por registro`);
        
        return results;
    }

    // Función para generar estadísticas del procesamiento
    function generateStats(results) {
        const stats = {
            totalRecords: results.length,
            recordsWithMatches: results.filter(r => r.matchCount > 0).length,
            recordsWithoutMatches: results.filter(r => r.matchCount === 0).length,
            recordsWithErrors: results.filter(r => r.error).length,
            averageMatchesPerRecord: 0,
            matchDistribution: {}
        };
        
        const totalMatches = results.reduce((sum, r) => sum + r.matchCount, 0);
        stats.averageMatchesPerRecord = (totalMatches / results.length).toFixed(2);
        
        // Distribución de matches
        results.forEach(r => {
            const count = r.matchCount;
            stats.matchDistribution[count] = (stats.matchDistribution[count] || 0) + 1;
        });
        
        return stats;
    }

    async  function close() {
        if (this.client) {
            await this.client.close();
            console.log('Conexión a MongoDB cerrada');
        }
    }




async function getReportados_ver_01(req, res){
	
	let resultados = [];
	let datos = req.body['registros'];
	console.log('datos recibidos en el servidor: ', datos);
	let id_empresa = req.body['id_empresa'];

	await ensureIndexes();

	const { results, errors } = await processRecordsInBatches(datos, 100, 10);
	res.status(200).send({ results, errors });

	// Antes de procesar las búsquedas, asegurarse de que los índices existen
	async function ensureIndexes() {
        try {
            // Crear índice de texto para búsqueda difusa
            await this.lists.createIndex(
                { 
                    "firstNamelastName": "text",
					"idNumber": "text",
                    "estado": "text", 
                    "nombreLista": "text",
                    "tipoLista": "text",
					"otraInformacion": "text",
                }, 
                { 
                    firstNamelastName: "name_text_index",
                    default_language: 'spanish',
                    // Configuración para ignorar acentos y mayúsculas
                    textIndexVersion: 3,
                    weights: {
                        firstNamelastName: 10,
                        estado: 8,
                        nombreLista: 8,
                        tipoLista: 8,
						otraInformacion: 8						
                    }
                }
            );
            // Índice adicional para búsquedas exactas normalizadas
            await this.collection.createIndex(
                { "normalizedName": 1 },
                { firstNamelastName: "normalized_name_index", sparse: true }
            );

            console.log('✅ Índices creados/verificados');
        } catch (error) {
            console.warn('⚠️  Error creando índices:', error.message);
        }
    }

	

	// Crear múltiples variaciones de búsqueda para aumentar coincidencias
    function generateSearchVariations(sname) {
        const normalized = this.normalizeText(sname);
        const words = normalized.split(' ').filter(w => w.length > 1);
        
        const  variations = [
            normalized, // Nombre completo normalizado
            ...words, // Palabras individuales
        ];

        // Agregar combinaciones de palabras
        if (words.length > 1) {
            for (let i = 0; i < words.length - 1; i++) {
                variations.push(words[i] + ' ' + words[i + 1]);
            }
        }

        return [...new Set(variations)]; // Quitar duplicados
    }

    async function searchSimilarNames(searchName, limit = 10) {
        const variations = generateSearchVariations(searchName);
        const normalizedSearch = normalizeText(searchName);

        // Pipeline de agregación optimizado para búsqueda difusa
        const pipeline = [
            {
                $match: {
                    $or: [
                        // Búsqueda por texto completo
                        { $text: { $search: variations.join(' ') } },
                        // Búsqueda por regex en nombres normalizados
                        { normalizedName: { $regex: normalizedSearch, $options: 'i' } },
                        // Búsquedas parciales en campos de nombre
                        { name: { $regex: normalizedSearch, $options: 'i' } },
                        { firstName: { $regex: normalizedSearch.split(' ')[0], $options: 'i' } },
                        { lastName: { $regex: normalizedSearch.split(' ').slice(1).join(' '), $options: 'i' } }
                    ]
                }
            },
            {
                $addFields: {
                    // Calcular score de similitud
                    similarity: {
                        $add: [
                            // Score por texto completo
                            { $ifNull: [{ $meta: "textScore" }, 0] },
                            // Bonus por coincidencia exacta normalizada
                            {
                                $cond: {
                                    if: { $eq: ["$normalizedName", normalizedSearch] },
                                    then: 10,
                                    else: 0
                                }
                            },
                            // Bonus por inicio de coincidencia
                            {
                                $cond: {
                                    if: { 
                                        $regexMatch: { 
                                            input: "$normalizedName", 
                                            regex: `^${normalizedSearch.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')}` 
                                        } 
                                    },
                                    then: 5,
                                    else: 0
                                }
                            }
                        ]
                    }
                }
            },
            {
                $sort: { similarity: -1 }
            },
            {
                $limit: limit
            },
            {
                $project: {
                    _id: 1,
                    name: 1,
                    firstName: 1,
                    lastName: 1,
                    fullName: 1,
                    similarity: 1,
                    // Incluir otros campos que necesites
                }
            }
        ];

        try {
            const results = await this.collection.aggregate(pipeline).toArray();
            return results;
        } catch (error) {
            console.error(`❌ Error buscando "${searchName}":`, error.message);
            return [];
        }
    }


	




}

 // Función para normalizar texto (quitar tildes, mayúsculas, caracteres especiales)
	function normalizeText(text) {
        if (!text) return '';
        return text
            .toString()
            .toLowerCase()
            .normalize('NFD')
            .replace(/[\u0300-\u036f]/g, '') // Quitar tildes
            .replace(/[^a-z0-9\s]/g, ' ') // Quitar caracteres especiales
            .replace(/\s+/g, ' ') // Múltiples espacios a uno
            .trim();
    }


	// Procesar registros en lotes con paralelización controlada
    async function processRecordsInBatches(records, batchSize = 100, concurrency = 10) {
        const results = [];
        const errors = [];
        
        console.log(`🚀 Iniciando procesamiento de ${records.length} registros`);
        console.log(`📦 Tamaño de lote: ${batchSize}, Concurrencia: ${concurrency}`);

        // Dividir registros en lotes
        const batches = [];
        for (let i = 0; i < records.length; i += batchSize) {
            batches.push(records.slice(i, i + batchSize));
        }

        // Procesar lotes con concurrencia controlada
        for (let i = 0; i < batches.length; i += concurrency) {
            const currentBatches = batches.slice(i, i + concurrency);
            
            const batchPromises = currentBatches.map(async (batch, batchIndex) => {
                const globalBatchIndex = i + batchIndex;
                console.log(`📊 Procesando lote ${globalBatchIndex + 1}/${batches.length} (${batch.length} registros)`);

                const batchResults = [];
                const batchErrors = [];

                // Crear consultas en paralelo para el lote actual
                const searchPromises = batch.map(async (record, recordIndex) => {
                    try {
                        const searchName = record.name || record.fullName || record.firstName + ' ' + record.lastName;
                        
                        if (!searchName || searchName.trim().length < 2) {
                            return {
                                originalRecord: record,
                                matches: [],
                                error: 'Nombre inválido o muy corto'
                            };
                        }

                        const matches = await searchSimilarNames(searchName, 5);
                        
                        return {
                            originalRecord: record,
                            matches: matches,
                            searchTerm: searchName,
                            matchCount: matches.length
                        };
                        
                    } catch (error) {
                        batchErrors.push({
                            record: record,
                            error: error.message,
                            index: globalBatchIndex * batchSize + recordIndex
                        });
                        
                        return {
                            originalRecord: record,
                            matches: [],
                            error: error.message
                        };
                    }
                });

                // Esperar a que termine el lote actual
                const batchResult = await Promise.all(searchPromises);
                batchResults.push(...batchResult);
                
                if (batchErrors.length > 0) {
                    console.warn(`⚠️  ${batchErrors.length} errores en lote ${globalBatchIndex + 1}`);
                }

                return { results: batchResults, errors: batchErrors };
            });

            // Esperar a que terminen todos los lotes de la iteración actual
            const iterationResults = await Promise.all(batchPromises);
            
            // Recopilar resultados
            iterationResults.forEach(({ results: batchResults, errors: batchErrors }) => {
                results.push(...batchResults);
                errors.push(...batchErrors);
            });

            // Mostrar progreso
            const processedCount = Math.min((i + concurrency) * batchSize, records.length);
            const progress = ((processedCount / records.length) * 100).toFixed(1);
            console.log(`✅ Progreso: ${processedCount}/${records.length} (${progress}%)`);
            
            // Pausa breve para evitar saturar la base de datos
            if (i + concurrency < batches.length) {
                await new Promise(resolve => setTimeout(resolve, 100));
            }
        }

        console.log(`🎉 Procesamiento completado!`);
        console.log(`✅ Registros procesados: ${results.length}`);
        console.log(`❌ Errores: ${errors.length}`);

        return { results, errors };
    }

	async function close() {
        if (this.client) {
            await this.client.close();
            console.log('🔐 Conexión MongoDB cerrada');
        }
    }




//la funcion que esta activa y funcionando y actualizada
async function getReportados_ver0(req, res) {
	
	let resultados = [];
	let datos = req.body['registros'];
	console.log('datos recibidos en el servidor: ', datos);
	let id_empresa = req.body['id_empresa'];
  
	for (const [index, element ] of datos.entries()) {

			let nit = element.identificacion;
			let nombreAlias = element.nombreAlias;

			// Función para normalizar texto (eliminar acentos)
			function normalizeText(text) {
				return text.normalize("NFD")
					.replace(/[\u0300-\u036f]/g, "")
					.trim();
			}

			// Divido la cadena de búsqueda y normalizo cada término
			const terminos = nombreAlias
			.split(' ')
			.map(term => normalizeText(term));

			// Escapar los términos
			let escapedTerms = terminos.map(t => {
			// Primero escapamos caracteres especiales
			const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');

			// Luego agregamos soporte para acentos en cada vocal
			return escaped
				.replace(/a/g, '[aáàâãä]')
				.replace(/e/g, '[eéèêë]')
				.replace(/i/g, '[iíìîï]')
				.replace(/o/g, '[oóòôõö]')
				.replace(/u/g, '[uúùûü]')
				.replace(/n/g, '[nñ]');
			});

			// Construir la expresión regular con límites de palabra
			let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");




			// //divido la cadena de busqueda
			// const terminos = nombreAlias.split(' ');
			// //escapar los terminos
			// let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
			// //let consulta_regexp = new RegExp(".*" + escapedTerms.join(".*") + ".*");
			// let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");


			
			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				let filtro = {
					firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				};
				const res_nombreAlias = await db.collection("lists").find(filtro).toArray();

				if (res_nombreAlias.length === 0) { //consulte por alias
					const consultaAlias = { aka: { $regex: new RegExp('.*' + nombreAlias + '.*', 'i') } }
					const res_Alias = await db.collection("lists").find(consultaAlias).toArray();

						if( res_Alias.length === 0) {
							sin_resultados(nit, nombreAlias, nombreAlias );
						} else {
							//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_Alias[0].firstNamelastName.toUpperCase());
							//res_Alias[0].coincidencia = coincidencia;
							res_Alias[0].el_primero = '1';

							res_Alias.forEach(element => {
								element.encontrado_por = '(Alias): ' + nombreAlias;
								let nombre = element.firstNamelastName;
								let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), nombre.toUpperCase());
								element.coincidencia = coincidencia;
								element.terminosBuscados = nombreAlias; //agrego el termino de busqueda
							});
							acumula_resultados(res_Alias);
						}
				} else {
					
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias[0].firstNamelastName.toUpperCase());
					res_nombreAlias[0].coincidencia = coincidencia;
					//res_nombreAlias[0].encontrado_por = '(Nombre): ' + nombreAlias;
					res_nombreAlias[0].el_primero = '1';
					
					res_nombreAlias.forEach(element => {
						element.encontrado_por = '(Nombre): ' + nombreAlias;
						let nombre = element.firstNamelastName;
						let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), nombre.toUpperCase());
						element.coincidencia = coincidencia;
						element.terminosBuscados = nombreAlias; //agrego el termino de busqueda
					});
					acumula_resultados(res_nombreAlias);
				}
			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos

				const res_nit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();

				if (res_nit.length === 0) {
				sin_resultados(nit, nombreAlias, nit );
				} else {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit[0].firstNamelastName.toUpperCase());
				res_nit[0].coincidencia = 1;
				//res_nit[0].encontrado_por = '(NIT): ' + nit;
				res_nit[0].el_primero = '1';
				res_nit.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //dado que el nit se busca completo dentro del campo
					element.terminosBuscados = nit; //agrego el termino de busqueda
				});
				acumula_resultados(res_nit);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos

				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
					]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos = await db.collection("lists").aggregate(pipeline).toArray();

				if (res_ambos.length === 0) {
				let nit_alias = nit + ' ' + nombreAlias;
				sin_resultados(nit, nombreAlias, nit_alias );
				} else {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_ambos[0].firstNamelastName.toUpperCase());
				res_ambos[0].coincidencia = 1;
				
				res_ambos[0].el_primero = '1';

				res_ambos.forEach(element => {
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						//element.encontrado_por = '(NIT_Alias): ' + nit;
						element.encontrado_por = '(NIT): ' + nit;
					} else {
						element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
					}
					//element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.coincidencia = 0.85;
					element.terminosBuscados = nit + ' / ' + nombreAlias; //pone los dos datos pues buesca por el uno o por el otro
				});
				//res_ambos[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
				acumula_resultados(res_ambos);
				}
			}


			/*
			//*********************lo busca en las listas personalizadas**********************
            */

			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				
				let filtro_personalizada = {
					$and: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i' } },
						{ empresa_id: id_empresa }
					]
				};
				
				const res_nombreAlias_personalizada = await db.collection("customlists").find(filtro_personalizada).toArray();
				
				if (res_nombreAlias_personalizada.length > 0) {
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias_personalizada[0].firstNamelastName.toUpperCase());
					res_nombreAlias_personalizada[0].coincidencia = coincidencia;
					//res_nombreAlias_personalizada[0].encontrado_por = '(Alias): ' + nombreAlias;

					res_nombreAlias_personalizada[0].el_primero = '1';

					res_nombreAlias_personalizada.forEach(element => {
						element.encontrado_por = '(Alias): ' + nombreAlias;
						element.terminosBuscados = nombreAlias;
					});

					acumula_resultados(res_nombreAlias_personalizada);
				}

			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos
				//const res_nit_personalizada = await db.collection("customlists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
				const res_nit_personalizada = await db.collection("customlists").find({
					$and: [
						{ 'idNumber': { '$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i' } },
						{ 'empresa_id': id_empresa }
					]
				}).toArray();

				if (res_nit_personalizada.length > 0) {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit_personalizada[0].firstNamelastName.toUpperCase());
				res_nit_personalizada[0].coincidencia = 1;
				//res_nit_personalizada[0].encontrado_por = '(NIT): ' + nit;

				res_nit_personalizada[0].el_primero = '1';

				res_nit_personalizada.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //pues lo encontró por nit y se presupone que la busqueda solo lo devuelve cuando lo encuentra
					element.terminosBuscados = nit;
				});

				acumula_resultados(res_nit_personalizada);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos
				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } },
					],
						$and: [
							{ empresa_id: id_empresa }
						]
					}
				},
				{
					$addFields: {
					  matchedBy: {
						$switch: {
							branches: [
								{
								  case: { $regexMatch: { input: "$idNumber", regex: new RegExp(`\\b${nit}\\b`, "i") } },
								  then: "idNumber"
								},
								{
								  case: { $regexMatch: { input: "$firstNamelastName", regex: consulta_regexp, options: "i" } },
								  then: "firstNamelastName"
								}
							  ],
						  default: "No match"  
						}
					  }
					} 
				  },
				  {
					$match: {
					  matchedBy: { $ne: "No match" }
					}
				  }
				];
				const res_ambos_personalizada = await db.collection("customlists").aggregate(pipeline).toArray();
				
				if (res_ambos_personalizada.length > 0) {
				let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_ambos_personalizada[0].firstNamelastName.toUpperCase());
				res_ambos_personalizada[0].coincidencia = coincidencia;
				//res_ambos_personalizada[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;

				res_ambos_personalizada[0].el_primero = '1';

				res_ambos_personalizada.forEach(element => {

					//se agrega nuevo
					if (element.matchedBy === 'firstNamelastName' ) {
						element.encontrado_por = '(Nombre): ' + ' ' + nombreAlias;
					} else if (element.matchedBy === 'idNumber' ) {
						element.encontrado_por = '(NIT): ' + nit;
					} else {
						element.encontrado_por = '(NIT / Nombre): ' + nit + ' ' + nombreAlias;
					}


					//fin se agreaga nuuevo
					//element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
					element.terminosBuscados = nit + ' / ' + nombreAlias;
				});

				acumula_resultados(res_ambos_personalizada);
				}
			}
			if (index === datos.length - 1) {	
				res.json(resultados);
			}

			

	}
  
	function acumula_resultados(respuesta) {
		if (respuesta[0].estado === 'Reportado') {
		  resultados.splice(0,0,...respuesta);
		} else {
		  resultados.push(...respuesta);
		}
	  //resultados.push(...respuesta);
	}
  
	function sin_resultados(nit, nombreAlias, encontrado_por) {
	  const sinResultados = [{
		firstNamelastName: nombreAlias,
		idNumber: nit,
		estado: 'No Reportado',
		coincidencia: 0,
		//encontrado_por: encontrado_por
		terminosBuscados: encontrado_por
	  }];
	  acumula_resultados(sinResultados);
	}
  

  }
  



async function getReportados_ver_01(req, res){

	let resultados = [];
	//var params = req.params;
	//var nombreAlias = params.nombreAlias;
	//var nit = params.nit;

	//let datos = JSON.parse(req.query['registros']);
		// let tipo_porcentaje = datos.tipo_porcentaje;
		// let id_empresa = datos.idEmpresa;
		// let clase_porcentaje = datos.clase_porcentaje;
	
		//console.log('lo recibido: ',JSON.parse(req.query['DATOS']));

		//let procesar = JSON.parse(req.query['DATOS']);

		//let procesar = JSON.parse(req.query['registros']);
		let procesar = req.body;


		procesar.forEach(async (element, index) => {
				let nombreAlias = element.nombreAlias;
				let nombreAliasParts = nombreAlias.split(' ');
						var i = 0;
						let queryString = [];
						nombreAliasParts.forEach(element => {
							queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
							i++;
						});
						
						const consulta ={
							"$and": queryString
						};

						let nit = element.identificacion.toString();
				
				if(nombreAlias !== '0' && nit !== '0'){


					try {
							const resultadoNit = await new Promise((resolve, reject) => {
								db.collection("lists")
								  .find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}})
								  .toArray()
								  .then((result) => {
									resolve(result);
								  })
								  .catch((error) => {
									reject(error);
								  });
							  });
							
							  resultadoNit.then((result) => {
								
								if (result.length === 0) {
									
								}
								
							  });
							// const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray()

							if(resultadoNit.length === 0){
								const resultadoNombre = await new Promise ((resolve,reject) => {
									db.collection("lists")
									.find(consulta)
									.toArray()
									.then((result) => {
										resolve(result);  
									})
									.catch((error) => {
										 reject(error);
									 });
								});

								if (resultadoNombre.length === 0) {
									//consulta por alias
									
									const resultadoAlias =  await new Promise ((resolve,reject) => {
										 db.collection("lists")
										 .find({'aka': { $regex: new RegExp(nombreAlias, 'i') }})
										 .toArray()
										 .then((result) => {
											 resolve(result);
										 })
										 .catch((error) => {
											 reject(error);
										 });
										});	

									if (resultadoAlias.length === 0) {
										// const noreportado = [{
										// 	firstNamelastName: nombreAlias,
										// 	idNumber: nit,
										// 	estado: "No Reportado",
										// 	encontrado_por: nombreAlias+'-'+nit,
										// 	coincidencia: 0
										// 	//terminoBusqueda: nombreAlias
										// }];
										//resultados.push(noreportado);
										// resultadoAlias.coincidencia = 0;
										// resultadoAlias.firstNamelastName = nombreAlias;
										// resultadoAlias.encontrado_por = '(Alias): '+ nombreAlias + nit
										// resultadoAlias.estado = 'No Reportado';
										resultados = acumula_resultados(resultadoAlias);

									} else {
										resultadoAlias[0].coincidencia = 100;
										resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
										//resultados.push(resultadoAlias);
										resultados = acumula_resultados(resultadoAlias);
										//res.json(resultadoAlias);
									}
								} else {
									let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoAlias[0].firstNamelastName.toUpperCase());
									resultadoNombre[0].coincidencia = coincidencia;
									resultadoNombre[0].encontrado_por = nombreAlias;
									//resultados.push(resultadoNombre);
									resultados = acumula_resultados(resultadoNombre);
									//console.log('nombre: ', resultadoNombre);
									//res.json(resultadoNombre);
								}
							}else{ //devuelve el resultado por nit pues lo encontró
								resultadoNit[0].encontrado_por = nit; 
								resultados = acumula_resultados(resultadoNit);
							}
						
					} catch (error) {
						//res.send(error);
					}
				} else {
					
					if(nombreAlias !== '0' && nit === '0'){
						//consulta por nombre alias

						try {
							const resultadoNombre = await new Promise((resolve, reject) => {
								 db.collection("lists")
									.find(consulta).toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
							});

							if (resultadoNombre.length === 0) {
								//lo busca en el campo del alias
								const resultadoAlias = await new Promise((resolve, reject) => {
								db.collection("lists")
									.find({'aka': { $regex: new RegExp(nombreAlias, 'i') }})
									.toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
								});

								if (resultadoAlias.length === 0) {
										const sinResultados =  [{
											firstNamelastName: nombreAlias,
											//idNumber: nit,
											estado: 'No Reportado',
											encontrado_por: nombreAlias,
											coincidencia: 0
										}];
										//resultados.push(sinResultados);
										sinResultados.coincidencia = 0;
										resultados =acumula_resultados(sinResultados);
									} else {
										resultadoAlias[0].coincidencia = 100;
										resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
										//res.json(resultadoAlias);
										//resultados.push(resultadoAlias);
										resultados = acumula_resultados(resultadoAlias);
									}
							} else { //devuelve lo encontrado al buscar en el campo firstnamelastName
								resultadoNombre[0].encontrado_por = 'Encontrado por Nombre: '+ nombreAlias;
								let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
								resultadoNombre[0].coincidencia = coincidencia;
								//resultados.push(resultadoNombre);
								resultados = acumula_resultados(resultadoNombre);
							}

						} catch (error) {
							//res.send(error);
						}
					} else {
						if(nit !== '0' && nombreAlias === '0'){
							try {

								const resultadoNit = await new Promise((resolve, reject) => {
									db.collection("lists")
									.find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}})
									.toArray()
									.then((result) => {
										resolve(result);
									})
									.catch((error) => {
										reject(error);
									});
								});

								if(resultadoNit.length === 0){
									const sinResultados =  [{
										firstNamelastName: nombreAlias,
										idNumber: nit,
										estado: 'No Reportado',
										encontrado_por: nit,
										coincidencia: 0
									}];
									sinResultados.coincidencia = 0;
									//res.json(arraySinResultados);
									//resultados.push(sinResultados);
									resultados = acumula_resultados(sinResultados);
								} else {
									resultadoNit[0].encontrado_por = 'Encontrado por NIT: ' + nit; 
									//resultadoNit[0].coincidencia = 100; //se poden 100 DADO QUE EL SOFTWARE LO BUSCA COMO NUMERO SOLITO E INDEPENDIENTE
									//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
									//resultadoNombre[0].coincidencia = coincidencia;
									//res.json(resultadoNit);
									//resultados.push(resultadoNit);
									resultados = acumula_resultados(resultadoNit);
								}
								
							} catch (error) {
								res.send(err);
							}
						}
					}
				}
				
				
				

				if(index === procesar.length-1) {

					//console.log('el arreglo final xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx',resultados, 'la longitud', resultados.length);
					res.json(resultados);
				  }

				
		});

		// function acumula_resultados(arreglo){
		// 	//console.log('el arreglo ha llegado a acumula ',arreglo, 'la longitud', arreglo.length);
			
		// 		resultados.push(arreglo);
			
			
		// 	return resultados;
		// }		
			
		

		//res.send(resultados);




	// let nombreAliasParts = nombreAlias.split(' ');
	// var i = 0;
	// let queryString = [];
	// nombreAliasParts.forEach(element => {
	// 	queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
	// 	i++;
	// });
	
	// const consulta ={
	// 	"$and": queryString
	// };

	// /*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
	// /******REVISAR los datos de una busqueda que no vienen con nit se estan yendo por aqui */

	// //busca si los dos datos tienen valores : nit y nombre alias
	// if(nombreAlias != '0' && nit != '0'){

	// 	try {
	// 		//consulta por nit
	// 		const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).toArray();
	// 			if(resultadoNit.length === 0){
	// 				const resultadoNombre = await db.collection("lists").find(consulta).toArray();
	// 				if (resultadoNombre.length === 0) {
	// 					//consulta por alias
	// 					const resultadoAlias = await db.collection("lists").find({
	// 						'aka': { $regex: new RegExp(nombreAlias, 'i') }
	// 					}).toArray();

	// 					if (resultadoAlias.length === 0) {
	// 						const noreportado = [{
	// 							firstNamelastName: nombreAlias,
	// 							idNumber: nit,
	// 							estado: "No Reportado",
	// 							encontrado_por: nombreAlias+'-'+nit,
	// 							coincidencia: 0
	// 							//terminoBusqueda: nombreAlias
	// 						}]
	// 						res.json(noreportado);

	// 					} else {
	// 						resultadoAlias[0].coincidencia = 100;
	// 						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
	// 						res.json(resultadoAlias);
	// 					}
	// 				} else {
	// 					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
	// 					resultadoNombre[0].coincidencia = coincidencia;
	// 					resultadoNombre[0].encontrado_por = nombreAlias;
	// 					res.json(resultadoNombre);
	// 				}
	// 			}else{
	// 				resultadoNit[0].encontrado_por = nit; 
	// 				res.json(resultadoNit);
	// 			}
			
	// 	} catch (error) {
	// 		res.send(error);
	// 	}
	// }else{
	// 	if(nombreAlias != '0' && nit === '0'){
	// 		//consulta por nombre alias

	// 		try {
	// 			const resultadoNombre = await db.collection("lists").find(consulta).toArray();
	// 			//console.log(resultadoNombre.length, resultadoNombre);

	// 			if (resultadoNombre.length === 0) {
	// 				//lo busca en el campo del alias
	// 				const resultadoAlias = await db.collection("lists").find({
	// 					'aka': { $regex: new RegExp(nombreAlias, 'i') }
	// 				  }).toArray();

	// 				 if (resultadoAlias.length === 0) {
	// 						const sinResultados =  {
	// 							firstNamelastName: nombreAlias,
	// 							//idNumber: nit,
	// 							estado: 'No Reportado',
	// 							encontrado_por: nombreAlias,
	// 							coincidencia: 0
	// 						}
	// 						const arraySinResultados = [sinResultados];
	// 						res.json(arraySinResultados);
	// 					} else {
	// 						resultadoAlias[0].coincidencia = 100;
	// 						resultadoAlias[0].encontrado_por = '(Alias): '+ nombreAlias; //almacena en el objeto por donde fue encontrado
	// 						res.json(resultadoAlias);
	// 					}
	// 			} else { //devuelve lo encontrado al buscar en el campo firstnamelastName
	// 				resultadoNombre[0].encontrado_por = 'Encontrado por Nombre: '+ nombreAlias;
	// 				let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), resultadoNombre[0].firstNamelastName.toUpperCase());
	// 				resultadoNombre[0].coincidencia = coincidencia;
	// 				//console.log('lo que envia al navegador: ', resultadoNombre);
	// 				res.json(resultadoNombre);
	// 			}

	// 		} catch (error) {
	// 			res.send(error);
	// 		}
	// 	}else
	// 		if(nit != '0' && nombreAlias === '0'){
	// 			try {

	// 				const resultadoNit = await db.collection("lists").find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).toArray();
	// 				if(resultadoNit.length === 0){
	// 					const sinResultados =  {
	// 						firstNamelastName: nombreAlias,
	// 						idNumber: nit,
	// 						estado: 'No Reportado',
	// 						encontrado_por: nit,
	// 						coincidencia: 0
	// 					}
	// 					const arraySinResultados = [sinResultados];
	// 					res.json(arraySinResultados);
	// 				}
	// 				resultadoNit[0].encontrado_por = 'Encontrado por NIT: ' + nit; 
	// 				res.json(resultadoNit);
					
	// 			} catch (error) {
	// 				res.send(err);
	// 			}
	// 		}
	// }
}

function saveSearchBMP(req, res){
	var entity = new Entity();

	var params = req.body;



	entity.empresa_id = params.empresa_id;
	entity.identificacion = params.identificacion;
	entity.nombreAlias = params.nombreAlias;
	entity.creado = params.fechaCreacion;
	entity.usuarioCrea = params.usuarioCrea;
	entity.tipoConsulta = params.tipoConsulta;

	//console.log(entity);
		//guarda el usuario
		entity.save((err, searchStored) => {
			if(err){
				//console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!searchStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: searchStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 


//de aqui para abajo tal vez no se usen estas funciones. Revisar

function saveSearchV2(req, res){
	var entity = new Entity();

	var params = req.body;

	//console.log(' estoy en save search V2');
	//console.log(params);

	entity.empresa_id = params.empresa_id;
	entity.identificacion = params.identificacion;
	entity.nombreAlias = params.nombreAlias;
	entity.creado = params.creado;
	entity.usuarioCrea = params.usuarioCrea;
	entity.tipoConsulta = params.tipoConsulta;

	//console.log(entity);
		//guarda el usuario
		entity.save((err, searchStored) => {
			if(err){
				//console.log(err);
				res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
			}else{
				if(!searchStored){
					res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
				}else{
					res.send({ id: searchStored._id });
				//	res.status(200).send({riskProfile: riskProfileStored});
				}
			}
		});
	


} 

function saveSearchV3(req, res){
	var entity = new Entity();

	var params = req.body;

	
	//console.log(params);
	// entity.empresa_id = params.empresa_id;
	// entity.identificacion = params.identificacion;
	// entity.nombreAlias = params.nombreAlias
	// entity.creado = params.creado;
	// entity.usuarioCrea = params.usuarioCrea;
	// entity.tipoConsulta = params.tipoConsulta;

	// //console.log("Soy entity" + entity);
	// 	//guarda el usuario
		// entity.save((err, searchStored) => {
		// 	if(err){
		// 		//console.log(err);
		// 		res.status(500).send({message: 'Error al guardar el perfil de riesgo'});
		// 	}else{
		// 		if(!searchStored){
		// 			res.status(404).send({message: 'No se ha guardado el perfil de riesgo'});
		// 		}else{
		// 			res.send({ id: searchStored._id });
		// 		//	res.status(200).send({riskProfile: riskProfileStored});
		// 		}
		// 	}
		// });
	
		//db.collection("searches").insertMany(params)
	if( params.length > 1 ){
		db.collection("searches").insertMany(params, function(err, result) {
			if (err) {
			  console.error('Error al insertar documentos', err);
			} else {
			  //console.log(`${result.insertedCount} documentos insertados correctamente`);
			  res.send({ estado: 'grabado' });
			}
		  });
		} else {
			db.collection("searches").insertOne(params, function(err, result) {
				if (err) {
				  console.error('Error al insertar documentos', err);
				} else {
				  //console.log(`${result.insertedCount} documentos insertados correctamente`);
				  res.send({ estado: 'grabado' });
				}
			  });
		}



} 


/***************************************************************/
/*  funcion para salvar cualquier registro en la base de datos****/
/*  Para adaptar:  (*), (*) ************************************/
/* *************************************************************/
function saveOneSearch(req, res){
	var entity = new Entity();
	var params = req.body;
	
	//(*)
	entity.nombre = params.nombre;
    entity.creado = new Date();
	entity.usuarioCrea = params.usuarioCrea;
		
		//graba la entidad en la base de datos
		//if(entity.nombre != null && user.apellido != null && user.username != null ){
		if(entity.nombre != null ){ //(*)
			//guarda la entidad
			entity.save((err, entityStored) => {
				if(err){
					res.status(500).send({message: 'Error al grabar en la base de datos'});
				}else{
					if(!entityStored){
						res.status(404).send({message: 'No se ha guardado la entidad en la base de datos'});
					}else{
						res.status(200).send({user: entityStored});
					}
				}
			});
		}else{
			res.status(200).send({message: 'Todos los campos son obligatorios'});
		}
} 



/********************************************************/
/*función para devolver UN registro de la base de datos**/
/*Esta función es usada para recueprar un registro dado */
/*que lo recupera y lo lleva al form de crear entity    */
/********************************************************/
function getEntity(req, res){
	var entityId = req.params.id;

	try {
		const entity = Entity.findById(entityId, function(err, result) { 
			if (err){
				res.send(err)
			}else{
				res.json(result);
			}
		}); 
	} catch (error) {
		res.status(400).send({message: 'Ha ocurrido un error en el controlador'});
	}
}


/*********************************************************/
/*función para ACTUALIZAR UNO de los registros ***********/
/*Esta función es usada para actualizar un registro dado */
/*********************************************************/
function updateEntity(req, res){
	var entityId = req.params.id;
	var update = req.body;

	Entity.findByIdAndUpdate(entityId, update, (err, entityUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar'});
		}else{
			if(!entityUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la base de datos'});
			}else{
				res.status(200).send({user: entityUpdated});
			}
		}
	})
}

/*********************************************************/
/** Función para ELIMINAR UNO de los registros ***********/
/** Esta función es usada para eliminar un registro dado */
/*********************************************************/
function deleteEntity(req, res){
	var entityId = req.params.id;
	
	try {
		Entity.findByIdAndDelete(entityId, function (err, entityRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(entityRemoved);
			}
		});
	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el registro'});
	}
}

async function getSearch(req, res){

	var fechaInicio = req.query.startDate;
	var fechaFin = req.query.endDate;
	//fechaFin = '2023-06-13T00:00:00.000Z'
	//fechaInicio = '2023-06-01T00:00:00.000Z'
	//console.log(fechaInicio);
	//console.log(fechaFin);

	const query = {};

  // Agregar campos a la consulta solo si tienen valores proporcionados
    query.creado = {
      $gte: new Date(fechaInicio),
      $lte: new Date(fechaFin)
    };
 

	try {
			
		const report = Entity.find(query, function(err, report) { 
			if (err){
				res.send(err)
			}else{
				res.json(report);
			}
		}); 
	//	console.log("Las consultas encontradas "+report);

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el servicio de consultas' + req + planId});
	}

}


async function getSearchCount(req, res) {
	
	let datos = JSON.parse(req.query['DATOS']);

	var fechaInicio = datos['startDate'];
	var fechaFin = datos['endDate'];
	var role =datos['elRole'];
	var idEmpresa = datos['idEmpresa'];
  
	var query = {};
	
  
	// devuelve todos los registros de una si  las dos fechas vienen con valor 0
	// if (fechaFin === 0 && fechaInicio === 0) {
	// 	console.log("entro cuando fechas valen 0");
	// 	query = { empresa_id: idEmpresa };
	// 	console.log('el valoir de query es ' + query);
	// }
	
//original

	if (role === "SuperAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
		 query = {
			creado: {
			  $gte: new Date(fechaInicio),
			  $lte: new Date(fechaFin),
			}
		  };
	} else if (role === "EmpresaAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
		 query = {
			$and: [
				{ creado: { $gte: new Date(fechaInicio), $lte: new Date(fechaFin) } },
				{ empresa_id: idEmpresa }
			]
		  };
	}

	try {
	  const report = await Entity.aggregate([
		{
			$match: query // Aplicar el filtro en la etapa de agregación usando 
		},
		{
		  $group: {
			_id: '$empresa_id',
			count: { $sum: 1 }
		  }
		}
	  ]).exec();
  
	//fin original

	// if (role === "SuperAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
	// 	query = {
	// 		creado: {
	// 			$gte: new Date(fechaInicio),
	// 			$lte: new Date(fechaFin),
	// 		},
	// 	};
	// } else if (role === "EmpresaAdmin" && fechaFin !== 0 && fechaInicio !== 0) {
	// 	// Para Empresa, construye un pipeline que combine ambas colecciones
	// 	const entityQuery = {
	// 		creado: { $gte: new Date(fechaInicio), $lte: new Date(fechaFin) },
	// 		empresa_id: idEmpresa,
	// 	};
	
	// 	const restQuery = {
	// 		creado: { $gte: new Date(fecha_de_grabacion), $lte: new Date(fecha_de_grabacion) },
	// 		empresa_id: idEmpresa, // Suponemos que 'rest' tiene el mismo campo 'empresa_id'
	// 	};
	
	// 	// Pipeline personalizado para Empresa
	// 	const pipeline = [
	// 		// Primero filtra los registros de 'Entity'
	// 		{ $match: entityQuery },
	// 		// Combina con los registros de 'rest' que cumplan las mismas condiciones
	// 		{
	// 			$unionWith: {
	// 				coll: 'apirest',
	// 				pipeline: [{ $match: restQuery }], // Filtros para 'rest'
	// 			},
	// 		},
	// 		// Agrupa por 'empresa_id' y cuenta todos los registros (de ambas colecciones)
	// 		{
	// 			$group: {
	// 				_id: '$empresa_id',
	// 				count: { $sum: 1 },
	// 			},
	// 		},
	// 	];
	
	// 	try {
	// 		const report = await Entity.aggregate(pipeline).exec();
	// 		res.json(report);
	// 		// ...
	// 	} catch (err) {
	// 		// Manejo de errores
	// 	}
	// } else {
	// 	// Otros casos (sin fecha o rol no válido)
	// 	// ...
	// }
	  
	res.json(report);
	
	} catch (err) {
	 // console.error("Error al realizar la agregación:", err);
	  res.status(500).send({ message: "Error al realizar la agregación" });
	}

}	


   //*******************************************************************************************************/
   // Jaro Winkler para comparar dos cadenas
   // Additional notes
   /*******************************************************************************************************/




/* esta funciona ien*/

//   function jaroWinklerf(s1, s2) {
// 	const maxLength = Math.max(s1.length, s2.length);
//   if (maxLength === 0) {
//     return 1; // Si ambas cadenas están vacías, la distancia es 1.
//   }

//   // Calcula la distancia de Jaro
//   function jaroDistance(s1, s2) {
//     const m = s1.length;
//     const n = s2.length;

//     if (m === 0 || n === 0) return 0;

//     const maxDistance = Math.floor(Math.max(m, n) / 2) - 1;
//     const matches = Array(n).fill(false);

//     let matchingCount = 0;

//     for (let i = 0; i < m; i++) {
//       const start = Math.max(0, i - maxDistance);
//       const end = Math.min(i + maxDistance + 1, n);

//       for (let j = start; j < end; j++) {
//         if (!matches[j] && s1[i] === s2[j]) {
//           matches[j] = true;
//           matchingCount++;
//           break;
//         }
//       }
//     }

//     if (matchingCount === 0) return 0;

//     let transpositions = 0;
//     let j = 0;

//     for (let i = 0; i < m; i++) {
//       if (!matches[j]) {
//         j++;
//         continue;
//       }
//       if (s1[i] !== s2[j]) transpositions++;
//       j++;
//     }

//     const m1 = matchingCount;
//     const m2 = transpositions / 2;

//     return (m1 / m + m1 / n + (m1 - m2) / m1) / 3;
//   }

//   const jaroDist = jaroDistance(s1, s2);

//   // Calcula el factor de Winkler
//   const prefixLength = 4; // Longitud máxima para considerar como prefijo
//   let commonPrefix = 0;

//   for (let i = 0; i < prefixLength && i < Math.min(s1.length, s2.length); i++) {
//     if (s1[i] === s2[i]) commonPrefix++;
//     else break;
//   }

//   const winklerFactor = 0.1;
//   const jaroWinklerDist = jaroDist + commonPrefix * winklerFactor * (1 - jaroDist);

//   return Math.min(jaroWinklerDist, 1); // Asegura que la distancia no sea mayor que 1.
//   }


  function jaroWinklerf(s1, s2){
	let dist = distance(s1,s2);

	return dist;
	
  }

module.exports = {
	saveSearch,
	updateEntity,
	getReportados,
	//getReportadosPerfilada,
	getEntity,
	deleteEntity,
	saveOneSearch,
	saveSearchV2,
	saveSearchV3,
	getSearch,
	getSearchCount,
	saveSearchBMP
};