'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');

const _ = require('lodash');

//para poder importar archivos de excel de +-50000 registros
//var express = require('express');
//var app = express();
//var bodyParser = require('body-parser');
//app.use(bodyParser.json({limit: "100mb", extended: true}));


//app.use(express.json({limit: '100mb'}));
//app.use(express.urlencoded({limit: '100mb'}));

//app.use(bodyParser.urlencoded({limit: "100mb", extended: true, parameterLimit:100000}));

//app.use(bodyParser.json({limit: '10mb', extended: true}))
//app.use(bodyParser.urlencoded({limit: '10mb', extended: true}))




var bcrypt = require('bcrypt-nodejs');
var Transaction = require('../models/transaction');

var jwt = require('../services/jwt');
const { Console } = require('console');
const { db } = require('../models/transaction');
const api = require('../routes/transaction');
//const transaction = require('../models/transaction');

//Para consultar el perfil de riesgo
var RiskProfile = require('../models/riskProfile');
const { query } = require('express');

var List = require('../models/list');
const { Collection } = require('mongoose');
const { uploadImage } = require('./user');
const { json } = require('body-parser');
 


/************************************************* */
/* Funcion para salvar en la base de datos los */
/* registros leidos desde una  */ 
/* hoja de excel para el módulo transaccional */
/************************************************* */

function saveTransactionExcel(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	
	var params = req.body;

	var transaction = new Transaction();

	db.collection("transactions").insertMany(params, function (err, result) {
		if (err) throw err;
		let cantidad_insertados = result.insertedCount ;
		res.send({cantidad_insertados});
	});

	
}


//***** Borra registros de una coleccion recibiendoo una fecha. La de creado */
function deleteTransactionExcel(req, res){

	orden = req.params;
	db.collection("transactions").deleteMany(orden)

}
			


function saveTransaction(req, res){

				var transaction = new Transaction();
			
				var params = req.body;
				
				transaction.empresa_id = params.empresa_id;
				transaction.nit = params.nit;
				transaction.nombreTransaccion = params.nombreTransaccion;
				transaction.montoTransaccion = params.montoTransaccion;
				transaction.fechaTransaccion = params.fechaTransaccion;
				
				transaction.creado = new Date();
			
			
							if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
								//guarda el usuario
								transaction.save((err, transactionStored) => {
									if(err){
										res.status(500).send({message: 'Error al guardar la transacción'});
									}else{
										if(!transactionStored){
											res.status(404).send({message: 'NO se ha guardado la transacción'});
										}else{
											res.status(200).send({transaction: transactionStored});
										}
									}
								});
							}else{
								res.status(200).send({message: 'Rellena todos los campos por favor'});
							}
			
}



function updateTransaction(req, res){
	var transactionId = req.params.id;
	var update = req.body;

	transaction.findByIdAndUpdate(transactionId, update, (err, transactionUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar la transaccion'});
		}else{
			if(!transactionUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la transaccion'});
			}else{
				res.status(200).send({user: transactionUpdated});
			}
		}


	})

}


function saveExcelTransaction(req, res){
	var transaction = new Transaction();
	var params = req.body;
	
	
}

/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada. Devuelve el promedio y la desv standard
/********************************************************/
//funciona ok, devuelve los adtos sin problema
//para el calculo de transaccional solo se usa esta funcion, no se llama ninguna otra desde frontend
async function getTransactions(req, res){
	
	console.log('llegó a getTransactions en el controlador');
	var datos = req.params.id_grabacion;

  //xplode datos
  //en datos viene el id de grabacion y el numero de desviaciones para calcular el monto estadistico
  //viene asi: 534fa0f-0319-4a9f-9a78-7a8096b7442c,1

  var datos1 = datos.split(',');
  let id_grabacion = datos1[0];
  let numDesviaciones = datos1[1];

  let montos = [];
  //calcula la mediana de los resultados
  montos = await Transaction.find({idGrabacion: id_grabacion}).select('montoTransaccion').lean();
montos = montos.map(doc => doc.montoTransaccion);


  let mediana =  calcularMediana(montos);
 function calcularMediana(numeros) {
		// Primero, ordenamos el array de números
		const ordenados = numeros.slice().sort(function(a, b) {
		return a - b;
		});
		
		const longitud = ordenados.length;
		const mitad = Math.floor(longitud / 2);
	
		// Si la longitud es impar, la mediana es el número del medio
		if (longitud % 2 !== 0) {
		return ordenados[mitad];
		}
		
		// Si la longitud es par, la mediana es el promedio de los dos números del medio
		return (ordenados[mitad - 1] + ordenados[mitad]) / 2;
  }
  


// Transaction.aggregate([
//     // { $match: {idGrabacion: id_grabacion}},
//     // { $group: {
//     //   _id: {nit: '$nit'},
//     //   //promedio: { $avg: '$montoTransaccion'}, 
// 	//   promedio: { $avg: '$montoTransaccion'}, 
//     //   devStd: {$stdDevSamp: '$montoTransaccion'},
//     //   count: {$sum: 1}, 
//     //   nombreTransaccion: { $first: '$nombreTransaccion' }}

// 	{ $match: { idGrabacion: id_grabacion } },
// 	{ $group: {
// 	  _id: { nit: '$nit' },
// 	  montoTransacciones: { $push: '$montoTransaccion' }, // Agrupar los montos en un array
// 	  devStd: { $stdDevSamp: '$montoTransaccion' }, // Mantener la desviación estándar
// 	  count: { $sum: 1 },
// 	  nombreTransaccion: { $first: '$nombreTransaccion' }
// 	}},
// 	{ $unwind: '$montoTransacciones' }, // Descomprimir el array
// 	{ $sort: { montoTransacciones: 1 } }, // Ordenar los montos
// 	{ $group: {
// 		_id: '$_id',
// 		montoTransacciones: { $push: '$montoTransacciones' }, // Volver a agrupar los montos
// 		devStd: { $first: '$devStd' }, // Mantener la desviación estándar
// 		count: { $first: '$count' },
// 		nombreTransaccion: { $first: '$nombreTransaccion' }
// 	}},
// 	{
// 	  $addFields: {
// 		promedio: {
// 			$function: {
// 			  body: function(montos) {
// 				montos.sort((a, b) => a - b);
// 				const middleIndex = Math.floor(montos.length / 2);
// 				return montos.length % 2 === 0
// 				  ? (montos[middleIndex - 1] + montos[middleIndex]) / 2
// 				  : montos[middleIndex];
// 			  },
// 			  args: ['$montoTransacciones'],
// 			  lang: 'js'
// 			}
// 		  }
// 		}

// 	}]).exec(async (err, transaccion) => {
// 		if(err){
// 			//console.log(err.message);
// 		}else{
// 			if(transaccion.length > 0){
// 				//calcula el monto estadistico sobre los resultados devueltos
// 				//asignando una nueva propiedad al objeto llamada maxTope
// 				//hasta aqui los calculos de promedio y descviancion estandar estan bien
			
				

// 			transaccion.forEach((element, index) => {
// 				let maxTope = element.promedio + (element.devStd * numDesviaciones);
// 				transaccion[index] = {...element, montoEstadistico: maxTope}; //asignando la nueva propiedad maxTope; agrega un nuevo campo
// 			});

// 		//sigue bien calculado	
//        //ahora con los datos anteriores buscamos los registros cuyos montos esten por encima del monto estadistico

// 	   for (const [index, element] of transaccion.entries()) {
// 		try {
// 		  const transaccionExcedeMonto = await Transaction.find({
// 			idGrabacion: id_grabacion,
// 			"montoTransaccion": { "$gt": element.montoEstadistico },
// 			"nit": element._id['nit']
// 		  }).exec();
	  
// 		  if (transaccionExcedeMonto.length > 0) {
// 			transaccion[index] = {
// 			  ...element,
// 			  montoTransaccion: transaccionExcedeMonto[0].montoTransaccion,
// 			  fechaTransaccion: transaccionExcedeMonto[0].fechaTransaccion.toISOString().slice(0, 10)
// 			};
// 		  }
// 		} catch (err) {
// 		  console.log(err.message);
// 		}
// 	  }
      
       
//        //Consultamos cada uno de los resultados en la tabla de lists para saber si estan resportados
//        for ( const [index, element ] of transaccion.entries()) {
//             let maxTope = element.maxTope;
//             let idNumber = element._id.nit;
// 			let nombre = element.nombreTransaccion; //nombre de la persona que hace la transacción

// 			await  consultaLista_id(idNumber) //verifica si esta reportado
// 				.then( async resultadoLista => {
// 					if(resultadoLista.length > 0){
// 						transaccion[index] = {...element, estado: resultadoLista[0]['estado'] + ' ' + 'ID'};
// 					} else { //busque el nombre
// 						await consultaLista_nombre(nombre) //verifica si esta reportado por nombre
// 							.then( resultadoNombre => {
// 								if(resultadoNombre.length > 0){
// 									transaccion[index] = {...element, estado: resultadoNombre[0]['estado'] + ' ' + '(Homónimo)'};
// 								} else {
// 									transaccion[index] = {...element, estado: 'No Registrado'};
// 								}
// 							}) 
// 							//transaccion[index] = {...element, estado: 'No Registra'};
// 					}
// 					});
//        }

//        //consultamos cada uno de los resultados anteriores en la tabla riskProfiles para saber si tiene perfil
//        for ( const [index, element ] of transaccion.entries()) {
//         	let idNumber = element._id.nit;
// 			let nombre = element.nombreTransaccion;

// 			await  consultaPerfil_id(idNumber) //verifica si esta reportado
// 				.then(async resultadoPerfil => {

// 					if(resultadoPerfil.length > 0){
// 						//console.log('los valores encontrados..', resultadoPerfil)
// 						if ( resultadoPerfil[0]['perfilRiesgo'] === '' || resultadoPerfil[0]['perfilRiesgo'] === undefined || resultadoPerfil[0]['perfilRiesgo'] === null) {
// 							transaccion[index] = {...element, perfil_riesgo: 'No Definido' + ' (ID)', 
// 							rango_salarial: resultadoPerfil[0]['rango_salarial'], 
// 							patrimonio_liquido: resultadoPerfil[0]['patrimonio_liquido'],} 
// 						} else {
// 						transaccion[index] = {...element, perfil_riesgo: resultadoPerfil[0]['perfilRiesgo'] + ' (ID)', 
// 							rango_salarial: resultadoPerfil[0]['rango_salarial'], 
// 							patrimonio_liquido: resultadoPerfil[0]['patrimonio_liquido'],};
// 						}
// 						//transaccion[index] = {...element, estado: resultadoPerfil[0]['estado'] + ' ' + 'ID'};
// 					} else { //busque por nombre
// 						await consultaPerfil_nombre(nombre) //verifica si esta reportado por nombre
// 							.then( resultadoNombrePerfil => {
// 								if(resultadoNombrePerfil.length > 0){
// 									if (resultadoNombrePerfil[0]['perfilRiesgo'] === '' || resultadoNombrePerfil[0]['perfilRiesgo'] === undefined || resultadoNombrePerfil[0]['perfilRiesgo'] === null ) {
// 										transaccion[index] = {...element, perfil_riesgo: 'No Definido' + ' ' + '(Homónimo)'};
// 									} else {
// 										transaccion[index] = {...element, perfil_riesgo: resultadoNombrePerfil[0]['perfilRiesgo'] + ' ' + '(Homónimo)'};
// 									}
// 								} else {
// 									transaccion[index] = {...element, perfil_riesgo: 'No Registrado'};
// 								}
// 							});
// 						//transaccion[index] = {...element, perfil_riesgo: 'No Registra'};
// 					}
// 				});


//        }

// 	   const datos_reportados = transaccion.filter(item => item.estado === 'Reportado');
// 	   const datos_reportados_adicionales_nombre = transaccion.filter(item => item.estado === 'Reportado (Homónimo)');
// 	   const datos_reportados_adicionales_id = transaccion.filter(item => item.estado === 'Reportado ID');

// 	   const datos_no_reportados = transaccion.filter(item => item.estado !== 'Reportado' && item.estado !== 'Reportado (Homónimo)' && item.estado !== 'Reportado ID');
// 	   //const datos_alertados_por_transaccion = datos_no_reportados.filter(item => item.montoTransaccion > 0 );
// 	   const datos_alertados_por_transaccion = datos_no_reportados
// 			.filter(item => parseFloat(item.montoTransaccion) > 0)
// 			.sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));

// 	//const datos_ordenados = datos_alertados_por_transaccion.sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));
			
// 	   const datos_restantes = datos_no_reportados.filter(item => item.montoTransaccion === undefined || item.montoTransaccion === null || 
// 			item.montoTransaccion === 0 || item.montoTransaccion === '' );

// 			let respuesta =  datos_reportados.concat( datos_reportados_adicionales_nombre, datos_reportados_adicionales_id, datos_alertados_por_transaccion, datos_restantes);

       
// 				res.status(200).send(respuesta);
// 			}
// 		}
// } );
// }














//VERSION 02 QUE CREÍA QUE FUNCIONABA
// Pipeline de agregación optimizado
// const transaccionesResult = await Transaction.aggregate([
//   { $match: { idGrabacion: id_grabacion } },
//   { 
//     $group: {
//       _id: { nit: '$nit' },
//       montoTransacciones: { $push: '$montoTransaccion' }, // Mantener valores originales
//       devStd: { $stdDevSamp: { $toDouble: '$montoTransaccion' } }, // Solo convertir para el cálculo estadístico
//       count: { $sum: 1 },
//       nombreTransaccion: { $first: '$nombreTransaccion' }
//     }
//   },
//   {
//     $addFields: {
//       promedio: {
//         $function: {
//           body: function(montos) {
//             // Convertir a números dentro de la función para el cálculo de mediana
//             const numericMontos = montos.map(m => parseFloat(m)).filter(m => !isNaN(m));
//             const sorted = numericMontos.sort((a, b) => a - b);
//             const mid = Math.floor(sorted.length / 2);
//             return sorted.length % 2 === 0
//               ? (sorted[mid - 1] + sorted[mid]) / 2
//               : sorted[mid];
//           },
//           args: ['$montoTransacciones'],
//           lang: 'js'
//         }
//       }
//     }
//   },
//   {
//     $addFields: {
//       montoEstadistico: {
//         $add: [
//           '$promedio', 
//           { 
//             $multiply: [
//               { $ifNull: [{ $toDouble: '$devStd' }, 0] }, 
//               { $toDouble: numDesviaciones }
//             ] 
//           }
//         ]
//       }
//     }
//   }
// ]).exec();

// if (transaccionesResult.length > 0) {
//   // Extraer NITs y nombres únicos
//   const nits = [...new Set(transaccionesResult.map(t => t._id.nit))];
//   const nombres = [...new Set(transaccionesResult.map(t => t.nombreTransaccion))];

//   // Función helper para procesar en lotes con límite de concurrencia
//   const processBatch = async (items, batchSize, processor) => {
//     const results = [];
//     for (let i = 0; i < items.length; i += batchSize) {
//       const batch = items.slice(i, i + batchSize);
//       const batchResults = await Promise.all(batch.map(processor));
//       results.push(...batchResults);
//     }
//     return results;
//   };

//   // Procesar consultas en lotes pequeños (máximo 10 consultas simultáneas)
//   const BATCH_SIZE = 10;

//   const [
//     transaccionesExcedentes,
//     listasIdResults,
//     listasNombreResults,
//     perfilesIdResults,
//     perfilesNombreResults
//   ] = await Promise.all([
//     // Consulta única de transacciones excedentes
//     Transaction.find({
//       idGrabacion: id_grabacion,
//       nit: { $in: nits }
//     }).sort({ nit: 1, montoTransaccion: -1 }).exec(),

//     // Procesar listas por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaLista_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar listas por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaLista_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaPerfil_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaPerfil_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     })
//   ]);

//   // Crear mapas para acceso eficiente
//   const transaccionesExcedentesMap = new Map();
//   transaccionesExcedentes.forEach(t => {
//     const nit = t.nit;
//     if (!transaccionesExcedentesMap.has(nit)) {
//       transaccionesExcedentesMap.set(nit, []);
//     }
//     transaccionesExcedentesMap.get(nit).push(t);
//   });

//   const listasIdMap = new Map(
//     listasIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const listasNombreMap = new Map(
//     listasNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   const perfilesIdMap = new Map(
//     perfilesIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const perfilesNombreMap = new Map(
//     perfilesNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   // Procesar transacciones con los datos precargados
//   const transaccion = transaccionesResult.map((element) => {
//     const nit = element._id.nit;
//     const nombre = element.nombreTransaccion;
//     let resultado = { ...element };

//     // Buscar transacción que excede el monto estadístico
//     const transaccionesDelNit = transaccionesExcedentesMap.get(nit) || [];
//     const transaccionExcedente = transaccionesDelNit.find(t => 
//       parseFloat(t.montoTransaccion) > parseFloat(element.montoEstadistico)
//     );

//     if (transaccionExcedente) {
//       resultado.montoTransaccion = transaccionExcedente.montoTransaccion;
//       resultado.fechaTransaccion = transaccionExcedente.fechaTransaccion.toISOString().slice(0, 10);
//     }

//     // Asignar estado de lista
//     const listaId = listasIdMap.get(nit);
//     const listaNombre = listasNombreMap.get(nombre);
    
//     if (listaId) {
//       resultado.estado = `${listaId.estado} ID`;
//     } else if (listaNombre) {
//       resultado.estado = `${listaNombre.estado} (Homónimo)`;
//     } else {
//       resultado.estado = 'No Registrado';
//     }

//     // Asignar perfil de riesgo
//     const perfilId = perfilesIdMap.get(nit);
//     const perfilNombre = perfilesNombreMap.get(nombre);
    
//     if (perfilId) {
//       const perfilRiesgo = perfilId.perfilRiesgo && 
//                           perfilId.perfilRiesgo !== '' && 
//                           perfilId.perfilRiesgo !== null && 
//                           perfilId.perfilRiesgo !== undefined 
//                           ? perfilId.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (ID)`;
//       resultado.rango_salarial = perfilId.rango_salarial;
//       resultado.patrimonio_liquido = perfilId.patrimonio_liquido;
//     } else if (perfilNombre) {
//       const perfilRiesgo = perfilNombre.perfilRiesgo && 
//                           perfilNombre.perfilRiesgo !== '' && 
//                           perfilNombre.perfilRiesgo !== null && 
//                           perfilNombre.perfilRiesgo !== undefined 
//                           ? perfilNombre.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (Homónimo)`;
//     } else {
//       resultado.perfil_riesgo = 'No Registrado';
//     }

//     return resultado;
//   });

//   // Clasificar resultados finales
//   const datos_reportados = transaccion.filter(item => item.estado === 'Reportado');
//   const datos_reportados_adicionales_nombre = transaccion.filter(item => item.estado === 'Reportado (Homónimo)');
//   const datos_reportados_adicionales_id = transaccion.filter(item => item.estado === 'Reportado ID');

//   const datos_no_reportados = transaccion.filter(item => 
//     item.estado !== 'Reportado' && 
//     item.estado !== 'Reportado (Homónimo)' && 
//     item.estado !== 'Reportado ID'
//   );

//   const datos_alertados_por_transaccion = datos_no_reportados
//     .filter(item => item.montoTransaccion && parseFloat(item.montoTransaccion) > 0)
//     .sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));

//   const datos_restantes = datos_no_reportados.filter(item => 
//     !item.montoTransaccion || 
//     item.montoTransaccion === null || 
//     parseFloat(item.montoTransaccion) === 0 || 
//     item.montoTransaccion === ''
//   );

//   const respuesta = datos_reportados.concat(
//     datos_reportados_adicionales_nombre,
//     datos_reportados_adicionales_id,
//     datos_alertados_por_transaccion,
//     datos_restantes
//   );

//   res.status(200).send(respuesta);
// } else {
//   res.status(200).send([]);
// }
// }



//VERSION 03
// Pipeline de agregación optimizado
// const transaccionesResult = await Transaction.aggregate([
//   { $match: { idGrabacion: id_grabacion } },
//   { 
//     $group: {
//       _id: { nit: '$nit' },
//       montoTransacciones: { $push: '$montoTransaccion' }, // Mantener valores originales
//       devStd: { $stdDevSamp: { $toDouble: '$montoTransaccion' } }, // Solo convertir para el cálculo estadístico
//       count: { $sum: 1 },
//       nombreTransaccion: { $first: '$nombreTransaccion' }
//     }
//   },
//   {
//     $addFields: {
//       promedio: {
//         $function: {
//           body: function(montos) {
//             // Convertir a números dentro de la función para el cálculo de mediana
//             const numericMontos = montos.map(m => parseFloat(m)).filter(m => !isNaN(m));
//             const sorted = numericMontos.sort((a, b) => a - b);
//             const mid = Math.floor(sorted.length / 2);
//             return sorted.length % 2 === 0
//               ? (sorted[mid - 1] + sorted[mid]) / 2
//               : sorted[mid];
//           },
//           args: ['$montoTransacciones'],
//           lang: 'js'
//         }
//       }
//     }
//   },
//   {
//     $addFields: {
//       montoEstadistico: {
//         $add: [
//           '$promedio', 
//           { 
//             $multiply: [
//               { $ifNull: [{ $toDouble: '$devStd' }, 0] }, 
//               { $toDouble: numDesviaciones }
//             ] 
//           }
//         ]
//       }
//     }
//   }
// ]).exec();

// if (transaccionesResult.length > 0) {
//   // Extraer NITs y nombres únicos
//   const nits = [...new Set(transaccionesResult.map(t => t._id.nit))];
//   const nombres = [...new Set(transaccionesResult.map(t => t.nombreTransaccion))];

//   // Función helper para procesar en lotes con límite de concurrencia
//   const processBatch = async (items, batchSize, processor) => {
//     const results = [];
//     for (let i = 0; i < items.length; i += batchSize) {
//       const batch = items.slice(i, i + batchSize);
//       const batchResults = await Promise.all(batch.map(processor));
//       results.push(...batchResults);
//     }
//     return results;
//   };

//   // Procesar consultas en lotes pequeños (máximo 10 consultas simultáneas)
//   const BATCH_SIZE = 10;

//   const [
//     transaccionesExcedentes,
//     listasIdResults,
//     listasNombreResults,
//     perfilesIdResults,
//     perfilesNombreResults
//   ] = await Promise.all([
//     // Consulta única de transacciones excedentes
//     Transaction.find({
//       idGrabacion: id_grabacion,
//       nit: { $in: nits }
//     }).sort({ nit: 1, montoTransaccion: -1 }).exec(),

//     // Procesar listas por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaLista_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar listas por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaLista_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaPerfil_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaPerfil_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     })
//   ]);

//   // Crear mapas para acceso eficiente
//   const transaccionesExcedentesMap = new Map();
//   transaccionesExcedentes.forEach(t => {
//     const nit = t.nit;
//     if (!transaccionesExcedentesMap.has(nit)) {
//       transaccionesExcedentesMap.set(nit, []);
//     }
//     transaccionesExcedentesMap.get(nit).push(t);
//   });

//   const listasIdMap = new Map(
//     listasIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const listasNombreMap = new Map(
//     listasNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   const perfilesIdMap = new Map(
//     perfilesIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const perfilesNombreMap = new Map(
//     perfilesNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   // Procesar transacciones con los datos precargados
//   const transaccion = transaccionesResult.map((element) => {
//     const nit = element._id.nit;
//     const nombre = element.nombreTransaccion;
    
//     // Calcular maxTope (igual que en código original)
//     let maxTope = element.promedio + (element.devStd * numDesviaciones);
//     let resultado = { ...element, maxTope: maxTope }; // Asignar maxTope como en el original

//     // Buscar transacción que excede el monto estadístico
//     const transaccionesDelNit = transaccionesExcedentesMap.get(nit) || [];
//     const transaccionExcedente = transaccionesDelNit.find(t => 
//       parseFloat(t.montoTransaccion) > parseFloat(element.montoEstadistico)
//     );

//     if (transaccionExcedente) {
//       resultado.montoTransaccion = transaccionExcedente.montoTransaccion;
//       resultado.fechaTransaccion = transaccionExcedente.fechaTransaccion.toISOString().slice(0, 10);
//     }

//     // Asignar estado de lista
//     const listaId = listasIdMap.get(nit);
//     const listaNombre = listasNombreMap.get(nombre);
    
//     if (listaId) {
//       resultado.estado = `${listaId.estado} ID`;
//     } else if (listaNombre) {
//       resultado.estado = `${listaNombre.estado} (Homónimo)`;
//     } else {
//       resultado.estado = 'No Registrado';
//     }

//     // Asignar perfil de riesgo
//     const perfilId = perfilesIdMap.get(nit);
//     const perfilNombre = perfilesNombreMap.get(nombre);
    
//     if (perfilId) {
//       const perfilRiesgo = perfilId.perfilRiesgo && 
//                           perfilId.perfilRiesgo !== '' && 
//                           perfilId.perfilRiesgo !== null && 
//                           perfilId.perfilRiesgo !== undefined 
//                           ? perfilId.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (ID)`;
//       resultado.rango_salarial = perfilId.rango_salarial;
//       resultado.patrimonio_liquido = perfilId.patrimonio_liquido;
//     } else if (perfilNombre) {
//       const perfilRiesgo = perfilNombre.perfilRiesgo && 
//                           perfilNombre.perfilRiesgo !== '' && 
//                           perfilNombre.perfilRiesgo !== null && 
//                           perfilNombre.perfilRiesgo !== undefined 
//                           ? perfilNombre.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (Homónimo)`;
//     } else {
//       resultado.perfil_riesgo = 'No Registrado';
//     }

//     return resultado;
//   });

//   // Clasificar resultados finales
//   const datos_reportados = transaccion.filter(item => item.estado === 'Reportado');
//   const datos_reportados_adicionales_nombre = transaccion.filter(item => item.estado === 'Reportado (Homónimo)');
//   const datos_reportados_adicionales_id = transaccion.filter(item => item.estado === 'Reportado ID');

//   const datos_no_reportados = transaccion.filter(item => 
//     item.estado !== 'Reportado' && 
//     item.estado !== 'Reportado (Homónimo)' && 
//     item.estado !== 'Reportado ID'
//   );

//   const datos_alertados_por_transaccion = datos_no_reportados
//     .filter(item => item.montoTransaccion && parseFloat(item.montoTransaccion) > 0)
//     .sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));

//   const datos_restantes = datos_no_reportados.filter(item => 
//     !item.montoTransaccion || 
//     item.montoTransaccion === null || 
//     parseFloat(item.montoTransaccion) === 0 || 
//     item.montoTransaccion === ''
//   );

//   const respuesta = datos_reportados.concat(
//     datos_reportados_adicionales_nombre,
//     datos_reportados_adicionales_id,
//     datos_alertados_por_transaccion,
//     datos_restantes
//   );

//   res.status(200).send(respuesta);
// } else {
//   res.status(200).send([]);
// }}



//VERSION 04 - REVISADA POR LA IA Y CUENTA CON LOS MISMO CÁLCULOS
// Pipeline de agregación optimizado
// const transaccionesResult = await Transaction.aggregate([
//   { $match: { idGrabacion: id_grabacion } },
//   { 
//     $group: {
//       _id: { nit: '$nit' },
//       montoTransacciones: { $push: '$montoTransaccion' }, // Mantener valores originales
//       devStd: { $stdDevSamp: { $toDouble: '$montoTransaccion' } }, // Solo convertir para el cálculo estadístico
//       count: { $sum: 1 },
//       nombreTransaccion: { $first: '$nombreTransaccion' }
//     }
//   },
//   {
//     $addFields: {
//       promedio: {
//         $function: {
//           body: function(montos) {
//             // Convertir a números dentro de la función para el cálculo de mediana
//             const numericMontos = montos.map(m => parseFloat(m)).filter(m => !isNaN(m));
//             const sorted = numericMontos.sort((a, b) => a - b);
//             const mid = Math.floor(sorted.length / 2);
//             return sorted.length % 2 === 0
//               ? (sorted[mid - 1] + sorted[mid]) / 2
//               : sorted[mid];
//           },
//           args: ['$montoTransacciones'],
//           lang: 'js'
//         }
//       }
//     }
//   },
//   {
//     $addFields: {
//       // Remover este cálculo duplicado - se hará en JavaScript como el original
//     }
//   }
// ]).exec();

// if (transaccionesResult.length > 0) {
//   // Extraer NITs y nombres únicos
//   const nits = [...new Set(transaccionesResult.map(t => t._id.nit))];
//   const nombres = [...new Set(transaccionesResult.map(t => t.nombreTransaccion))];

//   // Función helper para procesar en lotes con límite de concurrencia
//   const processBatch = async (items, batchSize, processor) => {
//     const results = [];
//     for (let i = 0; i < items.length; i += batchSize) {
//       const batch = items.slice(i, i + batchSize);
//       const batchResults = await Promise.all(batch.map(processor));
//       results.push(...batchResults);
//     }
//     return results;
//   };

//   // Procesar consultas en lotes pequeños (máximo 10 consultas simultáneas)
//   const BATCH_SIZE = 10;

//   const [
//     transaccionesExcedentes,
//     listasIdResults,
//     listasNombreResults,
//     perfilesIdResults,
//     perfilesNombreResults
//   ] = await Promise.all([
//     // Consulta única de transacciones excedentes
//     Transaction.find({
//       idGrabacion: id_grabacion,
//       nit: { $in: nits }
//     }).sort({ nit: 1, montoTransaccion: -1 }).exec(),

//     // Procesar listas por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaLista_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar listas por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaLista_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando lista nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por ID en lotes
//     processBatch(nits, BATCH_SIZE, async (nit) => {
//       try {
//         const resultado = await consultaPerfil_id(nit);
//         return { nit, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil ID ${nit}:`, err.message);
//         return { nit, resultado: [] };
//       }
//     }),

//     // Procesar perfiles por nombre en lotes
//     processBatch(nombres, BATCH_SIZE, async (nombre) => {
//       try {
//         const resultado = await consultaPerfil_nombre(nombre);
//         return { nombre, resultado };
//       } catch (err) {
//         console.log(`Error consultando perfil nombre ${nombre}:`, err.message);
//         return { nombre, resultado: [] };
//       }
//     })
//   ]);

//   // Crear mapas para acceso eficiente
//   const transaccionesExcedentesMap = new Map();
//   transaccionesExcedentes.forEach(t => {
//     const nit = t.nit;
//     if (!transaccionesExcedentesMap.has(nit)) {
//       transaccionesExcedentesMap.set(nit, []);
//     }
//     transaccionesExcedentesMap.get(nit).push(t);
//   });

//   const listasIdMap = new Map(
//     listasIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const listasNombreMap = new Map(
//     listasNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   const perfilesIdMap = new Map(
//     perfilesIdResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nit, item.resultado[0]])
//   );

//   const perfilesNombreMap = new Map(
//     perfilesNombreResults
//       .filter(item => item.resultado.length > 0)
//       .map(item => [item.nombre, item.resultado[0]])
//   );

//   // Procesar transacciones con los datos precargados
//   const transaccion = transaccionesResult.map((element, index) => {
//     const nit = element._id.nit;
//     const nombre = element.nombreTransaccion;
    
//     // EXACTO como original: Calcular maxTope y asignar como montoEstadistico
//     let maxTope = element.promedio + (element.devStd * numDesviaciones);
// 	console.log('maxTope', maxTope);
// 	console.log('element.promedio', element.promedio);
// 	console.log('element.devStd', element.devStd);
// 	console.log('numDesviaciones', numDesviaciones);
// 	console.log('-----------------------------------');

//     let resultado = { ...element, montoEstadistico: maxTope }; // Usar montoEstadistico, no maxTope

//     // Buscar transacción que excede el monto estadístico (igual que original)
//     const transaccionesDelNit = transaccionesExcedentesMap.get(nit) || [];
//     const transaccionExcedente = transaccionesDelNit.find(t => 
//       parseFloat(t.montoTransaccion) > parseFloat(maxTope) // Usar maxTope como en original
//     );

//     // EXACTO como original: Sobreescribir TODA la estructura si hay excedente
//     if (transaccionExcedente) {
//       resultado = {
//         ...element,
//         montoEstadistico: maxTope, // Mantener el montoEstadistico calculado
//         montoTransaccion: transaccionExcedente.montoTransaccion,
//         fechaTransaccion: transaccionExcedente.fechaTransaccion.toISOString().slice(0, 10)
//       };
//     }

//     // Asignar estado de lista
//     const listaId = listasIdMap.get(nit);
//     const listaNombre = listasNombreMap.get(nombre);
    
//     if (listaId) {
//       resultado.estado = `${listaId.estado} ID`;
//     } else if (listaNombre) {
//       resultado.estado = `${listaNombre.estado} (Homónimo)`;
//     } else {
//       resultado.estado = 'No Registrado';
//     }

//     // Asignar perfil de riesgo
//     const perfilId = perfilesIdMap.get(nit);
//     const perfilNombre = perfilesNombreMap.get(nombre);
    
//     if (perfilId) {
//       const perfilRiesgo = perfilId.perfilRiesgo && 
//                           perfilId.perfilRiesgo !== '' && 
//                           perfilId.perfilRiesgo !== null && 
//                           perfilId.perfilRiesgo !== undefined 
//                           ? perfilId.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (ID)`;
//       resultado.rango_salarial = perfilId.rango_salarial;
//       resultado.patrimonio_liquido = perfilId.patrimonio_liquido;
//     } else if (perfilNombre) {
//       const perfilRiesgo = perfilNombre.perfilRiesgo && 
//                           perfilNombre.perfilRiesgo !== '' && 
//                           perfilNombre.perfilRiesgo !== null && 
//                           perfilNombre.perfilRiesgo !== undefined 
//                           ? perfilNombre.perfilRiesgo : 'No Definido';
//       resultado.perfil_riesgo = `${perfilRiesgo} (Homónimo)`;
//     } else {
//       resultado.perfil_riesgo = 'No Registrado';
//     }

//     return resultado;
//   });

//   // Clasificar resultados finales
//   const datos_reportados = transaccion.filter(item => item.estado === 'Reportado');
//   const datos_reportados_adicionales_nombre = transaccion.filter(item => item.estado === 'Reportado (Homónimo)');
//   const datos_reportados_adicionales_id = transaccion.filter(item => item.estado === 'Reportado ID');

//   const datos_no_reportados = transaccion.filter(item => 
//     item.estado !== 'Reportado' && 
//     item.estado !== 'Reportado (Homónimo)' && 
//     item.estado !== 'Reportado ID'
//   );

//   const datos_alertados_por_transaccion = datos_no_reportados
//     .filter(item => item.montoTransaccion && parseFloat(item.montoTransaccion) > 0)
//     .sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));

//   const datos_restantes = datos_no_reportados.filter(item => 
//     !item.montoTransaccion || 
//     item.montoTransaccion === null || 
//     parseFloat(item.montoTransaccion) === 0 || 
//     item.montoTransaccion === ''
//   );

//   const respuesta = datos_reportados.concat(
//     datos_reportados_adicionales_nombre,
//     datos_reportados_adicionales_id,
//     datos_alertados_por_transaccion,
//     datos_restantes
//   );

//   res.status(200).send(respuesta);
// } else {
//   res.status(200).send([]);
// }}










//version 05
// Pipeline de agregación que REPLICA EXACTAMENTE el comportamiento original
const transaccionesResult = await Transaction.aggregate([
  { $match: { idGrabacion: id_grabacion } },
  { 
    $group: {
      _id: { nit: '$nit' },
      montoTransacciones: { $push: '$montoTransaccion' },
      devStd: { $stdDevSamp: { $toDouble: '$montoTransaccion' } }, // Conversión para evitar error TypeMismatch
      count: { $sum: 1 },
      nombreTransaccion: { $first: '$nombreTransaccion' }
    }
  },
  { $unwind: '$montoTransacciones' }, // Descomprimir el array (igual que original)
  { $sort: { montoTransacciones: 1 } }, // Ordenar los montos (igual que original)
  { $group: {
      _id: '$_id',
      montoTransacciones: { $push: '$montoTransacciones' }, // Volver a agrupar los montos
      devStd: { $first: '$devStd' }, // Mantener la desviación estándar
      count: { $first: '$count' },
      nombreTransaccion: { $first: '$nombreTransaccion' }
  }},
  {
    $addFields: {
      promedio: {
        $function: {
          body: function(montos) {
            // EXACTAMENTE igual que el código original
            montos.sort((a, b) => a - b);
            const middleIndex = Math.floor(montos.length / 2);
            return montos.length % 2 === 0
              ? (montos[middleIndex - 1] + montos[middleIndex]) / 2
              : montos[middleIndex];
          },
          args: ['$montoTransacciones'],
          lang: 'js'
        }
      }
    }
  }
]).exec();

if (transaccionesResult.length > 0) {
  // Extraer NITs y nombres únicos
  const nits = [...new Set(transaccionesResult.map(t => t._id.nit))];
  const nombres = [...new Set(transaccionesResult.map(t => t.nombreTransaccion))];

  // Función helper para procesar en lotes con límite de concurrencia
  const processBatch = async (items, batchSize, processor) => {
    const results = [];
    for (let i = 0; i < items.length; i += batchSize) {
      const batch = items.slice(i, i + batchSize);
      const batchResults = await Promise.all(batch.map(processor));
      results.push(...batchResults);
    }
    return results;
  };

  // Procesar consultas en lotes pequeños (máximo 10 consultas simultáneas)
  const BATCH_SIZE = 10;

  const [
    transaccionesExcedentes,
    listasIdResults,
    listasNombreResults,
    perfilesIdResults,
    perfilesNombreResults
  ] = await Promise.all([
    // Consulta única de transacciones excedentes
    Transaction.find({
      idGrabacion: id_grabacion,
      nit: { $in: nits }
    }).sort({ nit: 1, montoTransaccion: -1 }).exec(),

    // Procesar listas por ID en lotes
    processBatch(nits, BATCH_SIZE, async (nit) => {
      try {
        const resultado = await consultaLista_id(nit);
        return { nit, resultado };
      } catch (err) {
        console.log(`Error consultando lista ID ${nit}:`, err.message);
        return { nit, resultado: [] };
      }
    }),

    // Procesar listas por nombre en lotes
    processBatch(nombres, BATCH_SIZE, async (nombre) => {
      try {
        const resultado = await consultaLista_nombre(nombre);
        return { nombre, resultado };
      } catch (err) {
        console.log(`Error consultando lista nombre ${nombre}:`, err.message);
        return { nombre, resultado: [] };
      }
    }),

    // Procesar perfiles por ID en lotes
    processBatch(nits, BATCH_SIZE, async (nit) => {
      try {
        const resultado = await consultaPerfil_id(nit);
        return { nit, resultado };
      } catch (err) {
        console.log(`Error consultando perfil ID ${nit}:`, err.message);
        return { nit, resultado: [] };
      }
    }),

    // Procesar perfiles por nombre en lotes
    processBatch(nombres, BATCH_SIZE, async (nombre) => {
      try {
        const resultado = await consultaPerfil_nombre(nombre);
        return { nombre, resultado };
      } catch (err) {
        console.log(`Error consultando perfil nombre ${nombre}:`, err.message);
        return { nombre, resultado: [] };
      }
    })
  ]);

  // Crear mapas para acceso eficiente
  const transaccionesExcedentesMap = new Map();
  transaccionesExcedentes.forEach(t => {
    const nit = t.nit;
    if (!transaccionesExcedentesMap.has(nit)) {
      transaccionesExcedentesMap.set(nit, []);
    }
    transaccionesExcedentesMap.get(nit).push(t);
  });

  const listasIdMap = new Map(
    listasIdResults
      .filter(item => item.resultado.length > 0)
      .map(item => [item.nit, item.resultado[0]])
  );

  const listasNombreMap = new Map(
    listasNombreResults
      .filter(item => item.resultado.length > 0)
      .map(item => [item.nombre, item.resultado[0]])
  );

  const perfilesIdMap = new Map(
    perfilesIdResults
      .filter(item => item.resultado.length > 0)
      .map(item => [item.nit, item.resultado[0]])
  );

  const perfilesNombreMap = new Map(
    perfilesNombreResults
      .filter(item => item.resultado.length > 0)
      .map(item => [item.nombre, item.resultado[0]])
  );

  // Procesar transacciones con los datos precargados
  const transaccion = transaccionesResult.map((element, index) => {
    const nit = element._id.nit;
    const nombre = element.nombreTransaccion;
    
    // EXACTO como original: Calcular maxTope y asignar como montoEstadistico
    let maxTope = element.promedio + (element.devStd * numDesviaciones);
    let resultado = { ...element, montoEstadistico: maxTope }; // Usar montoEstadistico, no maxTope

    // Buscar transacción que excede el monto estadístico (igual que original)
    const transaccionesDelNit = transaccionesExcedentesMap.get(nit) || [];
    const transaccionExcedente = transaccionesDelNit.find(t => 
      parseFloat(t.montoTransaccion) > parseFloat(maxTope) // Usar maxTope como en original
    );

    // EXACTO como original: Sobreescribir TODA la estructura si hay excedente
    if (transaccionExcedente) {
      resultado = {
        ...element,
        montoEstadistico: maxTope, // Mantener el montoEstadistico calculado
        montoTransaccion: transaccionExcedente.montoTransaccion,
        fechaTransaccion: transaccionExcedente.fechaTransaccion?.toISOString()?.slice(0, 10) ?? null
      };
    }

    // Asignar estado de lista
    const listaId = listasIdMap.get(nit);
    const listaNombre = listasNombreMap.get(nombre);
    
    if (listaId) {
      resultado.estado = `${listaId.estado} ID`;
    } else if (listaNombre) {
      resultado.estado = `${listaNombre.estado} (Homónimo)`;
    } else {
      resultado.estado = 'No Registrado';
    }

    // Asignar perfil de riesgo
    const perfilId = perfilesIdMap.get(nit);
    const perfilNombre = perfilesNombreMap.get(nombre);
    
    if (perfilId) {
      const perfilRiesgo = perfilId.perfilRiesgo && 
                          perfilId.perfilRiesgo !== '' && 
                          perfilId.perfilRiesgo !== null && 
                          perfilId.perfilRiesgo !== undefined 
                          ? perfilId.perfilRiesgo : 'No Definido';
      resultado.perfil_riesgo = `${perfilRiesgo} (ID)`;
      resultado.rango_salarial = perfilId.rango_salarial;
      resultado.patrimonio_liquido = perfilId.patrimonio_liquido;
    } else if (perfilNombre) {
      const perfilRiesgo = perfilNombre.perfilRiesgo && 
                          perfilNombre.perfilRiesgo !== '' && 
                          perfilNombre.perfilRiesgo !== null && 
                          perfilNombre.perfilRiesgo !== undefined 
                          ? perfilNombre.perfilRiesgo : 'No Definido';
      resultado.perfil_riesgo = `${perfilRiesgo} (Homónimo)`;
    } else {
      resultado.perfil_riesgo = 'No Registrado';
    }

    return resultado;
  });

  // Clasificar resultados finales
  const datos_reportados = transaccion.filter(item => item.estado === 'Reportado');
  const datos_reportados_adicionales_nombre = transaccion.filter(item => item.estado === 'Reportado (Homónimo)');
  const datos_reportados_adicionales_id = transaccion.filter(item => item.estado === 'Reportado ID');

  const datos_no_reportados = transaccion.filter(item => 
    item.estado !== 'Reportado' && 
    item.estado !== 'Reportado (Homónimo)' && 
    item.estado !== 'Reportado ID'
  );

  const datos_alertados_por_transaccion = datos_no_reportados
    .filter(item => item.montoTransaccion && parseFloat(item.montoTransaccion) > 0)
    .sort((a, b) => parseFloat(b.montoTransaccion) - parseFloat(a.montoTransaccion));

  const datos_restantes = datos_no_reportados.filter(item => 
    !item.montoTransaccion || 
    item.montoTransaccion === null || 
    parseFloat(item.montoTransaccion) === 0 || 
    item.montoTransaccion === ''
  );

  const respuesta = datos_reportados.concat(
    datos_reportados_adicionales_nombre,
    datos_reportados_adicionales_id,
    datos_alertados_por_transaccion,
    datos_restantes
  );

  res.status(200).send(respuesta);
} else {
  res.status(200).send([]);
}}
















 async function consultaLista_id(idBusqueda){
	
	return new Promise(async (resolve, reject) => {
		var idQuery =  {"idNumber" : {"$regex": new RegExp("\\b"+ `${idBusqueda}`+"\\b")}};
		try {
			await List.find(idQuery).exec((err, estadoConsulta2) => {
				if(err){
					message: err.message;
				}else{
					//console.log('estado de la consulta', estadoConsulta2);
					if(estadoConsulta2){
						resolve(estadoConsulta2);
					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });
	
}

async function consultaLista_nombre(nombreTransaccion){
	//'El puto nombre..', nombreTransaccion);
	return new Promise(async (resolve, reject) => {

		//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
    //quitar los parentesis
    //nombreTransaccion = nombreTransaccion.replace(/[()]/g);

    // Función mejorada para escapar caracteres especiales en regex
        function escapeRegExp(string) {
            // Escapar todos los caracteres especiales de expresiones regulares
            return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        }
    nombreTransaccion = escapeRegExp(nombreTransaccion);
    //separa el nombre en partes
		let nombreAliasParts = nombreTransaccion.split(' ');
		var i = 0;
		let queryString = [];
		nombreAliasParts.forEach(element => {
			var exp = "\\b" + element + "\\b";
			//var expReg = new RegExp(exp, 'i');
			queryString[i] =  {"firstNamelastName" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}};
			i++;
		});
		
		const idQuery ={
			"$and": queryString
		};

		//var idQuery =  {"firstNamelastName" : {"$regex": new RegExp(`${nombreTransaccion}`), "$options" : 'i'}};
		//var idQuery =  {"firstNamelastName" : nombreTransaccion};
		try {
			await List.find(idQuery).exec((err, consultaNombre) => {
				if(err){
					message: err.message;
				}else{
					//console.log('estado de la consulta', estadoConsulta2);
					//if(estadoConsulta2.length > 0){
					//	console.log('resuelve la segunda vez', estadoConsulta2);
					if (consultaNombre.length > 0) {
						//console.log('encontro a..', consultaNombre);
					}
						resolve(consultaNombre);
					//}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });
	
}

//esta función es llamada por la funcion de arriba para consuktar en el perfil del riesgo si la persona esta reportada o no
async function consultaPerfil_id(idBusqueda){
	return new Promise(async (resolve, reject) => {

		var idQuery = {
			"$and": [
				{"idNumber" : {"$regex": new RegExp("\\b"+ `${idBusqueda}`+"\\b"), "$options" : 'i'}},
				{"perfilRiesgo": { "$exists": true, "$ne": null }}
			]
		}

		//var idQuery =  {"idNumber" : {"$regex": new RegExp("\\b"+ `${idBusqueda}`+"\\b"), "$options" : 'i'}};
		try {
			await RiskProfile.find(idQuery).exec((err, estadoConsulta) => {
				if(err){
					message: err.message;
				}else{
//					if(estadoConsulta){
	
						resolve(estadoConsulta);
//					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });
}

async function consultaPerfil_nombre(nombreTransaccion){
	return new Promise(async (resolve, reject) => {

	//BUSQUEDA SIN DISTINGUIR MAYUSCULA Y MINUSCULAS
    //quitar los parentesis
    //nombreTransaccion = nombreTransaccion.replace(/[()]/g);
    // Función mejorada para escapar caracteres especiales en regex
        function escapeRegExp(string) {
            // Escapar todos los caracteres especiales de expresiones regulares
            return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        }
		
    //separa el nombre en partes
    nombreTransaccion = escapeRegExp(nombreTransaccion);
		let nombreAliasParts = nombreTransaccion.split(' ');
		var i = 0;
		let queryString = [];
		nombreAliasParts.forEach(element => {
			var exp = "\\b" + element + "\\b";
			//var expReg = new RegExp(exp, 'i');
			queryString[i] =  {"nombreAlias" : {"$regex": new RegExp("\\b"+ `${element}`+"\\b"), "$options" : 'i'}}; //se busca por nombre alias y no per first...porque en el perfilk lo salvo con nombreAlias
			i++;
		});
		
		//ahora le agrega un nuevo criterio de busqueda para el perfil de riesgo y lo pone en el ultimo index (i)
		queryString[i] = {"perfilRiesgo": { "$exists": true, "$ne": null }};
		
		const idQuery ={
			"$and": queryString
		};
		  
		//var idQuery =  {"firstNamelastName" : {"$regex": new RegExp(`${nombreTransaccion}`), "$options" : 'i'}};
		//var idQuery =  {"firstNamelastName" : nombreTransaccion};
		try {
			await RiskProfile.find(idQuery).exec((err, estadoNombre) => {
				if(err){
					message: err.message;
				}else{
//					if(estadoConsulta){
						resolve(estadoNombre);
//					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });
}
 



//Devuelve todas las trasancciones por compañia, usuario y fechas
async function getTransactionsByCompany(req, res){
	var params = req.body;
var fechaIni = req.params.fIni;
var fechaFin = req.params.fFin;
var id_user = req.params.id_user;
var id_company = req.params.id_company;



const query = {
  // Agregar campos a la consulta solo si tienen valores proporcionados
  // id_usuario: id_user,
  // empresa_id: id_company,
  fechaTransaccion: {
    $gte: new Date(fechaIni),
    $lte: new Date(fechaFin)
  }
};

try {
  Transaction.aggregate([
    { $match: query },
    { $group: { _id: "$idGrabacion", creado: { $first: "$creado" }} }
  ], function(err, report) {
    if (err) {
      res.send(err);
    } else {
      res.json(report);
    }
  });
} catch (error) {
  res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal: ' + error });
}






}


module.exports = {
	saveTransaction,
	updateTransaction,
	saveExcelTransaction,
	saveTransactionExcel,
	deleteTransactionExcel,
	getTransactions,
	//getTransactionsGtMontoEstadistico,
	getTransactionsByCompany,

};


