'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');



//para poder importar archivos de excel de +-50000 registros
//var express = require('express');
//var app = express();
//var bodyParser = require('body-parser');
//app.use(bodyParser.json({limit: "100mb", extended: true}));


//app.use(express.json({limit: '100mb'}));
//app.use(express.urlencoded({limit: '100mb'}));

//app.use(bodyParser.urlencoded({limit: "100mb", extended: true, parameterLimit:100000}));

//app.use(bodyParser.json({limit: '10mb', extended: true}))
//app.use(bodyParser.urlencoded({limit: '10mb', extended: true}))




var bcrypt = require('bcrypt-nodejs');
var Transaction = require('../models/transaction');

var jwt = require('../services/jwt');
const { Console } = require('console');
const { db } = require('../models/transaction');
const api = require('../routes/transaction');
//const transaction = require('../models/transaction');

//Para consultar el perfil de riesgo
var RiskProfile = require('../models/riskProfile');
const { query } = require('express');

var List = require('../models/list');


/************************************************* */
/* Funcion para salvar en la base de datos los */
/* registros leidos desde una  */ 
/* hoja de excel para el módulo transaccional */
/************************************************* */

function saveTransactionExcel(req, res){ //graba los registros provenientes del archivo de excel
	//	var transaction = new Transaction();
	
	var params = req.body;
	console.log(params);
	//para extraer el id_empresa del primer registro, pues todos lo tienen
	//con la empresa_id le damos el nombre a la colección y garantizamos que cada empresa tiene su propia coleccion
	//y los datos no se amontonan en una sola tabla

	//var primerRegistro = params[0];
	//var empresa_id = primerRegistro.empresa_id;
	/*
	console.log('respuesta de a uno');
	params.forEach(element => {
		db.collection("transactions").bsonOptions(element);
		console.log(element);
	});
*/

	var transaction = new Transaction();

	transaction.nit = params.nit;
	transaction.empresa_id = params.empresa_id;
	transaction.creado = params.creado;
	transaction.nombreTransaccion = params.nombreTransaccion;
	transaction.montoTransaccion = params.montoTransaccion;
	transaction.fechaTransaccion = params.fechaTransaccion;
	transaction.usuarioCrea = params.usuarioCrea;
	transaction.idGrabacion = params.idGrabacion;

	if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
		//guarda el usuario
		transaction.save((err, transactionStored) => {
			if(err){
				res.status(500).send({message: 'Error al guardar la transacción'});
			}else{
				if(!transactionStored){
					res.status(404).send({message: 'NO se ha guardado la transacción'});
				}else{
					res.status(200).send({transaction: transactionStored});
				}
			}
		});
	}else{
		res.status(200).send({message: 'Rellena todos los campos por favor'});
	}



	
/*
	if (empresa_id != ''){
		//if(db.collection(empresa_id).insertMany (params)){
		if(db.collection("transactions").insertMany(params)){
			console.log("Archivo totalmente importado");
		}else{
			console.log("File imported error.");
		}
	}
*/
}


//***** Borra registros de una coleccion recibiendoo una fecha. La de creado */
function deleteTransactionExcel(req, res){

	orden = req.params;
	db.collection("transactions").deleteMany(orden)

}
			

function saveTransaction(req, res){

				var transaction = new Transaction();
			
				var params = req.body;
				
				transaction.empresa_id = params.empresa_id;
				transaction.nit = params.nit;
				transaction.nombreTransaccion = params.nombreTransaccion;
				transaction.montoTransaccion = params.montoTransaccion;
				transaction.fechaTransaccion = params.fechaTransaccion;
				//transaction.fechaTransaccion = new Date(JSON.parse(params.fechaTransaccion));
				//var obj = JSON.parse(json);
				//completar
				//transaction.idUsario = 'traerlo de la session'
				//transaction.idEmpresa = params.idEmpresa;
				//completar
				transaction.creado = new Date();
			
			
							if(transaction.nombreTransaccion != null && transaction.montoTransaccion != null && transaction.fechaTransaccion != null ){
								//guarda el usuario
								transaction.save((err, transactionStored) => {
									if(err){
										res.status(500).send({message: 'Error al guardar la transacción'});
									}else{
										if(!transactionStored){
											res.status(404).send({message: 'NO se ha guardado la transacción'});
										}else{
											res.status(200).send({transaction: transactionStored});
										}
									}
								});
							}else{
								res.status(200).send({message: 'Rellena todos los campos por favor'});
							}
			
}



function updateTransaction(req, res){
	var transactionId = req.params.id;
	var update = req.body;

	transaction.findByIdAndUpdate(transactionId, update, (err, transactionUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualziar la transaccion'});
		}else{
			if(!transactionUpdated){
				res.status(404).send({message: 'No se ha podido actualizar la transaccion'});
			}else{
				res.status(200).send({user: transactionUpdated});
			}
		}


	})

}


function saveExcelTransaction(req, res){
	var transaction = new Transaction();
	var params = req.body;
	console.log(params);
	
}

/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada. Devuelve el promedio y la desv standard
/********************************************************/
function getTransactions(req, res){
	
	var id_grabacion = req.params.id_grabacion;

console.log('el ide la grabacion grabando en trs', id_grabacion);

	/*
const agg = [
		{ $match: { fechaTransaccion: { $gte: new Date(fechaIni), $lte: new Date(fechaFin) } } },
		{ $group: { _id: {nit: "$nit", nombreTransaccion: "$nombreTransaccion"},  promedio: { $avg: "$montoTransaccion"}, devStd: {$stdDevSamp: "$montoTransaccion"}}}
		
		]
	*/

/*
	const agg = [
		{ $match: { fechaTransaccion: { $gte: new Date(fechaIni), $lte: new Date(fechaFin) } } },
		{ $group: { _id: {nit: "$nit", nombreTransaccion: "$nombreTransaccion"},  promedio: { $avg: "$montoTransaccion"}, devStd: {$stdDevSamp: "$montoTransaccion"}}}
		
		]
*/


/*
	const agg = [
		{
		  '$match': {
			'$and': [
			  {
				'fechaTransaccion': {
				  '$gte': new Date(fechaIni)
				}
			  }, {
				'fechaTransaccion': {
				  '$lte': new Date(fechaFin)
				}
			  }
			]
		  }
		}, {
		  '$group': {
			'_id': {}, 
			'Promedio': {
			  '$avg': '$montoTransaccion'
			},
			devstd:{
				$stdDevSamp: '$montoTransaccion'
			}
		  }
		}
	  ];
	*/  

	/*
fechaIni = fechaIni + "T00:00:00.000Z";
fechaFin = fechaFin + "T00:00:00.000Z";
console.log(fechaIni);
console.log(fechaFin);

fechaIni = "2022-01-01";
fechaFin = "2022-01-31";
*/

/*
const query = [{ $match: { fechaTransaccion: { $gte: new Date(fechaIni), $lte: new Date(fechaFin) } } },
		{ $group: { _id: {nit: "$nit", nombreTransaccion: "$nombreTransaccion"},  promedio: { $avg: "$montoTransaccion"}, devStd: {$stdDevSamp: "$montoTransaccion"}}}];

console.log('el agregado');
console.log(query);
*/

//new Date().toJSON()
console.log('el ide de la grabajación', id_grabacion);
Transaction.aggregate([
{ $match: {idGrabacion: id_grabacion}}, { $group: { _id: {nit: '$nit', project: { nombreTransaccion: 1}}, promedio: { $avg: '$montoTransaccion'}, devStd: {$stdDevSamp: '$montoTransaccion'}, "count": {"$sum": 1}}}]).exec((err, transaccion) => {
	if(err){
		console.log(err.message);
		console.log('la consulta de agregado no se ejecutó correctamente');
	}else{
		if(transaccion){
			res.status(200).send({transaccion});
		}
	}
} );
	

/*


try {
	const tra = Transaction.find({fechaTransaccion: {$gte: new Date(fechaIni), $lte: new Date(fechaFin)} }, function(err, transa) { 
		if (err){
			res.send(err)
		}else{
			res.json({transa});
			//console.log(transa);
		}
	}); //encuentra todos los usuarios
	//res.json(usuarios); //devuelve los usuarios

} catch (error) {
	res.status(400).send({message: 'ha ocurrido un error en el controlador'});
}

*/



/*
	try {
		const transaccion =  Transaction.find({fechaTransaccion: {$gte: fechaIni, $lte: fechaFin}}, function(err, docs) { 
			if (err){
				console.log('si hay error');
				console.log(docs);
				res.send(err)
			}else{
				res.json(docs);
				console.log(transaccion);
				console.log('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx');
				console.log(docs);
				console.log('si no hay error muestra esto');
			}
		}); 

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador de transacciones'});
	}
*/

}



/********************************************************/
//función para devolver todos las transacciones dentro 
//de una fecha determinada que superan el monto estadistico
/********************************************************/
function getTransactionsGtMontoEstadistico(req, res){
	var params = req.body;
	
	var fechaIni = req.params.fIni;
	var fechaFin = req.params.fFin;
	var monto = req.params.monto;
	var nitConsolidar = req.params.nitConsolidar;
	var id_grabacion_consultar = req.params.id_grabacion;

	
/*
	const consulta = [
		{"fechaTransaccion": {$gte: new Date(fechaIni)}, "fechaTransaccion": {$lte: new Date(fechaFin)}, "montoTransaccion": {$gte: monto}, "nit": {$eq: nitConsolidar}}
	];

	console.log('n el controlador');
console.log(consulta);
*/

const consulta = [
	{"fechaTransaccion": {"$gte": fechaIni}, "fechaTransaccion": {"$lte": fechaFin}, "montoTransaccion": {"$gte": monto}, "nit": {"$eq": nitConsolidar}}
]


//ASI ESTABA ANTES LA CONSULTA
//find({"fechaTransaccion": {"$gte": ISODate(fechaIni)}, "fechaTransaccion": {"$lte": ISODate(fechaFin)}, "montoTransaccion": {$gte: monto}, "nit": {$eq: nitConsolidar}}
	//Transaction.find({"fechaTransaccion": {"$gte": fechaIni}, "fechaTransaccion": {"$lte": fechaFin}, "montoTransaccion": {"$gte": monto}, "nit": {"$eq": nitConsolidar}}).exec((err, transaccionExcedeMonto) => {
		Transaction.find({idGrabacion:  id_grabacion_consultar, "montoTransaccion": {"$gte": monto}, "nit": nitConsolidar}).exec((err, transaccionExcedeMonto) => {
		if(err){
			message: err.message;
		}else{
			if(transaccionExcedeMonto != ""){
				consultaPerfil((transaccionExcedeMonto[0]['nit']))
				 .then((estadoConsulta) => {

					if(estadoConsulta != ''){
						console.log('entra a estado consulta');
						var resultado = { //incluye el nuevo campo llamado estado
							...transaccionExcedeMonto[0]._doc,
							estado: estadoConsulta[0]['estadoConsulta'],
							ingresos: estadoConsulta[0]['rango_salarial'],
							perfil_riesgo: estadoConsulta[0]['perfil_riesgo'],
							montoEstadistico: monto,
						};
					}else{
						
						//Si no encuentra el perfil consulta la lista para saber si esta reportado
						consultaLista((transaccionExcedeMonto[0]['nit']))
				 			.then((estado_enlistas) => {

								if(estado_enlistas != '') {
									console.log('entra a estado en listas => != de blanco', estado_enlistas);
									var resultado = { //incluye el nuevo campo llamado estado
										...transaccionExcedeMonto[0]._doc,
										estado: 'Reportado',
										montoEstadistico: monto,
								  };
								}else{
									console.log('entra cuando estado_en listas es blanco =>', estado_enlistas);
									var resultado = { //incluye el nuevo campo llamado estado
										...transaccionExcedeMonto[0]._doc,
										estado: 'Sin Perfil- No Reportado',
										montoEstadistico: monto,
									  };

									// console.log('el resultado total', resultado);
								}

							}).
							catch((error) => {
							   console.error('Error:', error);
							});

						
					}
					
					

					res.status(200).send({resultado});
					
				 }).
				 catch((error) => {
					console.error('Error:', error);
				 });

				
			}
		}
	});



}


//esta función es llamada por la funcion de arriba para consuktar en el perfil del riesgo si la persona esta reportada o no
function consultaPerfil(idBusqueda){
	return new Promise((resolve, reject) => {
		var idQuery =  {"idNumber" : {"$regex": new RegExp("\\b"+ `${idBusqueda}`+"\\b"), "$options" : 'i'}};
		try {
			RiskProfile.find(idQuery).exec((err, estadoConsulta) => {
				if(err){
					message: err.message;
				}else{
					if(estadoConsulta){
						resolve(estadoConsulta);
					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });


	  

	//RiskProfile.find({idNumber:{'$regex': new RegExp('.*' + idBusqueda + '.*' )}}).exec((err, estadoConsulta) => {
	/*	var idQuery =  {"idNumber" : {"$regex": new RegExp("\\b"+ `${21175602}`+"\\b"), "$options" : 'i'}};
		console.log('imprime la consulta', idQuery);
		try {
			RiskProfile.find(idQuery).exec((err, estadoConsulta) => {
				if(err){
					message: err.message;
				}else{
					if(estadoConsulta){
						return estadoConsulta;
					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		*/
}

//Consulta en listas PERO SOLO con el numero de cedula o NIT
function consultaLista(idBusqueda2){
	console.log('El id para consultar en la lista...',idBusqueda2);
	return new Promise((resolve, reject) => {
		var idQuery =  {"idNumber" : {"$regex": new RegExp("\\b"+ `${idBusqueda2}`+"\\b"), "$options" : 'i'}};
	//	console.log('Leego a consulta lista');
		try {
			List.find(idQuery).exec((err, estadoConsulta2) => {
				if(err){
					message: err.message;
				}else{
					if(estadoConsulta2){
						resolve(estadoConsulta2);
					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });
}

//Devuelve todas las trasancciones por compañia, usuario y fechas
async function getTransactionsByCompany(req, res){
	var params = req.body;
var fechaIni = req.params.fIni;
var fechaFin = req.params.fFin;
var id_user = req.params.id_user;
var id_company = req.params.id_company;

console.log("llegue al servicio");
console.log(fechaIni);
console.log(fechaFin);
console.log(id_user);
console.log(id_company);

const query = {
  // Agregar campos a la consulta solo si tienen valores proporcionados
  // id_usuario: id_user,
  // empresa_id: id_company,
  fechaTransaccion: {
    $gte: new Date(fechaIni),
    $lte: new Date(fechaFin)
  }
};

try {
  Transaction.aggregate([
    { $match: query },
    { $group: { _id: "$idGrabacion", creado: { $first: "$creado" }} }
  ], function(err, report) {
    if (err) {
      res.send(err);
    } else {
      res.json(report);
    }
  });
} catch (error) {
  res.status(400).send({ message: 'Ha ocurrido un error en el controlador de canal: ' + error });
}


}

/*
function getTransactionsByCompany(req, res){
	var params = req.body;
	
	var fechaIni = req.params.fIni;
	var fechaFin = req.params.fFin;
	var id_user = req.params.id_user;
	var id_company = req.params.id_company;

	return new Promise((resolve, reject) => {
		var id_Query =[
			{
			  $match: {
				$and: [
				  { id_usuario: id_user },
				  { empresa_id: id_company },
				  { fechaTransaccion: { $gte: new Date(fechaIni).toJSON(), $lte: new Date(fechaFin).toJSON() } }
				]
			  }
			},
			{
			  $group: {
				_id: "$idGrabacion",
				creado: { $first: "$creado" }
			  }
			}
		  ];

		try {
			Transaction.find(id_Query).exec((err, estadoConsulta) => {
				if(err){
					message: err.message;
				}else{
					if(estadoConsulta){
						resolve(estadoConsulta);
					}
				}
			} );
		} catch (error) {
			console.log(error);
		}
		
	  });


}
*/




module.exports = {
	saveTransaction,
	updateTransaction,
	saveExcelTransaction,
	saveTransactionExcel,
	deleteTransactionExcel,
	getTransactions,
	getTransactionsGtMontoEstadistico,
	getTransactionsByCompany
};


