'use strict'

//para trabajar con los sistemas de archivos
var fs = require ('fs');
var psth = require ('path');

const mongoose = require('mongoose');
const dbs = mongoose.connection;

var bcrypt = require('bcrypt-nodejs');
var User = require('../models/user');

var jwt = require('../services/jwt');

function pruebas (req, res){
	res.status(200).send({
		message: 'Probando una accion dewl controlador de usarios del api con node y mongodb'
	});
}

const mongodb = require('mongodb');

function saveUser(req, res){
	var user = new User();

	var params = req.body;
		
	user.nombre = params.nombre;
	user.apellido = params.apellido;
    user.username = params.username.toLowerCase();
	user.tipo_documento = params.tipo_documento;
    user.documento = params.documento;
    user.estado = params.estado;
	user.company_id = params.company_id;
    user.creado = new Date();
	user.usuarioCrea = params.usuarioCrea;
	user.role = params.role;
	
	
	if(params.password){
			//encriptar contraseña y guardar datos
			bcrypt.hash(params.password, null, null, function(err, hash){
				user.password = hash;

				if(user.nombre != null && user.apellido != null && user.username != null ){
					//guarda el usuario
					user.save((err, userStored) => {
						if(err){
							console.log(err);
							res.status(500).send({message: 'Error al guardar el usuario final'});
						}else{
							if(!userStored){
								res.status(404).send({message: 'NO se ha guardado el usuario'});
							}else{
								res.status(200).send({user: userStored});
							}
						}
					});
				}else{
					res.status(200).send({message: 'Rellena todos los campos'});
				}
			});
	}else{
		res.status(200).send({message: 'Introduce la contraseña'});
	}

} 


function loginUser(req, res){
	var params = req.body;

	var username = params.username;
	var password = params.password;
	
	User.findOne({username: username.toLowerCase()}, (err, user) => {
		if (err){
			res.status(500).send({message: 'Error en la peticion'});
		}else{
			if(!user){
				res.status(404).send({message: 'el usuario no existe'});
			}else{
				bcrypt.compare(password, user.password, function(err, check) {
					if(check){
						//devolver los datos del usuario logueado
						if(params.gethash){
							//devolver un token de jw
							res.status(200).send({
								token: jwt.createToken(user)
							});
						}else{
							res.status(200).send({user});
						}

					}else{
						res.status(404).send({message: 'El usuario no ha podido loguearse'});
					}

				})
			}
		}

	});
}




//para subir archivos

function uploadImage(req, res){
	var userId = req.params.id;
	var file_name = 'No subido...';

	if(req.files){
		var file_path = req.files.image.path;
		var file_split = file_path.split('\\');
		var file_name = file_split[2];

		var ext_split = file_name.split('\.');
		var file_ext = ext_split[1];

		if(file_ext == 'png' || file_ext == 'jpg' || file_ext == 'gif'){
			
			User.findByIdAndUpdate(userId, {image: file_name}, (err, userUpdated) => {
				
				if(!userUpdated){
					res.status(404).send({message: 'No se ha podido actualizar el usuario'});
				}else{
					res.status(200).send({image: file_name, user: userUpdated});
				}

			});
		}else{
			res.status(200).send({message: 'Extensión del archivo no válida'});
		}

	}else{
		res.status(200).send({message: 'No subido ninguna imagen'});
	}
}


//para trabajar con el sistema de archivos

function getImageFile(req, res){
	var imageFile = req.params.imageFile;
	var path_file = './uploads/users/'+imageFile;

	fs.exists(path_file, function(exists){
		if(exists){
			res.sendFile(path.resolve(path_file))
		}else{
			res.status(200).send({message: 'No existe la imagen'});
		}


	});
}	


//función para devolver todos los usuarios
function getUsers(req, res){

	try {
		const usuarios = User.find( function(err, persona) { 
			if (err){
				res.send(err)
			}else{
				res.json(persona);
			}
		}); //encuentra todos los usuarios
		//res.json(usuarios); //devuelve los usuarios

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}


}


 /*******************************************************************************************************/
 // devuleve los usuarios filtrados por id empresa
 // para listarlos en lista usuarios acorde con el perfil
 /*******************************************************************************************************/
 function getUsersByIdEmpresa(req, res){

	let idEmpresa = req.params.idEmpresa;


	try {
		const usuarios = User.find({company_id: idEmpresa}, function(err, persona) { 
			if (err){
				res.send(err)
			}else{
				res.json(persona);
			}
		}); //encuentra todos los usuarios
		//res.json(usuarios); //devuelve los usuarios

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}


}

/*******************************************************************************************************/
 // devuleve los usuarios filtrados por id empresa
 // para listarlos en lista usuarios acorde con el perfil adminEmpresa para ponerlos en el select de enviar email en perfil
 /*******************************************************************************************************/
 function getUsersByIdEmpresaRole(req, res){

	let idEmpresa = req.params.idEmpresa;
console.log(idEmpresa);
	try {
		const usuarios = User.find({ $and: [{company_id: idEmpresa, role: 'EmpresaAdmin'}]}, function(err, persona) { 
			if (err){
				res.send(err)
			}else{
				res.json(persona);
			}
		}); //encuentra todos los usuarios
		//res.json(usuarios); //devuelve los usuarios

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}


}


/********************************************************/
/*función para devolver UNO de los usuarios *************/
/*Esta función es usada para actualizar un usuario dado */
/*que lo recupera y lo lleva al form de crear usuario   */
/********************************************************/
function getUser(req, res){

	var userId = req.params.id;
	try {
		const usuario = User.findById(userId, function(err, persona) { 
			if (err){
				res.send(err)
			}else{
				res.json(persona);
			}
		}); //encuentra un usuario por id y lo devuelve para editarlo
		//res.json(usuarios); //devuelve los usuarios

	} catch (error) {
		res.status(400).send({message: 'ha ocurrido un error en el controlador'});
	}


}

/********************************************************/
/*función para ACTUALIZAR UNO de los usuarios *************/
/*Esta función es usada para actualizar un usuario dado */
/********************************************************/
function updateUser(req, res){
	var userId = req.params.id;
	var update = req.body;
	
	User.findByIdAndUpdate(userId, update, (err, userUpdated) => {
		if(err){
			res.status(500).send({message: 'Error al actualizar el usuario'});
		}else{
			if(!userUpdated){
				res.status(404).send({message: 'No se ha podido actualizar el usuario'});
			}else{
				res.status(200).send({user: userUpdated});
			}
		}


	})

}

 /*******************************************************************************************************/
 // Actualiza un usuario a traves del ID
 // Actualiza el password
 /*******************************************************************************************************/
//  function updateUserById(req, res){
	
// 	var userId = req.params.userId;
// 	var password = req.body.password;
// console.log('el id del usuario',userId);
// 	//calcula el hash del nuevo password
// 	bcrypt.hash(password, null, null, function(err, hash){

// 		User.findByIdAndUpdate(userId, {$set: {password: hash}}, (err, userUpdated) => {
// 			if(err){
// 				res.status(500).send({message: 'Error al actualizar el usuario'});
// 			}else{
// 				if(!userUpdated){
// 					res.status(404).send({message: 'No se ha podido actualizar el usuario'});
// 				}else{
// 					res.status(200).send({user: userUpdated});
// 				}
// 			}
// 		})
// 	});
// }




//para actualizar el usuario. Recibe un ID
function deleteUser(req, res){
	var userId = req.params.id;
	
//console.log('llego hasta aqui');
	try {
		
		User.findByIdAndDelete(userId, function (err, userRemoved){
			if (err){
				res.send(err)
			}else{
				res.json(userRemoved);
			}

		});

	} catch (error) {
		res.status(500).send({message: 'Sucedió un error al remover el usuario'});
	}
	


/*
	User.findOneAndRemove(userId, (err, userRemoved) => {
		if(err){
			res.status(500).send({message: 'Error el remover el usuario'});
		}else{
			if(!userRemoved){
				res.status(404).send({message: 'No se ha podido actualizar el usuario'});
			}else{
				res.status(200).send({user: userRemoved});
			}
		}


	})
*/
}


//función para devolver los usuarios por busqueda por nombre. Realizada apara ListaUsuarios den el boton filtrar
function getUsersByName(req, res){

	
	
	//let name = req.params.name;
	
	let datos = JSON.parse(req.query['DATOS']);

	let name = datos['nombre'];
	let idEmpresa = datos['idEmpresa'];
	let role = datos['role'];

	

		//revisa si es un ID de empresa para hacer la busqueda de usuarios por empresa
		if (mongodb.ObjectId.isValid(name)) {
			try {
				const usuarios = User.find({ company_id: name }, function(err, persona) { 
					if (persona.length > 0){
						res.json(persona);
					} else {
						//
						res.json(persona);
					}
				}); //encuentra un usuario por id y lo devuelve para editarlo
			} catch (error) {
				res.status(400).send({message: 'ha ocurrido un error en el controlador'});
			}
		} else if (isNaN(name)) { //es un texto
			
			
			if(role === 'SuperAdmin'){

				try {
					const usuarios = User.find({ nombre: { $regex: new RegExp(name, 'i') }}, function(err, persona) { 
						
						if (persona.length > 0){ //encuentra por nombre
							res.json(persona);
						} else { //busca por apellido
							const usuarios = User.find({ apellido: { $regex: new RegExp(name, 'i') }}, function(err, persona) { 
							if (persona.length > 0){ //encontro por apellido
								res.json(persona);
							} else { //toca buscar en ambos campos de nombre y apellido
								//busca en ambos campos nombre apellido usando el index
								const escapeRegex = (string) => {
									return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
								};
								  
								const pipeline = [
									{
									  $match: {
										$text: {
										  $search:  name
										}
									  }
									},
									{
									  $project: {
										_id: 1, // Exclude _id field if not needed
										nombre: 1, // Include desired fields for projection
										apellido: 1,
										username: 1,
										tipo_documento: 1,
										documento: 1,
										role: 1,
										company_id: 1,
										
										// ... other fields to include
									  }
									}
								  ];
								  
								  // Execute the aggregation and handle results
										User.aggregate(pipeline)
										.exec((err, results) => {
										if (err) {
											console.error('Error searching users:', err);
											return;
										}
										if (results.length > 0) {
											res.json(results)
										} else {
											console.log('No results found.');
										}
										;
										});
							
							}
						});
						}
					}); 

				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador'});
				}
			} else if(role === 'EmpresaAdmin'){ 
				try {
					const usuarios = User.find({ $and: [{nombre: { $regex: new RegExp(name, 'i') }}, {company_id: idEmpresa}]}, function(err, persona) { 
						if (persona.length > 0){
							res.json(persona);
						} else { //busca por apellido
							const usuarios = User.find({ $and : [{apellido: { $regex: new RegExp(name, 'i') }}, {company_id: idEmpresa}]}, function(err, persona) { 
								
							if (persona.length > 0){ //encontro por apellido
								res.json(persona);
							} else { //no encontro nada por apellidos o nombre. Entocnes busca por ambos
								//busca en ambos campos nombre apellido usando el index
								const escapeRegex = (string) => {
									return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
								  };
								  
								const pipeline = [
									{
									  $match: {
										$text: {
										  $search:  name
										}
									  }
									},
									{
									  $project: {
										_id: 1, // Exclude _id field if not needed
										nombre: 1, // Include desired fields for projection
										apellido: 1,
										username: 1,
										tipo_documento: 1,
										documento: 1,
										role: 1,
										company_id: 1,
										
										// ... other fields to include
									  }
									}
								  ];
								  
								  // Execute the aggregation and handle results
										User.aggregate(pipeline)
										.exec((err, results) => {
										if (err) {
											console.error('Error searching users:', err);
											return;
										}
										if (results.length > 0) {
											res.json(results)
										} else {
											console.log('No results found.');
										}
										;
										});
							} //termina el else
						});
						}
					}); 
				} catch (error) {
					res.status(400).send({message: 'ha ocurrido un error en el controlador'});
				}
			}
			
		} else { //es un numero
			
			let numero = parseInt(name);
			const regex = new RegExp("^" + numero + ".*$", 'i');
			
			try {
				const usuarios = User.find({ documento: name }, function(err, persona) {  
					if (err){
						console.log(err);
						res.send(err)
					}else{
						res.json(persona);
					}
				}); 

			} catch (error) {
				re
		}
	}

	if (name === '') {
		
		getUsers(req, res);
	}
}






module.exports = {
	pruebas,
	saveUser,
	loginUser,
	updateUser,
	uploadImage,
	getImageFile,
	getUsers,
	getUser,
	deleteUser,
	getUsersByIdEmpresa,
	getUsersByName,
	getUsersByIdEmpresaRole
	//updateUserById
};