
import puppeteer from 'puppeteer';


async function runPuppeteer() {
    const browser = await puppeteer.launch({
        headless: false,
        //slowMo: 250,
        defaultViewport: null
        //args: ['--no-sandbox', '--disable-setuid-sandbox']
    });

    const page = await browser.newPage();
  
    try {
      //Configurar un user-agent personalizado
      await page.setUserAgent(
          'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
      );

      // Navegar a Google
      await page.goto('https://consultaprocesos.ramajudicial.gov.co/Procesos/NombreRazonSocial/');
    

      /******************************************************************************************/
      /* Da clic sobre procesos y/o todos los procesos. Sobre el segundo boton de radio                                         */   
      /******************************************************************************************/
      const selector00 = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div.row > div > div > div > div > div.v-input__slot > div > div:nth-child(2) > label';
      //const selector00 = '.v-input__slot label'; //da clic en el primer boton

      // Verificar si el elemento es visible
      const isElementVisible = await page.evaluate((selector00) => {
        const element = document.querySelector(selector00);
        return element && element.offsetParent !== null; // offsetParent verifica si el elemento es visible
      }, selector00);

      if (isElementVisible) {
        // Desplazarse hacia el elemento para asegurarse de que esté en la vista
        await page.evaluate((selector00) => {
          const element = document.querySelector(selector00);
          if (element) {
            element.scrollIntoView({ behavior: 'smooth', block: 'center' });
          }
        }, selector00);
        // Hacer clic en el elemento
        await page.click(selector00); //abre el menu seleccionable
      }
      

      /******************************************************************************************/
      /* Selecciona la opción Jurídica o Natural                                         */   
      /******************************************************************************************/
      const selector_jur_natural = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div.v-input.theme--light.v-text-field.v-text-field--is-booted.v-select.custom';




















      /******************************************************************************************/
      /* Da clic sobre la opción natural                                              */
      /******************************************************************************************/

       const opcion = 'Natural';
      // //hacemos clic en el selector para abir el menu
      //const selector01 = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div.v-input.theme--light.v-text-field.v-text-field--is-booted.v-select.custom';
      const selector01 = '.v-select.custom';

      await page.click(selector01);

      // // Verificar si el elemento es visible
      // const selector01_visible = await page.evaluate((selector01) => {
      //   const element = document.querySelector(selector01);
      //   return element && element.offsetParent !== null; // offsetParent verifica si el elemento es visible
      // }, selector01);


      // if (selector01_visible) {
      //   // Desplazarse hacia el elemento para asegurarse de que esté en la vista
      //   await page.evaluate((selector01) => {
      //     const element = document.querySelector(selector01);
      //     if (element) {
      //       element.scrollIntoView({ behavior: 'smooth', block: 'center' });
      //     }
      //   }, selector01);
      //   // Hacer clic en el elemento
      //   await page.click(selector01); //aber el menu seleccionable
      // }


      // Veamos a ver si podemos seleccionar una opción
      //const opciones = await page.$$('#list-item-190-0.v-list-item.v-list-item--link.theme--light .v-list-item__content');
      const opciones = await page.$$('.v-list-item--link .v-list-item__content');
      const textoBuscado = 'Natural'; // Texto exacto de la opción
      for (const opcion of opciones) {
          const texto = await page.evaluate(el => el.textContent.trim(), opcion);
          if (texto === textoBuscado) {
              await opcion.click();
              break;
          }
      }




   
      //selecciona la opción respectiva
      if (opcion === 'Jurídica') {
          //selecciona la opción natural
          const selector02 = '#list-64 > div > div:nth-child(1)';
          await page.click(selector02);
      } else {
        
        //selecciona la opción juridica

        // la siguiente opcion funciona
       // const selector02 = '.v-list-item, .v-list-item--link, .theme--light';
        
        //proba 'div.v-list-item__title
        
        const selector02 = '.v-list-item--link:first-child .v-list-item__title';

        const selector02_visible = await page.evaluate((selector02) => {
          
          const element = document.querySelector(selector02);
          return element && element.offsetParent !== null; // offsetParent verifica si el elemento es visible
        }, selector02);



        await page.waitForSelector(selector02, { timeout: 10000 });
        //  const items = await page.$$(selector02);
        //  console.log('items', items);
        await page.click(selector02);



      }
     
     


      /***************************************************************************************/
      /*** Ingresa el texto a buscar en la caja de texto (nombre de la persona o empresa) ****/
      /***************************************************************************************/
      // Esperar a que el campo de entrada esté disponible
      //await page.waitForSelector('div.v-text-field__slot > input[type="text"]', { timeout: 5000 }); // Espera hasta 10 segundos
      const searchInputSelector = 'div.v-text-field__slot > input[type="text"]';
      await page.waitForSelector(searchInputSelector);
      // Escribir texto en el campo de búsqueda
      const searchText = 'Revista Semana'; // Cambia esto al texto que deseas buscar
      await page.type(searchInputSelector, searchText);


      /***************************************************************************************/
      /*** Ahora daremos clic sobre el boton consultar) ****/
      /***************************************************************************************/

      //daremos clic sobre un boton
      const selector03 = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div:nth-child(5) > button.v-btn.v-btn--is-elevated.v-btn--has-bg.theme--light.v-size--default.success.mt-2.mx-2.font-weight-bold';
      await page.click(selector03);

      //captura el valor de la ventana emergente
      // Escuchar eventos de diálogo (alert, confirm, prompt)
      // page.on('dialog', async (dialog) => {
      //   console.log('Mensaje de la ventana emergente:', dialog.message());
      //   await dialog.accept(); // Aceptar la alerta (opcional)
      // });

      // Esperar a que aparezca el modal
      await page.waitForSelector('#app > div.v-dialog__content.v-dialog__content--active > div > div > div:nth-child(1) > div > div > div.v-alert__content'); // Ajusta el selector según tu página

      // Capturar el mensaje del modal
      const modalMessage = await page.$eval('#app > div.v-dialog__content.v-dialog__content--active > div > div > div:nth-child(1) > div > div > div.v-alert__content', element => element.textContent);
      console.log('Mensaje del modal:', modalMessage);
      
  } catch (error) {
    console.error('Ocurrió un error:', error);
  } finally {
    await browser.close();
  }
}

(async () => {
    try {
      //const searchText = 'Juan Perez'; // Cambia esto al texto que deseas buscar
      const results = await runPuppeteer();
      //console.log('los resultados en JSON',JSON.stringify(results, null, 2));
    } catch (error) {
      console.error('Error:', error.message);
    }
  })();