
import puppeteer from 'puppeteer';


async function runPuppeteer(searchText) {
    const browser = await puppeteer.launch({
        headless: false,
        slowMo: 100,
        //args: ['--no-sandbox', '--disable-setuid-sandbox']
    });


    const page = await browser.newPage();
  
    try {

        // Configurar un user-agent personalizado
    // await page.setUserAgent(
    //     'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    //   );

      // Navegar a Google
      await page.goto('https://www.pldinternacional.com');


      const buttonSelector = '#zak-masthead > div.zak-main-header > div > div > div.zak-header-col.zak-header-col--2 > div.zak-header-actions.zak-header-actions--desktop > div > a';
      // Esperar hasta que el botón esté presente en el DOM
      // await page.waitForSelector(buttonSelector, { timeout: 10000 });
      
        // Verificar si el botón es visible y habilitado
    const isButtonVisible = await page.evaluate((selector) => {
        const element = document.querySelector(selector);
        return element && element.offsetParent !== null; // offsetParent verifica si el elemento es visible
      }, buttonSelector);
  
      if (isButtonVisible) {
        //console.log('El botón está visible. Haciendo clic...');
        await page.click(buttonSelector); // Hacer clic en el botón
      } else {
        //console.log('El botón no está visible o no es interactuable.');
      }




    // Selector del campo de búsqueda
    const searchInputSelector = 'input.zak-search-field';

    // Esperar hasta que el campo de búsqueda esté presente en el DOM
    //await page.waitForSelector(searchInputSelector, { timeout: 10000 });

    // Escribir texto en el campo de búsqueda
    const searchText = 'Prevención'; // Cambia esto al texto que deseas buscar
    await page.type(searchInputSelector, searchText);

    // Simular la pulsación de la tecla "Enter"
    await page.keyboard.press('Enter');

    // Esperar a que los resultados de búsqueda se carguen (ajusta según tu caso)
    await page.waitForNavigation({ waitUntil: 'networkidle2' });



  
      // Escribir el texto de búsqueda en el cuadro de búsqueda
      //await page.type('input[name="q"]', searchText);
  
      // Presionar Enter para enviar el formulario
     // await page.keyboard.press('Enter');
  
      // Esperar a que los resultados de búsqueda se carguen
      //await page.waitForSelector('div#search');
  
      // Extraer los resultados de búsqueda
      const results = await page.evaluate(() => {
        const items = Array.from(document.querySelectorAll('.zak-entry-summary'));
        return items.map(item => {
          const title = item.querySelector('p')?.innerText || 'No title';
          const link = item.querySelector('a')?.href || '#';
          return { title, link };
        });
      });
  
      return results;
    } finally {
      await browser.close();
    }
}

(async () => {
    try {
      const searchText = 'web scraping'; // Cambia esto al texto que deseas buscar
      const results = await runPuppeteer(searchText);
      console.log('los resultados en JSON',JSON.stringify(results, null, 2));
    } catch (error) {
      console.error('Error:', error.message);
    }
  })();