/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { compileNgModule } from '../render3/jit/module';
import { makeDecorator } from '../util/decorators';
/**
 * @Annotation
 * @publicApi
 */
export const NgModule = makeDecorator('NgModule', (ngModule) => ngModule, undefined, undefined, 
/**
 * Decorator that marks the following class as an NgModule, and supplies
 * configuration metadata for it.
 *
 * * The `declarations` and `entryComponents` options configure the compiler
 * with information about what belongs to the NgModule.
 * * The `providers` options configures the NgModule's injector to provide
 * dependencies the NgModule members.
 * * The `imports` and `exports` options bring in members from other modules, and make
 * this module's members available to others.
 */
(type, meta) => compileNgModule(type, meta));
//# sourceMappingURL=data:application/json;base64,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