/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Always use __globalThis if available, which is the spec-defined global variable across all
// environments, then fallback to __global first, because in Node tests both __global and
// __window may be defined and _global should be __global in that case. Note: Typeof/Instanceof
// checks are considered side-effects in Terser. We explicitly mark this as side-effect free:
// https://github.com/terser/terser/issues/250.
const _global = ( /* @__PURE__ */(() => (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof global !== 'undefined' && global) || (typeof window !== 'undefined' && window) ||
    (typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
        self instanceof WorkerGlobalScope && self))());
/**
 * Attention: whenever providing a new value, be sure to add an
 * entry into the corresponding `....externs.js` file,
 * so that closure won't use that global for its purposes.
 */
export { _global as global };
//# sourceMappingURL=data:application/json;base64,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