import { Subject } from 'rxjs';
export class DynamicDialogRef {
    constructor() {
        this._onClose = new Subject();
        this.onClose = this._onClose.asObservable();
        this._onDestroy = new Subject();
        this.onDestroy = this._onDestroy.asObservable();
        this._onDragStart = new Subject();
        this.onDragStart = this._onDragStart.asObservable();
        this._onDragEnd = new Subject();
        this.onDragEnd = this._onDragEnd.asObservable();
        this._onResizeInit = new Subject();
        this.onResizeInit = this._onResizeInit.asObservable();
        this._onResizeEnd = new Subject();
        this.onResizeEnd = this._onResizeEnd.asObservable();
        this._onMaximize = new Subject();
        this.onMaximize = this._onMaximize.asObservable();
    }
    close(result) {
        this._onClose.next(result);
    }
    destroy() {
        this._onDestroy.next(null);
    }
    dragStart(event) {
        this._onDragStart.next(event);
    }
    dragEnd(event) {
        this._onDragEnd.next(event);
    }
    resizeInit(event) {
        this._onResizeInit.next(event);
    }
    resizeEnd(event) {
        this._onResizeEnd.next(event);
    }
    maximize(value) {
        this._onMaximize.next(value);
    }
}
//# sourceMappingURL=data:application/json;base64,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