function ZIndexUtils() {
    let zIndexes = [];
    const generateZIndex = (key, baseZIndex) => {
        let lastZIndex = zIndexes.length > 0 ? zIndexes[zIndexes.length - 1] : { key, value: baseZIndex };
        let newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
        zIndexes.push({ key, value: newZIndex });
        return newZIndex;
    };
    const revertZIndex = (zIndex) => {
        zIndexes = zIndexes.filter((obj) => obj.value !== zIndex);
    };
    const getCurrentZIndex = () => {
        return zIndexes.length > 0 ? zIndexes[zIndexes.length - 1].value : 0;
    };
    const getZIndex = (el) => {
        return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
    };
    return {
        get: getZIndex,
        set: (key, el, baseZIndex) => {
            if (el) {
                el.style.zIndex = String(generateZIndex(key, baseZIndex));
            }
        },
        clear: (el) => {
            if (el) {
                revertZIndex(getZIndex(el));
                el.style.zIndex = '';
            }
        },
        getCurrent: () => getCurrentZIndex()
    };
}
export default ZIndexUtils();
//# sourceMappingURL=data:application/json;base64,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