import { AnimationEvent } from '@angular/animations';
import { AfterContentInit, AfterViewChecked, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnInit, QueryList, Renderer2, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { FilterService, OverlayOptions, OverlayService, PrimeNGConfig } from 'primeng/api';
import { Overlay } from 'primeng/overlay';
import { Scroller, ScrollerOptions } from 'primeng/scroller';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/overlay";
import * as i3 from "primeng/api";
import * as i4 from "primeng/tooltip";
import * as i5 from "primeng/ripple";
import * as i6 from "primeng/scroller";
export declare const MULTISELECT_VALUE_ACCESSOR: any;
export interface MultiSelectFilterOptions {
    filter?: (value?: any) => void;
    reset?: () => void;
}
export declare class MultiSelectItem {
    option: any;
    selected: boolean;
    label: any;
    disabled: boolean;
    itemSize: number;
    template: TemplateRef<any>;
    onClick: EventEmitter<any>;
    onKeydown: EventEmitter<any>;
    onOptionClick(event: Event): void;
    onOptionKeydown(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<MultiSelectItem, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<MultiSelectItem, "p-multiSelectItem", never, { "option": "option"; "selected": "selected"; "label": "label"; "disabled": "disabled"; "itemSize": "itemSize"; "template": "template"; }, { "onClick": "onClick"; "onKeydown": "onKeydown"; }, never, never, false, never>;
}
export declare class MultiSelect implements OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, ControlValueAccessor {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    zone: NgZone;
    filterService: FilterService;
    config: PrimeNGConfig;
    overlayService: OverlayService;
    style: any;
    styleClass: string;
    panelStyle: any;
    panelStyleClass: string;
    inputId: string;
    disabled: boolean;
    readonly: boolean;
    group: boolean;
    filter: boolean;
    filterPlaceHolder: string;
    filterLocale: string;
    overlayVisible: boolean;
    tabindex: number;
    appendTo: any;
    dataKey: string;
    name: string;
    label: string;
    ariaLabelledBy: string;
    displaySelectedLabel: boolean;
    maxSelectedLabels: number;
    selectionLimit: number;
    selectedItemsLabel: string;
    showToggleAll: boolean;
    emptyFilterMessage: string;
    emptyMessage: string;
    resetFilterOnHide: boolean;
    dropdownIcon: string;
    optionLabel: string;
    optionValue: string;
    optionDisabled: string;
    optionGroupLabel: string;
    optionGroupChildren: string;
    showHeader: boolean;
    filterBy: string;
    scrollHeight: string;
    lazy: boolean;
    virtualScroll: boolean;
    virtualScrollItemSize: number;
    virtualScrollOptions: ScrollerOptions;
    overlayOptions: OverlayOptions;
    ariaFilterLabel: string;
    filterMatchMode: string;
    tooltip: string;
    tooltipPosition: string;
    tooltipPositionStyle: string;
    tooltipStyleClass: string;
    autofocusFilter: boolean;
    display: string;
    autocomplete: string;
    showClear: boolean;
    containerViewChild: ElementRef;
    overlayViewChild: Overlay;
    filterInputChild: ElementRef;
    accessibleViewChild: ElementRef;
    itemsViewChild: ElementRef;
    scroller: Scroller;
    footerFacet: any;
    headerFacet: any;
    templates: QueryList<any>;
    onChange: EventEmitter<any>;
    onFilter: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onClick: EventEmitter<any>;
    onClear: EventEmitter<any>;
    onPanelShow: EventEmitter<any>;
    onPanelHide: EventEmitter<any>;
    onLazyLoad: EventEmitter<any>;
    _autoZIndex: boolean;
    get autoZIndex(): boolean;
    set autoZIndex(val: boolean);
    _baseZIndex: number;
    get baseZIndex(): number;
    set baseZIndex(val: number);
    _showTransitionOptions: string;
    get showTransitionOptions(): string;
    set showTransitionOptions(val: string);
    _hideTransitionOptions: string;
    get hideTransitionOptions(): string;
    set hideTransitionOptions(val: string);
    _defaultLabel: string;
    set defaultLabel(val: string);
    get defaultLabel(): string;
    _placeholder: string;
    set placeholder(val: string);
    get placeholder(): string;
    get options(): any[];
    set options(val: any[]);
    get filterValue(): string;
    set filterValue(val: string);
    _itemSize: number;
    get itemSize(): number;
    set itemSize(val: number);
    value: any[];
    _filteredOptions: any[];
    onModelChange: Function;
    onModelTouched: Function;
    valuesAsString: string;
    focus: boolean;
    filled: boolean;
    _filterValue: string;
    filtered: boolean;
    itemTemplate: TemplateRef<any>;
    groupTemplate: TemplateRef<any>;
    loaderTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    filterTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    emptyFilterTemplate: TemplateRef<any>;
    emptyTemplate: TemplateRef<any>;
    selectedItemsTemplate: TemplateRef<any>;
    headerCheckboxFocus: boolean;
    filterOptions: MultiSelectFilterOptions;
    _options: any[];
    maxSelectionLimitReached: boolean;
    preventModelTouched: boolean;
    preventDocumentDefault: boolean;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef, zone: NgZone, filterService: FilterService, config: PrimeNGConfig, overlayService: OverlayService);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngAfterViewChecked(): void;
    getOptionLabel(option: any): any;
    getOptionValue(option: any): any;
    getOptionGroupLabel(optionGroup: any): any;
    getOptionGroupChildren(optionGroup: any): any;
    isOptionDisabled(option: any): any;
    writeValue(value: any): void;
    checkSelectionLimit(): void;
    updateFilledState(): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onOptionClick(event: any): void;
    isSelected(option: any): boolean;
    findSelectionIndex(val: any): number;
    get toggleAllDisabled(): boolean;
    toggleAll(event: any): void;
    checkAll(): void;
    uncheckAll(): void;
    show(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    hide(): void;
    resetFilter(): void;
    close(event: any): void;
    clear(event: any): void;
    onMouseclick(event: MouseEvent, input: any): void;
    removeChip(chip: any, event: MouseEvent): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    onOptionKeydown(event: any): void;
    findNextItem(item: any): any;
    findPrevItem(item: any): any;
    onKeydown(event: KeyboardEvent): void;
    updateLabel(): void;
    findLabelByValue(val: any): string;
    searchLabelByValue(val: any, options: any[]): string;
    get allChecked(): boolean;
    get optionsToRender(): any[];
    get emptyMessageLabel(): string;
    get emptyFilterMessageLabel(): string;
    hasFilter(): boolean;
    isEmpty(): boolean;
    onFilterInputChange(event: KeyboardEvent): void;
    activateFilter(): void;
    onHeaderCheckboxFocus(): void;
    onHeaderCheckboxBlur(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<MultiSelect, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<MultiSelect, "p-multiSelect", never, { "style": "style"; "styleClass": "styleClass"; "panelStyle": "panelStyle"; "panelStyleClass": "panelStyleClass"; "inputId": "inputId"; "disabled": "disabled"; "readonly": "readonly"; "group": "group"; "filter": "filter"; "filterPlaceHolder": "filterPlaceHolder"; "filterLocale": "filterLocale"; "overlayVisible": "overlayVisible"; "tabindex": "tabindex"; "appendTo": "appendTo"; "dataKey": "dataKey"; "name": "name"; "label": "label"; "ariaLabelledBy": "ariaLabelledBy"; "displaySelectedLabel": "displaySelectedLabel"; "maxSelectedLabels": "maxSelectedLabels"; "selectionLimit": "selectionLimit"; "selectedItemsLabel": "selectedItemsLabel"; "showToggleAll": "showToggleAll"; "emptyFilterMessage": "emptyFilterMessage"; "emptyMessage": "emptyMessage"; "resetFilterOnHide": "resetFilterOnHide"; "dropdownIcon": "dropdownIcon"; "optionLabel": "optionLabel"; "optionValue": "optionValue"; "optionDisabled": "optionDisabled"; "optionGroupLabel": "optionGroupLabel"; "optionGroupChildren": "optionGroupChildren"; "showHeader": "showHeader"; "filterBy": "filterBy"; "scrollHeight": "scrollHeight"; "lazy": "lazy"; "virtualScroll": "virtualScroll"; "virtualScrollItemSize": "virtualScrollItemSize"; "virtualScrollOptions": "virtualScrollOptions"; "overlayOptions": "overlayOptions"; "ariaFilterLabel": "ariaFilterLabel"; "filterMatchMode": "filterMatchMode"; "tooltip": "tooltip"; "tooltipPosition": "tooltipPosition"; "tooltipPositionStyle": "tooltipPositionStyle"; "tooltipStyleClass": "tooltipStyleClass"; "autofocusFilter": "autofocusFilter"; "display": "display"; "autocomplete": "autocomplete"; "showClear": "showClear"; "autoZIndex": "autoZIndex"; "baseZIndex": "baseZIndex"; "showTransitionOptions": "showTransitionOptions"; "hideTransitionOptions": "hideTransitionOptions"; "defaultLabel": "defaultLabel"; "placeholder": "placeholder"; "options": "options"; "filterValue": "filterValue"; "itemSize": "itemSize"; }, { "onChange": "onChange"; "onFilter": "onFilter"; "onFocus": "onFocus"; "onBlur": "onBlur"; "onClick": "onClick"; "onClear": "onClear"; "onPanelShow": "onPanelShow"; "onPanelHide": "onPanelHide"; "onLazyLoad": "onLazyLoad"; }, ["footerFacet", "headerFacet", "templates"], ["p-header", "p-footer"], false, never>;
}
export declare class MultiSelectModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<MultiSelectModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<MultiSelectModule, [typeof MultiSelect, typeof MultiSelectItem], [typeof i1.CommonModule, typeof i2.OverlayModule, typeof i3.SharedModule, typeof i4.TooltipModule, typeof i5.RippleModule, typeof i6.ScrollerModule], [typeof MultiSelect, typeof i2.OverlayModule, typeof i3.SharedModule, typeof i6.ScrollerModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<MultiSelectModule>;
}
