import { AnimationEvent } from '@angular/animations';
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnChanges, OnDestroy, OnInit, QueryList, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { BlockableUI, FilterMetadata, FilterService, OverlayService, PrimeNGConfig, PrimeTemplate, SelectItem, SortMeta } from 'primeng/api';
import { Scroller, ScrollerOptions } from 'primeng/scroller';
import { Subscription } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/paginator";
import * as i3 from "primeng/inputtext";
import * as i4 from "primeng/dropdown";
import * as i5 from "@angular/forms";
import * as i6 from "primeng/button";
import * as i7 from "primeng/selectbutton";
import * as i8 from "primeng/calendar";
import * as i9 from "primeng/inputnumber";
import * as i10 from "primeng/tristatecheckbox";
import * as i11 from "primeng/scroller";
import * as i12 from "primeng/api";
export declare class TableService {
    private sortSource;
    private selectionSource;
    private contextMenuSource;
    private valueSource;
    private totalRecordsSource;
    private columnsSource;
    private resetSource;
    sortSource$: import("rxjs").Observable<SortMeta | SortMeta[]>;
    selectionSource$: import("rxjs").Observable<unknown>;
    contextMenuSource$: import("rxjs").Observable<any>;
    valueSource$: import("rxjs").Observable<any>;
    totalRecordsSource$: import("rxjs").Observable<any>;
    columnsSource$: import("rxjs").Observable<unknown>;
    resetSource$: import("rxjs").Observable<unknown>;
    onSort(sortMeta: SortMeta | SortMeta[]): void;
    onSelectionChange(): void;
    onResetChange(): void;
    onContextMenu(data: any): void;
    onValueChange(value: any): void;
    onTotalRecordsChange(value: number): void;
    onColumnsChange(columns: any[]): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TableService>;
}
export declare class Table implements OnInit, AfterViewInit, AfterContentInit, BlockableUI, OnChanges {
    el: ElementRef;
    zone: NgZone;
    tableService: TableService;
    cd: ChangeDetectorRef;
    filterService: FilterService;
    overlayService: OverlayService;
    frozenColumns: any[];
    frozenValue: any[];
    style: any;
    styleClass: string;
    tableStyle: any;
    tableStyleClass: string;
    paginator: boolean;
    pageLinks: number;
    rowsPerPageOptions: any[];
    alwaysShowPaginator: boolean;
    paginatorPosition: string;
    paginatorDropdownAppendTo: any;
    paginatorDropdownScrollHeight: string;
    currentPageReportTemplate: string;
    showCurrentPageReport: boolean;
    showJumpToPageDropdown: boolean;
    showJumpToPageInput: boolean;
    showFirstLastIcon: boolean;
    showPageLinks: boolean;
    defaultSortOrder: number;
    sortMode: string;
    resetPageOnSort: boolean;
    selectionMode: string;
    selectionPageOnly: boolean;
    selectAllChange: EventEmitter<any>;
    selectionChange: EventEmitter<any>;
    contextMenuSelection: any;
    contextMenuSelectionChange: EventEmitter<any>;
    contextMenuSelectionMode: string;
    dataKey: string;
    metaKeySelection: boolean;
    rowSelectable: any;
    rowTrackBy: Function;
    lazy: boolean;
    lazyLoadOnInit: boolean;
    compareSelectionBy: string;
    csvSeparator: string;
    exportFilename: string;
    filters: {
        [s: string]: FilterMetadata | FilterMetadata[];
    };
    globalFilterFields: string[];
    filterDelay: number;
    filterLocale: string;
    expandedRowKeys: {
        [s: string]: boolean;
    };
    editingRowKeys: {
        [s: string]: boolean;
    };
    rowExpandMode: string;
    scrollable: boolean;
    scrollDirection: string;
    rowGroupMode: string;
    scrollHeight: string;
    virtualScroll: boolean;
    virtualScrollItemSize: number;
    virtualScrollOptions: ScrollerOptions;
    virtualScrollDelay: number;
    frozenWidth: string;
    _responsive: boolean;
    get responsive(): boolean;
    set responsive(val: boolean);
    contextMenu: any;
    resizableColumns: boolean;
    columnResizeMode: string;
    reorderableColumns: boolean;
    loading: boolean;
    loadingIcon: string;
    showLoader: boolean;
    rowHover: boolean;
    customSort: boolean;
    showInitialSortBadge: boolean;
    autoLayout: boolean;
    exportFunction: any;
    exportHeader: string;
    stateKey: string;
    stateStorage: string;
    editMode: string;
    groupRowsBy: any;
    groupRowsByOrder: number;
    responsiveLayout: string;
    breakpoint: string;
    onRowSelect: EventEmitter<any>;
    onRowUnselect: EventEmitter<any>;
    onPage: EventEmitter<any>;
    onSort: EventEmitter<any>;
    onFilter: EventEmitter<any>;
    onLazyLoad: EventEmitter<any>;
    onRowExpand: EventEmitter<any>;
    onRowCollapse: EventEmitter<any>;
    onContextMenuSelect: EventEmitter<any>;
    onColResize: EventEmitter<any>;
    onColReorder: EventEmitter<any>;
    onRowReorder: EventEmitter<any>;
    onEditInit: EventEmitter<any>;
    onEditComplete: EventEmitter<any>;
    onEditCancel: EventEmitter<any>;
    onHeaderCheckboxToggle: EventEmitter<any>;
    sortFunction: EventEmitter<any>;
    firstChange: EventEmitter<number>;
    rowsChange: EventEmitter<number>;
    onStateSave: EventEmitter<any>;
    onStateRestore: EventEmitter<any>;
    containerViewChild: ElementRef;
    resizeHelperViewChild: ElementRef;
    reorderIndicatorUpViewChild: ElementRef;
    reorderIndicatorDownViewChild: ElementRef;
    wrapperViewChild: ElementRef;
    tableViewChild: ElementRef;
    tableHeaderViewChild: ElementRef;
    tableFooterViewChild: ElementRef;
    scroller: Scroller;
    templates: QueryList<PrimeTemplate>;
    _virtualRowHeight: number;
    get virtualRowHeight(): number;
    set virtualRowHeight(val: number);
    _value: any[];
    _columns: any[];
    _totalRecords: number;
    _first: number;
    _rows: number;
    filteredValue: any[];
    headerTemplate: TemplateRef<any>;
    headerGroupedTemplate: TemplateRef<any>;
    bodyTemplate: TemplateRef<any>;
    loadingBodyTemplate: TemplateRef<any>;
    captionTemplate: TemplateRef<any>;
    frozenRowsTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    footerGroupedTemplate: TemplateRef<any>;
    summaryTemplate: TemplateRef<any>;
    colGroupTemplate: TemplateRef<any>;
    expandedRowTemplate: TemplateRef<any>;
    groupHeaderTemplate: TemplateRef<any>;
    groupFooterTemplate: TemplateRef<any>;
    rowspanTemplate: TemplateRef<any>;
    frozenExpandedRowTemplate: TemplateRef<any>;
    frozenHeaderTemplate: TemplateRef<any>;
    frozenBodyTemplate: TemplateRef<any>;
    frozenFooterTemplate: TemplateRef<any>;
    frozenColGroupTemplate: TemplateRef<any>;
    emptyMessageTemplate: TemplateRef<any>;
    paginatorLeftTemplate: TemplateRef<any>;
    paginatorRightTemplate: TemplateRef<any>;
    paginatorDropdownItemTemplate: TemplateRef<any>;
    selectionKeys: any;
    lastResizerHelperX: number;
    reorderIconWidth: number;
    reorderIconHeight: number;
    draggedColumn: any;
    draggedRowIndex: number;
    droppedRowIndex: number;
    rowDragging: boolean;
    dropPosition: number;
    editingCell: Element;
    editingCellData: any;
    editingCellField: any;
    editingCellRowIndex: number;
    selfClick: boolean;
    documentEditListener: any;
    _multiSortMeta: SortMeta[];
    _sortField: string;
    _sortOrder: number;
    preventSelectionSetterPropagation: boolean;
    _selection: any;
    _selectAll: boolean | null;
    anchorRowIndex: number;
    rangeRowIndex: number;
    filterTimeout: any;
    initialized: boolean;
    rowTouched: boolean;
    restoringSort: boolean;
    restoringFilter: boolean;
    stateRestored: boolean;
    columnOrderStateRestored: boolean;
    columnWidthsState: string;
    tableWidthState: string;
    overlaySubscription: Subscription;
    resizeColumnElement: any;
    columnResizing: boolean;
    rowGroupHeaderStyleObject: any;
    id: string;
    styleElement: any;
    responsiveStyleElement: any;
    constructor(el: ElementRef, zone: NgZone, tableService: TableService, cd: ChangeDetectorRef, filterService: FilterService, overlayService: OverlayService);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(simpleChange: SimpleChanges): void;
    get value(): any[];
    set value(val: any[]);
    get columns(): any[];
    set columns(cols: any[]);
    get first(): number;
    set first(val: number);
    get rows(): number;
    set rows(val: number);
    get totalRecords(): number;
    set totalRecords(val: number);
    get sortField(): string;
    set sortField(val: string);
    get sortOrder(): number;
    set sortOrder(val: number);
    get multiSortMeta(): SortMeta[];
    set multiSortMeta(val: SortMeta[]);
    get selection(): any;
    set selection(val: any);
    get selectAll(): boolean | null;
    set selectAll(val: boolean | null);
    get processedData(): any[];
    dataToRender(data: any): any;
    updateSelectionKeys(): void;
    onPageChange(event: any): void;
    sort(event: any): void;
    sortSingle(): void;
    sortMultiple(): void;
    multisortField(data1: any, data2: any, multiSortMeta: any, index: any): any;
    compareValuesOnSort(value1: any, value2: any, order: any): number;
    getSortMeta(field: string): SortMeta;
    isSorted(field: string): boolean;
    handleRowClick(event: any): void;
    handleRowTouchEnd(event: any): void;
    handleRowRightClick(event: any): void;
    selectRange(event: MouseEvent, rowIndex: number): void;
    clearSelectionRange(event: MouseEvent): void;
    isSelected(rowData: any): boolean;
    findIndexInSelection(rowData: any): number;
    isRowSelectable(data: any, index: any): boolean;
    toggleRowWithRadio(event: any, rowData: any): void;
    toggleRowWithCheckbox(event: any, rowData: any): void;
    toggleRowsWithCheckbox(event: Event, check: boolean): void;
    equals(data1: any, data2: any): boolean;
    filter(value: any, field: string, matchMode: string): void;
    filterGlobal(value: any, matchMode: any): void;
    isFilterBlank(filter: any): boolean;
    _filter(): void;
    executeLocalFilter(field: string, rowData: any, filterMeta: FilterMetadata): boolean;
    hasFilter(): boolean;
    createLazyLoadMetadata(): any;
    clear(): void;
    reset(): void;
    getExportHeader(column: any): any;
    exportCSV(options?: any): void;
    onLazyItemLoad(event: any): void;
    resetScrollTop(): void;
    scrollToVirtualIndex(index: number): void;
    scrollTo(options: any): void;
    updateEditingCell(cell: any, data: any, field: any, index: any): void;
    isEditingCellValid(): boolean;
    bindDocumentEditListener(): void;
    unbindDocumentEditListener(): void;
    initRowEdit(rowData: any): void;
    saveRowEdit(rowData: any, rowElement: HTMLTableRowElement): void;
    cancelRowEdit(rowData: any): void;
    toggleRow(rowData: any, event?: Event): void;
    isRowExpanded(rowData: any): boolean;
    isRowEditing(rowData: any): boolean;
    isSingleSelectionMode(): boolean;
    isMultipleSelectionMode(): boolean;
    onColumnResizeBegin(event: any): void;
    onColumnResize(event: any): void;
    onColumnResizeEnd(): void;
    resizeTableCells(newColumnWidth: any, nextColumnWidth: any): void;
    onColumnDragStart(event: any, columnElement: any): void;
    onColumnDragEnter(event: any, dropHeader: any): void;
    onColumnDragLeave(event: any): void;
    onColumnDrop(event: any, dropColumn: any): void;
    onRowDragStart(event: any, index: any): void;
    onRowDragOver(event: any, index: any, rowElement: any): void;
    onRowDragLeave(event: any, rowElement: any): void;
    onRowDragEnd(event: any): void;
    onRowDrop(event: any, rowElement: any): void;
    isEmpty(): boolean;
    getBlockableElement(): HTMLElement;
    getStorage(): Storage;
    isStateful(): boolean;
    saveState(): void;
    clearState(): void;
    restoreState(): void;
    saveColumnWidths(state: any): void;
    setResizeTableWidth(width: string): void;
    restoreColumnWidths(): void;
    saveColumnOrder(state: any): void;
    restoreColumnOrder(): void;
    findColumnByKey(key: any): any;
    createStyleElement(): void;
    getGroupRowsMeta(): {
        field: any;
        order: number;
    };
    createResponsiveStyle(): void;
    destroyResponsiveStyle(): void;
    destroyStyleElement(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<Table, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<Table, "p-table", never, { "frozenColumns": "frozenColumns"; "frozenValue": "frozenValue"; "style": "style"; "styleClass": "styleClass"; "tableStyle": "tableStyle"; "tableStyleClass": "tableStyleClass"; "paginator": "paginator"; "pageLinks": "pageLinks"; "rowsPerPageOptions": "rowsPerPageOptions"; "alwaysShowPaginator": "alwaysShowPaginator"; "paginatorPosition": "paginatorPosition"; "paginatorDropdownAppendTo": "paginatorDropdownAppendTo"; "paginatorDropdownScrollHeight": "paginatorDropdownScrollHeight"; "currentPageReportTemplate": "currentPageReportTemplate"; "showCurrentPageReport": "showCurrentPageReport"; "showJumpToPageDropdown": "showJumpToPageDropdown"; "showJumpToPageInput": "showJumpToPageInput"; "showFirstLastIcon": "showFirstLastIcon"; "showPageLinks": "showPageLinks"; "defaultSortOrder": "defaultSortOrder"; "sortMode": "sortMode"; "resetPageOnSort": "resetPageOnSort"; "selectionMode": "selectionMode"; "selectionPageOnly": "selectionPageOnly"; "contextMenuSelection": "contextMenuSelection"; "contextMenuSelectionMode": "contextMenuSelectionMode"; "dataKey": "dataKey"; "metaKeySelection": "metaKeySelection"; "rowSelectable": "rowSelectable"; "rowTrackBy": "rowTrackBy"; "lazy": "lazy"; "lazyLoadOnInit": "lazyLoadOnInit"; "compareSelectionBy": "compareSelectionBy"; "csvSeparator": "csvSeparator"; "exportFilename": "exportFilename"; "filters": "filters"; "globalFilterFields": "globalFilterFields"; "filterDelay": "filterDelay"; "filterLocale": "filterLocale"; "expandedRowKeys": "expandedRowKeys"; "editingRowKeys": "editingRowKeys"; "rowExpandMode": "rowExpandMode"; "scrollable": "scrollable"; "scrollDirection": "scrollDirection"; "rowGroupMode": "rowGroupMode"; "scrollHeight": "scrollHeight"; "virtualScroll": "virtualScroll"; "virtualScrollItemSize": "virtualScrollItemSize"; "virtualScrollOptions": "virtualScrollOptions"; "virtualScrollDelay": "virtualScrollDelay"; "frozenWidth": "frozenWidth"; "responsive": "responsive"; "contextMenu": "contextMenu"; "resizableColumns": "resizableColumns"; "columnResizeMode": "columnResizeMode"; "reorderableColumns": "reorderableColumns"; "loading": "loading"; "loadingIcon": "loadingIcon"; "showLoader": "showLoader"; "rowHover": "rowHover"; "customSort": "customSort"; "showInitialSortBadge": "showInitialSortBadge"; "autoLayout": "autoLayout"; "exportFunction": "exportFunction"; "exportHeader": "exportHeader"; "stateKey": "stateKey"; "stateStorage": "stateStorage"; "editMode": "editMode"; "groupRowsBy": "groupRowsBy"; "groupRowsByOrder": "groupRowsByOrder"; "responsiveLayout": "responsiveLayout"; "breakpoint": "breakpoint"; "virtualRowHeight": "virtualRowHeight"; "value": "value"; "columns": "columns"; "first": "first"; "rows": "rows"; "totalRecords": "totalRecords"; "sortField": "sortField"; "sortOrder": "sortOrder"; "multiSortMeta": "multiSortMeta"; "selection": "selection"; "selectAll": "selectAll"; }, { "selectAllChange": "selectAllChange"; "selectionChange": "selectionChange"; "contextMenuSelectionChange": "contextMenuSelectionChange"; "onRowSelect": "onRowSelect"; "onRowUnselect": "onRowUnselect"; "onPage": "onPage"; "onSort": "onSort"; "onFilter": "onFilter"; "onLazyLoad": "onLazyLoad"; "onRowExpand": "onRowExpand"; "onRowCollapse": "onRowCollapse"; "onContextMenuSelect": "onContextMenuSelect"; "onColResize": "onColResize"; "onColReorder": "onColReorder"; "onRowReorder": "onRowReorder"; "onEditInit": "onEditInit"; "onEditComplete": "onEditComplete"; "onEditCancel": "onEditCancel"; "onHeaderCheckboxToggle": "onHeaderCheckboxToggle"; "sortFunction": "sortFunction"; "firstChange": "firstChange"; "rowsChange": "rowsChange"; "onStateSave": "onStateSave"; "onStateRestore": "onStateRestore"; }, ["templates"], never, false, never>;
}
export declare class TableBody implements AfterViewInit, OnDestroy {
    dt: Table;
    tableService: TableService;
    cd: ChangeDetectorRef;
    el: ElementRef;
    columns: any[];
    template: TemplateRef<any>;
    get value(): any[];
    set value(val: any[]);
    frozen: boolean;
    frozenRows: boolean;
    scrollerOptions: any;
    subscription: Subscription;
    _value: any[];
    ngAfterViewInit(): void;
    constructor(dt: Table, tableService: TableService, cd: ChangeDetectorRef, el: ElementRef);
    shouldRenderRowGroupHeader(value: any, rowData: any, i: any): boolean;
    shouldRenderRowGroupFooter(value: any, rowData: any, i: any): boolean;
    shouldRenderRowspan(value: any, rowData: any, i: any): boolean;
    calculateRowGroupSize(value: any, rowData: any, index: any): number;
    ngOnDestroy(): void;
    updateFrozenRowStickyPosition(): void;
    updateFrozenRowGroupHeaderStickyPosition(): void;
    getScrollerOption(option: any, options?: any): any;
    getRowIndex(rowIndex: any): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableBody, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TableBody, "[pTableBody]", never, { "columns": "pTableBody"; "template": "pTableBodyTemplate"; "value": "value"; "frozen": "frozen"; "frozenRows": "frozenRows"; "scrollerOptions": "scrollerOptions"; }, {}, never, never, false, never>;
}
export declare class RowGroupHeader {
    dt: Table;
    constructor(dt: Table);
    get getFrozenRowGroupHeaderStickyPosition(): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<RowGroupHeader, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<RowGroupHeader, "[pRowGroupHeader]", never, {}, {}, never, never, false, never>;
}
export declare class FrozenColumn implements AfterViewInit {
    private el;
    get frozen(): boolean;
    set frozen(val: boolean);
    alignFrozen: string;
    constructor(el: ElementRef);
    ngAfterViewInit(): void;
    _frozen: boolean;
    updateStickyPosition(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<FrozenColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<FrozenColumn, "[pFrozenColumn]", never, { "frozen": "frozen"; "alignFrozen": "alignFrozen"; }, {}, never, never, false, never>;
}
export declare class SortableColumn implements OnInit, OnDestroy {
    dt: Table;
    field: string;
    pSortableColumnDisabled: boolean;
    sorted: boolean;
    sortOrder: string;
    subscription: Subscription;
    constructor(dt: Table);
    ngOnInit(): void;
    updateSortState(): void;
    onClick(event: MouseEvent): void;
    onEnterKey(event: MouseEvent): void;
    isEnabled(): boolean;
    isFilterElement(element: HTMLElement): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SortableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<SortableColumn, "[pSortableColumn]", never, { "field": "pSortableColumn"; "pSortableColumnDisabled": "pSortableColumnDisabled"; }, {}, never, never, false, never>;
}
export declare class SortIcon implements OnInit, OnDestroy {
    dt: Table;
    cd: ChangeDetectorRef;
    field: string;
    subscription: Subscription;
    sortOrder: number;
    constructor(dt: Table, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: any): void;
    updateSortState(): void;
    getMultiSortMetaIndex(): number;
    getBadgeValue(): number;
    isMultiSorted(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SortIcon, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SortIcon, "p-sortIcon", never, { "field": "field"; }, {}, never, never, false, never>;
}
export declare class SelectableRow implements OnInit, OnDestroy {
    dt: Table;
    tableService: TableService;
    data: any;
    index: number;
    pSelectableRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(dt: Table, tableService: TableService);
    ngOnInit(): void;
    onClick(event: Event): void;
    onTouchEnd(event: Event): void;
    onArrowDownKeyDown(event: KeyboardEvent): void;
    onArrowUpKeyDown(event: KeyboardEvent): void;
    onEnterKeyDown(event: KeyboardEvent): void;
    onPageDownKeyDown(): void;
    onSpaceKeydown(): void;
    findNextSelectableRow(row: HTMLTableRowElement): HTMLTableRowElement;
    findPrevSelectableRow(row: HTMLTableRowElement): HTMLTableRowElement;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SelectableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<SelectableRow, "[pSelectableRow]", never, { "data": "pSelectableRow"; "index": "pSelectableRowIndex"; "pSelectableRowDisabled": "pSelectableRowDisabled"; }, {}, never, never, false, never>;
}
export declare class SelectableRowDblClick implements OnInit, OnDestroy {
    dt: Table;
    tableService: TableService;
    data: any;
    index: number;
    pSelectableRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(dt: Table, tableService: TableService);
    ngOnInit(): void;
    onClick(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SelectableRowDblClick, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<SelectableRowDblClick, "[pSelectableRowDblClick]", never, { "data": "pSelectableRowDblClick"; "index": "pSelectableRowIndex"; "pSelectableRowDisabled": "pSelectableRowDisabled"; }, {}, never, never, false, never>;
}
export declare class ContextMenuRow {
    dt: Table;
    tableService: TableService;
    private el;
    data: any;
    index: number;
    pContextMenuRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(dt: Table, tableService: TableService, el: ElementRef);
    onContextMenu(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ContextMenuRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ContextMenuRow, "[pContextMenuRow]", never, { "data": "pContextMenuRow"; "index": "pContextMenuRowIndex"; "pContextMenuRowDisabled": "pContextMenuRowDisabled"; }, {}, never, never, false, never>;
}
export declare class RowToggler {
    dt: Table;
    data: any;
    pRowTogglerDisabled: boolean;
    constructor(dt: Table);
    onClick(event: Event): void;
    isEnabled(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<RowToggler, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<RowToggler, "[pRowToggler]", never, { "data": "pRowToggler"; "pRowTogglerDisabled": "pRowTogglerDisabled"; }, {}, never, never, false, never>;
}
export declare class ResizableColumn implements AfterViewInit, OnDestroy {
    dt: Table;
    el: ElementRef;
    zone: NgZone;
    pResizableColumnDisabled: boolean;
    resizer: HTMLSpanElement;
    resizerMouseDownListener: any;
    documentMouseMoveListener: any;
    documentMouseUpListener: any;
    constructor(dt: Table, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindDocumentEvents(): void;
    unbindDocumentEvents(): void;
    onMouseDown(event: MouseEvent): void;
    onDocumentMouseMove(event: MouseEvent): void;
    onDocumentMouseUp(event: MouseEvent): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ResizableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ResizableColumn, "[pResizableColumn]", never, { "pResizableColumnDisabled": "pResizableColumnDisabled"; }, {}, never, never, false, never>;
}
export declare class ReorderableColumn implements AfterViewInit, OnDestroy {
    dt: Table;
    el: ElementRef;
    zone: NgZone;
    pReorderableColumnDisabled: boolean;
    dragStartListener: any;
    dragOverListener: any;
    dragEnterListener: any;
    dragLeaveListener: any;
    mouseDownListener: any;
    constructor(dt: Table, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindEvents(): void;
    unbindEvents(): void;
    onMouseDown(event: any): void;
    onDragStart(event: any): void;
    onDragOver(event: any): void;
    onDragEnter(event: any): void;
    onDragLeave(event: any): void;
    onDrop(event: any): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ReorderableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ReorderableColumn, "[pReorderableColumn]", never, { "pReorderableColumnDisabled": "pReorderableColumnDisabled"; }, {}, never, never, false, never>;
}
export declare class EditableColumn implements AfterViewInit, OnDestroy {
    dt: Table;
    el: ElementRef;
    zone: NgZone;
    data: any;
    field: any;
    rowIndex: number;
    pEditableColumnDisabled: boolean;
    pFocusCellSelector: string;
    overlayEventListener: any;
    constructor(dt: Table, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    onClick(event: MouseEvent): void;
    openCell(): void;
    closeEditingCell(completed: any, event: any): void;
    onEnterKeyDown(event: KeyboardEvent): void;
    onTabKeyDown(event: KeyboardEvent): void;
    onEscapeKeyDown(event: KeyboardEvent): void;
    onShiftKeyDown(event: KeyboardEvent): void;
    onArrowDown(event: KeyboardEvent): void;
    onArrowUp(event: KeyboardEvent): void;
    onArrowLeft(event: KeyboardEvent): void;
    onArrowRight(event: KeyboardEvent): void;
    findCell(element: any): any;
    moveToPreviousCell(event: KeyboardEvent): void;
    moveToNextCell(event: KeyboardEvent): void;
    findPreviousEditableColumn(cell: Element): any;
    findNextEditableColumn(cell: Element): any;
    findNextEditableColumnByIndex(cell: Element, index: number): Element;
    findPrevEditableColumnByIndex(cell: Element, index: number): Element;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<EditableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<EditableColumn, "[pEditableColumn]", never, { "data": "pEditableColumn"; "field": "pEditableColumnField"; "rowIndex": "pEditableColumnRowIndex"; "pEditableColumnDisabled": "pEditableColumnDisabled"; "pFocusCellSelector": "pFocusCellSelector"; }, {}, never, never, false, never>;
}
export declare class EditableRow {
    el: ElementRef;
    data: any;
    pEditableRowDisabled: boolean;
    constructor(el: ElementRef);
    isEnabled(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<EditableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<EditableRow, "[pEditableRow]", never, { "data": "pEditableRow"; "pEditableRowDisabled": "pEditableRowDisabled"; }, {}, never, never, false, never>;
}
export declare class InitEditableRow {
    dt: Table;
    editableRow: EditableRow;
    constructor(dt: Table, editableRow: EditableRow);
    onClick(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<InitEditableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<InitEditableRow, "[pInitEditableRow]", never, {}, {}, never, never, false, never>;
}
export declare class SaveEditableRow {
    dt: Table;
    editableRow: EditableRow;
    constructor(dt: Table, editableRow: EditableRow);
    onClick(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SaveEditableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<SaveEditableRow, "[pSaveEditableRow]", never, {}, {}, never, never, false, never>;
}
export declare class CancelEditableRow {
    dt: Table;
    editableRow: EditableRow;
    constructor(dt: Table, editableRow: EditableRow);
    onClick(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<CancelEditableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<CancelEditableRow, "[pCancelEditableRow]", never, {}, {}, never, never, false, never>;
}
export declare class CellEditor implements AfterContentInit {
    dt: Table;
    editableColumn: EditableColumn;
    editableRow: EditableRow;
    templates: QueryList<PrimeTemplate>;
    inputTemplate: TemplateRef<any>;
    outputTemplate: TemplateRef<any>;
    constructor(dt: Table, editableColumn: EditableColumn, editableRow: EditableRow);
    ngAfterContentInit(): void;
    get editing(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<CellEditor, [null, { optional: true; }, { optional: true; }]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<CellEditor, "p-cellEditor", never, {}, {}, ["templates"], never, false, never>;
}
export declare class TableRadioButton {
    dt: Table;
    tableService: TableService;
    cd: ChangeDetectorRef;
    disabled: boolean;
    value: any;
    index: number;
    inputId: string;
    name: string;
    ariaLabel: string;
    checked: boolean;
    focused: boolean;
    subscription: Subscription;
    constructor(dt: Table, tableService: TableService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: Event): void;
    onFocus(): void;
    onBlur(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableRadioButton, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TableRadioButton, "p-tableRadioButton", never, { "disabled": "disabled"; "value": "value"; "index": "index"; "inputId": "inputId"; "name": "name"; "ariaLabel": "ariaLabel"; }, {}, never, never, false, never>;
}
export declare class TableCheckbox {
    dt: Table;
    tableService: TableService;
    cd: ChangeDetectorRef;
    disabled: boolean;
    value: any;
    index: number;
    inputId: string;
    name: string;
    required: boolean;
    ariaLabel: string;
    checked: boolean;
    focused: boolean;
    subscription: Subscription;
    constructor(dt: Table, tableService: TableService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: Event): void;
    onFocus(): void;
    onBlur(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableCheckbox, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TableCheckbox, "p-tableCheckbox", never, { "disabled": "disabled"; "value": "value"; "index": "index"; "inputId": "inputId"; "name": "name"; "required": "required"; "ariaLabel": "ariaLabel"; }, {}, never, never, false, never>;
}
export declare class TableHeaderCheckbox {
    dt: Table;
    tableService: TableService;
    cd: ChangeDetectorRef;
    disabled: boolean;
    inputId: string;
    name: string;
    ariaLabel: string;
    checked: boolean;
    focused: boolean;
    selectionChangeSubscription: Subscription;
    valueChangeSubscription: Subscription;
    constructor(dt: Table, tableService: TableService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: Event): void;
    onFocus(): void;
    onBlur(): void;
    isDisabled(): boolean;
    ngOnDestroy(): void;
    updateCheckedState(): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<TableHeaderCheckbox, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TableHeaderCheckbox, "p-tableHeaderCheckbox", never, { "disabled": "disabled"; "inputId": "inputId"; "name": "name"; "ariaLabel": "ariaLabel"; }, {}, never, never, false, never>;
}
export declare class ReorderableRowHandle implements AfterViewInit {
    el: ElementRef;
    index: number;
    constructor(el: ElementRef);
    ngAfterViewInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ReorderableRowHandle, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ReorderableRowHandle, "[pReorderableRowHandle]", never, { "index": "pReorderableRowHandle"; }, {}, never, never, false, never>;
}
export declare class ReorderableRow implements AfterViewInit {
    dt: Table;
    el: ElementRef;
    zone: NgZone;
    index: number;
    pReorderableRowDisabled: boolean;
    mouseDownListener: any;
    dragStartListener: any;
    dragEndListener: any;
    dragOverListener: any;
    dragLeaveListener: any;
    dropListener: any;
    constructor(dt: Table, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindEvents(): void;
    unbindEvents(): void;
    onMouseDown(event: any): void;
    onDragStart(event: any): void;
    onDragEnd(event: any): void;
    onDragOver(event: any): void;
    onDragLeave(event: any): void;
    isEnabled(): boolean;
    onDrop(event: any): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ReorderableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<ReorderableRow, "[pReorderableRow]", never, { "index": "pReorderableRow"; "pReorderableRowDisabled": "pReorderableRowDisabled"; }, {}, never, never, false, never>;
}
export declare class ColumnFilter implements AfterContentInit {
    el: ElementRef;
    dt: Table;
    renderer: Renderer2;
    config: PrimeNGConfig;
    overlayService: OverlayService;
    field: string;
    type: string;
    display: string;
    showMenu: boolean;
    matchMode: string;
    operator: string;
    showOperator: boolean;
    showClearButton: boolean;
    showApplyButton: boolean;
    showMatchModes: boolean;
    showAddButton: boolean;
    hideOnClear: boolean;
    placeholder: string;
    matchModeOptions: SelectItem[];
    maxConstraints: number;
    minFractionDigits: number;
    maxFractionDigits: number;
    prefix: string;
    suffix: string;
    locale: string;
    localeMatcher: string;
    currency: string;
    currencyDisplay: string;
    useGrouping: boolean;
    showButtons: boolean;
    icon: ElementRef;
    templates: QueryList<any>;
    constructor(el: ElementRef, dt: Table, renderer: Renderer2, config: PrimeNGConfig, overlayService: OverlayService);
    overlaySubscription: Subscription;
    headerTemplate: TemplateRef<any>;
    filterTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    operatorOptions: any[];
    overlayVisible: boolean;
    overlay: HTMLElement;
    scrollHandler: any;
    documentClickListener: any;
    documentResizeListener: any;
    matchModes: SelectItem[];
    translationSubscription: Subscription;
    resetSubscription: Subscription;
    selfClick: boolean;
    overlayEventListener: any;
    ngOnInit(): void;
    generateMatchModeOptions(): void;
    generateOperatorOptions(): void;
    ngAfterContentInit(): void;
    initFieldFilterConstraint(): void;
    onMenuMatchModeChange(value: any, filterMeta: FilterMetadata): void;
    onRowMatchModeChange(matchMode: string): void;
    onRowMatchModeKeyDown(event: KeyboardEvent): void;
    onRowClearItemClick(): void;
    isRowMatchModeSelected(matchMode: string): boolean;
    addConstraint(): void;
    removeConstraint(filterMeta: FilterMetadata): void;
    onOperatorChange(value: any): void;
    toggleMenu(): void;
    onToggleButtonKeyDown(event: KeyboardEvent): void;
    onEscape(): void;
    findNextItem(item: HTMLLIElement): any;
    findPrevItem(item: HTMLLIElement): any;
    onContentClick(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    onOverlayAnimationEnd(event: AnimationEvent): void;
    getDefaultMatchMode(): string;
    getDefaultOperator(): string;
    hasRowFilter(): boolean;
    get fieldConstraints(): FilterMetadata[];
    get showRemoveIcon(): boolean;
    get showMenuButton(): boolean;
    get isShowOperator(): boolean;
    get isShowAddConstraint(): boolean;
    get applyButtonLabel(): string;
    get clearButtonLabel(): string;
    get addRuleButtonLabel(): string;
    get removeRuleButtonLabel(): string;
    get noFilterLabel(): string;
    hasFilter(): boolean;
    isOutsideClicked(event: any): boolean;
    bindDocumentClickListener(): void;
    unbindDocumentClickListener(): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    hide(): void;
    onOverlayHide(): void;
    clearFilter(): void;
    applyFilter(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ColumnFilter, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ColumnFilter, "p-columnFilter", never, { "field": "field"; "type": "type"; "display": "display"; "showMenu": "showMenu"; "matchMode": "matchMode"; "operator": "operator"; "showOperator": "showOperator"; "showClearButton": "showClearButton"; "showApplyButton": "showApplyButton"; "showMatchModes": "showMatchModes"; "showAddButton": "showAddButton"; "hideOnClear": "hideOnClear"; "placeholder": "placeholder"; "matchModeOptions": "matchModeOptions"; "maxConstraints": "maxConstraints"; "minFractionDigits": "minFractionDigits"; "maxFractionDigits": "maxFractionDigits"; "prefix": "prefix"; "suffix": "suffix"; "locale": "locale"; "localeMatcher": "localeMatcher"; "currency": "currency"; "currencyDisplay": "currencyDisplay"; "useGrouping": "useGrouping"; "showButtons": "showButtons"; }, {}, ["templates"], never, false, never>;
}
export declare class ColumnFilterFormElement implements OnInit {
    dt: Table;
    private colFilter;
    field: string;
    type: string;
    filterConstraint: FilterMetadata;
    filterTemplate: TemplateRef<any>;
    placeholder: string;
    minFractionDigits: number;
    maxFractionDigits: number;
    prefix: string;
    suffix: string;
    locale: string;
    localeMatcher: string;
    currency: string;
    currencyDisplay: string;
    useGrouping: boolean;
    get showButtons(): boolean;
    filterCallback: Function;
    constructor(dt: Table, colFilter: ColumnFilter);
    ngOnInit(): void;
    onModelChange(value: any): void;
    onTextInputEnterKeyDown(event: KeyboardEvent): void;
    onNumericInputKeyDown(event: KeyboardEvent): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ColumnFilterFormElement, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ColumnFilterFormElement, "p-columnFilterFormElement", never, { "field": "field"; "type": "type"; "filterConstraint": "filterConstraint"; "filterTemplate": "filterTemplate"; "placeholder": "placeholder"; "minFractionDigits": "minFractionDigits"; "maxFractionDigits": "maxFractionDigits"; "prefix": "prefix"; "suffix": "suffix"; "locale": "locale"; "localeMatcher": "localeMatcher"; "currency": "currency"; "currencyDisplay": "currencyDisplay"; "useGrouping": "useGrouping"; }, {}, never, never, false, never>;
}
export declare class TableModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<TableModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TableModule, [typeof Table, typeof SortableColumn, typeof FrozenColumn, typeof RowGroupHeader, typeof SelectableRow, typeof RowToggler, typeof ContextMenuRow, typeof ResizableColumn, typeof ReorderableColumn, typeof EditableColumn, typeof CellEditor, typeof TableBody, typeof SortIcon, typeof TableRadioButton, typeof TableCheckbox, typeof TableHeaderCheckbox, typeof ReorderableRowHandle, typeof ReorderableRow, typeof SelectableRowDblClick, typeof EditableRow, typeof InitEditableRow, typeof SaveEditableRow, typeof CancelEditableRow, typeof ColumnFilter, typeof ColumnFilterFormElement], [typeof i1.CommonModule, typeof i2.PaginatorModule, typeof i3.InputTextModule, typeof i4.DropdownModule, typeof i5.FormsModule, typeof i6.ButtonModule, typeof i7.SelectButtonModule, typeof i8.CalendarModule, typeof i9.InputNumberModule, typeof i10.TriStateCheckboxModule, typeof i11.ScrollerModule], [typeof Table, typeof i12.SharedModule, typeof SortableColumn, typeof FrozenColumn, typeof RowGroupHeader, typeof SelectableRow, typeof RowToggler, typeof ContextMenuRow, typeof ResizableColumn, typeof ReorderableColumn, typeof EditableColumn, typeof CellEditor, typeof SortIcon, typeof TableRadioButton, typeof TableCheckbox, typeof TableHeaderCheckbox, typeof ReorderableRowHandle, typeof ReorderableRow, typeof SelectableRowDblClick, typeof EditableRow, typeof InitEditableRow, typeof SaveEditableRow, typeof CancelEditableRow, typeof ColumnFilter, typeof ColumnFilterFormElement, typeof i11.ScrollerModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TableModule>;
}
