import { AfterContentInit, OnDestroy, EventEmitter, OnInit, OnChanges, QueryList, TemplateRef, ElementRef, SimpleChanges } from '@angular/core';
import { PrimeNGConfig, TreeNode } from 'primeng/api';
import { TreeDragDropService } from 'primeng/api';
import { Subscription } from 'rxjs';
import { BlockableUI } from 'primeng/api';
import { Scroller, ScrollerOptions } from 'primeng/scroller';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/api";
import * as i3 from "primeng/ripple";
import * as i4 from "primeng/scroller";
export declare class UITreeNode implements OnInit {
    static ICON_CLASS: string;
    rowNode: any;
    node: TreeNode;
    parentNode: TreeNode;
    root: boolean;
    index: number;
    firstChild: boolean;
    lastChild: boolean;
    level: number;
    indentation: number;
    itemSize: number;
    tree: Tree;
    constructor(tree: any);
    draghoverPrev: boolean;
    draghoverNext: boolean;
    draghoverNode: boolean;
    ngOnInit(): void;
    getIcon(): string;
    isLeaf(): boolean;
    toggle(event: Event): void;
    expand(event: Event): void;
    collapse(event: Event): void;
    onNodeClick(event: MouseEvent): void;
    onNodeKeydown(event: KeyboardEvent): void;
    onNodeTouchEnd(): void;
    onNodeRightClick(event: MouseEvent): void;
    isSelected(): boolean;
    onDropPoint(event: Event, position: number): void;
    processPointDrop(event: any): void;
    createDropPointEventMetadata(position: any): {
        dragNode: TreeNode<any>;
        dragNodeIndex: number;
        dragNodeSubNodes: TreeNode<any>[];
        dropNode: TreeNode<any>;
        index: number;
        position: any;
    };
    onDropPointDragOver(event: any): void;
    onDropPointDragEnter(event: Event, position: number): void;
    onDropPointDragLeave(event: Event): void;
    onDragStart(event: any): void;
    onDragStop(event: any): void;
    onDropNodeDragOver(event: any): void;
    onDropNode(event: any): void;
    createDropNodeEventMetadata(): {
        dragNode: TreeNode<any>;
        dragNodeIndex: number;
        dragNodeSubNodes: TreeNode<any>[];
        dropNode: TreeNode<any>;
    };
    processNodeDrop(event: any): void;
    onDropNodeDragEnter(event: any): void;
    onDropNodeDragLeave(event: any): void;
    onKeyDown(event: KeyboardEvent): void;
    findNextSiblingOfAncestor(nodeElement: any): any;
    findLastVisibleDescendant(nodeElement: any): any;
    getParentNodeElement(nodeElement: any): any;
    focusNode(element: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<UITreeNode, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<UITreeNode, "p-treeNode", never, { "rowNode": "rowNode"; "node": "node"; "parentNode": "parentNode"; "root": "root"; "index": "index"; "firstChild": "firstChild"; "lastChild": "lastChild"; "level": "level"; "indentation": "indentation"; "itemSize": "itemSize"; }, {}, never, never, false, never>;
}
export declare class Tree implements OnInit, AfterContentInit, OnChanges, OnDestroy, BlockableUI {
    el: ElementRef;
    dragDropService: TreeDragDropService;
    config: PrimeNGConfig;
    value: TreeNode[];
    selectionMode: string;
    selection: any;
    style: any;
    styleClass: string;
    contextMenu: any;
    layout: string;
    draggableScope: any;
    droppableScope: any;
    draggableNodes: boolean;
    droppableNodes: boolean;
    metaKeySelection: boolean;
    propagateSelectionUp: boolean;
    propagateSelectionDown: boolean;
    loading: boolean;
    loadingIcon: string;
    emptyMessage: string;
    ariaLabel: string;
    togglerAriaLabel: string;
    ariaLabelledBy: string;
    validateDrop: boolean;
    filter: boolean;
    filterBy: string;
    filterMode: string;
    filterPlaceholder: string;
    filteredNodes: TreeNode[];
    filterLocale: string;
    scrollHeight: string;
    lazy: boolean;
    virtualScroll: boolean;
    virtualScrollItemSize: number;
    virtualScrollOptions: ScrollerOptions;
    indentation: number;
    _templateMap: any;
    trackBy: Function;
    selectionChange: EventEmitter<any>;
    onNodeSelect: EventEmitter<any>;
    onNodeUnselect: EventEmitter<any>;
    onNodeExpand: EventEmitter<any>;
    onNodeCollapse: EventEmitter<any>;
    onNodeContextMenuSelect: EventEmitter<any>;
    onNodeDrop: EventEmitter<any>;
    onLazyLoad: EventEmitter<any>;
    onScroll: EventEmitter<any>;
    onScrollIndexChange: EventEmitter<any>;
    onFilter: EventEmitter<any>;
    templates: QueryList<any>;
    filterViewChild: ElementRef;
    scroller: Scroller;
    wrapperViewChild: ElementRef;
    _virtualNodeHeight: number;
    get virtualNodeHeight(): number;
    set virtualNodeHeight(val: number);
    serializedValue: any[];
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    loaderTemplate: TemplateRef<any>;
    emptyMessageTemplate: TemplateRef<any>;
    nodeTouched: boolean;
    dragNodeTree: Tree;
    dragNode: TreeNode;
    dragNodeSubNodes: TreeNode[];
    dragNodeIndex: number;
    dragNodeScope: any;
    dragHover: boolean;
    dragStartSubscription: Subscription;
    dragStopSubscription: Subscription;
    constructor(el: ElementRef, dragDropService: TreeDragDropService, config: PrimeNGConfig);
    ngOnInit(): void;
    ngOnChanges(simpleChange: SimpleChanges): void;
    get horizontal(): boolean;
    get emptyMessageLabel(): string;
    ngAfterContentInit(): void;
    updateSerializedValue(): void;
    serializeNodes(parent: any, nodes: any, level: any, visible: any): void;
    onNodeClick(event: any, node: TreeNode): void;
    onNodeTouchEnd(): void;
    onNodeRightClick(event: MouseEvent, node: TreeNode): void;
    findIndexInSelection(node: TreeNode): number;
    syncNodeOption(node: any, parentNodes: any, option: any, value?: any): void;
    hasFilteredNodes(): number;
    getNodeWithKey(key: string, nodes: TreeNode[]): any;
    propagateUp(node: TreeNode, select: boolean): void;
    propagateDown(node: TreeNode, select: boolean): void;
    isSelected(node: TreeNode): boolean;
    isSingleSelectionMode(): boolean;
    isMultipleSelectionMode(): boolean;
    isCheckboxSelectionMode(): boolean;
    isNodeLeaf(node: any): boolean;
    getRootNode(): TreeNode<any>[];
    getTemplateForNode(node: TreeNode): TemplateRef<any>;
    onDragOver(event: any): void;
    onDrop(event: any): void;
    processTreeDrop(dragNode: any, dragNodeIndex: any): void;
    onDragEnter(): void;
    onDragLeave(event: any): void;
    allowDrop(dragNode: TreeNode, dropNode: TreeNode, dragNodeScope: any): boolean;
    isValidDragScope(dragScope: any): boolean;
    _filter(value: any): void;
    resetFilter(): void;
    scrollToVirtualIndex(index: number): void;
    scrollTo(options: any): void;
    findFilteredNodes(node: any, paramsWithoutNode: any): boolean;
    isFilterMatched(node: any, { searchFields, filterText, isStrictMode }: {
        searchFields: any;
        filterText: any;
        isStrictMode: any;
    }): boolean;
    getIndex(options: any, index: any): any;
    getBlockableElement(): HTMLElement;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<Tree, [null, { optional: true; }, null]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<Tree, "p-tree", never, { "value": "value"; "selectionMode": "selectionMode"; "selection": "selection"; "style": "style"; "styleClass": "styleClass"; "contextMenu": "contextMenu"; "layout": "layout"; "draggableScope": "draggableScope"; "droppableScope": "droppableScope"; "draggableNodes": "draggableNodes"; "droppableNodes": "droppableNodes"; "metaKeySelection": "metaKeySelection"; "propagateSelectionUp": "propagateSelectionUp"; "propagateSelectionDown": "propagateSelectionDown"; "loading": "loading"; "loadingIcon": "loadingIcon"; "emptyMessage": "emptyMessage"; "ariaLabel": "ariaLabel"; "togglerAriaLabel": "togglerAriaLabel"; "ariaLabelledBy": "ariaLabelledBy"; "validateDrop": "validateDrop"; "filter": "filter"; "filterBy": "filterBy"; "filterMode": "filterMode"; "filterPlaceholder": "filterPlaceholder"; "filteredNodes": "filteredNodes"; "filterLocale": "filterLocale"; "scrollHeight": "scrollHeight"; "lazy": "lazy"; "virtualScroll": "virtualScroll"; "virtualScrollItemSize": "virtualScrollItemSize"; "virtualScrollOptions": "virtualScrollOptions"; "indentation": "indentation"; "_templateMap": "_templateMap"; "trackBy": "trackBy"; "virtualNodeHeight": "virtualNodeHeight"; }, { "selectionChange": "selectionChange"; "onNodeSelect": "onNodeSelect"; "onNodeUnselect": "onNodeUnselect"; "onNodeExpand": "onNodeExpand"; "onNodeCollapse": "onNodeCollapse"; "onNodeContextMenuSelect": "onNodeContextMenuSelect"; "onNodeDrop": "onNodeDrop"; "onLazyLoad": "onLazyLoad"; "onScroll": "onScroll"; "onScrollIndexChange": "onScrollIndexChange"; "onFilter": "onFilter"; }, ["templates"], never, false, never>;
}
export declare class TreeModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TreeModule, [typeof Tree, typeof UITreeNode], [typeof i1.CommonModule, typeof i2.SharedModule, typeof i3.RippleModule, typeof i4.ScrollerModule], [typeof Tree, typeof i2.SharedModule, typeof i4.ScrollerModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TreeModule>;
}
