import express from 'express';
import bodyParser from 'body-parser';

import convert  from 'xml-js';
import distance  from 'jaro-winkler';

//import usersRoutes  from './routes/users.js';
import mongoose from 'mongoose';

import  List    from '../models/list.js';
import  ListName   from '../models/listName.js';
import  Customlist    from '../models/customlist.js';
import listName from '../models/listName.js';

import bcrypt from 'bcrypt-nodejs';
import  User    from '../models/user.js';
import  jwt    from '../services/jwt.js';
import Country from '../models/country.js';
import Jurisdiction from '../models/jurisdiction.js';
import Activity from '../models/activity.js';
import Channel from '../models/channel.js';
import Product from '../models/product.js';
import Resource from '../models/resource.js';
import moment from 'moment-timezone';






/* NUEVAS FUNCIONES */
function normalizeAbbreviations(text) {
  if (!text) return '';
  
  return text
    // América Latina (orden específico importante)
    .replace(/\bs\.?\s*a\.?\s*p\.?\s*i\.?\s*\b/gi, 'sapi ') // S.A.P.I. (México)
    .replace(/\bs\.?\s*a\.?\s*s\.?\s*\b/gi, 'sas ') // S.A.S (debe ir ANTES de S.A.)
    .replace(/\bs\.?\s*a\.?\s*c\.?\s*\b/gi, 'sac ') // S.A.C (Perú)
    .replace(/\bs\.?\s*a\.?\s*a\.?\s*\b/gi, 'saa ') // S.A.A (Perú)
    .replace(/\bs\.?\s*a\.?\s*\b/gi, 'sa ') // S.A.
    .replace(/\bs\.?\s*r\.?\s*l\.?\s*\b/gi, 'srl ') // S.R.L. / S. de R.L.
    .replace(/\bltda\.?\s*\b/gi, 'ltda ') // Ltda.
    .replace(/\bc\.?\s*v\.?\s*\b/gi, 'cv ') // C.V. (Capital Variable - México)
    .replace(/\bs\.?\s*c\.?\s*\b/gi, 'sc ') // S.C. (Sociedad Civil)
    .replace(/\beireli\.?\s*\b/gi, 'eireli ') // EIRELI (Brasil)
    .replace(/\beirl\.?\s*\b/gi, 'eirl ') // EIRL (Perú)
    .replace(/\be\.?\s*u\.?\s*\b/gi, 'eu ') // E.U. (Empresa Unipersonal)
    
    // Estados Unidos
    .replace(/\bllc\.?\s*\b/gi, 'llc ') // LLC
    .replace(/\bpllc\.?\s*\b/gi, 'pllc ') // PLLC
    .replace(/\bllp\.?\s*\b/gi, 'llp ') // LLP
    .replace(/\binc\.?\s*\b/gi, 'inc ') // Inc.
    .replace(/\bcorp\.?\s*\b/gi, 'corp ') // Corp.
    
    // Europa - Alemania/Austria/Suiza
    .replace(/\bgmbh\.?\s*\b/gi, 'gmbh ') // GmbH
    .replace(/\ba\.?\s*g\.?\s*\b/gi, 'ag ') // AG
    
    // Europa - Reino Unido
    .replace(/\bplc\.?\s*\b/gi, 'plc ') // PLC
    .replace(/\bltd\.?\s*\b/gi, 'ltd ') // Ltd.
    
    // Europa - Francia
    .replace(/\bs\.?\s*a\.?\s*r\.?\s*l\.?\s*\b/gi, 'sarl ') // SARL
    
    // Europa - Italia
    .replace(/\bs\.?\s*p\.?\s*a\.?\s*\b/gi, 'spa ') // SpA
    
    // Europa - Países Bajos
    .replace(/\bb\.?\s*v\.?\s*\b/gi, 'bv ') // B.V.
    .replace(/\bn\.?\s*v\.?\s*\b/gi, 'nv ') // N.V.
    
    // Europa - Escandinavia
    .replace(/\ba\.?\s*b\.?\s*\b/gi, 'ab ') // AB (Suecia)
    .replace(/\ba\.?\s*s\.?\s*a\.?\s*\b/gi, 'asa ') // ASA (Noruega)
    .replace(/\ba\.?\s*s\.?\s*\b/gi, 'as ') // AS (Noruega)
    
    // Asia - Singapur/Malasia
    .replace(/\bpte\.?\s*ltd\.?\s*\b/gi, 'pte ltd ') // Pte. Ltd.
    .replace(/\bsdn\.?\s*bhd\.?\s*\b/gi, 'sdn bhd ') // Sdn. Bhd.
    
    // Asia - Australia/India
    .replace(/\bpty\.?\s*ltd\.?\s*\b/gi, 'pty ltd ') // Pty. Ltd.
    .replace(/\bpvt\.?\s*ltd\.?\s*\b/gi, 'pvt ltd ') // Pvt. Ltd.
    
    // Asia - China/Japón/Hong Kong
    .replace(/\bco\.?\s*ltd\.?\s*\b/gi, 'co ltd ') // Co. Ltd.
    
    // Otros términos comunes
    .replace(/\bc\.?\s*i\.?\s*a\.?\s*\b/gi, 'cia ') // Cía. (Compañía)
    
    // Normalizar espacios múltiples
    .replace(/\s+/g, ' ')
    .trim();
}


// Normalización completa para comparación
function normalizeText(text) {
  if (!text) return '';
  
  let normalized = text
    .toLowerCase()
    .normalize('NFD')
    .replace(/[\u0300-\u036f]/g, '');
  
  normalized = normalizeAbbreviations(normalized);
  
  normalized = normalized
    .replace(/[.,;:\-_()[\]{}'"!?¿¡]/g, ' ')
    .replace(/\s+/g, ' ')
    .trim();
 
  return normalized;
}

function calculateTokenSimilarity(searchTerm, targetText) {
  const search = normalizeText(searchTerm);
  const target = normalizeText(targetText);
  
  if (!search || !target) return 0;
  
  const searchTokens = search.split(' ').filter(t => t.length > 1);
  const targetTokens = target.split(' ').filter(t => t.length > 1);
  
  if (searchTokens.length === 0) return 0;
  
  let matchedTokens = 0;
  
  searchTokens.forEach(searchToken => {
    const exactMatch = targetTokens.some(targetToken => targetToken === searchToken);
    
    if (exactMatch) {
      matchedTokens++;
    } else {
      const partialMatch = targetTokens.some(targetToken => {
        const similarity = calculateLevenshteinSimilarity(searchToken, targetToken);
        return similarity >= 85;
      });
      
      if (partialMatch) {
        matchedTokens += 0.8;
      }
    }
  });
  
  return (matchedTokens / searchTokens.length) * 100;
}

function calculateLevenshteinSimilarity(str1, str2) {
  const s1 = str1.toLowerCase();
  const s2 = str2.toLowerCase();
  
  if (s1 === s2) return 100;
  
  const matrix = [];
  
  for (let i = 0; i <= s2.length; i++) {
    matrix[i] = [i];
  }
  for (let j = 0; j <= s1.length; j++) {
    matrix[0][j] = j;
  }
  
  for (let i = 1; i <= s2.length; i++) {
    for (let j = 1; j <= s1.length; j++) {
      if (s2.charAt(i - 1) === s1.charAt(j - 1)) {
        matrix[i][j] = matrix[i - 1][j - 1];
      } else {
        matrix[i][j] = Math.min(
          matrix[i - 1][j - 1] + 1,
          matrix[i][j - 1] + 1,
          matrix[i - 1][j] + 1
        );
      }
    }
  }
  
  const distance = matrix[s2.length][s1.length];
  const maxLength = Math.max(s1.length, s2.length);
  return ((maxLength - distance) / maxLength) * 100;
}

async function searchByName(searchTerm, PersonModel) {
  try {
    
    const normalizedForSearch = normalizeAbbreviations(searchTerm.trim());
    
    // NUEVO: Extraer tokens para garantizar que TODOS estén presentes
    const searchTokens = normalizeText(searchTerm).split(' ').filter(t => t.length > 1);

    let allResults = [];
    
    // ESTRATEGIA 1: Text Search
    try {
      const textResults = await PersonModel.aggregate([
        {
          $match: {
                $text: { 
                  $search: normalizedForSearch,
                  $caseSensitive: false,
                  $diacriticSensitive: false
                }
          }
        },
        {
          $addFields: {
            score: { $meta: "textScore" },
            searchMethod: { $literal: "text_search" }
          }
        },
        {
          $project: {
            firstNamelastName: 1,
            miAlias: 1,
            estado: 1,
            idNumber: 1,
            otraInformacion: 1,
            nombreLista: 1,
            tipoLista: 1,
            score: 1,
            searchMethod: 1,
            _id: 1
          }
        }
      ]);
      
      // NUEVO: Filtrar para garantizar que TODOS los tokens estén presentes
      const textResultsFiltered = textResults.filter(doc => {
        const docText = normalizeText(
          `${doc.firstNamelastName || ''} ${doc.miAlias || ''}`
        );
        
        // Verificar que TODOS los tokens de búsqueda estén en el documento
        const hasAllTokens = searchTokens.every(searchToken => {
          return docText.includes(searchToken);
        });
        
        return hasAllTokens;
      });
      
      // NUEVO: Usar resultados filtrados
      allResults = [...textResultsFiltered];
      
    } catch (err) {
      console.log('✗ Text search error:', err.message);
    }
    
    // ESTRATEGIA 2: Regex 
    if (allResults.length === 0) {
      const tokens = normalizeText(searchTerm).split(' ').filter(t => t.length > 1);
      
      if (tokens.length > 0) {
        const regexConditions = tokens.map(token => ({
          $or: [
            { firstNamelastName: { $regex: token, $options: 'i' } },
            { miAlias: { $regex: token, $options: 'i' } }
          ]
        }));
        
        // NUEVO: Usar $and para garantizar que TODOS los tokens estén presentes
        const regexResults = await PersonModel.find({
          $and: regexConditions
        }).limit(100).lean();
        
        
        //revisar si esta ok incluir los campos aqui
        const scoredResults = regexResults.map(doc => ({
          ...doc,
          score: 1,
          searchMethod: 'regex',
		  terminosBuscados: 'nit ' + ' / ' + searchTerm,
		  encontrado_por: '(Nombre_Alias): ' + ' ' + searchTerm
        }));
        
        allResults = [...allResults, ...scoredResults];
      }
    }
    
    if (allResults.length === 0) {
      
      return [];
    }
    
    
    const maxScore = Math.max(...allResults.map(r => r.score));
    
    const resultsWithScores = allResults.map(doc => {
      const namesSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.firstNamelastName || ''
      );
      
      const aliasSimilarity = calculateTokenSimilarity(
        searchTerm,
        doc.miAlias || ''
      );
      
      const maxStringSimilarity = Math.max(namesSimilarity, aliasSimilarity);
      
      let combinedScore;
      if (doc.searchMethod === 'text_search') {
        const normalizedMongoScore = (doc.score / maxScore) * 100;
        combinedScore = (normalizedMongoScore * 0.6) + (maxStringSimilarity * 0.4);
      } else {
        combinedScore = maxStringSimilarity;
      }
      
      
      
      return {
        ...doc,
        stringSimilarity: parseFloat(maxStringSimilarity.toFixed(2)),
        combinedScore: parseFloat(combinedScore.toFixed(2))
      };
    });
    
    const filteredResults = resultsWithScores
      .filter(result => result.combinedScore >= 75)
      .sort((a, b) => b.combinedScore - a.combinedScore)
      .slice(0, 50)
      .map(r => ({
        _id: r._id,
        firstNamelastName: r.firstNamelastName,
        miAlias: r.miAlias,
        estado: r.estado,
        idNumber: r.idNumber,
        otraInformacion: r.otraInformacion,
        nombreLista: r.nombreLista,
        tipoLista: r.tipoLista,
        stringSimilarity: r.stringSimilarity,
        combinedScore: r.combinedScore
		
      }));
    
   
    
    return filteredResults;

  } catch (error) {
    console.error('❌ Error:', error);
    throw error;
  }
}
/* FIN DE NUEVAS FUNCIONES */








const app = express();
//const PORT = 5000;

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

//app.use(bodyParser.json());
//app.use('/users', usersRoutes);



//conectar a mongodb
var uriLocal = 'mongodb://127.0.0.1:27017/pldint';
mongoose.connect(uriLocal, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
})
  .then(async () => {


	//habilitar este codigo para que funcione local

	/*

    console.log('Conexion a la base de datos establecida exitosamente');
    const port = process.env.PORT || 4000;
    app.listen(port, () => {
      console.log(`Servidor1 escuchando en el puerto ${port}`);
    });
*/

	//habilitar este codigo para subir al servidor


	const fs = await import('fs');
	const https = await import('https');
	  const options = {
			  key: fs.readFileSync('../../../../etc/letsencrypt/live/pldinternacional.co/privkey.pem'),
			  cert: fs.readFileSync('../../../../etc/letsencrypt/live/pldinternacional.co/fullchain.pem')
		// key: fs.readFileSync('../../../../../home/ssl/pldinternacional_tld.key'),
		// cert: fs.readFileSync('../../../../../home/ssl/__pldinternacional_com.crt')
	  };
  
	  // Inicia el servidor HTTPS
	  https.createServer(options, app).listen(4000, () => {
		console.log('Servidor HTTPS escuchando en el puerto 4000');
	  });


	  //hasta aqui para subir al servidor


  })
  .catch((error) => {
    console.error('Error al conectar a la base de datos:', error);
  });

// Define el esquema para la colección "informacion"
const informacionSchema = new mongoose.Schema({
	nombre_consulta: String,
	username: String,
	password: String,
	tipo_relacion: String,
	codigoPais: String,
	ciudad: String,
	actividad: String,
	canal: String,
	producto: String,
	origen_recursos: String,
	estado_en_listas: String,
	tipo_consulta: String,
	company_id: String,
	fecha_de_grabacion: Date,
});
//la codificación de la obtencion de los datos del perfil de riesgo
app.post('/api/perfil' , async (req , res)=>{

	let params = req.body;

	let tipo_relacion   = params.tipo_relacion; //1-Local 2-Internacional
	let codigoPais	    = params.pais;
	let ciudad		    = params.ciudad;
	let actividad       = params.actividad;
	let canal		    = params.canal;
	let producto	    = params.producto;
	let origen_recursos = params.origen_recursos;
	let username        = params.username;
	let password        = params.password;
	let estado_en_listas = params.estado_en_listas;
	let tipo_consulta = params.tipo_consulta;


	
	

	//0 = pesimista
	//1 = optimista
	if (tipo_consulta === '' || tipo_consulta === undefined || tipo_consulta === null) {
		tipo_consulta = '1'; //por defecto es optimista
		
	} else if (tipo_consulta !== '1' && tipo_consulta !== '0') {
		tipo_consulta = '1'; //por defecto es optimista
		
	}



	if ( tipo_consulta === '0') { //es pesimista
				//Si la tipo_relacion la mandan en blanco, le pone un cero para que no genere error
			if (estado_en_listas === '' || estado_en_listas === undefined || estado_en_listas === null) {
				estado_en_listas ='1'; //1 reportado 0 no reportado
			}

			//Si la tipo_relacion la mandan en blanco, le pone un cero para que no genere error
			if (tipo_relacion === '' || tipo_relacion === undefined || tipo_relacion === null) {
				tipo_relacion = '2';
			}

				//Si la tipo_relacion la mandan en blanco, le pone un cero para que no genere error
			if (codigoPais === '' || codigoPais === undefined || codigoPais === null) {
				codigoPais = '13';
			}
			
			//Si la ciudad la mandan en blanco, le pone un cero para que no genere error
			if (ciudad === '' || ciudad === undefined || ciudad === null) {
				ciudad = '5004';
			}
			
			//si la actividad la mandan en blanco, le damos un valor por default para que no genere error
			if (actividad === '' || actividad === undefined || actividad === null) {
				actividad = '022';
			}

			//si el canal la mandan en blanco, le damos un valor por default para que no genere error
			if (canal === '' || canal === undefined || canal === null) {
				canal = '49'; //pra darle un valor alto
			}


			//si la actividad la mandan en blanco, le damos un valor por default para que no genere error
			if (producto === '' || producto === undefined || producto === null) {
				producto = '04'; //pra darle un valor alto
			}

			
			//si la actividad la mandan en blanco, le damos un valor por default para que no genere error
			if (origen_recursos === '' || origen_recursos === undefined || origen_recursos === null) {
				origen_recursos = '07'; //para darle un valor alto
			}
	} else { //el valor de tipo consulta  = 1 y se debe consultar la base de datos y cuando no envía los datos devuelve 0
			
				//Si estado_en_listas la mandan en blanco, le pone un cero para que no genere error
				if (estado_en_listas === '' || estado_en_listas === undefined || estado_en_listas === null) {
					estado_en_listas ='0'; //1 reportado 0 no reportado
				}
					
				if (tipo_relacion === '' || tipo_relacion === undefined || tipo_relacion === null) {
					tipo_relacion = '1';
				}
						
				if (codigoPais === '' || codigoPais === undefined || codigoPais === null) {
					codigoPais = '9999';
				}
				
				
				if (ciudad === '' || ciudad === undefined || ciudad === null) {
					ciudad = '0';
				}
				
				
				if (actividad === '' || actividad === undefined || actividad === null) {
					actividad = '0';
				}
	
				//si el canal la mandan en blanco, le damos un valor por default para que no genere error
				if (canal === '' || canal === undefined || canal === null) {
					canal = '0'; 
				}
	
				
				if (producto === '' || producto === undefined || producto === null) {
					producto = '0'; 
				}
		
				
				if (origen_recursos === '' || origen_recursos === undefined || origen_recursos === null) {
					origen_recursos = '0'; 
				}

	}

// console.log('el valor de estado en listas es xxx  ' + estado_en_listas);
// console.log('el valor de tipo de relacion es  ' + tipo_relacion);

	//valida el usuario y trae el codigo del pais a la cual pertenece la empresa
	const data = {
		username: username,
		password: password
	}

	 loginUser(data, res , async (autenticacionExitosa, company_id) => {

		if (autenticacionExitosa === true) {

			//CALCULA LA HORA LOCAL DE FORMA CORRECTA
			// 1) Obtienes la fecha/hora “ahora” en UTC ms:
			const utcMs = Date.now();
			let desface = 5 * 60 * 60 * 1000;

			const Informacion = mongoose.models.Informacion || mongoose.model('Informacion', informacionSchema, 'apirests');
			//const Informacion = mongoose.model('Informacion', informacionSchema, 'apirest'); // El tercer argumento especifica el nombre de la colección
			// Crea una nueva instancia del modelo "Informacion" con los datos
			const nuevaInformacion = new Informacion({ nombre_consulta: 'perfil', username: username,
				password: password, tipo_relacion: tipo_relacion,
				codigoPais: codigoPais, ciudad: ciudad, actividad: actividad, canal: canal, producto: producto,
				origen_recursos: origen_recursos, estado_en_listas: estado_en_listas, tipo_consulta: tipo_consulta,
				fecha_de_grabacion: new Date(utcMs - desface),
				company_id: company_id });

			// Guarda la información en la base de datos
			const resultado = await nuevaInformacion.save();



			let contador = 0;
			var sumaTotal = [];
			var detalle_del_perfil = [];

			//evalua el valor de la consulta. Esto toca leerlo de la base de datos dependiendo de la empresa porque de pronto puede haber porcentajes personalizados
			if ( tipo_relacion === '1' && estado_en_listas === '1') { //es nacional y esta reportado
				var valor_consulta = '45';
				//sumaTotal.push(valor_consulta);
				suma(valor_consulta, 'Tipo Relacion');
			} else if ( tipo_relacion === '2' && estado_en_listas === '1') { //es internacional y esta reportado
				var valor_consulta = '50';
				//sumaTotal.push(valor_consulta);
				suma(valor_consulta, 'Tipo Relacion');
			} else if ( tipo_relacion === '1' && estado_en_listas === '0') { //es nacional y no esta reportado
				var valor_consulta = '0';
				suma(valor_consulta, 'Tipo Relacion');
			} else if ( tipo_relacion === ' 2' && estado_en_listas === '0') { //es internacional y no esta reportado
				var valor_consulta = '0';
				suma(valor_consulta, 'Tipo Relacion');
			} else {
				var valor_consulta = '0';
				suma(valor_consulta, 'Tipo Relacion');
			}


			//cosulta el valor de pais. Si es nacional no califica el pais. CAlifica la ciudad (jurisdiccion y la actividad
			if ( tipo_relacion === '1' ) {
				//califica la ciudad
				obtenerValorRiesgoJurisdiccion(ciudad, res)
					.then((valorRiesgojurisdiccion) => {
						suma(valorRiesgojurisdiccion, 'Jurisdicción');
					})
					.catch((error) => {
						console.error('Error al obtener el valor de riesgo jurisdiccion:', error);
					});

				//califica la actividad
				obtenerValorRiesgoActividad(actividad, res)
					.then((valorRiesgoActividad) => {
						suma(valorRiesgoActividad, 'Actividad');
					})
					.catch((error) => {
						console.error('Error al obtener el valor de riesgo actividad:', error);
					});

			} else if ( tipo_relacion === '2') {
				obtenerValorRiesgoPais(codigoPais, res)
					.then((valorRiesgoPais) => {
						suma(valorRiesgoPais, 'Pais');
					})
					.catch((error) => {
						console.error('Error al obtener el valor de riesgo país:', error);
					});
			}

			//ahora obtenemos el valor del riesgo del canal
			obtenerValorRiesgoChannel(canal, res)
				.then((valorRiesgoCanal) => {
					suma(valorRiesgoCanal, 'Canal');
				})
				.catch((error) => {
					console.error('Error al obtener el valor de riesgo canal:', error);
				});


			//ahora obtenemos el valor del riesgo del producto
			obtenerValorRiesgoProduct(producto, res)
				.then((valorRiesgoProducto) => {
					suma(valorRiesgoProducto, 'Producto');
				})
				.catch((error) => {
					console.error('Error al obtener el valor de riesgo proyecto:', error);
				});


			//ahora obtenemos el valor del riesgo del origen de recursos
			obtenerValorRiesgoOrigenRecursos(origen_recursos, res)
				.then((valorRiesgoOrigenRecursos) => {
					suma(valorRiesgoOrigenRecursos, 'Origen Recursos');
				})
				.catch((error) => {
					console.error('Error al obtener el valor de riesgo origen recursos:', error);
			})

		} else {//Hubo error en la autenticacion
				res.send({auth: false});
		}

		
		async function suma(valor_a_sumar, nombre){

			detalle_del_perfil.push({Nombre: nombre, Valor: valor_a_sumar,});

			sumaTotal.push(valor_a_sumar);
			if (sumaTotal.length == 5 && tipo_relacion == 2) {
				// Filtramos los elementos que son números y los convertimos a números
				const numeros = sumaTotal.filter(elemento => typeof elemento === 'number' || !isNaN(parseInt(elemento))).map(elemento => parseInt(elemento));
				// Sumamos los números

				const suma = numeros.reduce((total, numero) => total + numero, 0);

				//Le pone texto al perfil
				if (suma >=14 && suma <= 22) {
					 var descripcion_perfil =  'PERFIL DE RIESGO BAJO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 23 && suma <= 30) {
					 var descripcion_perfil =  'PERFIL DE RIESGO MEDIO BAJO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 31 && suma <= 40) {
					 var descripcion_perfil =  'PERFIL DE RIESGO MEDIO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 40 && suma <= 45) {
					 var descripcion_perfil = 'PERFIL DE RIESGO MEDIO ALTO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 46 && suma <= 54) {
					 var descripcion_perfil = 'PERFIL DE RIESGO ALTO - SEÑAL DE ALERTA SEGÚN CRITERIO DEL OFICIAL DE CUMPLIMIENTO';
				  } else if (suma > 55 && suma <= 100) {
					 var descripcion_perfil = 'PERFIL DE RIESGO INMINENTE - REPORTE OPERACIÓN SOSPECHOSA, REPORTE OPERACIÓN INUSUAL';
				  }

				res.send({Total_Perfil: suma, Descripcion_Perfil: descripcion_perfil, detalle_del_perfil: detalle_del_perfil});
			} else if (sumaTotal.length == 6 && tipo_relacion == 1) {
				// Filtramos los elementos que son números y los convertimos a números
				const numeros = sumaTotal.filter(elemento => typeof elemento === 'number' || !isNaN(parseInt(elemento))).map(elemento => parseInt(elemento));
				// Sumamos los números
				const suma = numeros.reduce((total, numero) => total + numero, 0);

				//Le pone texto al perfil
				if (suma >=14 && suma <= 22) {
					 var descripcion_perfil =  'PERFIL DE RIESGO BAJO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 23 && suma <= 30) {
					 var descripcion_perfil =  'PERFIL DE RIESGO MEDIO BAJO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 31 && suma <= 40) {
					 var descripcion_perfil =  'PERFIL DE RIESGO MEDIO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 40 && suma <= 45) {
					 var descripcion_perfil = 'PERFIL DE RIESGO MEDIO ALTO - SIN SEÑAL DE ALERTA';
				  } else if (suma > 46 && suma <= 54) {
					 var descripcion_perfil = 'PERFIL DE RIESGO ALTO - SEÑAL DE ALERTA SEGÚN CRITERIO DEL OFICIAL DE CUMPLIMIENTO';
				  } else if (suma > 55 && suma <= 100) {
					 var descripcion_perfil = 'PERFIL DE RIESGO INMINENTE - REPORTE OPERACIÓN SOSPECHOSA, REPORTE OPERACIÓN INUSUAL';
				  }
				res.send({Total_Perfil: suma, Descripcion_Perfil: descripcion_perfil, detalle_del_perfil: detalle_del_perfil});
			}
		}
	});
	


})

//hasta aqui todo funciona bien cuando tipo_relacion vale == 1


// GRABA LA INFORMACIÓN DE LO QUE CONSULTÓ EN LA BASE DE DATOS
// Se pone el esquema fuera para no tener que crearlo tantas veces
// Define el esquema para la colección "informacion"
const informacionSchema_qry = new mongoose.Schema({
	nombre_consulta: String,
	username: String,
	idNumber: String,
	nombreAlias: String,
	company_id: String,
	fecha_de_grabacion: Date,
});


//realiza la consulta a la base de datos y devuelve los resultados en XML
app.post('/api/query',  async (req,res) => {
    // let mlist = await List.find({ firstNamelastName: 'MONICA DEL PILAR MEZA GONZALEZ' }).exec();
    
    //   mlist = JSON.parse(JSON.stringify(mlist));
    //   const xml = convert.json2xml(mlist, {compact: true, ignoreComment: true});
    //   res.send(xml);

	let autenticacionExitosa = false;

	var xml = '';
	let params = req.body;

	let nit = params.idNumber;
	console.log('el valor de nit es  ' + nit);
	if (nit === '' || nit === undefined || nit === null) {
		nit = '0';
	}
	let nombreAlias = params.nombreAlias;
	if (nombreAlias === '' || nombreAlias === undefined || nombreAlias === null) {
		nombreAlias = '0';
	}


	let username = params.username;
	if (username === '' || username === undefined || username === null) {
		username = '0';
	}
	let password = params.password;
	if (password === '' || password === undefined || password === null) {
		password = '0';
	}

	const data = {
		username: username,
		password: password
	}

	loginUser(data, res , async (autenticacionExitosa, company_id) => {
		if (autenticacionExitosa === true) {

			//CALCULA LA HORA LOCAL DE FORMA CORRECTA
			// 1) Obtienes la fecha/hora “ahora” en UTC ms:
			const utcMs = Date.now();
			let desface = 5 * 60 * 60 * 1000;

			const Informacion_qry = mongoose.models.Informacion_qry || mongoose.model('Informacion_qry', informacionSchema_qry, 'apirests');

			//const Informacion_qry = mongoose.model('Informacion_qry', informacionSchema_qry, 'apirest'); // El tercer argumento especifica el nombre de la colección
			// Crea una nueva instancia del modelo "Informacion" con los datos
			const nuevaInformacion_qry = new Informacion_qry({
				nombre_consulta: 'query',
				username: username, 
				idNumber: nit,
				nombreAlias: nombreAlias,
				company_id: company_id,
				fecha_de_grabacion: new Date(utcMs - desface)
			 });

			// Guarda la información en la base de datos
			const resultado_qry = await nuevaInformacion_qry.save();

			// //divido la cadena de busqueda
			// const terminos = nombreAlias.split(' ');
			// //escapar los terminos
			// let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
			// //let consulta_regexp = new RegExp(".*" + escapedTerms.join(".*") + ".*");
            // let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");

			/*** este es el nuevo codigo para los acentos */
			// Función para normalizar texto (eliminar acentos)
			function normalizeText(text) {
				return text.normalize("NFD")
					.replace(/[\u0300-\u036f]/g, "")
					.trim();
			}

			// Divido la cadena de búsqueda y normalizo cada término
			const terminos = nombreAlias
			.split(' ')
			.map(term => normalizeText(term));

			// Escapar los términos
			let escapedTerms = terminos.map(t => {
			// Primero escapamos caracteres especiales
			const escaped = t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');

			// Luego agregamos soporte para acentos en cada vocal
			return escaped
				.replace(/a/g, '[aáàâãä]')
				.replace(/e/g, '[eéèêë]')
				.replace(/i/g, '[iíìîï]')
				.replace(/o/g, '[oóòôõö]')
				.replace(/u/g, '[uúùûü]')
				.replace(/n/g, '[nñ]');
			});

			// Construir la expresión regular con límites de palabra
			let consulta_regexp = new RegExp("\\b" + escapedTerms.join("\\b.*") + "\\b");

			/*** fin del nuevo coido para laos acentos */

			
			if (nombreAlias !== '0' && nit === '0') { //Solo el nombreAlias tiene datos
				
					let resultadosAproximados = await searchByName(nombreAlias, List);
					//console.log('resultadosAproximados', resultadosAproximados);
					//console.log('Los resultados aproximados son: ', resultadosAproximados);
						if(resultadosAproximados.length > 0) { //Si encontro algo por nombre, pues pone los campos adicionales
							resultadosAproximados.forEach(element => {
								element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
								element.terminosBuscados =  nombreAlias;
								element.coincidencia = 0;
							})

							let mlist = JSON.parse(JSON.stringify(resultadosAproximados));
                            let wrappedData = { persona: mlist };
                            xml = convert.json2xml(wrappedData, {compact: true, ignoreComment: true});
						} else {
							xml = '';
						}
			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit tiene datos

						//const res_nit = await List.find({'idNumber': {'$regex': new RegExp(`\\b${nit}\\b`, "i")}}).exec();
						const res_nit = await List.find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).exec();

						if (res_nit.length === 0) {
							//sin_resultados(nit, nombreAlias, nit, element );
							xml = '';
						} else {
						//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit[0].firstNamelastName.toUpperCase());
						res_nit[0].coincidencia = 1;
						//res_nit[0].encontrado_por = '(NIT): ' + nit;
						res_nit.forEach(element => {
							element.encontrado_por = '(NIT): ' + nit;
							element.coincidencia = 1; //dado que el nit se busca completo dentro del campo
						});

						let mlist = JSON.parse(JSON.stringify(res_nit));
						let wrappedData = { persona: mlist };
						xml = convert.json2xml(wrappedData, {compact: true, ignoreComment: true});
						//res.setHeader('Content-Type', 'application/xml');
						//res.send(xml);

						//acumula_resultados(res_nit, element);
						}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos

						const terminos = nombreAlias.split(' ').filter(t => t.trim() !== '');
									// Escapar los términos
									let escapedTerms = terminos.map(t => t.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
						
									// Crear array de expresiones regulares individuales para cada término
									// Cada término debe existir en cualquier parte del string
									let regexConditions = escapedTerms.map(term => ({
										firstNamelastName: { $regex: new RegExp(`\\b${term}\\b`, "i") }
									}));
						
									
									// Busca primero por nit usando la expresion regular
									try {
											const resultadoNit = await List.find({'idNumber': {'$regex': new RegExp('\\b'+nit+'\\b'), "$options" : 'i'}}).exec();
											//const resultadoNit = await List.find({'idNumber': {'$regex': new RegExp(`\\b${nit}\\b`, "i")}}).exec();
												
												if(resultadoNit.length === 0) { //Entonces busca por nombre usando la busqueda tipo text
													let resultadosAproximados = await searchByName(nombreAlias, List);
														if(resultadosAproximados.length > 0) { //Si encontro algo por nombre, pues pone los campos adicionales
															resultadosAproximados.forEach(element => {
																element.encontrado_por = '(Nombre / Alias. Coincidencia cercana): '+  nombreAlias;
																element.terminosBuscados =  nombreAlias + ' / ' + nit;
																element.coincidencia = 0;
															})
														}
														
													if(resultadosAproximados.length === 0){ // no encontró nada
														xml = '';
													} else { // 
														
														let mlist = JSON.parse(JSON.stringify(resultadosAproximados));
														let wrappedData = { persona: mlist };
																	
														xml = convert.json2xml(wrappedData, {compact: true, ignoreComment: true});
														
													}
						
						
						
												} else {
													// const resul_nit_enviar = resultadoNit.map(doc => ({
													// 	...doc,
													// 	score: 1,
													// 	searchMethod: 'regex',
													// 	terminosBuscados: nit + ' / ' + nombreAlias,
													// 	encontrado_por: '(Nit): ' + ' ' + nit
													// }));

													let mlist = JSON.parse(JSON.stringify(resultadoNit));
													let wrappedData = { persona: mlist };
													xml = convert.json2xml(wrappedData, {compact: true, ignoreComment: true});
												}
										} catch (error) {
											//res.send(error);
										}
						
									}
            /*
			//*********************lo busca en las listas personalizadas**********************
            */



			if (nombreAlias !== '0' && nit === '0') { //si solo nombre alias tiene datos
				let filtro_personalizada = {
					firstNamelastName: { $regex:  consulta_regexp, $options: 'i'}
				};
				const res_nombreAlias_personalizada = await Customlist.find(filtro_personalizada).exec();

				if (res_nombreAlias_personalizada.length > 0) {
					let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nombreAlias_personalizada[0].firstNamelastName.toUpperCase());
					res_nombreAlias_personalizada[0].coincidencia = coincidencia;
					//res_nombreAlias_personalizada[0].encontrado_por = '(Alias): ' + nombreAlias;

					res_nombreAlias_personalizada[0].el_primero = '1';

					res_nombreAlias_personalizada.forEach(element => {
						element.encontrado_por = '(Alias): ' + nombreAlias;
					});

                    //revisar este codigo que puede ser interesante saber que hace
                    // const documents = await db.collection(collectionName).find().toArray();
                    // // Convert documents to XML
                    // const xmlData = await xml2js.Promise.promisify(xml2js.builder)({ documents });

                   
                    let mlist = JSON.parse(JSON.stringify(res_nombreAlias_personalizada));
                    let wrappedData = { persona: mlist };
                    
                    xml = xml + convert.json2xml(wrappedData, {compact: true, ignoreComment: true}, { objectName: 'people' });

                    //res.setHeader('Content-Type', 'application/xml');
                    //res.send(xml);
					//acumula_resultados(res_nombreAlias_personalizada, element);
				}

			
			} else if (nombreAlias === '0' && nit !== '0') { //si solo nit rtiene datos
				const res_nit_personalizada = await Customlist.find({'idNumber': {'$regex': new RegExp("\\b" + nit + "\\b"), "$options" : 'i'}}).exec();

				if (res_nit_personalizada.length > 0) {
				//let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_nit_personalizada[0].firstNamelastName.toUpperCase());
				res_nit_personalizada[0].coincidencia = 1;
				//res_nit_personalizada[0].encontrado_por = '(NIT): ' + nit;

				res_nit_personalizada[0].el_primero = '1';

				res_nit_personalizada.forEach(element => {
					element.encontrado_por = '(NIT): ' + nit;
					element.coincidencia = 1; //pues lo encontró por nit y se presupone que la busqueda solo lo devuelve cuando lo encuentra
				});

                let mlist = JSON.parse(JSON.stringify(res_nit_personalizada));
                let wrappedData = { persona: mlist };
                xml = xml + convert.json2xml(wrappedData, {compact: true, ignoreComment: true});
                //res.setHeader('Content-Type', 'application/xml');
                //res.send(xml);

				//acumula_resultados(res_nit_personalizada, element);
				}
			
			} else if (nombreAlias !== '0' && nit !== '0') { //si ambos tienen datos

				console.log('entra por los ambos datos')
				const pipeline = [
				{
					$match: {
					$or: [
						{ firstNamelastName: { $regex: consulta_regexp, $options: 'i'} },
						{ idNumber: { $regex: new RegExp('.*' + nit + '.*', 'i') } }
					]
					}
				}
				];
				const res_ambos_personalizada = await Customlist.aggregate(pipeline).exec();
				
				if (res_ambos_personalizada.length > 0) {
				let coincidencia = jaroWinklerf(nombreAlias.toUpperCase(), res_ambos_personalizada[0].firstNamelastName.toUpperCase());
				res_ambos_personalizada[0].coincidencia = coincidencia;

				//res_ambos_personalizada[0].encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;

				res_ambos_personalizada[0].el_primero = '1';

				res_ambos_personalizada.forEach(element => {
					element.encontrado_por = '(NIT y Nombre): ' + nit + ' ' + nombreAlias;
				});

                let mlist = JSON.parse(JSON.stringify(res_ambos_personalizada));
                let wrappedData = { persona: mlist };
                xml = xml + convert.json2xml(wrappedData, {compact: true, ignoreComment: true});

				
													
                //res.send(xml);

				//acumula_resultados(res_ambos_personalizada, element);
				}
			}

			//ahora busca en la base de datos las listas en las cuales consultó
			const listasConsultadas = await listName.find({}, {  _id:0, elnombredelaLista: 1  });

			let valores_listas_consultadas = listasConsultadas.map(item => item.elnombredelaLista);

			valores_listas_consultadas =  valores_listas_consultadas.join(',');
			
			let l_consultadas = JSON.parse(JSON.stringify(valores_listas_consultadas));
			let wrappedData_listas = { listasconsultadas: l_consultadas };
			xml = xml + convert.json2xml(wrappedData_listas, {compact: true, ignoreComment: true});

			xml = `<personas>${xml}</personas>`;

            res.send(xml);
			
		} else {
			res.send({auth: false});
		}
	});

    });



function sin_resultados(nit, nombreAlias, encontrado_por, elemento) {
	const sinResultados = [{
	  firstNamelastName: nombreAlias,
	  idNumber: nit,
	  estado: 'No Reportado',
	  coincidencia: 0,
	  encontrado_por: encontrado_por
	}];
	//acumula_resultados(sinResultados, elemento);
  }

  function jaroWinklerf(s1, s2){
	let dist = distance(s1,s2);

	return dist;
	
  }

//crea un foreach para acumular los resultados




//FUNCIONES
  async  function loginUser(req,res, callback){

	let params = req;
	var username = req.username;
	var password = req.password;

	User.findOne({username: username.toLowerCase()}, (err, user) => {
		if (err){
			res.status(500).send({ok:false});
			callback(false);
		}else{
			if(!user){
				//res.status(404).send({ok: false});
				callback(false);
			}else{
				bcrypt.compare(password, user.password, function(err, check) {
					if(check){
						//devolver los datos del usuario logueado
						if(params.gethash){
							//devolver un token de jw
							// res.status(200).send({
							// 	'ok': true,
							// });
							//res.status(200).send({ok: true});
							
							callback(true);
						}else{
							//res.status(200).send({ok:true});
							callback(true, user.company_id);
						}
					}else{
						//res.status(404).send({ok: false});
						callback(false);
					}

				})
			}
		}

	});
}

async function getCountryByCode(req, res, callback) {

	var idPais = req;
		//console.log(idPais);
		var idPaisNumber = parseInt(idPais);
		try {
			const planes =  Country.find({'codigo': idPaisNumber}, function(err, planes) { 
				if (err){
					callback(err);
				}else{
					//res.json(planes);
					callback(planes);
				}
			}); 
		} catch (error) {
			//res.status(400).send({message: 'ha ocurrido un error en el controlador de canal' + req + planId});
			callback(error);
		}
	}


	// Función que retorna una promesa
function obtenerValorRiesgoPais(codigoPais, res) {
	
    return new Promise((resolve, reject) => {
        getCountryByCode(codigoPais, res, (country) => {
			if (country == undefined || country == null || country == '' || country == '0') {
				console.log('pais no encontrado');
				resolve(0);
			} else {
				const nivelRiesgoPais = country[0].nivel_riesgo;
				resolve(nivelRiesgoPais); // Resolvemos la promesa con el valor deseado
			}
           
        });
    });
}


function getJurisdicciones(req, res, callback) {

	var codigoMun = req;
		try {
			const jurisdicciones = Jurisdiction.find({'codigoMunicipio': codigoMun}, function(err, jurisdicciones) { 
				
				if (err){
					callback(err);
				}else{
					callback(jurisdicciones);
				}
			}); 
		} catch (error) {
			callback(error);
		}
	
}

function obtenerValorRiesgoJurisdiccion(ciudad, res) {
	
    return new Promise((resolve, reject) => {
        getJurisdicciones(ciudad, res, (ciuda) => {
			if (ciuda == undefined || ciuda == null || ciuda == '' || ciuda == '0') {
				console.log('ciudad no encontrada');
				resolve(0);
			} else {
				const nivelRiesgoCiudad = ciuda[0].calificacion;	
				resolve(nivelRiesgoCiudad);
			}
            
             // Resolvemos la promesa con el valor deseado
        });
    });
}


function getActividadByCode(req, res, callback) {
	var codigoActividad = req;
		try {
			const actividades = Activity.find({'codigo': codigoActividad}, function(err, actividades) { 
				if (actividades == undefined || actividades == null || actividades == '' || actividades == '0') {
					console.log('actividad no encontrada');
					callback(0);
				} else {
					callback(actividades);
				}
				// if (err){
				// 	callback(err);
				// }else{
				// 	callback(actividades);
				// }
			}); 
		} catch (error) {
			callback(error);
		}
	
}

function obtenerValorRiesgoActividad(actividad, res) {

	return new Promise((resolve, reject) => {
		getActividadByCode(actividad, res, (actividad) => {
			if (actividad == undefined || actividad == null || actividad == '' || actividad == '0') {
				console.log('actividad no encontrada');
				resolve(0);
			} else {
				const nivelRiesgoActividad = actividad[0].nivel_riesgo;
				resolve(nivelRiesgoActividad); // Resolvemos la promesa con el valor deseado
			}
		});
	});
}

function getChannelByCode(req, res, callback) {
	var codigoCanal = req;
		try {
			const canales = Channel.find({'codigo': codigoCanal}, function(err, canales) { 
				if (err){
					callback(err);
				}else{
					callback(canales);
				}
			}); 
		} catch (error) {
			callback(error);
		}
	
}

function obtenerValorRiesgoChannel(canal, res) {
	return new Promise((resolve, reject) => {
		getChannelByCode(canal, res, (canal) => {
			if (canal == undefined || canal == null || canal == '' || canal == '0') {
				console.log('canal no encontrado');
				resolve(0);
			} else {
			const nivelRiesgoActividad = canal[0].calificacion;
			resolve(nivelRiesgoActividad); // Resolvemos la promesa con el valor deseado
			}
		});
	});
}

function getProductByCode(req, res, callback) {
	var codigoProducto = req;
		try {
			const productos = Product.find({'codigo': codigoProducto}, function(err, productos) { 
				if (err){
					callback(err);
				}else{
					callback(productos);
				}
			}); 
		} catch (error) {
			callback(error);
		}
	
}

function obtenerValorRiesgoProduct(productos, res) {
	return new Promise((resolve, reject) => {
		getProductByCode(productos, res, (productos) => {
			if (productos == undefined || productos == null || productos == '' || productos == '0') {
				console.log('producto no encontrado');
				resolve(0);
			} else {
				const nivelRiesgoProducto = productos[0].calificacion;
				resolve(nivelRiesgoProducto); // Resolvemos la promesa con el valor deseado
			}
		});
	});
}


function getOrigenRecursosByCode(req, res, callback) {
	var codigoOrigen = req;
	
		try {
			const origenes = Resource.find({'codigo': codigoOrigen}, function(err, origenes) { 
				if (err){
					callback(err);
				}else{
					callback(origenes);
				}
			});
		} catch (error) {
			callback(error);
		}	
}

function obtenerValorRiesgoOrigenRecursos(origen, res) {
	return new Promise((resolve, reject) => {
		getOrigenRecursosByCode(origen, res, (origen) => {
			if (origen == undefined || origen == null || origen == '' || origen == '0') {
				console.log('origen no encontrado');
				resolve(0);
			} else {
				const nivelRiesgoOrigen = origen[0].calificacion;
				resolve(nivelRiesgoOrigen); // Resolvemos la promesa con el valor deseado
			}
		});
	});
}