'use strict'

var express = require('express');
var ActividadecoController = require('../controllers/activity');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getActivities', md_auth.ensureAuth , ActividadecoController.getPlans);
api.post('/saveActivity', md_auth.ensureAuth, ActividadecoController.savePlan);
api.get('/getActivity/:id', md_auth.ensureAuth, ActividadecoController.getPlan); //para devolver UNO de los planes
api.get('/getActivityReporte/:id', md_auth.ensureAuth, ActividadecoController.getActivity); //para devolver UNO de los planes
api.put('/updateActivity/:id',md_auth.ensureAuth, ActividadecoController.updatePlan);
api.delete('/delActivity/:id',md_auth.ensureAuth, ActividadecoController.delPlan);
api.get('/getActivities/:idPais', md_auth.ensureAuth , ActividadecoController.getActivitiesByCountry);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;