'use strict'

var express = require('express');
var CanalController = require('../controllers/channel');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getChannels', md_auth.ensureAuth , CanalController.getPlans); 
api.get('/getChannelFilter/:id', md_auth.ensureAuth , CanalController.getChannels); //para el boton canal del perfil usuario busqueda sencilla 
api.post('/saveChannel', md_auth.ensureAuth, CanalController.savePlan);
api.get('/getChannel/:id', md_auth.ensureAuth,CanalController.getPlan); //para devolver UNO de los planes
api.get('/getChannelReporte/:id', md_auth.ensureAuth,CanalController.getPlanReporte);
api.put('/updateChannel/:id',md_auth.ensureAuth, CanalController.updatePlan);
api.delete('/delChannel/:id',md_auth.ensureAuth, CanalController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;