'use strict'

var express = require('express');
var CiudadController = require('../controllers/city');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getCities', md_auth.ensureAuth , CiudadController.getPlans);
api.post('/saveCity',md_auth.ensureAuth, CiudadController.savePlan);
api.get('/getCity/:id', md_auth.ensureAuth,CiudadController.getPlan); //para devolver UNO de los planes
api.put('/updateCity/:id',md_auth.ensureAuth, CiudadController.updatePlan);
api.delete('/delCity/:id',md_auth.ensureAuth, CiudadController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;