'use strict'

var express = require('express');
var CompanyController = require('../controllers/company');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});



 /*******************************************************************************************************/
 // configuracion realizada para subir la imagens
 // Additional notes
 /*******************************************************************************************************/


const multer = require('multer');
const path = require('path');
const fs = require('node:fs')

// const storage = multer.diskStorage({
//   async destination(req, file, callback) {
//     const dirPath = path.join(__dirname, '../client/assets/logoCliente/');
//     await fs.mkdir(dirPath, { recursive: true }); // Create directory if needed
//     try {
//       await fs.access(dirPath, fs.constants.W_OK); // Check write permissions
//       callback(null, dirPath);
//     } catch (err) {
//       callback(new multer.MulterError('El directorio no tiene permisos de escritura'));
//     }
//   },
//   filename: (req, file, callback) => {
//     // Ensure `nombreLogo` is valid or use a unique filename generator
//     callback(null, req.params.nombreLogo || uuidv4());
//   }
// });

const upload = multer({ dest: 'client/assets/logoCliente/'});
//fin de la configuracion asociada a subir imagen

//Date.now() + '-' + file.originalname

api.get('/getCompanies', md_auth.ensureAuth , CompanyController.getCompanies);
api.post('/grabaCompania', md_auth.ensureAuth, CompanyController.grabaCompania);
api.get('/getCompanyBy/:id', md_auth.ensureAuth,CompanyController.getCompanyBy);
api.get('/getCompany/:id', md_auth.ensureAuth,CompanyController.getCompany); //para devolver UNO de los usuarios de la base de datos
api.put('/updateCompany/:id',md_auth.ensureAuth, CompanyController.updateCompany);
api.delete('/delCompany/:id',md_auth.ensureAuth, CompanyController.delCompany);

api.get('/getCompanyByName/:name', md_auth.ensureAuth,CompanyController.getCompanyByName); //devuelve los ususarios por nombre

//Para subir la imagen se instalo multer y se configuro acorde como esta en este archivo
api.post('/upload/logo', upload.single('image'), (req, res) => {
    if (req.file) {
        res.json({
          success: true,
          message: 'File uploaded successfully',
          file: req.file
        });
      } else {
        res.json({
          success: false,
          message: 'File upload failed'
        });
      }

      saveImage(req.file);

});

function saveImage(file){
    const newPath = `client/assets/logoCliente/${file.originalname}`;
    fs.renameSync(file.path, newPath);
    return newPath;
}


module.exports = api;