'use strict'

var express = require('express');
var PaisController = require('../controllers/country');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getCountries', md_auth.ensureAuth , PaisController.getPlans);
api.post('/saveCountry', md_auth.ensureAuth, PaisController.savePlan);
api.get('/getCountry/:id', md_auth.ensureAuth, PaisController.getPlan); //para devolver UNO de los paises
api.put('/updateCountry/:id',md_auth.ensureAuth, PaisController.updatePlan);
api.delete('/delCountry/:id',md_auth.ensureAuth, PaisController.delPlan);
api.get('/getCountryByCode/:id', md_auth.ensureAuth, PaisController.getCountryByCode); //para devolver UNO de los paises
api.get('/getCountryById/:id', md_auth.ensureAuth, PaisController.getCountryById); //para devolver UNO de los paises
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;