'use strict'

var express = require('express');
var GeneralController = require('../controllers/general');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});

//api.get('/getActivities', md_auth.ensureAuth , ActividadecoController.getPlans);
//api.post('/saveActivity', md_auth.ensureAuth, ActividadecoController.savePlan);
api.get('/getPorcentajes', md_auth.ensureAuth, GeneralController.getPorcentajes); //para devolver UNO de los planes
api.get('/getDataList/:idEmpresa', md_auth.ensureAuth, GeneralController.getDataList); //para devolver UNO de los planes
api.delete('/deldataList/:idEmpresa/:idGrabacion',md_auth.ensureAuth, GeneralController.delDataList);

//pára el historico de busquedas
api.get('/getHistoricoBusquedas/:idEmpresa', md_auth.ensureAuth, GeneralController.getHistoricoBusquedas); //para devolver UNO de los planes

//api.get('/probando-controlador', md_auth.ensureAuth , UserController.pruebas);
api.post('/updateUserPorId/',md_auth.ensureAuth, GeneralController.updateUserPorId);

//api.put('/updateActivity/:id',md_auth.ensureAuth, ActividadecoController.updatePlan);
//api.delete('/delActivity/:id',md_auth.ensureAuth, ActividadecoController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;