'use strict'

/***************************************************************/
/*  ROUTER *****************************************************/
/*  Para adaptar:  (*) **** ************************************/
/* *************************************************************/
var express = require('express');
var JurisdictionController = require('../controllers/jurisdiction'); //(*) cambie relation por el nombre del controlador específico

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

api.post('/saveJuris', md_auth.ensureAuth, JurisdictionController.saveJuris); //(*) cambie el nombre del controlador
api.get('/getJurisdicciones/:idPais', md_auth.ensureAuth, JurisdictionController.getJurisdicciones); //para devolver todos los registros de la base de datos
api.get('/getAllJurisdicciones', md_auth.ensureAuth, JurisdictionController.getAllJurisdicciones); //para devolver todos los registros de la base de datos
api.get('/getJurisdiccion/:idJurisdiccion', md_auth.ensureAuth, JurisdictionController.getJurisdiccion); //para devolver uno de los los registros de la base de datos
api.delete('/delJurisdiccion/:id',md_auth.ensureAuth, JurisdictionController.delJurisdiccion);

//api.get('/getJurisdicciones/:idCiudad', md_auth.ensureAuth, JurisdictionController.getJurisdicciones); //para devolver todos los registros de la base de datos
api.get('/getJurisdiccionesReporte/:idCiudad', md_auth.ensureAuth, JurisdictionController.getJurisdiccionesReporte);

//api.get('/getRelation/:id', md_auth.ensureAuth, RelationController.getEntity); //para devolver UNO de los registros de la base de datos
api.put('/updateJurisdiccion/:id',md_auth.ensureAuth, JurisdictionController.updateJurisdiccion);
//api.delete('/deleteRelation/:id', md_auth.ensureAuth, RelationController.deleteEntity); //para borrar un usuario dela base de datos

module.exports = api;