'use strict'

var express = require('express');
var ListController = require('../controllers/list');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
//var md_upload = multipart({uploadDir: './uploads/users'});

//api.post('/saveLista', md_auth.ensureAuth, ListController.saveTransaction);
api.delete('/deleteList/:id', md_auth.ensureAuth, ListController.deleteLista);
api.get('/moveList/:id', md_auth.ensureAuth, ListController.moveList);
api.post('/saveLista', ListController.saveLista);
api.post('/saveListaXML', ListController.saveListaXML);
api.post('/saveListname', ListController.saveListname); //para guardar el nombre de la lista y obtener el id del registro grabado
api.delete('/deleteLista', ListController.deleteLista);
api.put('/updateLista/:id',md_auth.ensureAuth, ListController.updateTransaction);
api.post('/saveListaPersonalizada', ListController.saveListaPersonalizada);
api.post('/saveMyListName', ListController.saveMyListName); //para guardar el nombre de la lista y obtener el id del registro grabado
api.delete('/deleteListPersonalizada/:id', md_auth.ensureAuth, ListController.deleteListaPersonalizada);
api.delete('/delList/:id', md_auth.ensureAuth , ListController.delListPersonal); //para borrar la lista personalizada, el indice

api.delete('/delListOficial/:id', md_auth.ensureAuth , ListController.delListOficial); //para borrar INDICE DE LA LISTA OFICIALES

//para obtener las personas reportadas
api.get('/getReportados/:nombreAlias/:nit', ListController.getReportados);
api.get('/getReportadosPersonalizado/:nombreAlias/:nit/:idEmpresa', ListController.getReportadosPersonalizado);

//api.get('/getTransactions/:fIni/:fFin',  md_auth.ensureAuth, ListController.getTransactions, function(req, res){});
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
//api.get('/probando', md_auth.ensureAuth,UserController.pruebas);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;