'use strict'

var express = require('express');
var PercentController = require('../controllers/percent');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getPercent/:id', md_auth.ensureAuth , PercentController.getPercent); 
api.get('/getAllPercent/', md_auth.ensureAuth , PercentController.getAllPercent); 
api.post('/savePercent/:idEmpresa', md_auth.ensureAuth , PercentController.savePercent); 
api.post('/savePercentByCompany/', md_auth.ensureAuth , PercentController.savePercentByCompany); 

api.get('/getAllPercentByIdEmpresa/:idEmpresa', md_auth.ensureAuth , PercentController.getAllPercentByIdEmpresa); 

api.delete('/delPercent/:id', md_auth.ensureAuth , PercentController.delPercent); 


module.exports = api;