'use strict'

var express = require('express');
var PlanController = require('../controllers/plan');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});



api.post('/savePlan', md_auth.ensureAuth, PlanController.savePlan);
api.get('/getPlans', md_auth.ensureAuth , PlanController.getPlans);
api.get('/getPlanByName/:id', md_auth.ensureAuth, PlanController.getPlanByName);
api.get('/getPlan/:id', md_auth.ensureAuth, PlanController.getPlan); //para devolver UNO de los planes y poderlo editar por ejemplo
api.put('/updatePlan/:id',md_auth.ensureAuth, PlanController.updatePlan);
api.delete('/delPlan/:id',md_auth.ensureAuth, PlanController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;