'use strict'

/***************************************************************/
/*  ROUTER *****************************************************/
/*  Para adaptar:  (*) **** ************************************/
/* *************************************************************/
var express = require('express');
var RelationController = require('../controllers/relation'); //(*) cambie relation por el nombre del controlador específico

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

api.post('/saveRelation', md_auth.ensureAuth, RelationController.saveEntity); //(*) cambie el nombre del controlador
api.get('/getRelations', md_auth.ensureAuth, RelationController.getEntities); //para devolver todos los registros de la base de datos
api.get('/getRelation/:id', md_auth.ensureAuth, RelationController.getEntity); //para devolver UNO de los registros de la base de datos
api.put('/updateRelation/:id',md_auth.ensureAuth, RelationController.updateEntity);
api.delete('/deleteRelation/:id', md_auth.ensureAuth, RelationController.deleteEntity); //para borrar un usuario dela base de datos

module.exports = api;