'use strict'

var express = require('express');
var OrigenrecController = require('../controllers/resource');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getResources', md_auth.ensureAuth , OrigenrecController.getPlans);
api.post('/saveResource', md_auth.ensureAuth, OrigenrecController.savePlan);
api.get('/getResource/:id', md_auth.ensureAuth, OrigenrecController.getPlan); //para devolver UNO de los usuarios de la base de datos
api.get('/getResourceReporte/:id', md_auth.ensureAuth, OrigenrecController.getResource); //para devolver UNO de los recursos de la base de datos
api.put('/updateResource/:id',md_auth.ensureAuth, OrigenrecController.updatePlan);
api.delete('/delResource/:id',md_auth.ensureAuth, OrigenrecController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;